/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.color;

import com.intellij.psi.css.impl.util.color.ColorSpace;
import com.intellij.psi.css.impl.util.color.CssColor;
import com.intellij.psi.css.impl.util.color.CssColorConversionUtilKt;
import com.intellij.psi.css.impl.util.color.HueInterpolationMethod;
import com.intellij.util.MathUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a(\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a:\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"interpolateColors", "Lcom/intellij/psi/css/impl/util/color/CssColor;", "colorSpace", "Lcom/intellij/psi/css/impl/util/color/ColorSpace;", "leftColor", "rightColor", "leftPercentage", "", "rightPercentage", "interpolationMethod", "Lcom/intellij/psi/css/impl/util/color/HueInterpolationMethod;", "linearlyInterpolateComponent", "left", "right", "fixUpHues", "Lkotlin/Pair;", "getPremultiplicationValues", "Lkotlin/Triple;", "intellij.css.common"})
public final class CssColorInterpolationUtilKt {
    @NotNull
    public static final CssColor interpolateColors(@NotNull ColorSpace colorSpace, @NotNull CssColor leftColor, @NotNull CssColor rightColor, double leftPercentage, double rightPercentage, @NotNull HueInterpolationMethod interpolationMethod) {
        int i;
        Intrinsics.checkNotNullParameter((Object)((Object)colorSpace), (String)"colorSpace");
        Intrinsics.checkNotNullParameter((Object)leftColor, (String)"leftColor");
        Intrinsics.checkNotNullParameter((Object)rightColor, (String)"rightColor");
        Intrinsics.checkNotNullParameter((Object)((Object)interpolationMethod), (String)"interpolationMethod");
        CssColor leftConverted = CssColorConversionUtilKt.convertColor(leftColor, colorSpace);
        CssColor rightConverted = CssColorConversionUtilKt.convertColor(rightColor, colorSpace);
        for (int i2 = 0; i2 < 3; ++i2) {
            if (leftConverted.get(i2) == null) {
                leftConverted.set(i2, rightConverted.get(i2));
            }
            if (rightConverted.get(i2) != null) continue;
            rightConverted.set(i2, leftConverted.get(i2));
        }
        if (leftConverted.getAlpha() == null) {
            leftConverted.setAlpha(rightConverted.getAlpha());
        }
        if (rightConverted.getAlpha() == null) {
            rightConverted.setAlpha(leftConverted.getAlpha());
        }
        Triple<Double, Double, Double> triple = CssColorInterpolationUtilKt.getPremultiplicationValues(leftConverted, rightConverted, leftPercentage, rightPercentage);
        double leftPremultiply = ((Number)triple.component1()).doubleValue();
        double rightPremultiply = ((Number)triple.component2()).doubleValue();
        double interpolatedAlpha = ((Number)triple.component3()).doubleValue();
        Double[] doubleArray = new Double[]{0.0, 0.0, 0.0};
        Double[] interpolated = doubleArray;
        for (i = 0; i < 3; ++i) {
            if (leftConverted.get(i) == null && rightConverted.get(i) == null) {
                interpolated[i] = null;
                continue;
            }
            Double d = leftConverted.get(i);
            Double d2 = rightConverted.get(i);
            interpolated[i] = CssColorInterpolationUtilKt.linearlyInterpolateComponent(d != null ? d : 0.0, leftPercentage * leftPremultiply, d2 != null ? d2 : 0.0, rightPercentage * rightPremultiply);
        }
        if (colorSpace.isPolar()) {
            Integer n = colorSpace.getPolarIndex();
            Intrinsics.checkNotNull((Object)n);
            int polarIndex = n;
            Double d = leftConverted.get(polarIndex);
            Double d3 = rightConverted.get(polarIndex);
            Pair<Double, Double> pair = CssColorInterpolationUtilKt.fixUpHues(d != null ? d : 0.0, d3 != null ? d3 : 0.0, interpolationMethod);
            double theta1 = ((Number)pair.component1()).doubleValue();
            double theta2 = ((Number)pair.component2()).doubleValue();
            interpolated[polarIndex] = CssColorInterpolationUtilKt.linearlyInterpolateComponent(theta1, leftPercentage, theta2, rightPercentage) % 1.0;
        }
        for (i = 0; i < 3; ++i) {
            Integer n = colorSpace.getPolarIndex();
            if (n != null && i == n || MathUtil.compare((double)interpolatedAlpha, (double)0.0, (double)1.0E-4) == 0 || interpolated[i] == null) continue;
            Double d = interpolated[i];
            interpolated[i] = d != null ? Double.valueOf(d / interpolatedAlpha) : null;
        }
        Double[] doubleArray2 = new Double[]{interpolated[0], interpolated[1], interpolated[2], interpolatedAlpha};
        return new CssColor(colorSpace, doubleArray2);
    }

    private static final double linearlyInterpolateComponent(double left, double leftPercentage, double right, double rightPercentage) {
        return left * leftPercentage + right * rightPercentage;
    }

    private static final Pair<Double, Double> fixUpHues(double left, double right, HueInterpolationMethod interpolationMethod) {
        double theta1 = left;
        double theta2 = right;
        switch (WhenMappings.$EnumSwitchMapping$0[interpolationMethod.ordinal()]) {
            case 1: {
                if (theta2 - theta1 > 0.5) {
                    theta1 += 1.0;
                    break;
                }
                if (!(theta2 - theta1 < -0.5)) break;
                theta2 += 1.0;
                break;
            }
            case 2: {
                if (0.0 < theta2 - theta1 && theta2 - theta1 < 0.5) {
                    theta1 += 1.0;
                    break;
                }
                if (!(-0.5 < theta2 - theta1) || !(theta2 - theta1 < 0.0)) break;
                theta2 += 1.0;
                break;
            }
            case 3: {
                if (!(theta2 < theta1)) break;
                theta2 += 1.0;
                break;
            }
            case 4: {
                if (!(theta1 < theta2)) break;
                theta1 += 1.0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new Pair((Object)theta1, (Object)theta2);
    }

    private static final Triple<Double, Double, Double> getPremultiplicationValues(CssColor leftColor, CssColor rightColor, double leftPercentage, double rightPercentage) {
        Double d = leftColor.getAlpha();
        double leftPremultiply = (d != null ? d : 1.0) / 1.0;
        Double d2 = rightColor.getAlpha();
        double rightPremultiply = (d2 != null ? d2 : 1.0) / 1.0;
        double interpolatedAlpha = leftColor.getAlpha() == null && rightColor.getAlpha() == null ? 0.0 : leftPremultiply * leftPercentage + rightPremultiply * rightPercentage;
        return new Triple((Object)leftPremultiply, (Object)rightPremultiply, (Object)interpolatedAlpha);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HueInterpolationMethod.values().length];
            try {
                nArray[HueInterpolationMethod.SHORTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HueInterpolationMethod.LONGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HueInterpolationMethod.INCREASING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HueInterpolationMethod.DECREASING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

