/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.dev.psiViewer.DevPsiViewerBundle;
import com.intellij.dev.psiViewer.PsiViewerExtension;
import com.intellij.dev.psiViewer.PsiViewerSettings;
import com.intellij.dev.psiViewer.PsiViewerSourceWrapper;
import com.intellij.dev.psiViewer.ViewerNodeDescriptor;
import com.intellij.dev.psiViewer.ViewerPsiBasedTree;
import com.intellij.dev.psiViewer.ViewerTreeStructure;
import com.intellij.dev.psiViewer.formatter.BlockViewerPsiBasedTree;
import com.intellij.dev.psiViewer.properties.PsiViewerPropertiesTab;
import com.intellij.dev.psiViewer.properties.PsiViewerPropertiesTabViewModel;
import com.intellij.dev.psiViewer.stubs.StubViewerPsiBasedTree;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.tabs.JBEditorTabsBase;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiViewerDialog
extends DialogWrapper
implements UiDataProvider {
    private static final Color BOX_COLOR = new JBColor(new Color(16542720), new Color(14576641));
    public static final Logger LOG = Logger.getInstance(PsiViewerDialog.class);
    private final Project myProject;
    private final StructureTreeModel<ViewerTreeStructure> myStructureTreeModel;
    private final ViewerTreeStructure myTreeStructure;
    private JPanel myPanel;
    private ComboBox<PsiViewerSourceWrapper> myFileTypeComboBox;
    private JCheckBox myShowWhiteSpacesBox;
    private JCheckBox myShowTreeNodesCheckBox;
    private JCheckBox myShowEmptyPropertiesCheckBox;
    private JCheckBox myUpdatePsiTreeCheckbox;
    private JBLabel myDialectLabel;
    private JComboBox<Language> myDialectComboBox;
    private JLabel myExtensionLabel;
    private JComboBox<String> myExtensionComboBox;
    private JPanel myTextPanel;
    private JSplitPane myTextSplit;
    private JSplitPane myTreeSplit;
    private final JPanel myPsiTreePanel;
    private final Tree myPsiTree;
    private final JList<String> myRefs;
    private TitledSeparator myTextSeparator;
    private final TitledSeparator myPsiTreeSeparator;
    @NotNull
    private final StubViewerPsiBasedTree myStubTree;
    @NotNull
    private final CoroutineScope myCoroutineScope;
    @NotNull
    final PsiViewerPropertiesTabViewModel myPsiViewerPropertiesTabViewModel;
    @NotNull
    private final BlockViewerPsiBasedTree myBlockTree;
    private RangeHighlighter myHighlighter;
    private final Set<PsiViewerSourceWrapper> mySourceWrappers;
    private final EditorEx myEditor;
    private final EditorListener myEditorListener;
    private String myLastParsedText;
    private int myLastParsedTextHashCode;
    private int myNewDocumentHashCode;
    private final boolean myExternalDocument;
    private final Map<PsiElement, PsiElement[]> myRefsResolvedCache;
    private final PsiFile myOriginalPsiFile;
    @NotNull
    private final JBTabs myTabs;
    @NotNull
    private final SingleAlarm myPsiUpdateAlarm;
    private boolean myIsUsingOriginalFile;
    private static final Pattern EXT_PATTERN = Pattern.compile("[a-z\\d]*");

    public PsiViewerDialog(@NotNull Project project, @Nullable Editor selectedEditor) {
        if (project == null) {
            PsiViewerDialog.$$$reportNull$$$0(0);
        }
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.$$$setupUI$$$();
        this.mySourceWrappers = new TreeSet<PsiViewerSourceWrapper>();
        this.myEditorListener = new EditorListener();
        this.myLastParsedTextHashCode = 17;
        this.myNewDocumentHashCode = 11;
        this.myRefsResolvedCache = new HashMap<PsiElement, PsiElement[]>();
        this.myPsiTreePanel = new JPanel(new BorderLayout());
        this.myPsiTreeSeparator = new TitledSeparator(DevPsiViewerBundle.message("separator.psi.tree", new Object[0]));
        this.myPsiTree = new Tree();
        this.myProject = project;
        this.myExternalDocument = selectedEditor != null;
        this.myOriginalPsiFile = PsiViewerDialog.getOriginalPsiFile(project, selectedEditor);
        this.myIsUsingOriginalFile = this.myOriginalPsiFile != null;
        this.myTabs = this.createTabPanel(project);
        this.myRefs = new JBList(new DefaultListModel());
        this.myPsiUpdateAlarm = new SingleAlarm(this::doUpdatePsi, 1500, this.getDisposable());
        this.myCoroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)ModalityKt.asContextElement((ModalityState)ModalityState.nonModal()));
        this.myPsiViewerPropertiesTabViewModel = new PsiViewerPropertiesTabViewModel(this.myProject, this.myCoroutineScope, this.myOriginalPsiFile, PsiViewerSettings.getSettings(), psiElement -> {
            this.focusTree();
            this.selectElement((PsiElement)psiElement);
        });
        this.myTreeStructure = new ViewerTreeStructure(this.myProject);
        this.myStructureTreeModel = new StructureTreeModel((AbstractTreeStructure)this.myTreeStructure, (Comparator)IndexComparator.getInstance(), this.getDisposable());
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel(this.myStructureTreeModel, this.getDisposable());
        this.myPsiTree.setModel((TreeModel)asyncTreeModel);
        ViewerPsiBasedTree.PsiTreeUpdater psiTreeUpdater = new ViewerPsiBasedTree.PsiTreeUpdater(){
            private final TextAttributes myAttributes = new TextAttributes();
            {
                this.myAttributes.setEffectColor(BOX_COLOR);
                this.myAttributes.setEffectType(EffectType.ROUNDED_BOX);
            }

            @Override
            public void updatePsiTree(@NotNull PsiElement toSelect, @Nullable TextRange selectRangeInEditor) {
                if (toSelect == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (selectRangeInEditor != null) {
                    int start = selectRangeInEditor.getStartOffset();
                    int end = selectRangeInEditor.getEndOffset();
                    PsiViewerDialog.this.clearSelection();
                    if (end <= PsiViewerDialog.this.myEditor.getDocument().getTextLength()) {
                        PsiViewerDialog.this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start);
                        PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    }
                }
                PsiViewerDialog.this.updateReferences(toSelect);
                if (!PsiViewerDialog.this.myPsiTree.hasFocus()) {
                    PsiViewerDialog.this.selectElement(toSelect);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSelect", "com/intellij/dev/psiViewer/PsiViewerDialog$1", "updatePsiTree"));
            }
        };
        this.myStubTree = new StubViewerPsiBasedTree(project, psiTreeUpdater);
        this.myBlockTree = new BlockViewerPsiBasedTree(project, psiTreeUpdater);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myStubTree);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myBlockTree);
        this.setOKButtonText(DevPsiViewerBundle.message("button.build.psi.tree", new Object[0]));
        this.setCancelButtonText(DevPsiViewerBundle.message("button.close", new Object[0]));
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        VirtualFile selectedFile = selectedEditor == null ? null : FileDocumentManager.getInstance().getFile(selectedEditor.getDocument());
        this.setTitle(selectedFile == null ? DevPsiViewerBundle.message("dialog.title.psi.viewer", new Object[0]) : DevPsiViewerBundle.message("dialog.title.psi.viewer.with.file", selectedFile.getName()));
        if (selectedEditor != null) {
            this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(selectedEditor.getDocument(), this.myProject);
        } else {
            PsiViewerSettings settings = PsiViewerSettings.getSettings();
            Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.notNullize((String)settings.text));
            this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject);
            this.myEditor.getSelectionModel().setSelection(0, document.getTextLength());
        }
        this.myEditor.getSettings().setLineMarkerAreaShown(false);
        DocRenderManager.setDocRenderingEnabled((Editor)this.myEditor, (Boolean)false);
        this.init();
        if (selectedEditor != null) {
            this.doOKAction();
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true));
                this.myEditor.getCaretModel().moveToOffset(selectedEditor.getCaretModel().getOffset());
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                SelectionModel selectionModel = selectedEditor.getSelectionModel();
                if (selectionModel.hasSelection()) {
                    this.myEditor.getSelectionModel().setSelection(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                }
            }, ModalityState.stateForComponent((Component)this.myPanel));
        }
    }

    @Nullable
    private static PsiFile getOriginalPsiFile(@NotNull Project project, @Nullable Editor selectedEditor) {
        if (project == null) {
            PsiViewerDialog.$$$reportNull$$$0(1);
        }
        return selectedEditor != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(selectedEditor.getDocument()) : null;
    }

    @NotNull
    private JBTabs createTabPanel(@NotNull Project project) {
        if (project == null) {
            PsiViewerDialog.$$$reportNull$$$0(2);
        }
        JBEditorTabsBase tabs = JBTabsFactory.createEditorTabs((Project)project, (Disposable)this.getDisposable());
        tabs.getPresentation().setAlphabeticalMode(false);
        JBEditorTabsBase jBEditorTabsBase = tabs;
        if (jBEditorTabsBase == null) {
            PsiViewerDialog.$$$reportNull$$$0(3);
        }
        return jBEditorTabsBase;
    }

    protected void init() {
        TabInfo defaultInfo;
        this.initMnemonics();
        PsiViewerDialog.initTree((JTree)this.myPsiTree);
        TreeCellRenderer renderer = this.myPsiTree.getCellRenderer();
        this.myPsiTree.setCellRenderer((tree, value, selected, expanded, leaf, row, hasFocus) -> {
            Object userObject;
            Component c = renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ViewerNodeDescriptor) {
                boolean isInjected;
                ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)((Object)userObject));
                Object element = descriptor.getElement();
                if (c instanceof NodeRenderer) {
                    NodeRenderer nodeRenderer = (NodeRenderer)c;
                    nodeRenderer.setToolTipText(PsiViewerDialog.getElementDescription(element));
                }
                PsiElement fileContext = null;
                if (element instanceof PsiElement) {
                    PsiElement psiElement = (PsiElement)element;
                    PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiElement)psiElement).getContainingFile());
                    if (containingFile != null) {
                        fileContext = FileContextUtil.getFileContext((PsiFile)containingFile);
                    }
                }
                boolean bl = isInjected = element instanceof ViewerTreeStructure.Inject || fileContext != null;
                if (isInjected) {
                    TextAttributes attr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.INJECTED_LANGUAGE_FRAGMENT);
                    c.setBackground(attr.getBackgroundColor());
                }
            }
            return c;
        });
        this.myPsiTree.addTreeSelectionListener((TreeSelectionListener)new MyPsiTreeSelectionListener());
        this.myPsiTreePanel.add((Component)this.myPsiTreeSeparator, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myPsiTree, (boolean)true);
        this.myPsiTreePanel.add((Component)scrollPane, "Center");
        this.myTreeSplit.add((Component)this.myPsiTreePanel, "left");
        this.myTreeSplit.add((Component)this.myTabs.getComponent(), "right");
        JPanel referencesPanel = new JPanel(new BorderLayout());
        referencesPanel.add(this.myRefs);
        PsiViewerPropertiesTab propertiesTab = new PsiViewerPropertiesTab(this.myPsiViewerPropertiesTabViewModel, this.myCoroutineScope);
        TabInfo propertiesTabInfo = new TabInfo((JComponent)propertiesTab.getComponent()).setText(DevPsiViewerBundle.message("tab.title.properties", new Object[0]));
        this.myTabs.addTab(propertiesTabInfo);
        this.myTabs.addTab(new TabInfo(this.myRefs).setText(DevPsiViewerBundle.message("tab.title.references", new Object[0])));
        this.myTabs.addTab(new TabInfo(this.myBlockTree.getComponent()).setText(DevPsiViewerBundle.message("tab.title.block.structure", new Object[0])));
        this.myTabs.addTab(new TabInfo(this.myStubTree.getComponent()).setText(DevPsiViewerBundle.message("tab.title.stub.structure", new Object[0])));
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        this.myTabs.setSelectionChangeHandler((tab, focus, el) -> {
            settings.lastSelectedTabIndex = this.myTabs.getIndexOf(tab);
            if (tab == propertiesTabInfo) {
                this.myPsiViewerPropertiesTabViewModel.openTab();
            } else {
                this.myPsiViewerPropertiesTabViewModel.closeTab();
            }
            return el.run();
        });
        int tabIndex = settings.lastSelectedTabIndex;
        TabInfo tabInfo = defaultInfo = tabIndex < this.myTabs.getTabCount() ? this.myTabs.getTabAt(tabIndex) : null;
        if (defaultInfo != null) {
            this.myTabs.select(defaultInfo, false);
        }
        GoToListener listener = new GoToListener();
        this.myRefs.addKeyListener(listener);
        this.myRefs.addMouseListener(listener);
        this.myRefs.getSelectionModel().addListSelectionListener(listener);
        this.myRefs.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                PsiElement[] elements = PsiViewerDialog.this.myRefsResolvedCache.get(PsiViewerDialog.this.getPsiElement());
                if (elements == null || elements.length <= index || elements[index] == null) {
                    comp.setForeground((Color)JBColor.RED);
                }
                return comp;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/dev/psiViewer/PsiViewerDialog$2", "getListCellRendererComponent"));
            }
        });
        this.myEditor.getSettings().setFoldingOutlineShown(false);
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this.myEditorListener, this.getDisposable());
        this.myEditor.getSelectionModel().addSelectionListener((SelectionListener)this.myEditorListener);
        this.myEditor.getCaretModel().addCaretListener((CaretListener)this.myEditorListener);
        FocusTraversalPolicy oldPolicy = this.getPeer().getWindow().getFocusTraversalPolicy();
        this.getPeer().getWindow().setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getInitialComponent(@NotNull Window window) {
                if (window == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PsiViewerDialog.this.myEditor.getComponent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/dev/psiViewer/PsiViewerDialog$3", "getInitialComponent"));
            }
        });
        Disposer.register((Disposable)this.getDisposable(), () -> this.getPeer().getWindow().setFocusTraversalPolicy(oldPolicy));
        VirtualFile file = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
        Language curLanguage = LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file);
        String type = curLanguage != null ? curLanguage.getDisplayName() : settings.type;
        PsiViewerSourceWrapper lastUsed = null;
        this.mySourceWrappers.addAll(PsiViewerSourceWrapper.getExtensionBasedWrappers());
        List<PsiViewerSourceWrapper> fileTypeBasedWrappers = PsiViewerSourceWrapper.getFileTypeBasedWrappers();
        for (PsiViewerSourceWrapper wrapper : fileTypeBasedWrappers) {
            this.mySourceWrappers.addAll(fileTypeBasedWrappers);
            if ((lastUsed != null || !wrapper.getText().equals(type)) && (curLanguage == null || wrapper.myFileType != curLanguage.getAssociatedFileType())) continue;
            lastUsed = wrapper;
        }
        this.myFileTypeComboBox.setSwingPopup(false);
        this.myFileTypeComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(new ArrayList<PsiViewerSourceWrapper>(this.mySourceWrappers), lastUsed));
        this.myFileTypeComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            if (value != null) {
                label.setText(value.getText());
                label.setIcon(value.getIcon());
            }
        }));
        ComboboxSpeedSearch search1 = new ComboboxSpeedSearch(this, (JComboBox)this.myFileTypeComboBox, null){

            protected String getElementText(Object element) {
                return element instanceof PsiViewerSourceWrapper ? ((PsiViewerSourceWrapper)element).getText() : null;
            }
        };
        search1.setupListeners();
        this.myFileTypeComboBox.addActionListener(__ -> {
            this.updateDialectsCombo(null);
            this.updateExtensionsCombo();
            this.rebuildPsiAndUpdateEditor();
        });
        this.myDialectComboBox.addActionListener(__ -> this.rebuildPsiAndUpdateEditor());
        ComboboxSpeedSearch search = new ComboboxSpeedSearch(this, this.myDialectComboBox, null){

            protected String getElementText(Object element) {
                return element instanceof Language ? ((Language)element).getDisplayName() : "<default>";
            }
        };
        search.setupListeners();
        this.myFileTypeComboBox.addFocusListener((FocusListener)new AutoExpandFocusListener((JComboBox<?>)this.myFileTypeComboBox));
        if (!this.myExternalDocument && lastUsed == null && !this.mySourceWrappers.isEmpty()) {
            this.myFileTypeComboBox.setSelectedIndex(0);
        }
        this.myDialectComboBox.setRenderer((ListCellRenderer<Language>)SimpleListCellRenderer.create((String)DevPsiViewerBundle.message("label.none", new Object[0]), value -> value.getDisplayName()));
        this.myDialectComboBox.addFocusListener(new AutoExpandFocusListener(this.myDialectComboBox));
        this.myExtensionComboBox.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", value -> "." + value));
        this.myExtensionComboBox.addFocusListener(new AutoExpandFocusListener(this.myExtensionComboBox));
        this.myExtensionComboBox.addActionListener(__ -> this.rebuildPsiAndUpdateEditor());
        this.myShowWhiteSpacesBox.addActionListener(__ -> {
            this.myTreeStructure.setShowWhiteSpaces(this.myShowWhiteSpacesBox.isSelected());
            this.myStructureTreeModel.invalidateAsync();
        });
        this.myShowTreeNodesCheckBox.addActionListener(__ -> {
            this.myTreeStructure.setShowTreeNodes(this.myShowTreeNodesCheckBox.isSelected());
            this.myStructureTreeModel.invalidateAsync();
        });
        this.myShowEmptyPropertiesCheckBox.addActionListener(__ -> this.myPsiViewerPropertiesTabViewModel.setShowEmptyProperties(this.myShowEmptyPropertiesCheckBox.isSelected()));
        this.myUpdatePsiTreeCheckbox.addActionListener(__ -> {
            boolean isSelected;
            settings.updatePsiTreeOnChanges = isSelected = this.myUpdatePsiTreeCheckbox.isSelected();
            if (isSelected) {
                this.queueUpdatePsi();
            }
        });
        this.myShowWhiteSpacesBox.setSelected(settings.showWhiteSpaces);
        this.myTreeStructure.setShowWhiteSpaces(settings.showWhiteSpaces);
        this.myShowTreeNodesCheckBox.setSelected(settings.showTreeNodes);
        this.myTreeStructure.setShowTreeNodes(settings.showTreeNodes);
        this.myShowEmptyPropertiesCheckBox.setSelected(this.myPsiViewerPropertiesTabViewModel.getShowEmptyProperties());
        this.myUpdatePsiTreeCheckbox.setSelected(settings.updatePsiTreeOnChanges);
        this.myTextPanel.setLayout(new BorderLayout());
        this.myTextPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.updateDialectsCombo(settings.dialect);
        this.updateExtensionsCombo();
        this.registerCustomKeyboardActions();
        Dimension size = DimensionService.getInstance().getSize(this.getDimensionServiceKey(), this.myProject);
        if (size == null) {
            DimensionService.getInstance().setSize(this.getDimensionServiceKey(), (Dimension)JBUI.size((int)800, (int)600), this.myProject);
        }
        this.myTextSplit.setDividerLocation(settings.textDividerLocation);
        this.myTreeSplit.setDividerLocation(settings.treeDividerLocation);
        this.updateEditor();
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myTextSplit, (boolean)true);
        super.init();
    }

    private void rebuildPsiAndUpdateEditor() {
        this.myIsUsingOriginalFile = false;
        this.doUpdatePsi();
        this.updateEditor();
    }

    @NotNull
    @NlsSafe
    private static String getElementDescription(Object element) {
        String string = element.getClass().getName();
        if (string == null) {
            PsiViewerDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void initTree(JTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.updateUI();
        ToolTipManager.sharedInstance().registerComponent(tree);
        TreeUtil.installActions((JTree)tree);
        TreeUIHelper.getInstance().installTreeSpeedSearch(tree);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.internal.psiView.PsiViewerDialog";
    }

    protected String getHelpId() {
        return "reference.psi.viewer";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    private void registerCustomKeyboardActions() {
        int mask = ClientSystemInfo.isMac() ? 256 : 512;
        this.registerKeyboardAction(__ -> this.focusEditor(), KeyStroke.getKeyStroke(84, mask));
        this.registerKeyboardAction(__ -> this.focusTree(), KeyStroke.getKeyStroke(83, mask));
        this.registerKeyboardAction(__ -> this.myBlockTree.focusTree(), KeyStroke.getKeyStroke(75, mask));
        this.registerKeyboardAction(__ -> this.focusRefs(), KeyStroke.getKeyStroke(82, mask));
        this.registerKeyboardAction(__ -> {
            if (this.myRefs.isFocusOwner()) {
                this.myBlockTree.focusTree();
            } else if (this.myPsiTree.isFocusOwner()) {
                this.focusRefs();
            } else if (this.myBlockTree.isFocusOwner()) {
                this.focusTree();
            }
        }, KeyStroke.getKeyStroke(9, 0));
    }

    private void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke) {
        this.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
    }

    private void focusEditor() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditor.getContentComponent(), true);
    }

    private void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myPsiTree, true);
    }

    private void focusRefs() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myRefs, true);
        if (this.myRefs.getModel().getSize() > 0 && this.myRefs.getSelectedIndex() == -1) {
            this.myRefs.setSelectedIndex(0);
        }
    }

    private void initMnemonics() {
        this.myTextSeparator.setLabelFor((Component)this.myEditor.getContentComponent());
        this.myPsiTreeSeparator.setLabelFor((Component)this.myPsiTree);
    }

    @Nullable
    private PsiElement getPsiElement() {
        TreePath path = this.myPsiTree.getSelectionPath();
        return path == null ? null : PsiViewerDialog.getPsiElement((DefaultMutableTreeNode)path.getLastPathComponent());
    }

    @Nullable
    private static PsiElement getPsiElement(DefaultMutableTreeNode node) {
        Object object = node.getUserObject();
        if (object instanceof ViewerNodeDescriptor) {
            ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)object);
            Object elementObject = descriptor.getElement();
            return elementObject instanceof PsiElement ? (PsiElement)elementObject : (elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
        }
        return null;
    }

    private void updateDialectsCombo(@Nullable String lastUsed) {
        Object source = this.getSource();
        ArrayList items = new ArrayList();
        if (source instanceof LanguageFileType) {
            Language baseLang = ((LanguageFileType)source).getLanguage();
            ((JBTreeTraverser)JBTreeTraverser.from(Language::getDialects).withRoot((Object)baseLang)).preOrderDfsTraversal().addAllTo(items);
            items.subList(1, items.size()).sort(LanguageUtil.LANGUAGE_COMPARATOR);
        }
        this.myDialectComboBox.setModel((ComboBoxModel<Language>)new CollectionComboBoxModel(items));
        boolean visible = items.size() > 1;
        this.myDialectLabel.setVisible(visible);
        this.myDialectComboBox.setVisible(visible);
        if (visible && (this.myExternalDocument || lastUsed != null)) {
            VirtualFile file = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
            Language curLanguage = LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file);
            int idx = items.indexOf(curLanguage);
            this.myDialectComboBox.setSelectedIndex(Math.max(idx, 0));
        }
    }

    private void updateExtensionsCombo() {
        List<String> extensions;
        Object source = this.getSource();
        if (source instanceof LanguageFileType && (extensions = PsiViewerDialog.getAllExtensions((LanguageFileType)source)).size() > 1) {
            String fileExt;
            ExtensionComparator comp = new ExtensionComparator(extensions.get(0));
            extensions.sort(comp);
            SortedComboBoxModel model = new SortedComboBoxModel((Comparator)comp);
            model.setAll(extensions);
            this.myExtensionComboBox.setModel((ComboBoxModel<String>)model);
            this.myExtensionComboBox.setVisible(true);
            this.myExtensionLabel.setVisible(true);
            VirtualFile file = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
            String string = fileExt = file == null ? "" : FileUtilRt.getExtension((String)file.getName());
            if (!fileExt.isEmpty() && extensions.contains(fileExt)) {
                this.myExtensionComboBox.setSelectedItem(fileExt);
                return;
            }
            this.myExtensionComboBox.setSelectedIndex(0);
            return;
        }
        this.myExtensionComboBox.setVisible(false);
        this.myExtensionLabel.setVisible(false);
    }

    private static List<String> getAllExtensions(LanguageFileType fileType) {
        List associations = FileTypeManager.getInstance().getAssociations((FileType)fileType);
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(StringUtil.toLowerCase((String)fileType.getDefaultExtension()));
        for (FileNameMatcher matcher : associations) {
            String ext;
            String presentableString = StringUtil.toLowerCase((String)matcher.getPresentableString());
            if (!presentableString.startsWith("*.") || (ext = presentableString.substring(2)).isEmpty() || extensions.contains(ext) || !EXT_PATTERN.matcher(ext).matches()) continue;
            extensions.add(ext);
        }
        return extensions;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    private Object getSource() {
        PsiViewerSourceWrapper wrapper = (PsiViewerSourceWrapper)this.myFileTypeComboBox.getSelectedItem();
        if (wrapper != null) {
            return wrapper.myFileType != null ? wrapper.myFileType : wrapper.myExtension;
        }
        return null;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = (Action[])ArrayUtil.mergeArrays((Object[])new Action[]{new CopyAction()}, (Object[])super.createActions());
        if (actionArray == null) {
            PsiViewerDialog.$$$reportNull$$$0(5);
        }
        return actionArray;
    }

    protected void doOKAction() {
        WriteIntentReadAction.run(() -> {
            this.doUpdatePsi();
            this.focusTree();
        });
    }

    private void doUpdatePsi() {
        String text = this.myEditor.getDocument().getText();
        this.myEditor.getSelectionModel().removeSelection();
        this.myLastParsedText = text;
        this.myNewDocumentHashCode = this.myLastParsedTextHashCode = text.hashCode();
        Object rootElement = this.myOriginalPsiFile != null && this.myIsUsingOriginalFile ? this.myOriginalPsiFile : this.parseText(text);
        this.setOriginalFiles((PsiElement)rootElement);
        this.myTreeStructure.setRootPsiElement((PsiElement)rootElement);
        this.myStructureTreeModel.invalidateAsync();
        this.myPsiTree.setRootVisible(true);
        this.myPsiTree.expandRow(0);
        this.myPsiTree.setRootVisible(false);
        this.myBlockTree.reloadTree((PsiElement)rootElement, text);
        this.myStubTree.reloadTree((PsiElement)rootElement, text);
        this.myRefsResolvedCache.clear();
        this.myPsiViewerPropertiesTabViewModel.reset();
    }

    private void queueUpdatePsi() {
        if (PsiViewerSettings.getSettings().updatePsiTreeOnChanges) {
            this.myPsiUpdateAlarm.cancelAndRequest();
        }
    }

    private PsiElement parseText(@NotNull String text) {
        if (text == null) {
            PsiViewerDialog.$$$reportNull$$$0(6);
        }
        Object source = this.getSource();
        try {
            if (source instanceof PsiViewerExtension) {
                return ((PsiViewerExtension)source).createElement(this.myProject, text);
            }
            if (source instanceof FileType) {
                Language dialect;
                FileType type = (FileType)source;
                String ext = type.getDefaultExtension();
                if (this.myExtensionComboBox.isVisible() && this.myExtensionComboBox.getSelectedItem() != null) {
                    ext = StringUtil.toLowerCase((String)this.myExtensionComboBox.getSelectedItem().toString());
                }
                if (type instanceof LanguageFileType && (dialect = (Language)this.myDialectComboBox.getSelectedItem()) != null) {
                    return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + ext, dialect, (CharSequence)text);
                }
                return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + ext, type, (CharSequence)text);
            }
        }
        catch (IncorrectOperationException e) {
            Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        return null;
    }

    private void setOriginalFiles(@Nullable PsiElement root) {
        if (root != null && this.myOriginalPsiFile != null && !this.myIsUsingOriginalFile) {
            PsiFile newPsiFile = root.getContainingFile();
            newPsiFile.putUserData(PsiFileFactory.ORIGINAL_FILE, (Object)this.myOriginalPsiFile);
            VirtualFile newVirtualFile = newPsiFile.getVirtualFile();
            if (newVirtualFile instanceof LightVirtualFile) {
                ((LightVirtualFile)newVirtualFile).setOriginalFile(this.myOriginalPsiFile.getVirtualFile());
            }
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            PsiViewerDialog.$$$reportNull$$$0(7);
        }
        Object selection = this.myPsiTree.hasFocus() ? TreeUtil.getLastUserObject((TreePath)this.myPsiTree.getSelectionPath()) : (this.myRefs.hasFocus() ? this.myRefs.getSelectedValue() : null);
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            String fqn;
            if (selection instanceof ViewerNodeDescriptor) {
                ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)((Object)selection));
                Object elementObject = descriptor.getElement();
                PsiElement element = elementObject instanceof PsiElement ? (PsiElement)elementObject : (elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                fqn = element != null ? element.getClass().getName() : null;
            } else {
                String str;
                fqn = selection instanceof String ? (str = (String)selection) : null;
            }
            return fqn == null ? null : this.getContainingFileForClass(fqn);
        });
    }

    private void updateReferences(@NotNull PsiElement element) {
        if (element == null) {
            PsiViewerDialog.$$$reportNull$$$0(8);
        }
        DefaultListModel model = (DefaultListModel)this.myRefs.getModel();
        model.clear();
        String progressTitle = DevPsiViewerBundle.message("psi.viewer.progress.dialog.update.refs", new Object[0]);
        Callable<List> updater = () -> (List)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.doUpdateReferences(element));
        List psiReferences = PsiViewerDialog.computeSlowOperationsSafeInBgThread(this.myProject, progressTitle, updater);
        for (PsiReference reference : psiReferences) {
            model.addElement(PsiViewerDialog.getElementDescription(reference));
        }
    }

    @NotNull
    private List<PsiReference> doUpdateReferences(@NotNull PsiElement element) {
        if (element == null) {
            PsiViewerDialog.$$$reportNull$$$0(9);
        }
        PsiReferenceService referenceService = PsiReferenceService.getService();
        List psiReferences = referenceService.getReferences(element, PsiReferenceService.Hints.NO_HINTS);
        if (this.myRefsResolvedCache.containsKey(element)) {
            List list = psiReferences;
            if (list == null) {
                PsiViewerDialog.$$$reportNull$$$0(10);
            }
            return list;
        }
        PsiElement[] cache = new PsiElement[psiReferences.size()];
        for (int i = 0; i < psiReferences.size(); ++i) {
            ResolveResult[] results;
            PsiReference reference = (PsiReference)psiReferences.get(i);
            PsiElement resolveResult = reference instanceof PsiPolyVariantReference ? ((results = ((PsiPolyVariantReference)reference).multiResolve(true)).length == 0 ? null : results[0].getElement()) : reference.resolve();
            cache[i] = resolveResult;
        }
        this.myRefsResolvedCache.put(element, cache);
        List list = psiReferences;
        if (list == null) {
            PsiViewerDialog.$$$reportNull$$$0(11);
        }
        return list;
    }

    private void clearSelection() {
        if (this.myHighlighter != null) {
            this.myEditor.getMarkupModel().removeHighlighter(this.myHighlighter);
            this.myHighlighter.dispose();
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        PsiViewerSourceWrapper wrapper = (PsiViewerSourceWrapper)this.myFileTypeComboBox.getSelectedItem();
        if (wrapper != null) {
            settings.type = wrapper.getText();
        }
        if (!this.myExternalDocument) {
            settings.text = StringUtil.first((String)this.myEditor.getDocument().getText(), (int)2048, (boolean)true);
        }
        settings.showTreeNodes = this.myShowTreeNodesCheckBox.isSelected();
        settings.showWhiteSpaces = this.myShowWhiteSpacesBox.isSelected();
        Object selectedDialect = this.myDialectComboBox.getSelectedItem();
        settings.dialect = this.myDialectComboBox.isVisible() && selectedDialect != null ? selectedDialect.toString() : "";
        settings.textDividerLocation = this.myTextSplit.getDividerLocation();
        settings.treeDividerLocation = this.myTreeSplit.getDividerLocation();
    }

    public void dispose() {
        if (!this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
        CoroutineScopeKt.cancel((CoroutineScope)this.myCoroutineScope, null);
        super.dispose();
    }

    @Nullable
    private PsiFile getContainingFileForClass(@NotNull String fqn) {
        if (fqn == null) {
            PsiViewerDialog.$$$reportNull$$$0(12);
        }
        Object filename = fqn;
        if (fqn.contains(".")) {
            filename = fqn.substring(fqn.lastIndexOf(46) + 1);
        }
        if (((String)filename).contains("$")) {
            filename = ((String)filename).substring(0, ((String)filename).indexOf(36));
        }
        filename = (String)filename + ".java";
        Object[] files = FilenameIndex.getFilesByName((Project)this.myProject, (String)filename, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        return (PsiFile)ArrayUtil.getFirstElement((Object[])files);
    }

    private void updateEditor() {
        LightVirtualFile lightFile;
        Object source = this.getSource();
        String fileName = "Dummy." + (source instanceof FileType ? ((FileType)source).getDefaultExtension() : "txt");
        if (source instanceof PsiViewerExtension) {
            lightFile = new LightVirtualFile(fileName, ((PsiViewerExtension)source).getDefaultFileType(), (CharSequence)"");
        } else if (source instanceof LanguageFileType) {
            lightFile = new LightVirtualFile(fileName, (Language)ObjectUtils.chooseNotNull((Object)((Language)this.myDialectComboBox.getSelectedItem()), (Object)((LanguageFileType)source).getLanguage()), (CharSequence)"");
        } else if (source instanceof FileType) {
            lightFile = new LightVirtualFile(fileName, (FileType)source, (CharSequence)"");
        } else {
            return;
        }
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)lightFile);
        try {
            this.myEditor.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    private void selectElement(@NotNull PsiElement element) {
        if (element == null) {
            PsiViewerDialog.$$$reportNull$$$0(13);
        }
        ReadAction.nonBlocking(() -> PsiViewerDialog.getElementToChooseInPsiTree(element)).finishOnUiThread(ModalityState.nonModal(), elementToChoose -> this.myStructureTreeModel.select(elementToChoose, (JTree)this.myPsiTree, path -> {})).expireWith(this.getDisposable()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static PsiElement getElementToChooseInPsiTree(@NotNull PsiElement element) {
        PsiNameIdentifierOwner parentAsNameIdentifierOwner;
        PsiElement parentNameIdentifier;
        if (element == null) {
            PsiViewerDialog.$$$reportNull$$$0(14);
        }
        if (element.getFirstChild() != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                PsiViewerDialog.$$$reportNull$$$0(15);
            }
            return psiElement;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                PsiViewerDialog.$$$reportNull$$$0(16);
            }
            return psiElement;
        }
        boolean isIdentifierName = element.toString().toLowerCase().contains("identifier");
        if (isIdentifierName) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                PsiViewerDialog.$$$reportNull$$$0(17);
            }
            return psiElement;
        }
        if (parent instanceof PsiNameIdentifierOwner && Objects.equals(parentNameIdentifier = (parentAsNameIdentifierOwner = (PsiNameIdentifierOwner)parent).getNameIdentifier(), element)) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                PsiViewerDialog.$$$reportNull$$$0(18);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PsiViewerDialog.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    private static <T> T computeSlowOperationsSafeInBgThread(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String progressDialogTitle, final @NotNull Callable<T> callable) {
        if (project == null) {
            PsiViewerDialog.$$$reportNull$$$0(20);
        }
        if (progressDialogTitle == null) {
            PsiViewerDialog.$$$reportNull$$$0(21);
        }
        if (callable == null) {
            PsiViewerDialog.$$$reportNull$$$0(22);
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, RuntimeException>(project, progressDialogTitle, true){

            protected T compute(@NotNull ProgressIndicator indicator) throws RuntimeException {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                return ReadAction.nonBlocking((Callable)callable).executeSynchronously();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dev/psiViewer/PsiViewerDialog$6", "compute"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 10, 11, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dev/psiViewer/PsiViewerDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressDialogTitle";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dev/psiViewer/PsiViewerDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdateReferences";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToChooseInPsiTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTabPanel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateReferences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateReferences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFileForClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "selectElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementToChooseInPsiTree";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "computeSlowOperationsSafeInBgThread";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 10, 11, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSplitPane jSplitPane;
        JPanel jPanel;
        JSplitPane jSplitPane2;
        TitledSeparator titledSeparator;
        JCheckBox jCheckBox;
        ComboBox comboBox;
        JBLabel jBLabel;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setDoubleBuffered(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 8, 2, 7, 0, null, null, null));
        this.myShowWhiteSpacesBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox3.setSelected(true);
        jCheckBox3.setText("Show PsiWhiteSpace");
        jCheckBox3.setMnemonic('W');
        jCheckBox3.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowTreeNodesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Show tree nodes");
        jCheckBox2.setMnemonic('N');
        jCheckBox2.setDisplayedMnemonicIndex(10);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 6, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExtensionLabel = jLabel = new JLabel();
        jLabel.setText("Extension:");
        jLabel.setDisplayedMnemonic('X');
        jLabel.setDisplayedMnemonicIndex(1);
        jPanel4.add((Component)jLabel, "West");
        JComboBox jComboBox = new JComboBox();
        this.myExtensionComboBox = jComboBox;
        jPanel4.add(jComboBox, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 5, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDialectLabel = jBLabel = new JBLabel();
        jBLabel.setText("Dialect:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBLabel, "West");
        JComboBox jComboBox2 = new JComboBox();
        this.myDialectComboBox = jComboBox2;
        jPanel5.add(jComboBox2, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setIconTextGap(0);
        jLabel2.setText("Show PSI structure for:");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(5);
        jPanel6.add((Component)jLabel2, "West");
        this.myFileTypeComboBox = comboBox = new ComboBox();
        comboBox.setMaximumRowCount(30);
        jPanel6.add((Component)comboBox, "Center");
        this.myShowEmptyPropertiesCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setSelected(false);
        jCheckBox.setText("Show empty properties");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myUpdatePsiTreeCheckbox = jBCheckBox;
        jBCheckBox.setText("Update PSI tree on file changes");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 4, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTextSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("&Text");
        titledSeparator.setToolTipText("Type or paste source code which you want to explore, then click Build PSI Tree");
        jPanel2.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTextSplit = jSplitPane2 = new JSplitPane();
        jSplitPane2.setDividerLocation(134);
        jSplitPane2.setDividerSize(4);
        jSplitPane2.setOrientation(0);
        jPanel7.add((Component)jSplitPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myTextPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane2.setLeftComponent(jPanel);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane2.setRightComponent(jPanel8);
        this.myTreeSplit = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(98);
        jSplitPane.setDividerSize(4);
        jPanel8.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        jLabel.setLabelFor(jComboBox);
        jBLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class EditorListener
    implements SelectionListener,
    DocumentListener,
    CaretListener {
        private EditorListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            Callable<PsiElement> finder;
            if (e == null) {
                EditorListener.$$$reportNull$$$0(0);
            }
            if (!this.available() || PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            PsiElement rootPsiElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
            if (rootPsiElement == null) {
                return;
            }
            PsiElement rootElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
            int baseOffset = rootPsiElement.getTextRange().getStartOffset();
            int offset = PsiViewerDialog.this.myEditor.getCaretModel().getOffset() + baseOffset;
            String progressDialogTitle = DevPsiViewerBundle.message("psi.viewer.progress.dialog.get.element.at.offset", new Object[0]);
            PsiElement element = PsiViewerDialog.computeSlowOperationsSafeInBgThread(PsiViewerDialog.this.myProject, progressDialogTitle, finder = () -> InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)rootElement.getContainingFile(), (int)offset));
            if (element != null) {
                PsiViewerDialog.this.myBlockTree.selectNodeFromEditor(element);
                PsiViewerDialog.this.myStubTree.selectNodeFromEditor(element);
                PsiViewerDialog.this.selectElement(element);
            }
        }

        public void selectionChanged(@NotNull SelectionEvent e) {
            Callable<PsiElement> finder;
            if (e == null) {
                EditorListener.$$$reportNull$$$0(1);
            }
            if (!this.available() || !PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            PsiElement rootElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
            if (rootElement == null) {
                return;
            }
            SelectionModel selection = PsiViewerDialog.this.myEditor.getSelectionModel();
            TextRange textRange = rootElement.getTextRange();
            int baseOffset = textRange != null ? textRange.getStartOffset() : 0;
            int start = selection.getSelectionStart() + baseOffset;
            int end = selection.getSelectionEnd() + baseOffset - 1;
            String progressDialogTitle = DevPsiViewerBundle.message("psi.viewer.progress.dialog.get.common.parent", new Object[0]);
            PsiElement element = PsiViewerDialog.computeSlowOperationsSafeInBgThread(PsiViewerDialog.this.myProject, progressDialogTitle, finder = () -> EditorListener.findCommonParent(InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)rootElement.getContainingFile(), (int)start), InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)rootElement.getContainingFile(), (int)end)));
            if (element != null) {
                if (PsiViewerDialog.this.myEditor.getContentComponent().hasFocus()) {
                    PsiViewerDialog.this.myBlockTree.selectNodeFromEditor(element);
                    PsiViewerDialog.this.myStubTree.selectNodeFromEditor(element);
                }
                PsiViewerDialog.this.selectElement(element);
            }
        }

        @Nullable
        private static PsiElement findCommonParent(PsiElement start, PsiElement end) {
            PsiElement parent;
            if (end == null || start == end) {
                return start;
            }
            TextRange endRange = end.getTextRange();
            for (parent = start.getContext(); parent != null && !parent.getTextRange().contains(endRange); parent = parent.getContext()) {
            }
            return parent;
        }

        private boolean available() {
            return PsiViewerDialog.this.myLastParsedTextHashCode == PsiViewerDialog.this.myNewDocumentHashCode && PsiViewerDialog.this.myEditor.getContentComponent().hasFocus();
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            int currentDocumentHashCode;
            if (event == null) {
                EditorListener.$$$reportNull$$$0(2);
            }
            int oldDocumentHashCode = PsiViewerDialog.this.myNewDocumentHashCode;
            PsiViewerDialog.this.myNewDocumentHashCode = currentDocumentHashCode = event.getDocument().getText().hashCode();
            if (oldDocumentHashCode != currentDocumentHashCode) {
                PsiViewerDialog.this.queueUpdatePsi();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dev/psiViewer/PsiViewerDialog$EditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyPsiTreeSelectionListener
    implements TreeSelectionListener {
        private final TextAttributes myAttributes = new TextAttributes();

        MyPsiTreeSelectionListener() {
            this.myAttributes.setEffectColor(BOX_COLOR);
            this.myAttributes.setEffectType(EffectType.ROUNDED_BOX);
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (e == null) {
                MyPsiTreeSelectionListener.$$$reportNull$$$0(0);
            }
            if (!PsiViewerDialog.this.myEditor.getDocument().getText().equals(PsiViewerDialog.this.myLastParsedText) || PsiViewerDialog.this.myBlockTree.isFocusOwner()) {
                return;
            }
            TreePath path = PsiViewerDialog.this.myPsiTree.getSelectionPath();
            PsiViewerDialog.this.clearSelection();
            if (path != null) {
                PsiElement element;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = node.getUserObject();
                if (!(object instanceof ViewerNodeDescriptor)) {
                    return;
                }
                ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)object);
                Object elementObject = descriptor.getElement();
                Object object2 = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                if (element != null) {
                    int textLength;
                    TextRange rangeInHostFile = (TextRange)ReadAction.compute(() -> InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element, element.getTextRange()));
                    int start = rangeInHostFile.getStartOffset();
                    int end = rangeInHostFile.getEndOffset();
                    PsiElement rootPsiElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
                    if (rootPsiElement != null) {
                        int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                        start -= baseOffset;
                        end -= baseOffset;
                    }
                    if (end <= (textLength = PsiViewerDialog.this.myEditor.getDocument().getTextLength())) {
                        PsiViewerDialog.this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        if (PsiViewerDialog.this.myPsiTree.hasFocus()) {
                            PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start);
                            PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                        }
                    }
                    if (PsiViewerDialog.this.myPsiTree.hasFocus()) {
                        WriteIntentReadAction.run(() -> {
                            PsiViewerDialog.this.myBlockTree.selectNodeFromPsi(element);
                            PsiViewerDialog.this.myStubTree.selectNodeFromPsi(element);
                        });
                    }
                    PsiViewerDialog.this.myPsiViewerPropertiesTabViewModel.setSelectedPsiElement(element);
                    WriteIntentReadAction.run(() -> PsiViewerDialog.this.updateReferences(element));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dev/psiViewer/PsiViewerDialog$MyPsiTreeSelectionListener", "valueChanged"));
        }
    }

    private class GoToListener
    implements KeyListener,
    MouseListener,
    ListSelectionListener {
        private RangeHighlighter myListenerHighlighter;

        private GoToListener() {
        }

        private void navigate() {
            String fqn = PsiViewerDialog.this.myRefs.getSelectedValue();
            PsiFile file = PsiViewerDialog.this.getContainingFileForClass(fqn);
            if (file != null) {
                file.navigate(true);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(0);
            }
            if (e.getKeyCode() == 10) {
                this.navigate();
            }
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(1);
            }
            if (e.getClickCount() > 1) {
                this.navigate();
            }
        }

        @Override
        public void valueChanged(@NotNull ListSelectionEvent e) {
            PsiReference[] references;
            if (e == null) {
                GoToListener.$$$reportNull$$$0(2);
            }
            this.clearSelection();
            PsiViewerDialog.this.updateDialectsCombo(null);
            PsiViewerDialog.this.updateExtensionsCombo();
            int ind = PsiViewerDialog.this.myRefs.getSelectedIndex();
            PsiElement element = PsiViewerDialog.this.getPsiElement();
            if (ind > -1 && element != null && ind < (references = element.getReferences()).length) {
                TextRange textRange = references[ind].getRangeInElement();
                TextRange range = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element, element.getTextRange());
                int start = range.getStartOffset();
                PsiElement rootPsiElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
                if (rootPsiElement != null) {
                    int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                    start -= baseOffset;
                }
                int end = (start += textRange.getStartOffset()) + textRange.getLength();
                TextAttributes highlightReferenceTextRange = new TextAttributes(null, null, (Color)JBColor.namedColor((String)"PsiViewer.referenceHighlightColor", (int)11059235), EffectType.BOLD_DOTTED_LINE, 0);
                this.myListenerHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, highlightReferenceTextRange, HighlighterTargetArea.EXACT_RANGE);
            }
        }

        public void clearSelection() {
            if (this.myListenerHighlighter != null && ArrayUtil.contains((Object)this.myListenerHighlighter, (Object[])PsiViewerDialog.this.myEditor.getMarkupModel().getAllHighlighters())) {
                this.myListenerHighlighter.dispose();
                this.myListenerHighlighter = null;
            }
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(3);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(4);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(5);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(6);
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dev/psiViewer/PsiViewerDialog$GoToListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyPressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyTyped";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AutoExpandFocusListener
    extends FocusAdapter {
        private final JComboBox<?> myComboBox;
        private final Component myParent;

        private AutoExpandFocusListener(JComboBox<?> comboBox) {
            this.myComboBox = comboBox;
            this.myParent = UIUtil.findUltimateParent(this.myComboBox);
        }

        @Override
        public void focusGained(@NotNull FocusEvent e) {
            if (e == null) {
                AutoExpandFocusListener.$$$reportNull$$$0(0);
            }
            Component from = e.getOppositeComponent();
            if (!e.isTemporary() && from != null && !this.myComboBox.isPopupVisible() && AutoExpandFocusListener.isUnder(from, this.myParent)) {
                this.myComboBox.setPopupVisible(true);
            }
        }

        private static boolean isUnder(@NotNull Component component, Component parent) {
            if (component == null) {
                AutoExpandFocusListener.$$$reportNull$$$0(1);
            }
            while (component != null) {
                if (component == parent) {
                    return true;
                }
                component = component.getParent();
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dev/psiViewer/PsiViewerDialog$AutoExpandFocusListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "focusGained";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUnder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ExtensionComparator
    implements Comparator<String> {
        private final String myOnTop;

        ExtensionComparator(String onTop) {
            this.myOnTop = onTop;
        }

        @Override
        public int compare(@NotNull String o1, @NotNull String o2) {
            if (o1 == null) {
                ExtensionComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                ExtensionComparator.$$$reportNull$$$0(1);
            }
            if (o1.equals(this.myOnTop)) {
                return -1;
            }
            if (o2.equals(this.myOnTop)) {
                return 1;
            }
            return o1.compareToIgnoreCase(o2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/dev/psiViewer/PsiViewerDialog$ExtensionComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CopyAction
    extends AbstractAction {
        CopyAction() {
            super(DevPsiViewerBundle.message("cop.y.psi", new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            PsiElement element = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
            PsiViewerDialog.this.setOriginalFiles(element);
            ArrayList<PsiElement> allToParse = new ArrayList<PsiElement>();
            if (element instanceof PsiFile) {
                allToParse.addAll(((PsiFile)element).getViewProvider().getAllFiles());
            } else if (element != null) {
                allToParse.add(element);
            }
            StringBuilder data = new StringBuilder();
            for (PsiElement psiElement : allToParse) {
                data.append(DebugUtil.psiToString((PsiElement)psiElement, (boolean)PsiViewerDialog.this.myShowWhiteSpacesBox.isSelected(), (boolean)true));
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(data.toString()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dev/psiViewer/PsiViewerDialog$CopyAction", "actionPerformed"));
        }
    }
}

