/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPreviewFeatureUtil {
    @NonNls
    public static final String JDK_INTERNAL_PREVIEW_FEATURE = "jdk.internal.PreviewFeature";
    @NonNls
    public static final String JDK_INTERNAL_JAVAC_PREVIEW_FEATURE = "jdk.internal.javac.PreviewFeature";

    private JavaPreviewFeatureUtil() {
    }

    @Nullable
    public static PreviewFeatureUsage getPreviewFeatureUsage(@NotNull PsiElement element) {
        if (element == null) {
            JavaPreviewFeatureUtil.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)element;
            PsiElement resolved = refElement.resolve();
            if (resolved instanceof PsiModifierListOwner) {
                PsiModifierListOwner owner = (PsiModifierListOwner)resolved;
                return JavaPreviewFeatureUtil.getPreviewFeatureUsage(refElement, owner);
            }
        } else if (element instanceof PsiRequiresStatement) {
            PsiRequiresStatement requiresStatement = (PsiRequiresStatement)element;
            PsiJavaModule module = requiresStatement.resolve();
            if (module == null) {
                return null;
            }
            PsiAnnotation annotation = JavaPreviewFeatureUtil.getPreviewFeatureAnnotationInternal((PsiModifierListOwner)module);
            JavaFeature feature = JavaPreviewFeatureUtil.fromPreviewFeatureAnnotation(annotation);
            if (feature == null) {
                return null;
            }
            PsiJavaModuleReferenceElement moduleRef = requiresStatement.getReferenceElement();
            if (moduleRef != null) {
                return new PreviewFeatureUsage(feature, (PsiElement)moduleRef, (PsiModifierListOwner)module, annotation);
            }
        } else if (element instanceof PsiProvidesStatement) {
            PsiProvidesStatement providesStatement = (PsiProvidesStatement)element;
            PsiReferenceList list = providesStatement.getImplementationList();
            if (list == null) {
                return null;
            }
            for (PsiJavaCodeReferenceElement ref : list.getReferenceElements()) {
                PsiClass psiClass;
                PsiAnnotation annotation;
                JavaFeature feature;
                PsiElement resolved = ref.resolve();
                if (!(resolved instanceof PsiClass) || (feature = JavaPreviewFeatureUtil.fromPreviewFeatureAnnotation(annotation = JavaPreviewFeatureUtil.getPreviewFeatureAnnotationInternal((PsiModifierListOwner)(psiClass = (PsiClass)resolved)))) == null) continue;
                return new PreviewFeatureUsage(feature, (PsiElement)ref, (PsiModifierListOwner)psiClass, annotation);
            }
        }
        return null;
    }

    @Nullable
    public static PreviewFeatureUsage getPreviewFeatureUsage(@NotNull PsiJavaCodeReferenceElement refElement, @NotNull PsiModifierListOwner owner) {
        PsiAnnotation annotation;
        JavaFeature feature;
        if (refElement == null) {
            JavaPreviewFeatureUtil.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            JavaPreviewFeatureUtil.$$$reportNull$$$0(2);
        }
        if ((feature = JavaPreviewFeatureUtil.fromPreviewFeatureAnnotation(annotation = JavaPreviewFeatureUtil.getPreviewFeatureAnnotationInternal(owner))) == null) {
            return null;
        }
        if (JavaPreviewFeatureUtil.isParticipating((PsiElement)refElement, (PsiElement)owner)) {
            return null;
        }
        return new PreviewFeatureUsage(feature, (PsiElement)refElement, owner, annotation);
    }

    private static boolean isParticipating(PsiElement from, PsiElement to) {
        return JavaPsiFacade.getInstance((Project)from.getProject()).arePackagesTheSame(from, to);
    }

    private static PsiAnnotation getPreviewFeatureAnnotationInternal(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            JavaPreviewFeatureUtil.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiPackage) {
            return null;
        }
        PsiAnnotation annotation = element.getAnnotation(JDK_INTERNAL_JAVAC_PREVIEW_FEATURE);
        if (annotation == null) {
            annotation = element.getAnnotation(JDK_INTERNAL_PREVIEW_FEATURE);
        }
        if (annotation == null && element instanceof PsiMember) {
            PsiClass containingClass = ((PsiMember)element).getContainingClass();
            PsiAnnotation psiAnnotation = annotation = containingClass == null ? null : JavaPreviewFeatureUtil.getPreviewFeatureAnnotationInternal((PsiModifierListOwner)containingClass);
        }
        if (annotation == null && !(element instanceof PsiJavaModule)) {
            PsiJavaModule javaModule = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)element);
            annotation = javaModule == null ? null : JavaPreviewFeatureUtil.getPreviewFeatureAnnotationInternal((PsiModifierListOwner)javaModule);
        }
        return annotation;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static JavaFeature fromPreviewFeatureAnnotation(@Nullable PsiAnnotation annotation) {
        if (annotation == null) {
            return null;
        }
        if (!annotation.hasQualifiedName(JDK_INTERNAL_PREVIEW_FEATURE) && !annotation.hasQualifiedName(JDK_INTERNAL_JAVAC_PREVIEW_FEATURE)) {
            return null;
        }
        PsiNameValuePair feature = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"feature");
        if (feature == null) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)feature.getDetachedValue(), PsiReferenceExpression.class);
        if (referenceExpression == null) {
            return null;
        }
        String referenceName = referenceExpression.getReferenceName();
        return referenceName == null ? null : JavaFeature.convertFromPreviewFeatureName((String)referenceName);
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiAnnotation getPreviewFeatureAnnotation(@Nullable PsiModifierListOwner owner) {
        PsiPackage psiPackage;
        if (owner == null) {
            return null;
        }
        PsiAnnotation annotation = JavaPreviewFeatureUtil.getAnnotation(owner);
        if (annotation != null) {
            return annotation;
        }
        if (owner instanceof PsiMember) {
            PsiAnnotation result;
            PsiMember member = (PsiMember)owner;
            if (!owner.hasModifier(JvmModifier.STATIC) && (result = JavaPreviewFeatureUtil.getPreviewFeatureAnnotation((PsiModifierListOwner)member.getContainingClass())) != null) {
                return result;
            }
        }
        if ((psiPackage = JavaResolveUtil.getContainingPackage((PsiElement)owner)) == null) {
            return null;
        }
        PsiAnnotation packageAnnotation = JavaPreviewFeatureUtil.getAnnotation((PsiModifierListOwner)psiPackage);
        if (packageAnnotation != null) {
            return packageAnnotation;
        }
        PsiJavaModule module = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)owner);
        if (module == null) {
            return null;
        }
        return JavaPreviewFeatureUtil.getAnnotation((PsiModifierListOwner)module);
    }

    private static PsiAnnotation getAnnotation(@NotNull PsiModifierListOwner owner) {
        PsiAnnotation annotation;
        if (owner == null) {
            JavaPreviewFeatureUtil.$$$reportNull$$$0(4);
        }
        if ((annotation = owner.getAnnotation(JDK_INTERNAL_JAVAC_PREVIEW_FEATURE)) != null) {
            return annotation;
        }
        return owner.getAnnotation(JDK_INTERNAL_PREVIEW_FEATURE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/core/JavaPreviewFeatureUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviewFeatureUsage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviewFeatureAnnotationInternal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record PreviewFeatureUsage(@NotNull JavaFeature feature, @NotNull PsiElement ref, @NotNull PsiModifierListOwner target, @NotNull PsiAnnotation annotation) {
        @NotNull
        private final JavaFeature feature;
        @NotNull
        private final PsiElement ref;
        @NotNull
        private final PsiModifierListOwner target;
        @NotNull
        private final PsiAnnotation annotation;

        public PreviewFeatureUsage(@NotNull JavaFeature feature, @NotNull PsiElement ref, @NotNull PsiModifierListOwner target, @NotNull PsiAnnotation annotation) {
            if (feature == null) {
                PreviewFeatureUsage.$$$reportNull$$$0(0);
            }
            if (ref == null) {
                PreviewFeatureUsage.$$$reportNull$$$0(1);
            }
            if (target == null) {
                PreviewFeatureUsage.$$$reportNull$$$0(2);
            }
            if (annotation == null) {
                PreviewFeatureUsage.$$$reportNull$$$0(3);
            }
        }

        @NlsSafe
        public String targetName() {
            PsiModifierListOwner psiModifierListOwner = this.target;
            if (psiModifierListOwner instanceof PsiJavaModule) {
                PsiJavaModule module = (PsiJavaModule)psiModifierListOwner;
                return module.getName();
            }
            Object name = null;
            PsiModifierListOwner psiModifierListOwner2 = this.target;
            if (psiModifierListOwner2 instanceof PsiMember) {
                PsiMethod method;
                PsiMember member = (PsiMember)psiModifierListOwner2;
                PsiClass containingClass = member.getContainingClass();
                String methodName = member.getName();
                if (member instanceof PsiClass) {
                    PsiClass psiClass = (PsiClass)member;
                    name = psiClass.getQualifiedName();
                } else if (member instanceof PsiMethod && (method = (PsiMethod)member).isConstructor()) {
                    if (containingClass != null) {
                        name = containingClass.getQualifiedName();
                    }
                } else if (containingClass != null && methodName != null) {
                    name = containingClass.getQualifiedName() + "#" + methodName;
                }
            }
            if (name == null && (psiModifierListOwner2 = this.ref) instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)psiModifierListOwner2;
                name = refElement.getQualifiedName();
            }
            return Objects.requireNonNullElse(name, this.ref.getText());
        }

        public boolean isReflective() {
            return Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)this.annotation(), (String)"reflective"));
        }

        @NotNull
        public JavaFeature feature() {
            JavaFeature javaFeature = this.feature;
            if (javaFeature == null) {
                PreviewFeatureUsage.$$$reportNull$$$0(4);
            }
            return javaFeature;
        }

        @NotNull
        public PsiElement ref() {
            PsiElement psiElement = this.ref;
            if (psiElement == null) {
                PreviewFeatureUsage.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        @NotNull
        public PsiModifierListOwner target() {
            PsiModifierListOwner psiModifierListOwner = this.target;
            if (psiModifierListOwner == null) {
                PreviewFeatureUsage.$$$reportNull$$$0(6);
            }
            return psiModifierListOwner;
        }

        @NotNull
        public PsiAnnotation annotation() {
            PsiAnnotation psiAnnotation = this.annotation;
            if (psiAnnotation == null) {
                PreviewFeatureUsage.$$$reportNull$$$0(7);
            }
            return psiAnnotation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "feature";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPreviewFeatureUtil$PreviewFeatureUsage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPreviewFeatureUtil$PreviewFeatureUsage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "feature";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ref";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "target";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "annotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

