/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.java.codeserver.core.JavaManifestUtil;
import com.intellij.java.codeserver.core.JpmsModuleAccessInfo;
import com.intellij.java.codeserver.core.JpmsModuleInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaModuleGraphHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiJavaModuleModificationTracker;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.searches.JavaModuleSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.JavaMultiReleaseUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class JavaPsiModuleUtil {
    private JavaPsiModuleUtil() {
    }

    @Contract(value="null->null")
    @Nullable
    public static PsiJavaModule findDescriptorByElement(@Nullable PsiElement element) {
        PsiJavaFile file;
        PsiJavaModule module;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiJavaModule) {
            PsiJavaModule module2 = (PsiJavaModule)element;
            return module2;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile instanceof PsiJavaFile && (module = (file = (PsiJavaFile)psiFile).getModuleDeclaration()) != null) {
            return module;
        }
        if (element instanceof PsiFileSystemItem) {
            PsiFileSystemItem fsItem = (PsiFileSystemItem)element;
            return JavaPsiModuleUtil.findDescriptorByFile(fsItem.getVirtualFile(), fsItem.getProject());
        }
        file = element.getContainingFile();
        if (file != null) {
            return JavaPsiModuleUtil.findDescriptorByFile(file.getVirtualFile(), file.getProject());
        }
        if (element instanceof PsiPackage) {
            PsiDirectory[] directories;
            PsiPackage psiPackage = (PsiPackage)element;
            for (PsiDirectory directory : directories = psiPackage.getDirectories(ProjectScope.getLibrariesScope((Project)psiPackage.getProject()))) {
                PsiJavaModule descriptor = JavaPsiModuleUtil.findDescriptorByFile(directory.getVirtualFile(), directory.getProject());
                if (descriptor == null) continue;
                return descriptor;
            }
        }
        return null;
    }

    @Contract(value="null, _->null")
    @Nullable
    public static PsiJavaModule findDescriptorByFile(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return null;
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        return index.isInLibrary(file) ? JavaPsiModuleUtil.findDescriptorInLibrary(file, project) : JavaPsiModuleUtil.findDescriptorByModule(index.getModuleForFile(file), index.isInTestSourceContent(file));
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiJavaModule findDescriptorByLibrary(@Nullable Library library, @NotNull Project project) {
        if (project == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(1);
        }
        if (library == null) {
            return null;
        }
        VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
        if (files.length == 0) {
            return null;
        }
        PsiJavaModule javaModule = JavaPsiModuleUtil.findDescriptorInLibrary(files[0], project);
        return javaModule != null && javaModule.isValid() ? javaModule : null;
    }

    @Nullable
    public static PsiJavaModule findDescriptorInLibrary(@NotNull VirtualFile file, @NotNull Project project) {
        ProjectFileIndex index;
        VirtualFile root;
        if (file == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(3);
        }
        if ((root = (index = ProjectFileIndex.getInstance((Project)project)).getClassRootForFile(file)) != null) {
            VirtualFile descriptorFile = JavaMultiReleaseUtil.findVersionSpecificFile((VirtualFile)root, (String)"module-info.class", (LanguageLevel)LanguageLevel.HIGHEST);
            if (descriptorFile != null) {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(descriptorFile);
                if (psiFile instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            } else if (root.getFileType() instanceof ArchiveFileType && "jar".equalsIgnoreCase(root.getExtension())) {
                PsiDirectory rootPsi = PsiManager.getInstance((Project)project).findDirectory(root);
                assert (rootPsi != null) : root;
                return (PsiJavaModule)CachedValuesManager.getCachedValue((PsiElement)rootPsi, () -> {
                    VirtualFile _root = rootPsi.getVirtualFile();
                    LightJavaModule result = LightJavaModule.create((PsiManager)rootPsi.getManager(), (VirtualFile)_root, (String)LightJavaModule.moduleName((VirtualFile)_root));
                    return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{_root, ProjectRootModificationTracker.getInstance((Project)rootPsi.getProject())});
                });
            }
        } else {
            root = index.getSourceRootForFile(file);
            if (root != null) {
                PsiFile psiFile;
                VirtualFile moduleDescriptor = root.findChild("module-info.java");
                PsiFile psiFile2 = psiFile = moduleDescriptor != null ? PsiManager.getInstance((Project)project).findFile(moduleDescriptor) : null;
                if (psiFile instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            }
        }
        return null;
    }

    @Contract(value="null,_->null")
    @Nullable
    public static PsiJavaModule findDescriptorByModule(@Nullable Module module, boolean inTests) {
        if (module == null) {
            return null;
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)module.getProject());
        PsiJavaModule javaModule = inTests ? (PsiJavaModule)valuesManager.getCachedValue((UserDataHolder)module, () -> JavaPsiModuleUtil.createModuleCacheResult(module, true)) : (PsiJavaModule)valuesManager.getCachedValue((UserDataHolder)module, () -> JavaPsiModuleUtil.createModuleCacheResult(module, false));
        return javaModule != null && javaModule.isValid() ? javaModule : null;
    }

    @NotNull
    private static CachedValueProvider.Result<PsiJavaModule> createModuleCacheResult(@NotNull Module module, boolean inTests) {
        if (module == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(4);
        }
        Project project = module.getProject();
        return new CachedValueProvider.Result((Object)JavaPsiModuleUtil.findDescriptionByModuleInner(module, inTests), new Object[]{ProjectRootModificationTracker.getInstance((Project)project), PsiJavaModuleModificationTracker.getInstance((Project)project)});
    }

    @Nullable
    private static PsiJavaModule findDescriptionByModuleInner(@NotNull Module module, boolean inTests) {
        if (module == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(5);
        }
        Project project = module.getProject();
        GlobalSearchScope moduleScope = module.getModuleScope();
        String virtualAutoModuleName = JavaManifestUtil.getManifestAttributeValue(module, "Automatic-Module-Name");
        if (!DumbService.isDumb((Project)project) && FilenameIndex.getVirtualFilesByName((String)"module-info.java", (GlobalSearchScope)moduleScope).isEmpty() && FilenameIndex.getVirtualFilesByName((String)"MANIFEST.MF", (GlobalSearchScope)moduleScope).isEmpty() && virtualAutoModuleName == null) {
            return null;
        }
        JavaSourceRootType rootType = inTests ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        HashSet excludeRoots = ContainerUtil.newHashSet((Object[])ModuleRootManager.getInstance((Module)module).getExcludeRoots());
        List sourceRoots = ContainerUtil.filter((Collection)rootManager.getSourceRoots((JpsModuleSourceRootType)rootType), root -> !excludeRoots.contains(root));
        List files = ContainerUtil.mapNotNull((Collection)sourceRoots, root -> root.findChild("module-info.java"));
        if (files.isEmpty()) {
            JavaResourceRootType resourceRootType = inTests ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE;
            ArrayList roots = new ArrayList(rootManager.getSourceRoots((JpsModuleSourceRootType)resourceRootType));
            roots.addAll(sourceRoots);
            files = ContainerUtil.mapNotNull(roots, root -> root.findFileByRelativePath("META-INF/MANIFEST.MF"));
            if (files.size() == 1 || new HashSet(files).size() == 1) {
                VirtualFile manifest = (VirtualFile)files.getFirst();
                PsiFile manifestPsi = PsiManager.getInstance((Project)project).findFile(manifest);
                assert (manifestPsi != null) : manifest;
                return (PsiJavaModule)CachedValuesManager.getCachedValue((PsiElement)manifestPsi, () -> {
                    String name = LightJavaModule.claimedModuleName((VirtualFile)manifest);
                    LightJavaModule result = name != null ? LightJavaModule.create((PsiManager)PsiManager.getInstance((Project)project), (VirtualFile)manifest.getParent().getParent(), (String)name) : null;
                    return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{manifestPsi, ProjectRootModificationTracker.getInstance((Project)project)});
                });
            }
            List sourceSourceRoots = rootManager.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
            if (virtualAutoModuleName != null && !sourceSourceRoots.isEmpty()) {
                return LightJavaModule.create((PsiManager)PsiManager.getInstance((Project)project), (VirtualFile)((VirtualFile)sourceSourceRoots.getFirst()), (String)virtualAutoModuleName);
            }
        } else {
            PsiFile psiFile;
            VirtualFile file = (VirtualFile)files.getFirst();
            if (ContainerUtil.and((Iterable)files, f -> f.equals(file)) && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof PsiJavaFile) {
                return ((PsiJavaFile)psiFile).getModuleDeclaration();
            }
        }
        return null;
    }

    public static boolean reads(@NotNull PsiJavaModule source, @NotNull PsiJavaModule destination) {
        if (source == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(6);
        }
        if (destination == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(7);
        }
        return JavaPsiModuleUtil.getRequiresGraph(source).reads(source, destination);
    }

    @NotNull
    public static Set<PsiJavaModule> getAllDependencies(@NotNull PsiJavaModule source) {
        if (source == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(8);
        }
        Set<PsiJavaModule> set = JavaPsiModuleUtil.getRequiresGraph(source).getAllDependencies(source, false);
        if (set == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static Set<PsiJavaModule> getAllTransitiveDependencies(@NotNull PsiJavaModule source) {
        if (source == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(10);
        }
        Set<PsiJavaModule> set = JavaPsiModuleUtil.getRequiresGraph(source).getAllDependencies(source, true);
        if (set == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public static Collection<PsiJavaModule> findCycle(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(12);
        }
        Project project = module.getProject();
        List cycles = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(JavaPsiModuleUtil.findCycles(project), (Object[])new Object[]{PsiJavaModuleModificationTracker.getInstance((Project)project), ProjectRootModificationTracker.getInstance((Project)project)}));
        Collection collection = Objects.requireNonNullElse((Collection)ContainerUtil.find((Iterable)cycles, set -> set.contains(module)), Collections.emptyList());
        if (collection == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiJavaModule module) {
        if (module == null) {
            return null;
        }
        if (module instanceof LightJavaModule) {
            LightJavaModule light = (LightJavaModule)module;
            return light.getRootVirtualFile();
        }
        return PsiUtilCore.getVirtualFile((PsiElement)module);
    }

    private static @Unmodifiable @NotNull List<Set<PsiJavaModule>> findCycles(@NotNull Project project) {
        if (project == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(14);
        }
        HashSet<PsiJavaModule> projectModules = new HashSet<PsiJavaModule>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            List descriptors = ContainerUtil.mapNotNull((Object[])moduleRootManager.getSourceRoots(true), root -> JavaPsiModuleUtil.findDescriptorByFile(root, project));
            if (descriptors.size() > 2) {
                List<Set<PsiJavaModule>> list = Collections.emptyList();
                if (list == null) {
                    JavaPsiModuleUtil.$$$reportNull$$$0(15);
                }
                return list;
            }
            if (descriptors.size() == 2) {
                if (descriptors.stream().map(d -> JavaPsiModuleUtil.getVirtualFile(d)).filter(Objects::nonNull).count() < 2L) {
                    List<Set<PsiJavaModule>> list = Collections.emptyList();
                    if (list == null) {
                        JavaPsiModuleUtil.$$$reportNull$$$0(16);
                    }
                    return list;
                }
                projectModules.addAll(descriptors);
            }
            if (descriptors.size() != 1) continue;
            projectModules.add((PsiJavaModule)descriptors.getFirst());
        }
        if (!projectModules.isEmpty()) {
            ChameleonGraph graph;
            DFSTBuilder builder;
            Collection components;
            MultiMap relations = MultiMap.create();
            for (PsiJavaModule module : projectModules) {
                for (PsiRequiresStatement statement : module.getRequires()) {
                    PsiJavaModule dependency;
                    ResolveResult[] results;
                    PsiJavaModuleReference ref = statement.getModuleReference();
                    if (ref == null || (results = ref.multiResolve(true)).length != 1 || (dependency = (PsiJavaModule)results[0].getElement()) == null || !projectModules.contains(dependency)) continue;
                    relations.putValue((Object)module, (Object)dependency);
                }
            }
            if (!relations.isEmpty() && !(components = (builder = new DFSTBuilder(graph = new ChameleonGraph(relations, false))).getComponents()).isEmpty()) {
                List list = ContainerUtil.map((Collection)components, elements -> new LinkedHashSet(elements));
                if (list == null) {
                    JavaPsiModuleUtil.$$$reportNull$$$0(17);
                }
                return list;
            }
        }
        List<Set<PsiJavaModule>> list = Collections.emptyList();
        if (list == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    public static boolean exports(@NotNull PsiJavaModule source, @NotNull String packageName, @Nullable PsiJavaModule target) {
        Map exports;
        Set targets;
        if (source == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(19);
        }
        if (packageName == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(20);
        }
        return (targets = (Set)(exports = (Map)CachedValuesManager.getCachedValue((PsiElement)source, () -> CachedValueProvider.Result.create(JavaPsiModuleUtil.exportsMap(source), (Object[])new Object[]{source.getContainingFile()}))).get(packageName)) != null && (targets.isEmpty() || target != null && targets.contains(target.getName()));
    }

    @NotNull
    private static Map<String, Set<String>> exportsMap(@NotNull PsiJavaModule source) {
        if (source == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(21);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (PsiPackageAccessibilityStatement statement : source.getExports()) {
            String pkg = statement.getPackageName();
            List targets = statement.getModuleNames();
            map.put(pkg, targets.isEmpty() ? Collections.emptySet() : new HashSet(targets));
        }
        HashMap<String, Set<String>> hashMap = map;
        if (hashMap == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(22);
        }
        return hashMap;
    }

    @Nullable
    public static ModulePackageConflict findConflict(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(23);
        }
        return JavaPsiModuleUtil.getRequiresGraph(module).findConflict(module);
    }

    @Nullable
    public static PsiJavaModule findOrigin(@NotNull PsiJavaModule module, @NotNull String packageName) {
        if (module == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(24);
        }
        if (packageName == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(25);
        }
        return JavaPsiModuleUtil.getRequiresGraph(module).findOrigin(module, packageName);
    }

    private static RequiresGraph getRequiresGraph(@NotNull PsiJavaModule module) {
        Project project;
        if (module == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(26);
        }
        if (DumbService.getInstance((Project)(project = module.getProject())).isAlternativeResolveEnabled()) {
            return (RequiresGraph)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> JavaPsiModuleUtil.buildRequiresGraph(project));
        }
        return (RequiresGraph)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)JavaPsiModuleUtil.buildRequiresGraph(project), (Object[])new Object[]{PsiJavaModuleModificationTracker.getInstance((Project)project), ProjectRootModificationTracker.getInstance((Project)project)}));
    }

    @NotNull
    private static RequiresGraph buildRequiresGraph(@NotNull Project project) {
        if (project == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(27);
        }
        MultiMap allModules = MultiMap.create();
        MultiMap relations = MultiMap.create();
        HashSet<String> transitiveEdges = new HashSet<String>();
        GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
        JavaModuleSearch.allModules((Project)project, (GlobalSearchScope)scope).forEach(module -> {
            allModules.putValue((Object)module.getName(), module);
            return true;
        });
        for (PsiJavaModule module2 : allModules.values()) {
            if (module2 instanceof LightJavaModule) continue;
            JavaPsiModuleUtil.visit(module2, (MultiMap<PsiJavaModule, PsiJavaModule>)relations, transitiveEdges, (MultiMap<String, PsiJavaModule>)allModules);
        }
        Graph graph = GraphGenerator.generate(new ChameleonGraph(relations, true));
        return new RequiresGraph((Graph<PsiJavaModule>)graph, transitiveEdges);
    }

    private static void visit(@NotNull PsiJavaModule module, @NotNull MultiMap<PsiJavaModule, PsiJavaModule> relations, @NotNull Set<String> transitiveEdges, @NotNull MultiMap<String, PsiJavaModule> allModules) {
        List<PsiJavaModule> modules;
        if (module == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(28);
        }
        if (relations == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(29);
        }
        if (transitiveEdges == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(30);
        }
        if (allModules == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(31);
        }
        relations.putValues((Object)module, Collections.emptyList());
        boolean explicitJavaBase = false;
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)module.getProject());
        for (PsiRequiresStatement statement : module.getRequires()) {
            PsiJavaModuleReference ref = statement.getModuleReference();
            if (ref == null) continue;
            String moduleName = ref.getCanonicalText();
            if ("java.base".equals(moduleName)) {
                explicitJavaBase = true;
            }
            for (PsiJavaModule dependency : JavaPsiModuleUtil.filterModules(allModules.get((Object)moduleName), scope)) {
                relations.putValue((Object)module, (Object)dependency);
                if (!statement.hasModifierProperty("transitive")) continue;
                transitiveEdges.add(RequiresGraph.key(dependency, module));
            }
        }
        if (!explicitJavaBase && (modules = JavaPsiModuleUtil.filterModules(allModules.get((Object)"java.base"), module.getResolveScope())).size() == 1) {
            relations.putValue((Object)module, (Object)((PsiJavaModule)modules.iterator().next()));
        }
    }

    @NotNull
    private static List<PsiJavaModule> filterModules(@NotNull Collection<PsiJavaModule> modules, @NotNull GlobalSearchScope scope) {
        if (modules == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(33);
        }
        SmartList filtered = new SmartList();
        for (PsiJavaModule candidate : modules) {
            VirtualFile candidateFile = JavaPsiModuleUtil.getVirtualFile(candidate);
            if (candidateFile == null || !scope.contains(candidateFile)) continue;
            filtered.add((Object)candidate);
        }
        SmartList smartList = filtered;
        if (smartList == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(34);
        }
        return smartList;
    }

    @NotNull
    public static PackageReferenceState checkPackageReference(@NotNull PsiPackageAccessibilityStatement statement) {
        PsiFile file;
        Module module;
        PsiJavaCodeReferenceElement refElement;
        if (statement == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(35);
        }
        if ((refElement = statement.getPackageReference()) != null && (module = ModuleUtilCore.findModuleForFile((PsiFile)(file = statement.getContainingFile()))) != null) {
            boolean opens;
            PsiElement target = refElement.resolve();
            Object[] directories = PsiDirectory.EMPTY_ARRAY;
            if (target instanceof PsiPackage) {
                PsiPackage psiPackage = (PsiPackage)target;
                boolean inTests = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(file.getVirtualFile());
                directories = psiPackage.getDirectories(module.getModuleScope(inTests));
                Module mainMultiReleaseModule = JavaMultiReleaseUtil.getMainMultiReleaseModule((Module)module);
                if (mainMultiReleaseModule != null) {
                    directories = (PsiDirectory[])ArrayUtil.mergeArrays((Object[])directories, (Object[])psiPackage.getDirectories(mainMultiReleaseModule.getModuleScope(inTests)));
                }
            }
            String packageName = statement.getPackageName();
            if (directories.length == 0) {
                PackageReferenceState packageReferenceState = PackageReferenceState.PACKAGE_NOT_FOUND;
                if (packageReferenceState == null) {
                    JavaPsiModuleUtil.$$$reportNull$$$0(36);
                }
                return packageReferenceState;
            }
            boolean bl = opens = statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS;
            if (packageName != null && JavaPsiModuleUtil.isPackageEmpty((PsiDirectory[])directories, packageName, opens)) {
                PackageReferenceState packageReferenceState = PackageReferenceState.PACKAGE_EMPTY;
                if (packageReferenceState == null) {
                    JavaPsiModuleUtil.$$$reportNull$$$0(37);
                }
                return packageReferenceState;
            }
        }
        PackageReferenceState packageReferenceState = PackageReferenceState.VALID;
        if (packageReferenceState == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(38);
        }
        return packageReferenceState;
    }

    private static boolean isPackageEmpty(PsiDirectory @NotNull [] directories, @NotNull String packageName, boolean anyFile) {
        if (packageName == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(39);
        }
        if (directories == null) {
            JavaPsiModuleUtil.$$$reportNull$$$0(40);
        }
        if (anyFile) {
            return !ContainerUtil.exists((Object[])directories, dir -> dir.getFiles().length > 0);
        }
        return PsiUtil.isPackageEmpty((PsiDirectory[])directories, (String)packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 13, 15, 16, 17, 18, 22, 34, 36, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil";
                break;
            }
            case 20: 
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relations";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transitiveEdges";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModules";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTransitiveDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findCycle";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findCycles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "exportsMap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "filterModules";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPackageReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorByFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorByLibrary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorInLibrary";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModuleCacheResult";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptionByModuleInner";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reads";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependencies";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllTransitiveDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCycle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCycles";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "exports";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exportsMap";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findConflict";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findOrigin";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRequiresGraph";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildRequiresGraph";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "filterModules";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageReference";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isPackageEmpty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 13, 15, 16, 17, 18, 22, 34, 36, 37, 38 -> new IllegalStateException(string);
        };
    }

    private static final class RequiresGraph {
        @NotNull
        private final Graph<PsiJavaModule> myGraph;
        @NotNull
        private final Set<String> myTransitiveEdges;

        private RequiresGraph(@NotNull Graph<PsiJavaModule> graph, @NotNull Set<String> transitiveEdges) {
            if (graph == null) {
                RequiresGraph.$$$reportNull$$$0(0);
            }
            if (transitiveEdges == null) {
                RequiresGraph.$$$reportNull$$$0(1);
            }
            this.myGraph = graph;
            this.myTransitiveEdges = transitiveEdges;
        }

        public boolean reads(PsiJavaModule source, PsiJavaModule destination) {
            source = RequiresGraph.getPhysicalModule(source);
            destination = RequiresGraph.getPhysicalModule(destination);
            Collection nodes = this.myGraph.getNodes();
            if (!nodes.contains(destination) || !nodes.contains(source)) {
                return false;
            }
            UniqueBuffer<PsiJavaModule> buffer = new UniqueBuffer<PsiJavaModule>();
            buffer.add(destination);
            while (!buffer.isEmpty()) {
                destination = (PsiJavaModule)buffer.poll();
                Iterator directReaders = this.myGraph.getOut((Object)destination);
                while (directReaders.hasNext()) {
                    PsiJavaModule next = (PsiJavaModule)directReaders.next();
                    if (source.equals((Object)next)) {
                        return true;
                    }
                    if (!this.myTransitiveEdges.contains(RequiresGraph.key(destination, next)) || next.equals((Object)destination)) continue;
                    buffer.add(next);
                }
            }
            return false;
        }

        @Nullable
        private ModulePackageConflict findConflict(@NotNull PsiJavaModule source) {
            if (source == null) {
                RequiresGraph.$$$reportNull$$$0(2);
            }
            source = RequiresGraph.getPhysicalModule(source);
            HashMap exports = new HashMap();
            return this.processExports(source, (pkg, m) -> {
                PsiJavaModule found = exports.put(pkg, m);
                return found == null || found instanceof LightJavaModule && m instanceof LightJavaModule || found.getName().equals(m.getName()) ? null : new ModulePackageConflict((String)pkg, found, (PsiJavaModule)m);
            });
        }

        @Nullable
        private PsiJavaModule findOrigin(@NotNull PsiJavaModule module, @NotNull String packageName) {
            if (module == null) {
                RequiresGraph.$$$reportNull$$$0(3);
            }
            if (packageName == null) {
                RequiresGraph.$$$reportNull$$$0(4);
            }
            return this.processExports(RequiresGraph.getPhysicalModule(module), (pkg, m) -> packageName.equals(pkg) ? m : null);
        }

        @Nullable
        private <T> T processExports(@NotNull PsiJavaModule start, @NotNull BiFunction<? super String, ? super PsiJavaModule, ? extends T> processor) {
            if (start == null) {
                RequiresGraph.$$$reportNull$$$0(5);
            }
            if (processor == null) {
                RequiresGraph.$$$reportNull$$$0(6);
            }
            start = RequiresGraph.getPhysicalModule(start);
            return this.myGraph.getNodes().contains(start) ? (T)this.processExports(start.getName(), start, true, new HashSet(), processor) : null;
        }

        @Nullable
        private <T> T processExports(@Nullable String name, @NotNull PsiJavaModule module, boolean direct, @NotNull Set<? super PsiJavaModule> visited, @NotNull BiFunction<? super String, ? super PsiJavaModule, ? extends T> processor) {
            if (module == null) {
                RequiresGraph.$$$reportNull$$$0(7);
            }
            if (visited == null) {
                RequiresGraph.$$$reportNull$$$0(8);
            }
            if (processor == null) {
                RequiresGraph.$$$reportNull$$$0(9);
            }
            if (visited.add((PsiJavaModule)(module = RequiresGraph.getPhysicalModule(module)))) {
                if (!direct) {
                    for (PsiPackageAccessibilityStatement statement : module.getExports()) {
                        T result;
                        List exportTargets = statement.getModuleNames();
                        if (!exportTargets.isEmpty() && !exportTargets.contains(name) || (result = processor.apply(statement.getPackageName(), (PsiJavaModule)module)) == null) continue;
                        return result;
                    }
                }
                Iterator iterator = this.myGraph.getIn((Object)module);
                while (iterator.hasNext()) {
                    T result;
                    PsiJavaModule dependency = (PsiJavaModule)iterator.next();
                    if (!direct && !this.myTransitiveEdges.contains(RequiresGraph.key(dependency, module)) || (result = this.processExports(name, dependency, false, visited, processor)) == null) continue;
                    return result;
                }
            }
            return null;
        }

        @NotNull
        public static String key(@NotNull PsiJavaModule module, @NotNull PsiJavaModule exporter) {
            if (module == null) {
                RequiresGraph.$$$reportNull$$$0(10);
            }
            if (exporter == null) {
                RequiresGraph.$$$reportNull$$$0(11);
            }
            String string = module.getName() + "/" + exporter.getName();
            if (string == null) {
                RequiresGraph.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        public Set<PsiJavaModule> getAllDependencies(@NotNull PsiJavaModule module, boolean transitive) {
            if (module == null) {
                RequiresGraph.$$$reportNull$$$0(13);
            }
            HashSet<PsiJavaModule> requires = new HashSet<PsiJavaModule>();
            this.collectDependencies(RequiresGraph.getPhysicalModule(module), requires, transitive);
            HashSet<PsiJavaModule> hashSet = requires;
            if (hashSet == null) {
                RequiresGraph.$$$reportNull$$$0(14);
            }
            return hashSet;
        }

        private void collectDependencies(@NotNull PsiJavaModule module, @NotNull Set<PsiJavaModule> dependencies, boolean transitive) {
            if (module == null) {
                RequiresGraph.$$$reportNull$$$0(15);
            }
            if (dependencies == null) {
                RequiresGraph.$$$reportNull$$$0(16);
            }
            module = RequiresGraph.getPhysicalModule(module);
            Iterator iterator = this.myGraph.getIn((Object)module);
            while (iterator.hasNext()) {
                PsiJavaModule dependency = (PsiJavaModule)iterator.next();
                if (dependencies.contains(dependency) || transitive && !this.myTransitiveEdges.contains(RequiresGraph.key(dependency, module))) continue;
                dependencies.add(dependency);
                this.collectDependencies(dependency, dependencies, transitive);
            }
        }

        @NotNull
        private static PsiJavaModule getPhysicalModule(@NotNull PsiJavaModule from) {
            if (from == null) {
                RequiresGraph.$$$reportNull$$$0(17);
            }
            if (from.isPhysical()) {
                PsiJavaModule psiJavaModule = from;
                if (psiJavaModule == null) {
                    RequiresGraph.$$$reportNull$$$0(18);
                }
                return psiJavaModule;
            }
            PsiFile psiFile = from.getContainingFile();
            if (!(psiFile instanceof PsiJavaFile)) {
                PsiJavaModule psiJavaModule = from;
                if (psiJavaModule == null) {
                    RequiresGraph.$$$reportNull$$$0(19);
                }
                return psiJavaModule;
            }
            PsiJavaFile file = (PsiJavaFile)psiFile;
            PsiFile psiFile2 = file.getOriginalFile();
            if (!(psiFile2 instanceof PsiJavaFile)) {
                PsiJavaModule psiJavaModule = from;
                if (psiJavaModule == null) {
                    RequiresGraph.$$$reportNull$$$0(20);
                }
                return psiJavaModule;
            }
            PsiJavaFile origin = (PsiJavaFile)psiFile2;
            PsiJavaModule psiJavaModule = origin.getModuleDeclaration();
            if (psiJavaModule instanceof PsiJavaModule) {
                PsiJavaModule result;
                PsiJavaModule psiJavaModule2 = result = psiJavaModule;
                if (psiJavaModule2 == null) {
                    RequiresGraph.$$$reportNull$$$0(21);
                }
                return psiJavaModule2;
            }
            PsiJavaModule psiJavaModule3 = from;
            if (psiJavaModule3 == null) {
                RequiresGraph.$$$reportNull$$$0(22);
            }
            return psiJavaModule3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 12, 14, 18, 19, 20, 21, 22 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transitiveEdges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 7: 
                case 10: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "start";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exporter";
                    break;
                }
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil$RequiresGraph";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil$RequiresGraph";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "key";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllDependencies";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPhysicalModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findConflict";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrigin";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "processExports";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "key";
                    break;
                }
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllDependencies";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependencies";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getPhysicalModule";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 12, 14, 18, 19, 20, 21, 22 -> new IllegalStateException(string);
            };
        }

        private static class UniqueBuffer<T> {
            private final Set<T> myUnique = new HashSet<T>();
            private final Queue<T> myBuffer = new ArrayDeque<T>();

            private UniqueBuffer() {
            }

            public void add(T value) {
                if (this.myUnique.add(value)) {
                    this.myBuffer.add(value);
                }
            }

            public T poll() {
                return this.myBuffer.poll();
            }

            public boolean isEmpty() {
                return this.myBuffer.isEmpty();
            }
        }
    }

    private static final class ChameleonGraph<N>
    implements Graph<N> {
        private final Set<N> myNodes = new HashSet<N>();
        private final MultiMap<N, N> myEdges;
        private final boolean myInbound;

        private ChameleonGraph(MultiMap<N, N> edges, boolean inbound) {
            edges.entrySet().forEach(e -> {
                this.myNodes.add(e.getKey());
                this.myNodes.addAll((Collection)e.getValue());
            });
            this.myEdges = edges;
            this.myInbound = inbound;
        }

        @NotNull
        public Collection<N> getNodes() {
            Set<N> set = this.myNodes;
            if (set == null) {
                ChameleonGraph.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public Iterator<N> getIn(N n) {
            Iterator<Object> iterator = this.myInbound ? this.myEdges.get(n).iterator() : Collections.emptyIterator();
            if (iterator == null) {
                ChameleonGraph.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        @NotNull
        public Iterator<N> getOut(N n) {
            Iterator<Object> iterator = this.myInbound ? Collections.emptyIterator() : this.myEdges.get(n).iterator();
            if (iterator == null) {
                ChameleonGraph.$$$reportNull$$$0(2);
            }
            return iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil$ChameleonGraph";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOut";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public record ModulePackageConflict(@NotNull String packageName, @NotNull PsiJavaModule module1, @NotNull PsiJavaModule module2) {
        @NotNull
        private final String packageName;
        @NotNull
        private final PsiJavaModule module1;
        @NotNull
        private final PsiJavaModule module2;

        public ModulePackageConflict(@NotNull String packageName, @NotNull PsiJavaModule module1, @NotNull PsiJavaModule module2) {
            if (packageName == null) {
                ModulePackageConflict.$$$reportNull$$$0(0);
            }
            if (module1 == null) {
                ModulePackageConflict.$$$reportNull$$$0(1);
            }
            if (module2 == null) {
                ModulePackageConflict.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public String packageName() {
            String string = this.packageName;
            if (string == null) {
                ModulePackageConflict.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public PsiJavaModule module1() {
            PsiJavaModule psiJavaModule = this.module1;
            if (psiJavaModule == null) {
                ModulePackageConflict.$$$reportNull$$$0(4);
            }
            return psiJavaModule;
        }

        @NotNull
        public PsiJavaModule module2() {
            PsiJavaModule psiJavaModule = this.module2;
            if (psiJavaModule == null) {
                ModulePackageConflict.$$$reportNull$$$0(5);
            }
            return psiJavaModule;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module2";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil$ModulePackageConflict";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil$ModulePackageConflict";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "packageName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "module1";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "module2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static enum PackageReferenceState {
        VALID,
        PACKAGE_NOT_FOUND,
        PACKAGE_EMPTY;

    }

    public static class Helper
    extends JavaModuleGraphHelper {
        @Contract(value="null->null")
        @Nullable
        public PsiJavaModule findDescriptorByElement(@Nullable PsiElement element) {
            return JavaPsiModuleUtil.findDescriptorByElement(element);
        }

        @NotNull
        public Set<PsiJavaModule> getAllTransitiveDependencies(@NotNull PsiJavaModule psiJavaModule) {
            if (psiJavaModule == null) {
                Helper.$$$reportNull$$$0(0);
            }
            Set<PsiJavaModule> set = JavaPsiModuleUtil.getAllTransitiveDependencies(psiJavaModule);
            if (set == null) {
                Helper.$$$reportNull$$$0(1);
            }
            return set;
        }

        public boolean isAccessible(@NotNull String targetPackageName, PsiFile targetFile, @NotNull PsiElement place) {
            PsiFile useFile;
            if (targetPackageName == null) {
                Helper.$$$reportNull$$$0(2);
            }
            if (place == null) {
                Helper.$$$reportNull$$$0(3);
            }
            PsiFile psiFile = useFile = place.getContainingFile() != null ? place.getContainingFile().getOriginalFile() : null;
            if (useFile == null) {
                return true;
            }
            List<JpmsModuleInfo.TargetModuleInfo> infos = JpmsModuleInfo.findTargetModuleInfos(targetPackageName, targetFile, useFile);
            if (infos == null) {
                return true;
            }
            return !infos.isEmpty() && ContainerUtil.exists(infos, info -> info.accessAt((PsiFileSystemItem)useFile).checkAccess((PsiFileSystemItem)useFile, JpmsModuleAccessInfo.JpmsModuleAccessMode.EXPORT) == null);
        }

        public boolean isAccessible(@NotNull PsiJavaModule targetModule, @NotNull PsiElement place) {
            PsiFile useFile;
            if (targetModule == null) {
                Helper.$$$reportNull$$$0(4);
            }
            if (place == null) {
                Helper.$$$reportNull$$$0(5);
            }
            PsiFile psiFile = useFile = place.getContainingFile() != null ? place.getContainingFile().getOriginalFile() : null;
            if (useFile == null) {
                return true;
            }
            return new JpmsModuleInfo.TargetModuleInfoByJavaModule(targetModule, "").accessAt((PsiFileSystemItem)useFile).checkModuleAccess(place) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiJavaModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil$Helper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPackageName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiModuleUtil$Helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllTransitiveDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllTransitiveDependencies";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAccessible";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

