/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiSealedUtil {
    private JavaPsiSealedUtil() {
    }

    public static boolean isAbstractSealed(@Nullable PsiClass psiClass) {
        return psiClass != null && JavaPsiSealedUtil.isSealed(psiClass) && psiClass.hasModifierProperty("abstract");
    }

    private static boolean isSealed(@Nullable PsiClass psiClass) {
        return psiClass != null && (psiClass.hasModifierProperty("sealed") || psiClass.getPermitsList() != null);
    }

    @NotNull
    public static Collection<PsiClass> getPermittedClasses(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaPsiSealedUtil.$$$reportNull$$$0(0);
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            PsiReferenceList permitsList = psiClass.getPermitsList();
            Collection results = permitsList == null ? SyntaxTraverser.psiTraverser((PsiElement)psiClass.getContainingFile()).filter(PsiClass.class).filter(cls -> !(cls instanceof PsiAnonymousClass) && !PsiUtil.isLocalClass((PsiClass)cls)).filter(cls -> cls.isInheritor(psiClass, false)).toList() : (Collection)Stream.of(permitsList.getReferencedTypes()).map(type -> type.resolve()).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
            return CachedValueProvider.Result.create((Object)results, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (collection == null) {
            JavaPsiSealedUtil.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public static Set<PsiClass> getAllPermittedClasses(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaPsiSealedUtil.$$$reportNull$$$0(2);
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            HashSet<PsiClass> result = new HashSet<PsiClass>();
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            LinkedList<PsiClass> notVisitedClasses = new LinkedList<PsiClass>();
            notVisitedClasses.add(psiClass);
            while (!notVisitedClasses.isEmpty()) {
                PsiClass notVisitedClass = (PsiClass)notVisitedClasses.poll();
                if (!JavaPsiSealedUtil.isAbstractSealed(notVisitedClass) || visitedClasses.contains(notVisitedClass)) continue;
                visitedClasses.add(notVisitedClass);
                Collection<PsiClass> permittedClasses = JavaPsiSealedUtil.getPermittedClasses(notVisitedClass);
                result.addAll(permittedClasses);
                notVisitedClasses.addAll(permittedClasses);
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static Set<PsiClass> findSealedUpperClasses(Set<PsiClass> classes) {
        HashSet<PsiClass> sealedUpperClasses = new HashSet<PsiClass>();
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        ArrayDeque<PsiClass> nonVisited = new ArrayDeque<PsiClass>(classes);
        while (!nonVisited.isEmpty()) {
            PsiClassType[] types;
            PsiClass polled = (PsiClass)nonVisited.poll();
            if (!visited.add(polled)) continue;
            for (PsiClassType type : types = polled.getSuperTypes()) {
                PsiClass superClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)TypeConversionUtil.erasure((PsiType)type));
                if (!JavaPsiSealedUtil.isAbstractSealed(superClass)) continue;
                nonVisited.add(superClass);
                sealedUpperClasses.add(superClass);
            }
        }
        return sealedUpperClasses;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/core/JavaPsiSealedUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiSealedUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermittedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPermittedClasses";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllPermittedClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

