/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.dataSource.LinkedDataSourceHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dialects.mssql.model.MsLinkedServer;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/mssql/MsLinkedDataSourceHelper;", "Lcom/intellij/database/dataSource/LinkedDataSourceHelper;", "<init>", "()V", "getLinkedDataSourceKind", "Lcom/intellij/database/model/ObjectKind;", "createLinkedDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "link", "Lcom/intellij/database/model/DasObject;", "linkDs", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.dialects.mssql"})
public final class MsLinkedDataSourceHelper
extends LinkedDataSourceHelper {
    @NotNull
    public ObjectKind getLinkedDataSourceKind() {
        ObjectKind objectKind = ObjectKind.LINKED_SERVER;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"LINKED_SERVER");
        return objectKind;
    }

    @NotNull
    public LocalDataSource createLinkedDataSource(@NotNull DasObject link, @NotNull LocalDataSource linkDs, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)linkDs, (String)"linkDs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LocalDataSource localDataSource = super.createLinkedDataSource(link, linkDs, project);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"createLinkedDataSource(...)");
        LocalDataSource ds = localDataSource;
        MsLinkedServer msLinkedServer = link instanceof MsLinkedServer ? (MsLinkedServer)link : null;
        if (msLinkedServer == null) {
            return ds;
        }
        MsLinkedServer linkedServer = msLinkedServer;
        if (!Intrinsics.areEqual((Object)linkedServer.getProviderName(), (Object)"SQLNCLI")) {
            return ds;
        }
        Object object = linkDs.getDatabaseDriver();
        UrlEditorModel model = new UrlEditorModel(object != null && (object = object.getJDBCUrlParsers()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
        String string = linkDs.getUrl();
        if (string == null) {
            string = "";
        }
        model.setUrl(string);
        model.commit((Object)true);
        String string2 = linkedServer.getDataSource();
        if (string2 == null) {
            string2 = "";
        }
        model.setParameter("instance", string2);
        String string3 = linkedServer.getCatalog();
        if (string3 == null) {
            string3 = "";
        }
        model.setParameter("database", string3);
        model.commit((Object)true);
        ds.setUrl(model.getUrl());
        return ds;
    }
}

