/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.SizeAndScale;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0014\u0010\u0018\u001a\u00020\u00102\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/mssql/generator/TsqlScriptGeneratorHelperBase;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/dialects/base/generator/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "statementDelimiterStr", "getStatementDelimiterStr", "()Ljava/lang/String;", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "isNullExplicit", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "useObjectIdInOrder", "getUseObjectIdInOrder", "isOptionSupported", "option", "Lcom/intellij/database/script/generator/ScriptingOption;", "intellij.database.dialects.mssql"})
public abstract class TsqlScriptGeneratorHelperBase
extends ScriptGeneratorHelper {
    @NotNull
    private final Map<String, SizeAndScale> defaultPrimitiveSizes;
    @NotNull
    private final String statementDelimiterStr;
    private final boolean statementDelimiterOwnsLine;

    public TsqlScriptGeneratorHelperBase(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bit", (Object)ScriptGeneratorHelperKt.getSizeAndScale1()), TuplesKt.to((Object)"boolean", (Object)ScriptGeneratorHelperKt.getSizeAndScale1()), TuplesKt.to((Object)"char", (Object)ScriptGeneratorHelperKt.getSizeAndScale1()), TuplesKt.to((Object)"nchar", (Object)ScriptGeneratorHelperKt.getSizeAndScale1()), TuplesKt.to((Object)"varchar", (Object)ScriptGeneratorHelperKt.getSizeAndScale1()), TuplesKt.to((Object)"nvarchar", (Object)ScriptGeneratorHelperKt.getSizeAndScale1()), TuplesKt.to((Object)"binary", (Object)ScriptGeneratorHelperKt.getSizeAndScale1()), TuplesKt.to((Object)"varbinary", (Object)ScriptGeneratorHelperKt.getSizeAndScale1()), TuplesKt.to((Object)"decimal", (Object)new SizeAndScale(18, 0, 2, null)), TuplesKt.to((Object)"numeric", (Object)new SizeAndScale(18, 0, 2, null)), TuplesKt.to((Object)"float", (Object)new SizeAndScale(53, 0, 2, null))};
        this.defaultPrimitiveSizes = MapsKt.mapOf((Pair[])pairArray);
        this.statementDelimiterStr = "go";
        this.statementDelimiterOwnsLine = true;
    }

    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    @NotNull
    public String getStatementDelimiterStr() {
        return this.statementDelimiterStr;
    }

    public boolean getStatementDelimiterOwnsLine() {
        return this.statementDelimiterOwnsLine;
    }

    public boolean isNullExplicit(@Nullable BasicLikeColumn column) {
        BasicLikeColumn basicLikeColumn = column;
        DasType dasType = basicLikeColumn != null ? basicLikeColumn.getDasType() : null;
        return dasType != null && Intrinsics.areEqual((Object)DasTypeUtilsKt.getTypeName((DasType)dasType), (Object)"timestamp") && !dasType.toDataType().custom;
    }

    protected final boolean getUseObjectIdInOrder() {
        return false;
    }

    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        return Intrinsics.areEqual(option, (Object)ScriptingOptionStatic.USE_SEMICOLON) ? true : super.isOptionSupported(option);
    }
}

