/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.mssql.generator.MsNamingService;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.mssql.MsDialect;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u000fJ\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u000fH\u0002J\"\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u0014\u001a\u00020\u000fH\u0002J\f\u0010\u001a\u001a\u00020\u000f*\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014 \u000b*\t\u0018\u00010\t\u00a2\u0006\u0002\b\n0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospectorHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/Dbms;)V", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "Lorg/jetbrains/annotations/UnknownNullability;", "kotlin.jvm.PlatformType", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "isSchemaSystem", "", "schemaName", "", "normalizeExpression", "expression", "forceUnquote", "parseAndNormalizeExpression", "normalizeExpressionInPsi", "Lcom/intellij/sql/psi/SqlExpression;", "textSize", "", "shouldBeEliminated", "Lcom/intellij/sql/psi/SqlParenthesizedExpression;", "Companion", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsIntrospectorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospectorHelper.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospectorHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1915#2,2:140\n1915#2,2:142\n1#3:144\n*S KotlinDebug\n*F\n+ 1 MsIntrospectorHelper.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospectorHelper\n*L\n95#1:140,2\n110#1:142,2\n*E\n"})
public final class MsIntrospectorHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final SqlLanguageDialect dialect;
    @NotNull
    private static final Map<String, ObjectKind> majorKindByCodes;
    @NotNull
    private static final Set<SqlTokenType> leftAssociativeOperators;
    @NotNull
    private static final Set<String> systemSchemaNames;

    public MsIntrospectorHelper(@NotNull Project project, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.project = project;
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(dbms);
        if (sqlLanguageDialect == null) {
            sqlLanguageDialect = (SqlLanguageDialect)MsDialect.INSTANCE;
        }
        this.dialect = sqlLanguageDialect;
    }

    public final SqlLanguageDialect getDialect() {
        return this.dialect;
    }

    public final boolean isSchemaSystem(@NotNull String schemaName) {
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        return systemSchemaNames.contains(schemaName);
    }

    @Nullable
    public final String normalizeExpression(@Nullable String expression, boolean forceUnquote) {
        CharSequence charSequence = expression;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        if (!StringsKt.contains$default((CharSequence)expression, (char)'(', (boolean)false, (int)2, null)) {
            return expression;
        }
        String string = this.parseAndNormalizeExpression(expression, forceUnquote);
        if (string == null) {
            string = expression;
        }
        return string;
    }

    public static /* synthetic */ String normalizeExpression$default(MsIntrospectorHelper msIntrospectorHelper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return msIntrospectorHelper.normalizeExpression(string, bl);
    }

    private final String parseAndNormalizeExpression(String expression, boolean forceUnquote) {
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText((String)expression, (SqlLanguageDialect)this.dialect, (Project)this.project, null);
        if (sqlExpression == null) {
            return null;
        }
        SqlExpression exp = sqlExpression;
        return this.normalizeExpressionInPsi(exp, expression.length(), forceUnquote);
    }

    static /* synthetic */ String parseAndNormalizeExpression$default(MsIntrospectorHelper msIntrospectorHelper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return msIntrospectorHelper.parseAndNormalizeExpression(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final String normalizeExpressionInPsi(SqlExpression expression, int textSize, boolean forceUnquote) {
        void $this$forEach$iv;
        PsiElement c2;
        Set eliminateElements = new HashSet();
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)expression)).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        Iterable $this$forEach$iv2 = (Iterable)jBIterable;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (!(it instanceof SqlParenthesizedExpression) || !this.shouldBeEliminated((SqlParenthesizedExpression)it)) continue;
            PsiElement c1 = ((SqlParenthesizedExpression)it).getFirstChild();
            while (c1 instanceof LeafPsiElement && ((LeafPsiElement)c1).textMatches((CharSequence)"(") || c1 instanceof PsiWhiteSpace) {
                ((Collection)eliminateElements).add(c1);
                c1 = c1.getNextSibling();
            }
            c2 = ((SqlParenthesizedExpression)it).getLastChild();
            while (c2 instanceof LeafPsiElement && ((LeafPsiElement)c2).textMatches((CharSequence)")") || c2 instanceof PsiWhiteSpace) {
                ((Collection)eliminateElements).add(c2);
                c2 = c2.getPrevSibling();
            }
        }
        StringBuilder b = new StringBuilder(textSize);
        JBIterable jBIterable2 = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)expression)).expandAndFilter(arg_0 -> MsIntrospectorHelper.normalizeExpressionInPsi$lambda$2(arg_0 -> MsIntrospectorHelper.normalizeExpressionInPsi$lambda$1(eliminateElements, arg_0), arg_0))).traverse().filter(arg_0 -> MsIntrospectorHelper.normalizeExpressionInPsi$lambda$4(MsIntrospectorHelper::normalizeExpressionInPsi$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        Iterable $i$f$forEach22 = (Iterable)jBIterable2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (forceUnquote) {
                SqlReferenceExpression ref;
                SqlIdentifier identifier;
                c2 = it.getParent();
                SqlIdentifier sqlIdentifier = identifier = c2 instanceof SqlIdentifier ? (SqlIdentifier)c2 : null;
                PsiElement psiElement = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
                SqlReferenceExpression sqlReferenceExpression = ref = psiElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement : null;
                if (ref != null) {
                    String name2;
                    Intrinsics.checkNotNullExpressionValue((Object)identifier.getName(), (String)"getName(...)");
                    if (identifier.isQuotedIdentifier() && SqlImplUtil.canUnquote((String)name2, (ObjectKind)ref.getKind(), (NamingService)((NamingService)MsNamingService.INSTANCE))) {
                        b.append(name2);
                        continue;
                    }
                }
            }
            b.append(it.getText());
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String normalizeExpressionInPsi$default(MsIntrospectorHelper msIntrospectorHelper, SqlExpression sqlExpression, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return msIntrospectorHelper.normalizeExpressionInPsi(sqlExpression, n, bl);
    }

    private final boolean shouldBeEliminated(SqlParenthesizedExpression $this$shouldBeEliminated) {
        SqlExpression sqlExpression = $this$shouldBeEliminated.getExpression();
        if (sqlExpression == null) {
            return false;
        }
        SqlExpression inner = sqlExpression;
        PsiElement parent = $this$shouldBeEliminated.getParent();
        if (parent == null || !(parent instanceof SqlExpression)) {
            return true;
        }
        if (inner instanceof SqlParenthesizedExpression || inner instanceof SqlLiteralExpression) {
            return true;
        }
        return parent instanceof SqlBinaryExpression && inner instanceof SqlBinaryExpression && Intrinsics.areEqual((Object)((SqlBinaryExpression)parent).getOpSign(), (Object)((SqlBinaryExpression)inner).getOpSign()) && ((SqlBinaryExpression)parent).getLOperand() == $this$shouldBeEliminated && CollectionsKt.contains((Iterable)leftAssociativeOperators, (Object)((SqlBinaryExpression)inner).getOpSign());
    }

    private static final boolean normalizeExpressionInPsi$lambda$1(Set $eliminateElements, PsiElement it) {
        return !$eliminateElements.contains(it);
    }

    private static final boolean normalizeExpressionInPsi$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean normalizeExpressionInPsi$lambda$3(PsiElement it) {
        return it.getFirstChild() == null;
    }

    private static final boolean normalizeExpressionInPsi$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"U", (Object)ObjectKind.TABLE), TuplesKt.to((Object)"S", (Object)ObjectKind.TABLE), TuplesKt.to((Object)"IT", (Object)ObjectKind.TABLE), TuplesKt.to((Object)"V", (Object)ObjectKind.VIEW), TuplesKt.to((Object)"TT", (Object)ObjectKind.TABLE_TYPE), TuplesKt.to((Object)"R", (Object)ObjectKind.RULE), TuplesKt.to((Object)"FN", (Object)ObjectKind.ROUTINE), TuplesKt.to((Object)"TF", (Object)ObjectKind.ROUTINE), TuplesKt.to((Object)"IF", (Object)ObjectKind.ROUTINE), TuplesKt.to((Object)"P", (Object)ObjectKind.ROUTINE), TuplesKt.to((Object)"X", (Object)ObjectKind.ROUTINE), TuplesKt.to((Object)"PC", (Object)ObjectKind.ROUTINE), TuplesKt.to((Object)"SO", (Object)ObjectKind.SEQUENCE), TuplesKt.to((Object)"SN", (Object)ObjectKind.SYNONYM)};
        majorKindByCodes = MapsKt.mapOf((Pair[])object);
        object = new SqlTokenType[]{SqlCommonKeywords.SQL_AND, SqlCommonKeywords.SQL_OR, SqlCommonTokens.SQL_OP_BITWISE_AND, SqlCommonTokens.SQL_OP_BITWISE_OR, SqlCommonTokens.SQL_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_PLUS, SqlCommonKeywords.SQL_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_CONCAT};
        leftAssociativeOperators = SetsKt.setOf((Object[])object);
        Object $this$systemSchemaNames_u24lambda_u240 = object = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        boolean bl = false;
        ((TreeSet)$this$systemSchemaNames_u24lambda_u240).add("sys");
        ((TreeSet)$this$systemSchemaNames_u24lambda_u240).add("information_schema");
        systemSchemaNames = (Set)object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospectorHelper$Companion;", "", "<init>", "()V", "majorKindByCodes", "", "", "Lcom/intellij/database/model/ObjectKind;", "getMajorKindByCodes", "()Ljava/util/Map;", "leftAssociativeOperators", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "systemSchemaNames", "intellij.database.dialects.mssql"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, ObjectKind> getMajorKindByCodes() {
            return majorKindByCodes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

