/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsLogin;
import com.intellij.database.dialects.mssql.model.MsRole;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTableTypeColumn;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.properties.MsDatabasePrincipalType;
import com.intellij.database.dialects.mssql.model.properties.MsObjectGrantController;
import com.intellij.database.dialects.mssql.model.properties.MsServerPrincipalType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.icons.AllIcons;
import icons.DatabaseIcons;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0017\u001a\u000e\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J4\u0010\u001f\u001a\u00020\t\"\b\b\u0000\u0010 *\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#2\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0&0%H\u0016J\u001c\u0010'\u001a\u00020\u00102\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010(\u001a\u00020)H\u0016\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/mssql/model/MsModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "mustParticipateInInsert", "", "column", "Lcom/intellij/database/model/DasColumn;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "", "modifyParent", "getExampleArgName", "getIcon", "Ljavax/swing/Icon;", "c", "Lcom/intellij/database/model/DasObject;", "getCustomName", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/Nullable;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "getGrantController", "Lcom/intellij/database/dialects/mssql/model/properties/MsObjectGrantController;", "reorderProperties", "E", "Lcom/intellij/database/model/basic/BasicElement;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "getTitle", "prop", "Lcom/intellij/database/model/meta/BasicMetaId;", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsModelHelper.kt\ncom/intellij/database/dialects/mssql/model/MsModelHelper\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,95:1\n18#2:96\n18#2:97\n*S KotlinDebug\n*F\n+ 1 MsModelHelper.kt\ncom/intellij/database/dialects/mssql/model/MsModelHelper\n*L\n68#1:96\n69#1:97\n*E\n"})
public final class MsModelHelper
extends ModelHelper {
    public boolean mustParticipateInInsert(@NotNull DasColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return (!(column instanceof MsTableColumn) || !((MsTableColumn)column).isHidden()) && super.mustParticipateInInsert(column);
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
        BasicModElement basicModElement = e;
        if (basicModElement instanceof MsLogin) {
            ((MsLogin)e).setPassword(new OneTimeString(""));
            vars.put("password", "''");
        } else if (basicModElement instanceof MsTrigger) {
            vars.put("turn", "for");
        } else if (basicModElement instanceof MsAliasType) {
            MsAliasType msAliasType = (MsAliasType)e;
            DataType dataType = DataTypeFactory.of((String)"varchar");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            msAliasType.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            vars.put("target_type", "varchar");
        } else if (basicModElement instanceof MsTableType) {
            BasicModElement basicModElement2 = ((MsTableType)e).getColumns().createNewOne();
            Intrinsics.checkNotNullExpressionValue((Object)basicModElement2, (String)"createNewOne(...)");
            MsTableTypeColumn col = (MsTableTypeColumn)basicModElement2;
            this.setTemplateName(col, "type_column");
            DataType dataType = DataTypeFactory.of((String)"int");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            col.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            vars.put("type_columns", "type_column int");
        }
    }

    @NotNull
    protected String getExampleArgName() {
        return "@arg1";
    }

    @Nullable
    public Icon getIcon(@NotNull DasObject c) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        DasObject dasObject = c;
        if (dasObject instanceof MsLogin) {
            icon = ((MsLogin)c).getType() == MsServerPrincipalType.SERVER_ROLE ? DatabaseIcons.Role : super.getIcon(c);
        } else if (dasObject instanceof MsRole) {
            switch (WhenMappings.$EnumSwitchMapping$0[((MsRole)c).getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    icon = AllIcons.General.User;
                    break;
                }
                default: {
                    icon = super.getIcon(c);
                    break;
                }
            }
        } else {
            icon = super.getIcon(c);
        }
        return icon;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.LOGIN)) {
            int _true_$iv;
            void $this$choose$iv;
            Object[] objectArray = new Object[1];
            boolean bl = plural;
            int n = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv != false ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message((String)"CustomObjectKind.server.principal", (Object[])objectArray);
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE)) {
            Object[] objectArray = new Object[1];
            boolean $this$choose$iv = plural;
            int _true_$iv = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message((String)"CustomObjectKind.database.principal", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public MsObjectGrantController getGrantController() {
        return MsObjectGrantController.INSTANCE;
    }

    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super.reorderProperties(meta, fields);
        BasicMetaId[] basicMetaIdArray = new BasicMetaId[]{MsExtendedPropertiesHolder.EXTENDED_PROPERTIES, BasicModSourceAware.SOURCE_TEXT};
        ModelHelper.moveTo(fields, (int)fields.size(), (BasicMetaId[])basicMetaIdArray);
        if (meta.kindOf(MsRole.class)) {
            ModelHelper.moveTo(fields, (int)1, (BasicMetaId)((BasicMetaId)MsRole.TYPE));
        } else if (meta.kindOf(MsLogin.class)) {
            ModelHelper.moveTo(fields, (int)1, (BasicMetaId)((BasicMetaId)MsLogin.TYPE));
        } else if (meta.kindOf(MsStoredColumn.class)) {
            basicMetaIdArray = new BasicMetaId[]{MsStoredColumn.COMPUTED, MsTableColumn.SPARSE, MsTableColumn.HIDDEN, MsTableColumn.COLUMN_SET};
            ModelHelper.moveTo(fields, (int)(ModelHelper.indexOf(fields, (BasicMetaId)((BasicMetaId)MsStoredColumn.NOT_NULL)) + 1), (BasicMetaId[])basicMetaIdArray);
        } else if (meta.kindOf(MsLikeIndex.class)) {
            basicMetaIdArray = new BasicMetaId[]{MsLikeIndex.CLUSTERING, MsLikeIndex.COLUMNSTORE, MsLikeIndex.UNIQUE, MsLikeIndex.JSON};
            ModelHelper.moveTo(fields, (int)1, (BasicMetaId[])basicMetaIdArray);
        }
    }

    @NotNull
    public String getTitle(@NotNull BasicMetaObject<?> meta, @NotNull BasicMetaId prop) {
        String string;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        if (Intrinsics.areEqual((Object)prop, MsLikeIndex.INCLUDED_COL_NAMES)) {
            String string2 = DatabaseBundle.message((String)"label.include.columns", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = super.getTitle(meta, prop);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTitle(...)");
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MsDatabasePrincipalType.values().length];
            try {
                nArray[MsDatabasePrincipalType.SQL_USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsDatabasePrincipalType.ASYMMETRIC_KEY_MAPPED_USER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsDatabasePrincipalType.CERTIFICATE_MAPPED_USER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsDatabasePrincipalType.EXTERNAL_USER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MsDatabasePrincipalType.WINDOWS_USER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

