/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.executor;

import com.intellij.clouds.docker.gateway.executor.DevcontainerCommandExecutorKt;
import com.intellij.clouds.docker.gateway.executor.DockerContainerFileAccessor;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.remote.DockerExecResult;
import com.intellij.docker.agent.remote.DockerRemoteUtilsKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import com.jetbrains.gateway.ssh.HostTunnelConnector;
import com.jetbrains.gateway.ssh.deploy.CommandExecutionResultWithRawStreams;
import com.jetbrains.gateway.ssh.deploy.HostCommandExecutor;
import com.jetbrains.gateway.ssh.deploy.HostFileAccessor;
import com.jetbrains.gateway.ssh.deploy.ShellArgument;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015JV\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u001a\u0010-\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020)0(\u0012\u0004\u0012\u00020\u00140.H\u0096@\u00a2\u0006\u0002\u0010/R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u0014X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lcom/intellij/clouds/docker/gateway/executor/DockerCommandExecutor;", "Lcom/jetbrains/gateway/ssh/deploy/HostCommandExecutor;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "container", "Lcom/intellij/docker/agent/DockerAgentContainer;", "<init>", "(Lcom/intellij/remoteServer/configuration/RemoteServer;Lcom/intellij/docker/agent/DockerAgentContainer;)V", "getContainer", "()Lcom/intellij/docker/agent/DockerAgentContainer;", "fileAccessor", "Lcom/jetbrains/gateway/ssh/deploy/HostFileAccessor;", "getFileAccessor", "()Lcom/jetbrains/gateway/ssh/deploy/HostFileAccessor;", "tunnelConnector", "Lcom/jetbrains/gateway/ssh/HostTunnelConnector;", "getTunnelConnector", "()Lcom/jetbrains/gateway/ssh/HostTunnelConnector;", "getUploadFilesOwner", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connectionTypeId", "getConnectionTypeId", "()Ljava/lang/String;", "uniqueConfigId", "getUniqueConfigId", "host", "getHost", "user", "getUser", "userData", "Lcom/intellij/openapi/util/UserDataHolder;", "getUserData", "()Lcom/intellij/openapi/util/UserDataHolder;", "executeCommand", "Lcom/jetbrains/gateway/ssh/deploy/CommandExecutionResultWithRawStreams;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "command", "", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument;", "mergeStderrIntoStdout", "", "useTty", "stringifier", "Lkotlin/Function1;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;[Lcom/jetbrains/gateway/ssh/deploy/ShellArgument;ZZLkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.docker.gateway"})
@ApiStatus.Internal
public class DockerCommandExecutor
implements HostCommandExecutor {
    @NotNull
    private final DockerAgentContainer container;
    @NotNull
    private final HostFileAccessor fileAccessor;
    @NotNull
    private final HostTunnelConnector tunnelConnector;
    @NotNull
    private final String connectionTypeId;
    @NotNull
    private final String uniqueConfigId;
    @NotNull
    private final String host;
    @NotNull
    private final String user;
    @NotNull
    private final UserDataHolder userData;

    public DockerCommandExecutor(@NotNull RemoteServer<DockerCloudConfiguration> server, @NotNull DockerAgentContainer container) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.container = container;
        this.fileAccessor = new DockerContainerFileAccessor(server, this.container, (Function1<? super Continuation<? super String>, ? extends Object>)((Function1)new Function1<Continuation<? super String>, Object>(this, null){
            int label;
            final /* synthetic */ DockerCommandExecutor this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getUploadFilesOwner((Continuation<? super String>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super String> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.tunnelConnector = new HostTunnelConnector(){
            private final String host;
            {
                String string = NetUtils.getLocalHostString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalHostString(...)");
                this.host = string;
            }

            public String getHost() {
                return this.host;
            }

            public String getType() {
                return "docker";
            }

            public Object connect(Lifetime lifetime, int port, Continuation<? super Integer> $completion) {
                return Boxing.boxInt((int)port);
            }
        };
        this.connectionTypeId = "docker";
        this.uniqueConfigId = this.container.getContainerId();
        String string = this.container.getPresentableName();
        if (string == null) {
            throw new IllegalStateException();
        }
        this.host = string;
        Object object = this.container.getInfo();
        if (object == null || (object = object.getUser()) == null) {
            object = "DEFAULT_USER";
        }
        this.user = object;
        this.userData = (UserDataHolder)new UserDataHolderBase();
    }

    @NotNull
    public final DockerAgentContainer getContainer() {
        return this.container;
    }

    @NotNull
    public final HostFileAccessor getFileAccessor() {
        return this.fileAccessor;
    }

    @NotNull
    public HostTunnelConnector getTunnelConnector() {
        return this.tunnelConnector;
    }

    @Nullable
    public Object getUploadFilesOwner(@NotNull Continuation<? super String> $completion) {
        return DockerCommandExecutor.getUploadFilesOwner$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object getUploadFilesOwner$suspendImpl(DockerCommandExecutor $this, Continuation<? super String> $completion) {
        return null;
    }

    @NotNull
    public final String getConnectionTypeId() {
        return this.connectionTypeId;
    }

    @NotNull
    public final String getUniqueConfigId() {
        return this.uniqueConfigId;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final String getUser() {
        return this.user;
    }

    @NotNull
    public final UserDataHolder getUserData() {
        return this.userData;
    }

    @Nullable
    public Object executeCommand(@NotNull Lifetime lifetime, @NotNull ShellArgument[] command, boolean mergeStderrIntoStdout, boolean useTty, @NotNull Function1<? super ShellArgument[], String> stringifier, @NotNull Continuation<? super CommandExecutionResultWithRawStreams> $completion) {
        return DockerCommandExecutor.executeCommand$suspendImpl(this, lifetime, command, mergeStderrIntoStdout, useTty, stringifier, $completion);
    }

    static /* synthetic */ Object executeCommand$suspendImpl(DockerCommandExecutor $this, Lifetime lifetime, ShellArgument[] command, boolean mergeStderrIntoStdout, boolean useTty, Function1<? super ShellArgument[], String> stringifier, Continuation<? super CommandExecutionResultWithRawStreams> $completion) {
        Date startTime = Calendar.getInstance().getTime();
        String stringCommand = (String)stringifier.invoke((Object)command);
        String rawCommand = "sh -c \"" + stringCommand + "\"";
        String[] stringArray = ParametersListUtil.parseToArray((String)rawCommand);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"parseToArray(...)");
        String[] rawCommandArray = stringArray;
        DockerExecResult execResult2 = DockerRemoteUtilsKt.execCommand$default((DockerAgentContainer)$this.container, (String[])Arrays.copyOf(rawCommandArray, rawCommandArray.length), (boolean)false, null, (boolean)mergeStderrIntoStdout, null, null, (int)54, null);
        Intrinsics.checkNotNull((Object)startTime);
        return DevcontainerCommandExecutorKt.access$toCommandExecutionResult(execResult2, lifetime, startTime, rawCommand);
    }
}

