/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs;

import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.ReadResult;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFsError;
import com.intellij.platform.eel.fs.EelOpenedFile;
import com.intellij.platform.eel.fs.EelPosixFileInfo;
import com.intellij.platform.eel.fs.EelPosixFileInfoImpl;
import com.intellij.platform.eel.fs.EelWindowsFileInfo;
import com.intellij.platform.eel.fs.StreamingReadResult;
import com.intellij.platform.eel.fs.StreamingWriteResult;
import com.intellij.platform.eel.fs.WalkDirectoryEntry;
import com.intellij.platform.eel.fs.WalkDirectoryEntryPosix;
import com.intellij.platform.eel.fs.WalkDirectoryEntryResult;
import com.intellij.platform.eel.fs.WalkDirectoryEntryWindows;
import com.intellij.platform.eel.impl.fs.EelFsResultImpl;
import com.intellij.platform.eel.impl.fs.LocalEelFileSystemApiKt;
import com.intellij.platform.eel.impl.fs.NioBasedEelFileSystemApi;
import com.intellij.platform.eel.impl.fs.StreamingWriteResultImpl;
import com.intellij.platform.eel.impl.fs.WalkDirectoryEntryPosixImpl;
import com.intellij.platform.eel.impl.fs.WalkDirectoryEntryResultImpl;
import com.intellij.platform.eel.impl.fs.WalkDirectoryEntryWindowsImpl;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.spi.FileSystemProvider;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00e0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aD\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0002\u001aD\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u001aL\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u001a4\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u001a,\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a \u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a\f\u0010\"\u001a\u00020#*\u00020$H\u0002\u001a\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0018\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0010\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002\u001a\u0016\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002\u001a$\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\t072\u0006\u00108\u001a\u000209H\u0082@\u00a2\u0006\u0002\u0010:\u001a\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>2\u0006\u0010\u001e\u001a\u000209H\u0002\u001a\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020(H\u0002\u001a\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020B072\u0006\u0010\u001e\u001a\u00020C2\u0006\u0010D\u001a\u00020E\u001a6\u0010F\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010B\u0012\u0004\u0012\u00020\f0G2\u0006\u0010H\u001a\u00020(2\u0006\u0010I\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002\u00a8\u0006J"}, d2={"doRead", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/ReadResult;", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Reader$ReadError;", "eelFs", "Lcom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi;", "byteChannel", "Ljava/nio/channels/SeekableByteChannel;", "buf", "Ljava/nio/ByteBuffer;", "isClosed", "Ljava/util/concurrent/atomic/AtomicReference;", "", "autoCloseAfterLastChunk", "offset", "", "doSeek", "Lcom/intellij/platform/eel/fs/EelOpenedFile$SeekError;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "whence", "Lcom/intellij/platform/eel/fs/EelOpenedFile$SeekWhence;", "doTell", "Lcom/intellij/platform/eel/fs/EelOpenedFile$TellError;", "doClose", "", "Lcom/intellij/platform/eel/fs/EelOpenedFile$CloseError;", "copyTimes", "oldAttrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "options", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ChangeAttributesOptions;", "view", "Ljava/nio/file/attribute/BasicFileAttributeView;", "toFileTime", "Ljava/nio/file/attribute/FileTime;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$TimeSinceEpoch;", "getFileAttributes", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "child", "Ljava/nio/file/Path;", "symlinkPolicy", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$SymlinkPolicy;", "getPosixFileAttributes", "Lcom/intellij/platform/eel/fs/EelPosixFileInfo;", "getWindowsFileAttributes", "Lcom/intellij/platform/eel/fs/EelWindowsFileInfo;", "convertPermissionsToMask", "", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "doStreamingWrite", "Lcom/intellij/platform/eel/fs/StreamingWriteResult;", "chunks", "Lkotlinx/coroutines/flow/Flow;", "targetFileOpenOptions", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$WriteOptions;", "(Lkotlinx/coroutines/flow/Flow;Lcom/intellij/platform/eel/fs/EelFileSystemApi$WriteOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doStreamingRead", "Lcom/intellij/platform/eel/fs/StreamingReadResult;", "writeOptionsToNioOptions", "", "Ljava/nio/file/StandardOpenOption;", "getFileContentsHash", "doWalkDirectory", "Lcom/intellij/platform/eel/fs/WalkDirectoryEntryResult;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$WalkDirectoryOptions;", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "walkDirectoryProcessFile", "Lkotlin/Pair;", "currentItem", "emptyFileHash", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nLocalEelFileSystemApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/LocalEelFileSystemApiKt\n+ 2 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,991:1\n98#2,28:992\n98#2,28:1020\n98#2,28:1048\n98#2,28:1076\n95#2,31:1104\n1#3:1135\n*S KotlinDebug\n*F\n+ 1 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/LocalEelFileSystemApiKt\n*L\n405#1:992,28\n424#1:1020,28\n440#1:1048,28\n455#1:1076,28\n464#1:1104,31\n*E\n"})
public final class LocalEelFileSystemApiKt {
    /*
     * WARNING - void declaration
     */
    private static final EelResult<ReadResult, EelOpenedFile.Reader.ReadError> doRead(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, ByteBuffer buf, AtomicReference<Boolean> isClosed, boolean autoCloseAfterLastChunk) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = eelFs;
        AtomicReference<Boolean> isClosed$iv = isClosed;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            int read = byteChannel.read(buf);
            ReadResult result = ReadResult.Companion.fromNumberOfReadBytes(read);
            if (autoCloseAfterLastChunk) {
                switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                    case 1: {
                        isClosed.set(true);
                        break;
                    }
                    case 2: {
                        isClosed.set(false);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            ReadResult readResult = result;
            EelFsResultImpl.Ok<ReadResult> result$iv = new EelFsResultImpl.Ok<ReadResult>(readResult);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.Reader.ReadError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.Reader.ReadError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.Reader.ReadError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final EelResult<ReadResult, EelOpenedFile.Reader.ReadError> doRead(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, long offset, ByteBuffer buf, AtomicReference<Boolean> isClosed) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = eelFs;
        AtomicReference<Boolean> isClosed$iv = isClosed;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            long oldPosition = byteChannel.position();
            byteChannel.position(offset);
            int read = byteChannel.read(buf);
            byteChannel.position(oldPosition);
            ReadResult readResult = ReadResult.Companion.fromNumberOfReadBytes(read);
            EelFsResultImpl.Ok<ReadResult> result$iv = new EelFsResultImpl.Ok<ReadResult>(readResult);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.Reader.ReadError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.Reader.ReadError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.Reader.ReadError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final EelResult<Long, EelOpenedFile.SeekError> doSeek(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, EelPath path, EelOpenedFile.SeekWhence whence, long offset, AtomicReference<Boolean> isClosed) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = eelFs;
        AtomicReference<Boolean> isClosed$iv = isClosed;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            long newPosition = switch (WhenMappings.$EnumSwitchMapping$1[whence.ordinal()]) {
                case 1 -> offset;
                case 2 -> byteChannel.position() + offset;
                case 3 -> byteChannel.size() - offset;
                default -> throw new NoWhenBranchMatchedException();
            };
            byteChannel.position(newPosition);
            Long l = newPosition;
            EelFsResultImpl.Ok<Long> result$iv = new EelFsResultImpl.Ok<Long>(l);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.SeekError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.SeekError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.SeekError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final EelResult<Long, EelOpenedFile.TellError> doTell(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, AtomicReference<Boolean> isClosed) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = eelFs;
        AtomicReference<Boolean> isClosed$iv = isClosed;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            Long l = byteChannel.position();
            EelFsResultImpl.Ok<Long> result$iv = new EelFsResultImpl.Ok<Long>(l);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.TellError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.TellError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.TellError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final EelResult<Unit, EelOpenedFile.CloseError> doClose(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, EelPath path) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = eelFs;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            byteChannel.close();
            Unit unit = Unit.INSTANCE;
            EelFsResultImpl.Ok<Unit> result$iv$iv = new EelFsResultImpl.Ok<Unit>(unit);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            try {
                eelPath = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = eelPath;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelOpenedFile.CloseError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.CloseError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.CloseError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    private static final void copyTimes(BasicFileAttributes oldAttrs, EelFileSystemApi.ChangeAttributesOptions options, BasicFileAttributeView view) {
        Object object;
        Object mtime;
        FileTime ctime = oldAttrs.creationTime();
        Object object2 = options.getModificationTime();
        if (object2 == null || (object2 = LocalEelFileSystemApiKt.toFileTime(object2)) == null) {
            object2 = mtime = oldAttrs.lastModifiedTime();
        }
        if ((object = options.getAccessTime()) == null || (object = LocalEelFileSystemApiKt.toFileTime(object)) == null) {
            object = oldAttrs.lastAccessTime();
        }
        Object atime = object;
        view.setTimes(ctime, (FileTime)mtime, (FileTime)atime);
    }

    private static final FileTime toFileTime(EelFileSystemApi.TimeSinceEpoch $this$toFileTime) {
        FileTime fileTime = FileTime.from(Instant.ofEpochSecond($this$toFileTime.getSeconds-s-VKNKU(), (long)$this$toFileTime.getNanoseconds-pVg5ArA() & 0xFFFFFFFFL));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"from(...)");
        return fileTime;
    }

    private static final EelFileInfo getFileAttributes(Path child, EelFileSystemApi.SymlinkPolicy symlinkPolicy) {
        return SystemInfoRt.isWindows ? (EelFileInfo)LocalEelFileSystemApiKt.getWindowsFileAttributes(child) : (EelFileInfo)LocalEelFileSystemApiKt.getPosixFileAttributes(child, symlinkPolicy);
    }

    private static final EelPosixFileInfo getPosixFileAttributes(Path child, EelFileSystemApi.SymlinkPolicy symlinkPolicy) {
        Object it;
        FileSystemProvider fileSystemProvider = child.getFileSystem().provider();
        LinkOption[] linkOptionArray = switch (WhenMappings.$EnumSwitchMapping$2[symlinkPolicy.ordinal()]) {
            case 1 -> {
                LinkOption[] var6_2 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                yield var6_2;
            }
            case 2, 3 -> new LinkOption[]{};
            default -> throw new NoWhenBranchMatchedException();
        };
        PosixFileAttributes s = fileSystemProvider.readAttributes(child, PosixFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        EelPosixFileInfo.Type type = s.isRegularFile() ? (EelPosixFileInfo.Type)new EelPosixFileInfoImpl.Regular(s.size()) : (s.isDirectory() ? (EelPosixFileInfo.Type)new EelPosixFileInfoImpl.Directory(EelFileInfo.CaseSensitivity.SENSITIVE) : (s.isSymbolicLink() ? (EelPosixFileInfo.Type)EelPosixFileInfoImpl.SymlinkUnresolved.INSTANCE : (EelPosixFileInfo.Type)EelPosixFileInfoImpl.Other.INSTANCE));
        Object object = Files.getAttribute(child, "unix:uid", new LinkOption[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int n = (Integer)object;
        Object object2 = Files.getAttribute(child, "unix:gid", new LinkOption[0]);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
        int n2 = (Integer)object2;
        Set<PosixFilePermission> set = s.permissions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"permissions(...)");
        Object object3 = Files.getAttribute(child, "unix:dev", new LinkOption[0]);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(s.lastAccessTime().toInstant(), ZoneId.systemDefault());
        ZonedDateTime zonedDateTime2 = ZonedDateTime.ofInstant(s.lastModifiedTime().toInstant(), ZoneId.systemDefault());
        ZonedDateTime zonedDateTime3 = ZonedDateTime.ofInstant(s.creationTime().toInstant(), ZoneId.systemDefault());
        EelPosixFileInfo.Permissions permissions2 = (EelPosixFileInfo.Permissions)new EelPosixFileInfoImpl.Permissions(n, n2, LocalEelFileSystemApiKt.convertPermissionsToMask(set));
        EelPosixFileInfo.Type type2 = type;
        boolean bl = false;
        Long l = it instanceof Long ? (Long)it : null;
        long l2 = l != null ? l : 0L;
        it = Files.getAttribute(child, "unix:ino", new LinkOption[0]);
        boolean bl2 = false;
        Long l3 = it instanceof Long ? (Long)it : null;
        long l4 = l3 != null ? l3 : 0L;
        long l5 = l4;
        long l6 = l2;
        ZonedDateTime zonedDateTime4 = zonedDateTime;
        ZonedDateTime zonedDateTime5 = zonedDateTime2;
        ZonedDateTime zonedDateTime6 = zonedDateTime3;
        EelPosixFileInfo.Permissions permissions3 = permissions2;
        EelPosixFileInfo.Type type3 = type2;
        return (EelPosixFileInfo)new EelPosixFileInfoImpl(type3, permissions3, zonedDateTime6, zonedDateTime5, zonedDateTime4, l6, l5);
    }

    private static final EelWindowsFileInfo getWindowsFileAttributes(Path child) {
        DosFileAttributes s = Files.readAttributes(child, DosFileAttributes.class, new LinkOption[0]);
        return new EelWindowsFileInfo(s){
            private final EelWindowsFileInfo.Permissions permissions;
            private final EelFileInfo.Type type;
            private final ZonedDateTime creationTime;
            private final ZonedDateTime lastModifiedTime;
            private final ZonedDateTime lastAccessTime;
            {
                this.permissions = new EelWindowsFileInfo.Permissions($s){
                    private final boolean isReadOnly;
                    private final boolean isHidden;
                    private final boolean isArchive;
                    private final boolean isSystem;
                    {
                        this.isReadOnly = $s.isReadOnly();
                        this.isHidden = $s.isHidden();
                        this.isArchive = $s.isArchive();
                        this.isSystem = $s.isSystem();
                    }

                    public boolean isReadOnly() {
                        return this.isReadOnly;
                    }

                    public boolean isHidden() {
                        return this.isHidden;
                    }

                    public boolean isArchive() {
                        return this.isArchive;
                    }

                    public boolean isSystem() {
                        return this.isSystem;
                    }
                };
                this.type = $s.isRegularFile() ? (EelFileInfo.Type)new EelPosixFileInfoImpl.Regular($s.size()) : ($s.isDirectory() ? (EelFileInfo.Type)new EelPosixFileInfoImpl.Directory(EelFileInfo.CaseSensitivity.SENSITIVE) : (EelFileInfo.Type)EelPosixFileInfoImpl.Other.INSTANCE);
                this.creationTime = ZonedDateTime.ofInstant($s.creationTime().toInstant(), ZoneId.systemDefault());
                this.lastModifiedTime = ZonedDateTime.ofInstant($s.lastModifiedTime().toInstant(), ZoneId.systemDefault());
                this.lastAccessTime = ZonedDateTime.ofInstant($s.lastAccessTime().toInstant(), ZoneId.systemDefault());
            }

            public EelWindowsFileInfo.Permissions getPermissions() {
                return this.permissions;
            }

            public EelFileInfo.Type getType() {
                return this.type;
            }

            public ZonedDateTime getCreationTime() {
                return this.creationTime;
            }

            public ZonedDateTime getLastModifiedTime() {
                return this.lastModifiedTime;
            }

            public ZonedDateTime getLastAccessTime() {
                return this.lastAccessTime;
            }
        };
    }

    private static final int convertPermissionsToMask(Set<? extends PosixFilePermission> permissions2) {
        int mask = 0;
        if (permissions2.contains((Object)PosixFilePermission.OWNER_READ)) {
            mask |= 0x100;
        }
        if (permissions2.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mask |= 0x80;
        }
        if (permissions2.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mask |= 0x40;
        }
        if (permissions2.contains((Object)PosixFilePermission.GROUP_READ)) {
            mask |= 0x20;
        }
        if (permissions2.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mask |= 0x10;
        }
        if (permissions2.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mask |= 8;
        }
        if (permissions2.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mask |= 4;
        }
        if (permissions2.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mask |= 2;
        }
        if (permissions2.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mask |= 1;
        }
        return mask;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object doStreamingWrite(Flow<? extends ByteBuffer> chunks, EelFileSystemApi.WriteOptions targetFileOpenOptions, Continuation<? super StreamingWriteResult> $completion) {
        if (!($completion instanceof doStreamingWrite.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LocalEelFileSystemApiKt.access$doStreamingWrite(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                totalBytesWritten = new Ref.LongRef();
                path = targetFileOpenOptions.getPath();
                nioOptions = LocalEelFileSystemApiKt.writeOptionsToNioOptions(targetFileOpenOptions);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)chunks);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)targetFileOpenOptions);
                $continuation.L$2 = totalBytesWritten;
                $continuation.L$3 = path;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(nioOptions);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path, nioOptions, (Flow<? extends ByteBuffer>)chunks, totalBytesWritten, null){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    int label;
                    final /* synthetic */ EelPath $path;
                    final /* synthetic */ Set<StandardOpenOption> $nioOptions;
                    final /* synthetic */ Flow<ByteBuffer> $chunks;
                    final /* synthetic */ Ref.LongRef $totalBytesWritten;
                    {
                        this.$path = $path;
                        this.$nioOptions = $nioOptions;
                        this.$chunks = $chunks;
                        this.$totalBytesWritten = $totalBytesWritten;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var2_3 = Files.newByteChannel(EelNioBridgeServiceKt.asNioPath((EelPath)this.$path), this.$nioOptions, new FileAttribute[0]);
                                var3_4 = this.$chunks;
                                var4_5 = this.$totalBytesWritten;
                                var5_6 = null;
                                channel = (SeekableByteChannel)var2_3;
                                $i$a$-use-LocalEelFileSystemApiKt$doStreamingWrite$2$1 = 0;
                                this.L$0 = var2_3;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)channel);
                                this.I$0 = $i$a$-use-LocalEelFileSystemApiKt$doStreamingWrite$2$1;
                                this.label = 1;
                                v0 = var3_4.collect(new FlowCollector(var4_5, channel){
                                    final /* synthetic */ Ref.LongRef $totalBytesWritten;
                                    final /* synthetic */ SeekableByteChannel $channel;
                                    {
                                        this.$totalBytesWritten = $totalBytesWritten;
                                        this.$channel = $channel;
                                    }

                                    public final Object emit(ByteBuffer buffer, Continuation<? super Unit> $completion) {
                                        while (buffer.hasRemaining()) {
                                            this.$totalBytesWritten.element += (long)this.$channel.write(buffer);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }, (Continuation)this);
                                ** if (v0 != var8_2) goto lbl20
lbl19:
                                // 1 sources

                                return var8_2;
lbl20:
                                // 1 sources

                                ** GOTO lbl30
                            }
                            case 1: {
                                $i$a$-use-LocalEelFileSystemApiKt$doStreamingWrite$2$1 = this.I$0;
                                channel = (SeekableByteChannel)this.L$1;
                                var5_6 = null;
                                var2_3 = (AutoCloseable)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl30:
                                    // 2 sources

                                    var6_7 = Unit.INSTANCE;
                                    ** GOTO lbl40
                                }
                                catch (Throwable var7_10) {
                                    var5_6 = var7_10;
                                    throw var7_10;
                                }
                            }
                            catch (Throwable var7_11) {
                                throw var7_11;
                            }
                            {
                                finally {
                                    AutoCloseableKt.closeFinally((AutoCloseable)var2_3, (Throwable)var5_6);
                                }
lbl40:
                                // 1 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var11_5) goto lbl26
lbl25:
                // 1 sources

                return var11_5;
lbl26:
                // 1 sources

                ** GOTO lbl64
            }
            case 1: {
                nioOptions = (Set)$continuation.L$4;
                path = (EelPath)$continuation.L$3;
                totalBytesWritten = (Ref.LongRef)$continuation.L$2;
                targetFileOpenOptions = (EelFileSystemApi.WriteOptions)$continuation.L$1;
                chunks = (Flow)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (FileSystemException e) {
                    var8_11 = e;
                    if (var8_11 instanceof NoSuchFileException) {
                        v1 = e.getMessage();
                        if (v1 == null) {
                            v1 = "Target path does not exist";
                        }
                        v2 = (EelFsError)new EelFsResultImpl.DoesNotExist(path, v1);
                    } else if (var8_11 instanceof FileAlreadyExistsException) {
                        v3 = e.getMessage();
                        if (v3 == null) {
                            v3 = "Target path already exists";
                        }
                        v2 = (EelFsError)new EelFsResultImpl.AlreadyExists(path, v3);
                    } else if (var8_11 instanceof AccessDeniedException) {
                        v4 = e.getMessage();
                        if (v4 == null) {
                            v4 = "Target path is not a file, no permissions to write, or the path points to a directory";
                        }
                        v2 = (EelFsError)new EelFsResultImpl.NotFile(path, v4);
                    } else {
                        v5 = e.getMessage();
                        if (v5 == null) {
                            v5 = e.toString();
                        }
                        v2 = (EelFsError)new EelFsResultImpl.Other(path, v5);
                    }
                    err = v2;
                    return new StreamingWriteResultImpl.Error((EelFileSystemApi.StreamingWriteError)err);
                }
lbl64:
                // 2 sources

                return new StreamingWriteResultImpl.Ok(totalBytesWritten.element);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Flow<StreamingReadResult> doStreamingRead(EelPath path) {
        return FlowKt.flowOn((Flow)FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super StreamingReadResult>, Continuation<? super Unit>, Object>(path, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ EelPath $path;
            {
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 13[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super StreamingReadResult> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    private static final Set<StandardOpenOption> writeOptionsToNioOptions(EelFileSystemApi.WriteOptions options) {
        Object[] objectArray = new StandardOpenOption[]{StandardOpenOption.WRITE};
        Set nioOptions = SetsKt.mutableSetOf((Object[])objectArray);
        switch (WhenMappings.$EnumSwitchMapping$3[options.getCreationMode().ordinal()]) {
            case 1: {
                ((Collection)nioOptions).add(StandardOpenOption.CREATE);
                break;
            }
            case 2: {
                ((Collection)nioOptions).add(StandardOpenOption.CREATE_NEW);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (options.getAppend()) {
            ((Collection)nioOptions).add(StandardOpenOption.APPEND);
        }
        if (options.getTruncateExisting()) {
            ((Collection)nioOptions).add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        return nioOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long getFileContentsHash(Path path) {
        HashStream64 hasher = Hashing.xxh3_64().hashStream();
        byte[] buffer = new byte[65536];
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = Files.newInputStream(path, object);
        Throwable throwable = null;
        try {
            int bytesRead;
            InputStream inputStream = (InputStream)object;
            boolean bl = false;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                hasher.putBytes(buffer, 0, bytesRead);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        return hasher.getAsLong();
    }

    @NotNull
    public static final Flow<WalkDirectoryEntryResult> doWalkDirectory(@NotNull EelFileSystemApi.WalkDirectoryOptions options, @NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return FlowKt.flowOn((Flow)FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super WalkDirectoryEntryResult>, Continuation<? super Unit>, Object>(options, descriptor, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            long J$0;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int I$5;
            boolean Z$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ EelFileSystemApi.WalkDirectoryOptions $options;
            final /* synthetic */ EelDescriptor $descriptor;
            {
                this.$options = $options;
                this.$descriptor = $descriptor;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 26[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super WalkDirectoryEntryResult> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    private static final Pair<WalkDirectoryEntryResult, Boolean> walkDirectoryProcessFile(Path currentItem, long emptyFileHash, EelFileSystemApi.WalkDirectoryOptions options, EelDescriptor descriptor) {
        WalkDirectoryEntry walkDirectoryEntry;
        WalkDirectoryEntry.Type type;
        BasicFileAttributes basicFileAttributes;
        boolean isPosix = EelPlatformKt.isPosix((EelOsFamily)descriptor.getOsFamily());
        if (isPosix) {
            var7_5 = currentItem;
            var8_6 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(var7_5, PosixFileAttributeView.class, Arrays.copyOf(var8_6, var8_6.length));
            if (posixFileAttributeView == null) {
                PathsKt.fileAttributeViewNotAvailable((Path)var7_5, PosixFileAttributeView.class);
                throw new KotlinNothingValueException();
            }
            basicFileAttributes = posixFileAttributeView.readAttributes();
        } else {
            var7_5 = currentItem;
            var8_6 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(var7_5, DosFileAttributeView.class, Arrays.copyOf(var8_6, var8_6.length));
            if (dosFileAttributeView == null) {
                PathsKt.fileAttributeViewNotAvailable((Path)var7_5, DosFileAttributeView.class);
                throw new KotlinNothingValueException();
            }
            basicFileAttributes = dosFileAttributeView.readAttributes();
        }
        BasicFileAttributes sourceAttributes = basicFileAttributes;
        if (sourceAttributes.isRegularFile() && !options.getYieldRegularFiles()) {
            return new Pair(null, (Object)false);
        }
        if (sourceAttributes.isDirectory() && !options.getYieldDirectories()) {
            return new Pair(null, (Object)true);
        }
        if (sourceAttributes.isSymbolicLink() && !options.getYieldSymlinks()) {
            return new Pair(null, (Object)false);
        }
        if (sourceAttributes.isOther() && !options.getYieldOtherFileTypes()) {
            return new Pair(null, (Object)false);
        }
        EelPath currentPathAsEel = EelPath.Companion.parse(((Object)currentItem).toString(), descriptor);
        ZonedDateTime creationTime = null;
        ZonedDateTime lastModifiedTime = null;
        ZonedDateTime lastAccessTime = null;
        WalkDirectoryEntry.Permissions permissions2 = null;
        WalkDirectoryEntry.Attributes attributes = null;
        if (options.getReadMetadata()) {
            WalkDirectoryEntry.Permissions permissions3;
            ZonedDateTime zonedDateTime;
            ZonedDateTime zonedDateTime2;
            LinkOption[] it;
            ZoneId zone = ZoneId.of("UTC");
            LinkOption[] linkOptionArray = sourceAttributes.lastModifiedTime();
            if (linkOptionArray != null) {
                it = linkOptionArray;
                boolean bl = false;
                zonedDateTime2 = ZonedDateTime.ofInstant(it.toInstant(), zone);
            } else {
                zonedDateTime2 = null;
            }
            lastModifiedTime = zonedDateTime2;
            FileTime fileTime = sourceAttributes.lastAccessTime();
            if (fileTime != null) {
                it = fileTime;
                boolean bl = false;
                zonedDateTime = ZonedDateTime.ofInstant(it.toInstant(), zone);
            } else {
                zonedDateTime = null;
            }
            lastAccessTime = zonedDateTime;
            FileTime fileTime2 = sourceAttributes.creationTime();
            if (fileTime2 != null) {
                it = fileTime2;
                boolean bl = false;
                v8 = ZonedDateTime.ofInstant(it.toInstant(), zone);
            } else {
                v8 = creationTime = null;
            }
            if (!isPosix) {
                Intrinsics.checkNotNull((Object)sourceAttributes, (String)"null cannot be cast to non-null type java.nio.file.attribute.DosFileAttributes");
                DosFileAttributes windowsAttributes = (DosFileAttributes)sourceAttributes;
                v9 = (WalkDirectoryEntry.Attributes)new WalkDirectoryEntryWindowsImpl.Attributes(windowsAttributes.isReadOnly(), windowsAttributes.isHidden(), windowsAttributes.isArchive(), windowsAttributes.isSystem());
            } else {
                v9 = attributes = (WalkDirectoryEntry.Attributes)WalkDirectoryEntryPosixImpl.Attributes.INSTANCE;
            }
            if (!isPosix) {
                permissions3 = (WalkDirectoryEntry.Permissions)WalkDirectoryEntryWindowsImpl.Permissions.INSTANCE;
            } else {
                Intrinsics.checkNotNull((Object)sourceAttributes, (String)"null cannot be cast to non-null type java.nio.file.attribute.PosixFileAttributes");
                PosixFileAttributes posixAttributes = (PosixFileAttributes)sourceAttributes;
                it = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                Object object = Files.getAttribute(currentItem, "unix:uid", it);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int n = (Integer)object;
                it = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                Object object2 = Files.getAttribute(currentItem, "unix:gid", it);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                int n2 = (Integer)object2;
                Set<PosixFilePermission> set = posixAttributes.permissions();
                Intrinsics.checkNotNullExpressionValue(set, (String)"permissions(...)");
                int n3 = LocalEelFileSystemApiKt.convertPermissionsToMask(set);
                Set<PosixFilePermission> set2 = posixAttributes.permissions();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"permissions(...)");
                permissions3 = (WalkDirectoryEntry.Permissions)new WalkDirectoryEntryPosixImpl.Permissions(n, n2, n3, set2);
            }
            permissions2 = permissions3;
        }
        if (sourceAttributes.isRegularFile()) {
            Long hash = !options.getFileContentsHash() ? null : (sourceAttributes.size() > 0L ? Long.valueOf(LocalEelFileSystemApiKt.getFileContentsHash(currentItem)) : Long.valueOf(emptyFileHash));
            type = (WalkDirectoryEntry.Type)(isPosix ? (WalkDirectoryEntry.Type.Regular)new WalkDirectoryEntryPosixImpl.Regular(hash) : (WalkDirectoryEntry.Type.Regular)new WalkDirectoryEntryWindowsImpl.Regular(hash));
        } else if (sourceAttributes.isDirectory()) {
            type = (WalkDirectoryEntry.Type)(isPosix ? (WalkDirectoryEntry.Type.Directory)WalkDirectoryEntryPosixImpl.Directory.INSTANCE : (WalkDirectoryEntry.Type.Directory)WalkDirectoryEntryWindowsImpl.Directory.INSTANCE);
        } else if (sourceAttributes.isSymbolicLink()) {
            WalkDirectoryEntry.Type.Symlink symlink;
            String relativePath;
            Path symlinkTarget = Files.readSymbolicLink(currentItem);
            EelPath absPath = symlinkTarget.isAbsolute() ? EelPath.Companion.parse(((Object)symlinkTarget).toString(), descriptor) : null;
            String string = relativePath = symlinkTarget.isAbsolute() ? null : ((Object)symlinkTarget).toString();
            if (isPosix) {
                if (symlinkTarget.isAbsolute()) {
                    EelPath eelPath = absPath;
                    Intrinsics.checkNotNull((Object)eelPath);
                    symlink = (WalkDirectoryEntry.Type.Symlink)new WalkDirectoryEntryPosixImpl.SymlinkAbsolute(eelPath);
                } else {
                    String string2 = relativePath;
                    Intrinsics.checkNotNull((Object)string2);
                    symlink = (WalkDirectoryEntry.Type.Symlink)new WalkDirectoryEntryPosixImpl.SymlinkRelative(string2);
                }
            } else if (symlinkTarget.isAbsolute()) {
                EelPath eelPath = absPath;
                Intrinsics.checkNotNull((Object)eelPath);
                symlink = (WalkDirectoryEntry.Type.Symlink)new WalkDirectoryEntryWindowsImpl.SymlinkAbsolute(eelPath);
            } else {
                String string3 = relativePath;
                Intrinsics.checkNotNull((Object)string3);
                symlink = (WalkDirectoryEntry.Type.Symlink)new WalkDirectoryEntryWindowsImpl.SymlinkRelative(string3);
            }
            type = (WalkDirectoryEntry.Type)symlink;
        } else if (sourceAttributes.isOther()) {
            type = (WalkDirectoryEntry.Type)(isPosix ? (WalkDirectoryEntry.Type.Other)WalkDirectoryEntryPosixImpl.Other.INSTANCE : (WalkDirectoryEntry.Type.Other)WalkDirectoryEntryWindowsImpl.Other.INSTANCE);
        } else {
            throw new IllegalStateException("File has to be one of the four: regular, directory, symlink, other".toString());
        }
        WalkDirectoryEntry.Type type2 = type;
        if (isPosix) {
            var15_17 = (WalkDirectoryEntryPosixImpl.Permissions)permissions2;
            var16_13 = (WalkDirectoryEntryPosixImpl.Attributes)attributes;
            var17_15 = lastModifiedTime;
            var18_18 = lastAccessTime;
            var19_19 = creationTime;
            walkDirectoryEntry = (WalkDirectoryEntry)new WalkDirectoryEntryPosixImpl(currentPathAsEel, type2, (WalkDirectoryEntryPosix.Permissions)var15_17, (WalkDirectoryEntryPosix.Attributes)var16_13, var19_19, var17_15, var18_18);
        } else {
            var15_17 = (WalkDirectoryEntryWindowsImpl.Permissions)permissions2;
            var16_13 = (WalkDirectoryEntryWindowsImpl.Attributes)attributes;
            var17_15 = lastModifiedTime;
            var18_18 = lastAccessTime;
            var19_19 = creationTime;
            walkDirectoryEntry = (WalkDirectoryEntry)new WalkDirectoryEntryWindowsImpl(currentPathAsEel, type2, (WalkDirectoryEntryWindows.Attributes)var16_13, (WalkDirectoryEntryWindows.Permissions)var15_17, var19_19, var17_15, var18_18);
        }
        WalkDirectoryEntry entry = walkDirectoryEntry;
        return new Pair((Object)new WalkDirectoryEntryResultImpl.Ok(entry), (Object)sourceAttributes.isDirectory());
    }

    public static final /* synthetic */ EelFileInfo access$getFileAttributes(Path child, EelFileSystemApi.SymlinkPolicy symlinkPolicy) {
        return LocalEelFileSystemApiKt.getFileAttributes(child, symlinkPolicy);
    }

    public static final /* synthetic */ EelResult access$doClose(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, EelPath path) {
        return LocalEelFileSystemApiKt.doClose(eelFs, byteChannel, path);
    }

    public static final /* synthetic */ Set access$writeOptionsToNioOptions(EelFileSystemApi.WriteOptions options) {
        return LocalEelFileSystemApiKt.writeOptionsToNioOptions(options);
    }

    public static final /* synthetic */ EelResult access$doRead(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, ByteBuffer buf, AtomicReference isClosed, boolean autoCloseAfterLastChunk) {
        return LocalEelFileSystemApiKt.doRead(eelFs, byteChannel, buf, isClosed, autoCloseAfterLastChunk);
    }

    public static final /* synthetic */ EelResult access$doRead(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, long offset, ByteBuffer buf, AtomicReference isClosed) {
        return LocalEelFileSystemApiKt.doRead(eelFs, byteChannel, offset, buf, isClosed);
    }

    public static final /* synthetic */ EelResult access$doTell(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, AtomicReference isClosed) {
        return LocalEelFileSystemApiKt.doTell(eelFs, byteChannel, isClosed);
    }

    public static final /* synthetic */ EelResult access$doSeek(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, EelPath path, EelOpenedFile.SeekWhence whence, long offset, AtomicReference isClosed) {
        return LocalEelFileSystemApiKt.doSeek(eelFs, byteChannel, path, whence, offset, isClosed);
    }

    public static final /* synthetic */ void access$copyTimes(BasicFileAttributes oldAttrs, EelFileSystemApi.ChangeAttributesOptions options, BasicFileAttributeView view) {
        LocalEelFileSystemApiKt.copyTimes(oldAttrs, options, view);
    }

    public static final /* synthetic */ Object access$doStreamingWrite(Flow chunks, EelFileSystemApi.WriteOptions targetFileOpenOptions, Continuation $completion) {
        return LocalEelFileSystemApiKt.doStreamingWrite((Flow<? extends ByteBuffer>)chunks, targetFileOpenOptions, (Continuation<? super StreamingWriteResult>)$completion);
    }

    public static final /* synthetic */ Flow access$doStreamingRead(EelPath path) {
        return LocalEelFileSystemApiKt.doStreamingRead(path);
    }

    public static final /* synthetic */ Pair access$walkDirectoryProcessFile(Path currentItem, long emptyFileHash, EelFileSystemApi.WalkDirectoryOptions options, EelDescriptor descriptor) {
        return LocalEelFileSystemApiKt.walkDirectoryProcessFile(currentItem, emptyFileHash, options, descriptor);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ReadResult.values().length];
            try {
                nArray[ReadResult.EOF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadResult.NOT_EOF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EelOpenedFile.SeekWhence.values().length];
            try {
                nArray[EelOpenedFile.SeekWhence.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelOpenedFile.SeekWhence.CURRENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelOpenedFile.SeekWhence.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[EelFileSystemApi.SymlinkPolicy.values().length];
            try {
                nArray[EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.SymlinkPolicy.JUST_RESOLVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[EelFileSystemApi.FileWriterCreationMode.values().length];
            try {
                nArray[EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.FileWriterCreationMode.ONLY_CREATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.FileWriterCreationMode.ONLY_OPEN_EXISTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

