/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.JUnitBundle;
import com.intellij.jvm.analysis.quickFix.CompositeModCommandQuickFix;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.util.UastControlFlowUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 42\u00020\u0001:\u0003234B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u001e\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010\u001c\u001a\u00020\u0007*\u00020\u001dJ\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J1\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00052\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$H\u0002\u00a2\u0006\u0002\u0010%J1\u0010\u001f\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00052\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$H\u0002\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010/\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010&\u001a\u00020'H\u0002\u00a8\u00065"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "startInWriteAction", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "applyFix", "", "descriptor", "performConversion", "junit3Class", "Lorg/jetbrains/uast/UClass;", "findConflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "findInheritedUsagesConflicts", "isAvailableAfterMigration", "fqn", "findNonMigratableTestSuiteConflicts", "Lkotlin/Pair;", "isSuite", "Lorg/jetbrains/uast/UCallExpression;", "findSetupTeardownNameConflicts", "addAnnotation", "aClass", "Lcom/intellij/psi/PsiClass;", "parameters", "", "Lcom/intellij/lang/jvm/actions/AnnotationAttributeRequest;", "(Lcom/intellij/psi/PsiClass;Ljava/lang/String;[Lcom/intellij/lang/jvm/actions/AnnotationAttributeRequest;)V", "method", "Lorg/jetbrains/uast/UMethod;", "(Lorg/jetbrains/uast/UMethod;Ljava/lang/String;[Lcom/intellij/lang/jvm/actions/AnnotationAttributeRequest;)V", "invoke", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "file", "Lcom/intellij/psi/PsiFile;", "transformSetUpOrTearDownMethod", "transformTesSuite", "findAddedTestSuites", "", "SuperCallRemoverVisitor", "AssertionsConverter", "Companion", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnit4ConverterQuickfix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnit4ConverterQuickfix.kt\ncom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,397:1\n212#2:398\n212#2:399\n176#2:400\n1401#3,2:401\n1#4:403\n1915#5,2:404\n1915#5,2:406\n1586#5:408\n1661#5,3:409\n*S KotlinDebug\n*F\n+ 1 JUnit4ConverterQuickfix.kt\ncom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix\n*L\n82#1:398\n89#1:399\n119#1:400\n121#1:401,2\n244#1:404,2\n250#1:406,2\n271#1:408\n271#1:409,3\n*E\n"})
public final class JUnit4ConverterQuickfix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SETUP = "setUp";
    @NotNull
    private static final String TEARDOWN = "tearDown";
    @NotNull
    private static final String SUITE = "suite";
    @NotNull
    private static final String ADD_TEST = "addTest";
    @NotNull
    private static final String ADD_TEST_SUITE = "addTestSuite";
    @NotNull
    private static final List<String> migratableMethodNames;
    @NotNull
    private static final List<String> migratableConstructorNames;
    private static final CallMatcher.Simple addTestMatcher;
    private static final CallMatcher.Simple addTestSuiteMatcher;

    @NotNull
    public String getFamilyName() {
        String string = JUnitBundle.message("jvm.inspections.junit4.converter.quickfix.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        PsiElement $this$getUastParentOfType_u24default$iv = previewDescriptor.getPsiElement();
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UClass uClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        if (uClass == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        UClass junit3Class = uClass;
        this.performConversion(junit3Class);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
            return;
        }
        PsiElement $this$getUastParentOfType_u24default$iv = descriptor.getPsiElement();
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UClass uClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        if (uClass == null) {
            return;
        }
        UClass junit3Class = uClass;
        MultiMap<PsiElement, String> conflicts = this.findConflicts(junit3Class);
        Runnable runnable = () -> JUnit4ConverterQuickfix.applyFix$lambda$0(this, junit3Class);
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode() && !BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            if (!new ConflictsDialog(junit3Class.getJavaPsi().getProject(), conflicts, runnable).showAndGet()) {
                return;
            }
        }
        runnable.run();
    }

    private final void performConversion(UClass junit3Class) {
        block11: {
            PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray;
            PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray2;
            block10: {
                for (UMethod method : junit3Class.getMethods()) {
                    SmartPsiElementPointer methodPtr;
                    PsiElement psiElement;
                    PsiElement psiElement2 = method.getSourcePsi();
                    if (psiElement2 == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)SmartPointerManager.createPointer((PsiElement)psiElement2), (String)"createPointer(...)");
                    if (StringsKt.startsWith$default((String)method.getName(), (String)"test", (boolean)false, (int)2, null)) {
                        this.addAnnotation(method, "org.junit.Test", new AnnotationAttributeRequest[0]);
                    } else if (Intrinsics.areEqual((Object)method.getName(), (Object)SETUP)) {
                        this.addAnnotation(method, "org.junit.Before", new AnnotationAttributeRequest[0]);
                        this.transformSetUpOrTearDownMethod(method);
                    } else if (Intrinsics.areEqual((Object)method.getName(), (Object)TEARDOWN)) {
                        this.addAnnotation(method, "org.junit.After", new AnnotationAttributeRequest[0]);
                        this.transformSetUpOrTearDownMethod(method);
                    } else if (Intrinsics.areEqual((Object)method.getName(), (Object)SUITE)) {
                        this.transformTesSuite(method);
                    }
                    if ((psiElement = methodPtr.getElement()) == null) continue;
                    PsiElement $this$toUElementOfType$iv = psiElement;
                    boolean $i$f$toUElementOfType = false;
                    psiElement = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                    if (psiElement == null) continue;
                    psiElement.accept((UastVisitor)new AssertionsConverter());
                }
                psiJavaCodeReferenceElementArray2 = junit3Class.getJavaPsi().getExtendsList();
                if (psiJavaCodeReferenceElementArray2 == null || (psiJavaCodeReferenceElementArray2 = psiJavaCodeReferenceElementArray2.getReferenceElements()) == null) break block11;
                PsiJavaCodeReferenceElement[] $this$firstOrNull$iv = psiJavaCodeReferenceElementArray2;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiJavaCodeReferenceElement[] element$iv;
                    PsiJavaCodeReferenceElement[] it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"junit.framework.TestCase")) continue;
                    psiJavaCodeReferenceElementArray = element$iv;
                    break block10;
                }
                psiJavaCodeReferenceElementArray = psiJavaCodeReferenceElementArray2 = null;
            }
            if (psiJavaCodeReferenceElementArray != null) {
                psiJavaCodeReferenceElementArray2.delete();
            }
        }
    }

    private final MultiMap<PsiElement, String> findConflicts(UClass junit3Class) {
        MultiMap conflicts = new MultiMap();
        Pair<PsiElement, String> pair = this.findNonMigratableTestSuiteConflicts(junit3Class);
        if (pair != null) {
            Pair<PsiElement, String> it = pair;
            boolean bl = false;
            conflicts.putValue(it.getFirst(), it.getSecond());
        }
        conflicts.putAllValues(this.findInheritedUsagesConflicts(junit3Class));
        conflicts.putAllValues(this.findSetupTeardownNameConflicts(junit3Class));
        return conflicts;
    }

    private final MultiMap<PsiElement, String> findInheritedUsagesConflicts(UClass junit3Class) {
        MultiMap conflicts = new MultiMap();
        junit3Class.accept((UastVisitor)new AbstractUastVisitor(this, junit3Class, (MultiMap<PsiElement, String>)conflicts){
            final /* synthetic */ JUnit4ConverterQuickfix this$0;
            final /* synthetic */ UClass $junit3Class;
            final /* synthetic */ MultiMap<PsiElement, String> $conflicts;
            {
                this.this$0 = $receiver;
                this.$junit3Class = $junit3Class;
                this.$conflicts = $conflicts;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visitCallExpression(UCallExpression node) {
                String string;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (CollectionsKt.contains((Iterable)JUnit4ConverterQuickfix.access$getMigratableMethodNames$cp(), (Object)node.getMethodName())) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                    return false;
                }
                UResolvable $this$resolveToUElementOfType$iv = (UResolvable)node;
                boolean $i$f$resolveToUElementOfType = false;
                UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                if (!(uElement instanceof UMethod)) {
                    uElement = null;
                }
                UMethod uMethod = (UMethod)((UElement)((UMethod)uElement));
                if (uMethod == null) {
                    return false;
                }
                UMethod method = uMethod;
                if (JUnit4ConverterQuickfix.access$getMigratableConstructorNames$cp().contains(method.getName())) {
                    return false;
                }
                if (method.isStatic()) {
                    return false;
                }
                PsiClass psiClass = method.getJavaPsi().getContainingClass();
                if (psiClass == null) {
                    return false;
                }
                PsiClass containingMethodClass = psiClass;
                String string2 = containingMethodClass.getQualifiedName();
                if (string2 == null) {
                    return false;
                }
                if (JUnit4ConverterQuickfix.access$isAvailableAfterMigration(this.this$0, string2)) {
                    return false;
                }
                PsiElement psiElement = node.getSourcePsi();
                if (psiElement == null) {
                    return false;
                }
                PsiElement sourcePsi = psiElement;
                String expressionText = CommonRefactoringUtil.htmlEmphasize((String)sourcePsi.getText());
                String classText = RefactoringUIUtil.getDescription((PsiElement)((PsiElement)this.$junit3Class.getJavaPsi()), (boolean)false);
                PsiMethod[] psiMethodArray = method.getJavaPsi().findSuperMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
                Object[] objectArray = psiMethodArray;
                boolean $i$f$mapNotNull = false;
                void var10_11 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    String it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    PsiMethod it = (PsiMethod)element$iv$iv;
                    boolean bl2 = false;
                    PsiClass psiClass2 = it.getContainingClass();
                    if ((psiClass2 != null ? psiClass2.getQualifiedName() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                Object object = this.this$0;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!JUnit4ConverterQuickfix.access$isAvailableAfterMigration((JUnit4ConverterQuickfix)object, it)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List availableSupers = (List)destination$iv$iv2;
                if (!((Collection)availableSupers).isEmpty()) {
                    var10_13 = new Object[]{expressionText, classText};
                    string = JUnitBundle.message("jvm.inspections.junit4.converter.quickfix.conflict.semantics", var10_13);
                } else {
                    var10_13 = new Object[]{expressionText, classText};
                    string = JUnitBundle.message("jvm.inspections.junit4.converter.quickfix.conflict.call.compile", var10_13);
                }
                object = string;
                Intrinsics.checkNotNull((Object)object);
                Object problem = object;
                this.$conflicts.putValue((Object)node.getSourcePsi(), problem);
                return false;
            }
        });
        return conflicts;
    }

    private final boolean isAvailableAfterMigration(String fqn) {
        return !StringsKt.startsWith$default((String)fqn, (String)"junit.framework", (boolean)false, (int)2, null);
    }

    private final Pair<PsiElement, String> findNonMigratableTestSuiteConflicts(UClass junit3Class) {
        Ref.ObjectRef conflict = new Ref.ObjectRef();
        junit3Class.accept((UastVisitor)new AbstractUastVisitor((Ref.ObjectRef<Pair<PsiElement, String>>)conflict, this){
            final /* synthetic */ Ref.ObjectRef<Pair<PsiElement, String>> $conflict;
            final /* synthetic */ JUnit4ConverterQuickfix this$0;
            {
                this.$conflict = $conflict;
                this.this$0 = $receiver;
            }

            public boolean visitElement(UElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return this.$conflict.element != null;
            }

            public boolean visitMethod(UMethod node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.$conflict.element != null) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)node.getName(), (Object)"suite") && !this.isMigratableTestSuite(node)) {
                    UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                    if (uClass == null) {
                        return false;
                    }
                    UClass containingClass = uClass;
                    String classText = RefactoringUIUtil.getDescription((PsiElement)((PsiElement)containingClass.getJavaPsi()), (boolean)false);
                    Object[] objectArray = new Object[]{classText};
                    this.$conflict.element = TuplesKt.to((Object)node, (Object)JUnitBundle.message("jvm.inspections.junit4.converter.quickfix.conflict.suite", objectArray));
                }
                return true;
            }

            private final boolean isMigratableTestSuite(UMethod method) {
                Ref.BooleanRef migratable;
                block0: {
                    migratable = new Ref.BooleanRef();
                    migratable.element = true;
                    UExpression uExpression = method.getUastBody();
                    if (uExpression == null) break block0;
                    uExpression.accept((UastVisitor)new AbstractUastVisitor(migratable, this.this$0){
                        final /* synthetic */ Ref.BooleanRef $migratable;
                        final /* synthetic */ JUnit4ConverterQuickfix this$0;
                        {
                            this.$migratable = $migratable;
                            this.this$0 = $receiver;
                        }

                        public boolean visitElement(UElement node) {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            return !this.$migratable.element;
                        }

                        public boolean visitCallExpression(UCallExpression node) {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (!this.$migratable.element) {
                                return true;
                            }
                            UastCallKind uastCallKind = node.getKind();
                            if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.METHOD_CALL)) {
                                if (JUnit4ConverterQuickfix.access$getAddTestMatcher$cp().uCallMatches(node)) {
                                    UCallExpression uCallExpression = UastUtils.getUCallExpression((UElement)((UElement)CollectionsKt.first((List)node.getValueArguments())), (int)2);
                                    if (uCallExpression == null) {
                                        return false;
                                    }
                                    UCallExpression argumentExpr = uCallExpression;
                                    if (this.this$0.isSuite(argumentExpr)) {
                                        return true;
                                    }
                                    this.$migratable.element = false;
                                } else if (!JUnit4ConverterQuickfix.access$getAddTestSuiteMatcher$cp().uCallMatches(node)) {
                                    this.$migratable.element = false;
                                }
                            } else if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                                boolean bl;
                                PsiType psiType = node.getReturnType();
                                if (psiType != null) {
                                    String[] stringArray = new String[]{"junit.framework.TestSuite"};
                                    bl = !AnalysisUastUtilKt.isInheritorOf((PsiType)psiType, (String[])stringArray);
                                } else {
                                    bl = false;
                                }
                                if (bl) {
                                    this.$migratable.element = false;
                                }
                            } else {
                                this.$migratable.element = false;
                            }
                            return true;
                        }

                        public boolean visitReturnExpression(UReturnExpression node) {
                            String[] stringArray;
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (!this.$migratable.element) {
                                return true;
                            }
                            UExpression uExpression = node.getReturnExpression();
                            boolean bl = uExpression != null && (uExpression = uExpression.getExpressionType()) != null ? !AnalysisUastUtilKt.isInheritorOf((PsiType)uExpression, (String[])(stringArray = new String[]{"junit.framework.TestSuite"})) : false;
                            if (bl) {
                                this.$migratable.element = false;
                            }
                            return false;
                        }
                    });
                }
                return migratable.element;
            }
        });
        return (Pair)conflict.element;
    }

    public final boolean isSuite(@NotNull UCallExpression $this$isSuite) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuite, (String)"<this>");
        return $this$isSuite.getValueArgumentCount() == 0 && Intrinsics.areEqual((Object)$this$isSuite.getMethodName(), (Object)SUITE) && Intrinsics.areEqual((Object)TypeUtils.resolvedClassName((PsiType)$this$isSuite.getReturnType()), (Object)"junit.framework.Test");
    }

    private final MultiMap<PsiElement, String> findSetupTeardownNameConflicts(UClass junit3Class) {
        MultiMap conflicts = new MultiMap();
        junit3Class.accept((UastVisitor)new AbstractUastVisitor((MultiMap<PsiElement, String>)conflicts){
            final /* synthetic */ MultiMap<PsiElement, String> $conflicts;
            {
                this.$conflicts = $conflicts;
            }

            public boolean visitMethod(UMethod node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!Intrinsics.areEqual((Object)node.getName(), (Object)"tearDown") && !Intrinsics.areEqual((Object)node.getName(), (Object)"setUp")) {
                    return true;
                }
                PsiMethod[] psiMethodArray = node.getJavaPsi().findSuperMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
                List superMethods = ArraysKt.toMutableList((Object[])psiMethodArray);
                for (PsiMethod method : superMethods) {
                    PsiClass psiClass = method.getContainingClass();
                    if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"junit.framework.TestCase")) continue;
                    superMethods.remove(method);
                    break;
                }
                if (superMethods.isEmpty()) {
                    return true;
                }
                UElement uElement = node.getUastAnchor();
                Object[] objectArray = new Object[]{uElement != null && (uElement = uElement.getSourcePsi()) != null ? uElement.getText() : null};
                this.$conflicts.putValue((Object)node, (Object)JUnitBundle.message("jvm.inspections.junit4.converter.quickfix.conflict.name", objectArray));
                return true;
            }
        });
        return conflicts;
    }

    private final void addAnnotation(PsiClass aClass, String fqn, AnnotationAttributeRequest ... parameters) {
        Iterable $this$forEach$iv = JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)((JvmModifiersOwner)aClass), (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)fqn, (AnnotationAttributeRequest[])Arrays.copyOf(parameters, parameters.length)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntentionAction it = (IntentionAction)element$iv;
            boolean bl = false;
            PsiFile psiFile = aClass.getContainingFile();
            Intrinsics.checkNotNull((Object)psiFile);
            this.invoke(it, psiFile);
        }
    }

    private final void addAnnotation(UMethod method, String fqn, AnnotationAttributeRequest ... parameters) {
        Iterable $this$forEach$iv = JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)((JvmModifiersOwner)method.getJavaPsi()), (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)fqn, (AnnotationAttributeRequest[])Arrays.copyOf(parameters, parameters.length)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntentionAction it = (IntentionAction)element$iv;
            boolean bl = false;
            PsiElement psiElement = method.getSourcePsi();
            Object object = psiElement != null ? psiElement.getContainingFile() : null;
            Intrinsics.checkNotNull((Object)object);
            this.invoke(it, (PsiFile)object);
        }
    }

    private final void invoke(IntentionAction action, PsiFile file) {
        PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(file.getViewProvider().getDocument());
        action.invoke(file.getProject(), null, file);
    }

    private final void transformSetUpOrTearDownMethod(UMethod method) {
        PsiElement psiElement = method.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return;
        }
        PsiElement containingFile = psiElement;
        CompositeModCommandQuickFix.Companion.performActions(JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((JvmModifiersOwner)method.getJavaPsi()), (ChangeModifierRequest)MemberRequestsKt.modifierRequest$default((JvmModifier)JvmModifier.PUBLIC, (boolean)true, (boolean)false, (int)4, null)), (PsiFile)containingFile);
        CompositeModCommandQuickFix.Companion.performActions(JvmElementActionFactories.createChangeOverrideActions((JvmModifiersOwner)((JvmModifiersOwner)method.getJavaPsi()), (boolean)false), (PsiFile)containingFile);
        SuperCallRemoverVisitor visitor = new SuperCallRemoverVisitor(method.getName());
        method.accept((UastVisitor)visitor);
        visitor.applyModifications();
    }

    /*
     * WARNING - void declaration
     */
    private final void transformTesSuite(UMethod method) {
        block2: {
            void $this$mapTo$iv$iv;
            PsiClass psiClass = method.getJavaPsi().getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            Iterable $this$map$iv = this.findAddedTestSuites(method);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnnotationAttributeValueRequest.ClassValue((String)it));
            }
            List classValues = (List)destination$iv$iv;
            AnnotationAttributeRequest[] annotationAttributeRequestArray = new AnnotationAttributeRequest[]{AnnotationAttributeValueRequestKt.arrayAttribute((String)"value", (List)classValues)};
            this.addAnnotation(containingClass, "org.junit.runners.Suite.SuiteClasses", annotationAttributeRequestArray);
            annotationAttributeRequestArray = new AnnotationAttributeRequest[]{AnnotationAttributeValueRequestKt.classAttribute((String)"value", (String)"org.junit.runners.Suite")};
            this.addAnnotation(containingClass, "org.junit.runner.RunWith", annotationAttributeRequestArray);
            PsiElement psiElement = method.getSourcePsi();
            if (psiElement == null) break block2;
            psiElement.delete();
        }
    }

    private final List<String> findAddedTestSuites(UMethod method) {
        List classLiterals;
        block0: {
            classLiterals = new ArrayList();
            UExpression uExpression = method.getUastBody();
            if (uExpression == null) break block0;
            uExpression.accept((UastVisitor)new AbstractUastVisitor(this, classLiterals){
                final /* synthetic */ JUnit4ConverterQuickfix this$0;
                final /* synthetic */ List<String> $classLiterals;
                {
                    this.this$0 = $receiver;
                    this.$classLiterals = $classLiterals;
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public boolean visitCallExpression(UCallExpression node) {
                    block15: {
                        block14: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (!JUnit4ConverterQuickfix.access$getAddTestMatcher$cp().uCallMatches(node)) break block14;
                            $this$asSafely$iv = CollectionsKt.first((List)node.getValueArguments());
                            $i$f$asSafely = false;
                            v0 = $this$asSafely$iv;
                            if (!(v0 instanceof UQualifiedReferenceExpression)) {
                                v0 = null;
                            }
                            if ((qualified = (UQualifiedReferenceExpression)v0) == null || ($this$asSafely$iv = qualified.getSelector()) == null) ** GOTO lbl-1000
                            $this$asSafely$iv = $this$asSafely$iv;
                            $i$f$asSafely = false;
                            v1 = $this$asSafely$iv;
                            if (!(v1 instanceof UCallExpression)) {
                                v1 = null;
                            }
                            if (($i$f$asSafely = (UCallExpression)v1) != null) {
                                v2 = !this.this$0.isSuite($i$f$asSafely);
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = false;
                            }
                            if (v2) {
                                return false;
                            }
                            v3 = qualified;
                            $this$asSafely$iv = v3 != null ? v3.getReceiver() : null;
                            $i$f$asSafely = false;
                            v4 = $this$asSafely$iv;
                            if (!(v4 instanceof UReferenceExpression)) {
                                v4 = null;
                            }
                            v5 = (UReferenceExpression)v4;
                            if (v5 == null) {
                                return false;
                            }
                            receiver = v5;
                            $this$toUElementOfType$iv = receiver.resolve();
                            $i$f$toUElementOfType = false;
                            v6 = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
                            v7 /* !! */  = suiteClass = v6 != null ? v6.getJavaPsi() : null;
                            if (InheritanceUtil.isInheritor((PsiClass)suiteClass, (String)"junit.framework.TestCase")) {
                                v8 = suiteClass;
                                v9 = v8 != null ? v8.getQualifiedName() : null;
                            } else {
                                v10 = suiteClass;
                                v9 = v10 != null && (v10 = v10.getContainingClass()) != null ? v10.getQualifiedName() : null;
                            }
                            v11 = suiteFqn = v9;
                            if (v11 == null) {
                                return false;
                            }
                            this.$classLiterals.add(v11);
                            break block15;
                        }
                        if (JUnit4ConverterQuickfix.access$getAddTestSuiteMatcher$cp().uCallMatches(node)) {
                            $this$asSafely$iv = CollectionsKt.first((List)UastUtils.getQualifiedChain((UExpression)((UExpression)CollectionsKt.first((List)node.getValueArguments()))));
                            $i$f$asSafely = false;
                            v12 = $this$asSafely$iv;
                            if (!(v12 instanceof UClassLiteralExpression)) {
                                v12 = null;
                            }
                            if ((var3_3 = (UClassLiteralExpression)v12) == null || (var4_7 = var3_3.getType()) == null) {
                                return false;
                            }
                            type = var4_7;
                            v13 = TypeUtils.resolvedClassName((PsiType)type);
                            if (v13 == null) {
                                return false;
                            }
                            this.$classLiterals.add(v13);
                        }
                    }
                    return false;
                }
            });
        }
        return classLiterals;
    }

    private static final void applyFix$lambda$0$0(JUnit4ConverterQuickfix this$0, UClass $junit3Class) {
        this$0.performConversion($junit3Class);
    }

    private static final void applyFix$lambda$0(JUnit4ConverterQuickfix this$0, UClass $junit3Class) {
        WriteAction.run(() -> JUnit4ConverterQuickfix.applyFix$lambda$0$0(this$0, $junit3Class));
    }

    public static final /* synthetic */ List access$getMigratableMethodNames$cp() {
        return migratableMethodNames;
    }

    public static final /* synthetic */ List access$getMigratableConstructorNames$cp() {
        return migratableConstructorNames;
    }

    public static final /* synthetic */ boolean access$isAvailableAfterMigration(JUnit4ConverterQuickfix $this, String fqn) {
        return $this.isAvailableAfterMigration(fqn);
    }

    public static final /* synthetic */ CallMatcher.Simple access$getAddTestMatcher$cp() {
        return addTestMatcher;
    }

    public static final /* synthetic */ CallMatcher.Simple access$getAddTestSuiteMatcher$cp() {
        return addTestSuiteMatcher;
    }

    static {
        Object[] objectArray = new String[]{SETUP, TEARDOWN, SUITE, ADD_TEST, ADD_TEST_SUITE};
        migratableMethodNames = CollectionsKt.listOf((Object[])objectArray);
        migratableConstructorNames = CollectionsKt.listOf((Object)"TestSuite");
        objectArray = new String[]{ADD_TEST};
        CallMatcher.Simple simple = CallMatcher.instanceCall((String)"junit.framework.TestSuite", (String[])objectArray);
        objectArray = new String[]{"junit.framework.Test"};
        addTestMatcher = simple.parameterTypes((String[])objectArray);
        objectArray = new String[]{ADD_TEST_SUITE};
        CallMatcher.Simple simple2 = CallMatcher.instanceCall((String)"junit.framework.TestSuite", (String[])objectArray);
        objectArray = new String[]{"java.lang.Class"};
        addTestSuiteMatcher = simple2.parameterTypes((String[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix$AssertionsConverter;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "<init>", "()V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnit4ConverterQuickfix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnit4ConverterQuickfix.kt\ncom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix$AssertionsConverter\n+ 2 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n+ 3 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,397:1\n43#2:398\n271#3,6:399\n278#3:406\n13#4:405\n*S KotlinDebug\n*F\n+ 1 JUnit4ConverterQuickfix.kt\ncom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix$AssertionsConverter\n*L\n363#1:398\n374#1:399,6\n374#1:406\n374#1:405\n*E\n"})
    private static final class AssertionsConverter
    extends AbstractUastVisitor {
        /*
         * WARNING - void declaration
         */
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            void $this$replace$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!node.isPsiValid()) {
                return true;
            }
            UResolvable $this$resolveToUElementOfType$iv = (UResolvable)node;
            boolean $i$f$resolveToUElementOfType = false;
            UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
            if (!(uElement instanceof UMethod)) {
                uElement = null;
            }
            UMethod uMethod = (UMethod)((UElement)((UMethod)uElement));
            if (uMethod == null) {
                return false;
            }
            UMethod method = uMethod;
            if (!method.isStatic()) {
                return false;
            }
            PsiClass psiClass = method.getJavaPsi().getContainingClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass containingMethodClass = psiClass;
            String containingClassFqn = containingMethodClass.getQualifiedName();
            if (!Intrinsics.areEqual((Object)containingClassFqn, (Object)"junit.framework.Assert") && !Intrinsics.areEqual((Object)containingClassFqn, (Object)"junit.framework.TestCase")) {
                return false;
            }
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null || (psiElement = psiElement.getProject()) == null) {
                return true;
            }
            PsiElement project = psiElement;
            UastElementFactory uastElementFactory = UastCodeGenerationPluginKt.getUastElementFactory((UElement)((UElement)node), (Project)project);
            if (uastElementFactory == null) {
                return false;
            }
            UastElementFactory elementFactory = uastElementFactory;
            UCallExpression uCallExpression = UastElementFactory.createCallExpression$default((UastElementFactory)elementFactory, (UExpression)((UExpression)elementFactory.createQualifiedReference("org.junit.Assert", node.getSourcePsi())), (String)method.getName(), (List)node.getValueArguments(), (PsiType)node.getReturnType(), (UastCallKind)UastCallKind.METHOD_CALL, null, (int)32, null);
            if (uCallExpression == null) {
                return false;
            }
            UCallExpression newCall = uCallExpression;
            UElement uElement2 = (UElement)node;
            UElement newElement$iv = (UElement)newCall;
            boolean $i$f$replace = false;
            if (!Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
                UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UCallExpression.class) : null;
                boolean bl = false;
                if (it$iv == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
                }
            }
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix$Companion;", "", "<init>", "()V", "SETUP", "", "TEARDOWN", "SUITE", "ADD_TEST", "ADD_TEST_SUITE", "migratableMethodNames", "", "migratableConstructorNames", "addTestMatcher", "Lcom/siyeh/ig/callMatcher/CallMatcher$Simple;", "kotlin.jvm.PlatformType", "addTestSuiteMatcher", "intellij.junit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix$SuperCallRemoverVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "methodName", "", "<init>", "(Ljava/lang/String;)V", "elementsToDelete", "", "Lcom/intellij/psi/PsiElement;", "tryExpressions", "Lorg/jetbrains/uast/UTryExpression;", "visitSuperExpression", "", "node", "Lorg/jetbrains/uast/USuperExpression;", "applyModifications", "", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnit4ConverterQuickfix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnit4ConverterQuickfix.kt\ncom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix$SuperCallRemoverVisitor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,397:1\n18#2:398\n18#2:399\n18#2:400\n1#3:401\n1915#4,2:402\n*S KotlinDebug\n*F\n+ 1 JUnit4ConverterQuickfix.kt\ncom/intellij/execution/junit/codeInspection/JUnit4ConverterQuickfix$SuperCallRemoverVisitor\n*L\n321#1:398\n322#1:399\n331#1:400\n356#1:402,2\n*E\n"})
    private static final class SuperCallRemoverVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final String methodName;
        @NotNull
        private final List<PsiElement> elementsToDelete;
        @NotNull
        private final List<UTryExpression> tryExpressions;

        public SuperCallRemoverVisitor(@NotNull String methodName) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            this.methodName = methodName;
            this.elementsToDelete = new ArrayList();
            this.tryExpressions = new ArrayList();
        }

        public boolean visitSuperExpression(@NotNull USuperExpression node) {
            block13: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement $this$asSafely$iv = node.getUastParent();
                boolean $i$f$asSafely = false;
                UElement uElement = $this$asSafely$iv;
                if (!(uElement instanceof UQualifiedReferenceExpression)) {
                    uElement = null;
                }
                UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)uElement;
                if (uQualifiedReferenceExpression == null) {
                    return false;
                }
                UQualifiedReferenceExpression qualifiedSuper = uQualifiedReferenceExpression;
                UExpression $this$asSafely$iv2 = qualifiedSuper.getSelector();
                boolean $i$f$asSafely22 = false;
                UExpression uExpression = $this$asSafely$iv2;
                if (!(uExpression instanceof UCallExpression)) {
                    uExpression = null;
                }
                UCallExpression uCallExpression = (UCallExpression)uExpression;
                if (uCallExpression == null) {
                    return false;
                }
                UCallExpression selector = uCallExpression;
                if (!Intrinsics.areEqual((Object)selector.getMethodName(), (Object)this.methodName)) {
                    return false;
                }
                if (UastControlFlowUtils.isInFinallyBlock((UElement)((UElement)qualifiedSuper))) {
                    Object object;
                    UExpression finallyClause;
                    Class[] $i$f$asSafely22 = new Class[]{UMethod.class};
                    UTryExpression uTryExpression = (UTryExpression)UastUtils.getParentOfType((UElement)((UElement)qualifiedSuper), UTryExpression.class, (boolean)true, (Class[])$i$f$asSafely22);
                    if (uTryExpression == null) {
                        return false;
                    }
                    UTryExpression tryExpression = uTryExpression;
                    UExpression uExpression2 = tryExpression.getFinallyClause();
                    if (uExpression2 == null) {
                        return false;
                    }
                    UExpression $this$asSafely$iv3 = finallyClause = uExpression2;
                    boolean $i$f$asSafely3 = false;
                    UExpression uExpression3 = $this$asSafely$iv3;
                    if (!(uExpression3 instanceof UBlockExpression)) {
                        uExpression3 = null;
                    }
                    boolean bl = (object = (UBlockExpression)uExpression3) != null && (object = object.getExpressions()) != null ? object.size() == 1 : false;
                    if (bl) {
                        List catchClauses = tryExpression.getCatchClauses();
                        if (catchClauses.isEmpty() && !tryExpression.getHasResources()) {
                            this.tryExpressions.add(tryExpression);
                        } else {
                            PsiElement psiElement = finallyClause.getSourcePsi();
                            if (psiElement != null) {
                                PsiElement it = psiElement;
                                boolean bl2 = false;
                                this.elementsToDelete.add(it);
                            }
                        }
                        return false;
                    }
                }
                PsiElement psiElement = qualifiedSuper.getSourcePsi();
                if (psiElement == null) break block13;
                PsiElement it = psiElement;
                boolean bl = false;
                this.elementsToDelete.add(it);
            }
            return false;
        }

        public final void applyModifications() {
            for (UTryExpression tryExpression : this.tryExpressions) {
                PsiElement tryExprSrcPsi;
                PsiElement tryClauseSrcPsi;
                if (tryExpression.getSourcePsi() == null || tryExpression.getTryClause().getSourcePsi() == null) continue;
                PsiElement psiElement = tryClauseSrcPsi.getFirstChild();
                PsiElement first = psiElement != null ? psiElement.getNextSibling() : null;
                PsiElement psiElement2 = tryClauseSrcPsi.getLastChild();
                PsiElement last = psiElement2 != null ? psiElement2.getPrevSibling() : null;
                PsiElement psiElement3 = tryExprSrcPsi.getParent();
                if (psiElement3 != null) {
                    psiElement3.addRangeAfter(first, last, tryExpression.getSourcePsi());
                }
                tryExprSrcPsi.delete();
            }
            Iterable $this$forEach$iv = this.elementsToDelete;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                it.delete();
            }
        }
    }
}

