/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.diagram;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.diagrams.perspectives.beans.SpringElementWrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.PsiElementPointer;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LiveBeanWrapper
extends SpringElementWrapper<LiveBean> {
    private static final String DELIMITER = ";";
    @NotNull
    private final Project myProject;
    @NotNull
    private final NotNullLazyValue<PsiElementPointer> myPointer;

    LiveBeanWrapper(@NotNull LiveBean bean, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration) {
        if (bean == null) {
            LiveBeanWrapper.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            LiveBeanWrapper.$$$reportNull$$$0(1);
        }
        super((Object)bean);
        this.myProject = runConfiguration.getProject();
        this.myPointer = NotNullLazyValue.lazy(() -> {
            Module module = runConfiguration.getModule();
            PsiElement resourceElement = ((LiveBean)this.getWrapped()).getResource() == null ? null : ((LiveBean)this.getWrapped()).getResource().findResourceElement(runConfiguration.getResourceContext());
            PsiClass beanClass = ((LiveBean)this.getWrapped()).findBeanClass(this.myProject, runConfiguration.getSearchScope());
            SpringModel model = module == null ? null : SpringManager.getInstance((Project)this.myProject).getCombinedModel(module);
            return ((LiveBean)this.getWrapped()).findBeanPointer(beanClass, resourceElement, (CommonSpringModel)model);
        });
    }

    public String getName() {
        return ((LiveBean)this.getWrapped()).getName();
    }

    @Nullable
    public CommonSpringModel getProcessingSpringModel(boolean localModel) {
        return null;
    }

    @NotNull
    public String getFqn() {
        LiveBean liveBean = (LiveBean)this.getWrapped();
        if (!liveBean.isInnerBean()) {
            String string = LiveBeanWrapper.getLiveBeanFqn(liveBean);
            if (string == null) {
                LiveBeanWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }
        Set injectedInto = liveBean.getInjectedInto();
        LiveBean injected = (LiveBean)ContainerUtil.getFirstItem((Collection)injectedInto);
        Object object = injected == null ? LiveBeanWrapper.getLiveBeanFqn(liveBean) : LiveBeanWrapper.getLiveBeanFqn(injected) + DELIMITER + liveBean.getId();
        if (object == null) {
            LiveBeanWrapper.$$$reportNull$$$0(3);
        }
        return object;
    }

    private static String getLiveBeanFqn(LiveBean liveBean) {
        StringBuilder sb = new StringBuilder();
        LiveResource liveResource = liveBean.getResource();
        if (liveResource != null) {
            sb.append(liveResource.getContext().getName()).append(DELIMITER).append(liveResource.getDescription()).append(DELIMITER);
        } else {
            sb.append(DELIMITER).append(DELIMITER);
        }
        sb.append(liveBean.getId());
        return sb.toString();
    }

    @Nullable
    public Module getModule() {
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = ((LiveBean)this.getWrapped()).getIcon();
        if (icon == null) {
            LiveBeanWrapper.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public PsiElementPointer getPointer() {
        PsiElementPointer psiElementPointer = DumbService.isDumb((Project)this.myProject) ? () -> null : (PsiElementPointer)this.myPointer.getValue();
        if (psiElementPointer == null) {
            LiveBeanWrapper.$$$reportNull$$$0(5);
        }
        return psiElementPointer;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            LiveBeanWrapper.$$$reportNull$$$0(6);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/diagram/LiveBeanWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/diagram/LiveBeanWrapper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

