/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jvm.analysis.quickFix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jvm/analysis/quickFix/RemoveAnnotationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "annotation", "Lcom/intellij/lang/jvm/JvmAnnotation;", "<init>", "(Lcom/intellij/lang/jvm/JvmAnnotation;)V", "annotationPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiAnnotation;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getName", "", "getFamilyName", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "applyFix", "", "descriptor", "intellij.jvm.analysis.quickFix"})
@SourceDebugExtension(value={"SMAP\nRemoveAnnotationQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveAnnotationQuickFix.kt\ncom/intellij/jvm/analysis/quickFix/RemoveAnnotationQuickFix\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,37:1\n176#2:38\n*S KotlinDebug\n*F\n+ 1 RemoveAnnotationQuickFix.kt\ncom/intellij/jvm/analysis/quickFix/RemoveAnnotationQuickFix\n*L\n29#1:38\n*E\n"})
public final class RemoveAnnotationQuickFix
implements LocalQuickFix {
    @NotNull
    private final SmartPsiElementPointer<PsiAnnotation> annotationPointer;

    public RemoveAnnotationQuickFix(@NotNull JvmAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)((PsiAnnotation)annotation)));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.annotationPointer = smartPsiElementPointer;
    }

    @NotNull
    public String getName() {
        Object object = (PsiAnnotation)this.annotationPointer.getElement();
        Object[] objectArray = new Object[]{object != null && (object = object.getQualifiedName()) != null ? StringsKt.substringAfterLast$default((String)object, (String)".", null, (int)2, null) : null};
        String string = CommonQuickFixBundle.message((String)"fix.remove.annotation.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CommonQuickFixBundle.message((String)"fix.remove.annotation.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        void $this$toUElementOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.annotationPointer.getElement();
        PsiElement psiElement = PsiTreeUtil.findSameElementInCopy((PsiElement)(psiAnnotation != null ? psiAnnotation.getNavigationElement() : null), (PsiFile)previewDescriptor.getPsiElement().getContainingFile());
        boolean $i$f$toUElementOfType = false;
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UAnnotation.class);
        if (uAnnotation == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        UAnnotation annotation = uAnnotation;
        PsiElement psiElement2 = annotation.getSourcePsi();
        if (psiElement2 != null) {
            psiElement2.delete();
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiAnnotation psiAnnotation = (PsiAnnotation)this.annotationPointer.getElement();
            if (psiAnnotation == null) break block0;
            psiAnnotation.delete();
        }
    }
}

