/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.mode.key.handlers;

import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/mode/key/handlers/JupyterEditorBackSpaceKeyHandler;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "isEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "backspaceShouldWork", "isNotebookEditor", "doExecute", "", "intellij.jupyter.core"})
public final class JupyterEditorBackSpaceKeyHandler
extends EditorActionHandler
implements ActionRemoteBehaviorSpecification.Frontend {
    @Nullable
    private final EditorActionHandler originalHandler;

    public JupyterEditorBackSpaceKeyHandler(@Nullable EditorActionHandler originalHandler) {
        this.originalHandler = originalHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!this.backspaceShouldWork(editor, dataContext)) return false;
        EditorActionHandler editorActionHandler = this.originalHandler;
        if (editorActionHandler == null) return false;
        if (!editorActionHandler.isEnabled(editor, caret, dataContext)) return false;
        return true;
    }

    private final boolean backspaceShouldWork(Editor editor, DataContext dataContext) {
        return !this.isNotebookEditor(dataContext) || NotebookEditorModeKt.getCurrentMode((Editor)editor) == NotebookEditorMode.EDIT;
    }

    private final boolean isNotebookEditor(DataContext dataContext) {
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return false;
        }
        EditorImpl jupyterEditor = editorImpl;
        return Intrinsics.areEqual((Object)JupyterDataContextExtensionsKt.getContextComponent(dataContext), (Object)jupyterEditor.getContentComponent());
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (!this.backspaceShouldWork(editor, dataContext)) break block1;
            EditorActionHandler editorActionHandler = this.originalHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(editor, caret, dataContext);
            }
        }
    }
}

