/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.actions.edit.mode;

import com.intellij.codeInsight.editorActions.PasteHandler;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.Producer;
import com.intellij.util.system.OS;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/editor/actions/edit/mode/JupyterEditModePasteAction;", "Lcom/intellij/codeInsight/editorActions/PasteHandler;", "originalAction", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "execute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "producer", "Lcom/intellij/util/Producer;", "Ljava/awt/datatransfer/Transferable;", "getBufferedImageFromCopyPasteManager", "Ljava/awt/image/BufferedImage;", "tryInsertImage", "", "getBufferedImage", "image", "Ljava/awt/Image;", "bufferedImageToBase64", "", "bufferedImage", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterEditModePasteAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterEditModePasteAction.kt\ncom/intellij/jupyter/core/editor/actions/edit/mode/JupyterEditModePasteAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n1#2:106\n23#3:107\n*S KotlinDebug\n*F\n+ 1 JupyterEditModePasteAction.kt\ncom/intellij/jupyter/core/editor/actions/edit/mode/JupyterEditModePasteAction\n*L\n56#1:107\n*E\n"})
public final class JupyterEditModePasteAction
extends PasteHandler {
    public JupyterEditModePasteAction(@NotNull EditorActionHandler originalAction) {
        Intrinsics.checkNotNullParameter((Object)originalAction, (String)"originalAction");
        super(originalAction);
    }

    public void execute(@NotNull Editor editor, @NotNull DataContext dataContext, @Nullable Producer<? extends Transferable> producer) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!this.tryInsertImage(editor)) {
            super.execute(editor, dataContext, producer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BufferedImage getBufferedImageFromCopyPasteManager() {
        try {
            Object object;
            CopyPasteManager $this$getBufferedImageFromCopyPasteManager_u24lambda_u240 = CopyPasteManager.getInstance();
            boolean bl = false;
            if (OS.CURRENT == OS.macOS) {
                object = (List)$this$getBufferedImageFromCopyPasteManager_u24lambda_u240.getContents(DataFlavor.javaFileListFlavor);
                if (object != null && (object = CollectionsKt.firstOrNull((List)object)) != null) {
                    Object it = object;
                    boolean bl2 = false;
                    File file = it instanceof File ? (File)it : null;
                    object = file;
                    if (file != null) {
                        Object file2 = object;
                        boolean bl3 = false;
                        BufferedImage bufferedImage = ImageIO.read((File)file2);
                        object = bufferedImage;
                        if (bufferedImage != null) return object;
                    }
                }
                Image image = (Image)$this$getBufferedImageFromCopyPasteManager_u24lambda_u240.getContents(DataFlavor.imageFlavor);
                if (image == null) return null;
                Image it = image;
                boolean bl4 = false;
                object = this.getBufferedImage(it);
                return object;
            } else {
                object = (Image)$this$getBufferedImageFromCopyPasteManager_u24lambda_u240.getContents(DataFlavor.imageFlavor);
                if (object != null) {
                    Object it = object;
                    boolean bl5 = false;
                    BufferedImage bufferedImage = this.getBufferedImage((Image)it);
                    object = bufferedImage;
                    if (bufferedImage != null) return object;
                }
                List list = (List)$this$getBufferedImageFromCopyPasteManager_u24lambda_u240.getContents(DataFlavor.javaFileListFlavor);
                Object object2 = list;
                if (list == null) return null;
                Object object3 = CollectionsKt.firstOrNull((List)object2);
                object2 = object3;
                if (object3 == null) return null;
                Object it = object2;
                boolean bl6 = false;
                if (!(it instanceof File)) return null;
                File file = (File)it;
                object2 = file;
                if (file == null) return null;
                Object file3 = object2;
                boolean bl7 = false;
                object = ImageIO.read((File)file3);
            }
            return object;
        }
        catch (Exception e) {
            JupyterEditModePasteAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterEditModePasteAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            return null;
        }
    }

    private final boolean tryInsertImage(Editor editor) {
        if (!(editor instanceof EditorImpl) || ((EditorImpl)editor).getEditorKind() != EditorKind.MAIN_EDITOR || !JupyterEditorExtensionsKt.isJupyter(editor)) {
            return false;
        }
        Project project = ((EditorImpl)editor).getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)editor);
        if (notebookCellSelectionModel == null) {
            return false;
        }
        NotebookCellSelectionModel cellSelection = notebookCellSelectionModel;
        JupyterCell jupyterCell = JupyterCellLinesExtensionsKt.toJupyterCell(cellSelection.getPrimarySelectedCell(), (EditorImpl)editor);
        if (jupyterCell == null) {
            return false;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        BufferedImage bufferedImage = this.getBufferedImageFromCopyPasteManager();
        if (bufferedImage == null) {
            return false;
        }
        BufferedImage bufferedImage2 = bufferedImage;
        if (!Intrinsics.areEqual((Object)jupyterCell2.getCellTypeProvider().getJupyterCellType(), (Object)JupyterCellType.Companion.getMARKDOWN())) {
            JBPopupFactory.getInstance().createMessage(JupyterBundle.message("notification.jupyter.trying.insert.image.not.in.md.cell", new Object[0])).showInBestPositionFor(editor);
            return false;
        }
        String base64Image = this.bufferedImageToBase64(bufferedImage2);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String imageUUID = string;
        jupyterCell2.getAttachments().putAttachment(imageUUID + ".png", MimeType.IMAGE_PNG, base64Image);
        WriteCommandAction.writeCommandAction((Project)project2).run(() -> JupyterEditModePasteAction.tryInsertImage$lambda$0(editor, imageUUID));
        return true;
    }

    private final BufferedImage getBufferedImage(Image image) {
        Graphics2D graphics2D;
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage $this$getBufferedImage_u24lambda_u240 = bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        boolean bl = false;
        Graphics2D $this$getBufferedImage_u24lambda_u240_u240 = graphics2D = $this$getBufferedImage_u24lambda_u240.createGraphics();
        boolean bl2 = false;
        $this$getBufferedImage_u24lambda_u240_u240.drawImage(image, 0, 0, null);
        $this$getBufferedImage_u24lambda_u240_u240.dispose();
        return bufferedImage;
    }

    private final String bufferedImageToBase64(BufferedImage bufferedImage) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteStream);
        byte[] imageBytes = byteStream.toByteArray();
        String string = Base64.getEncoder().encodeToString(imageBytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    private static final void tryInsertImage$lambda$0(Editor $editor, String $imageUUID) {
        ((EditorImpl)$editor).getDocument().insertString(((EditorImpl)$editor).getCaretModel().getPrimaryCaret().getOffset(), (CharSequence)("![image.png](attachment:" + $imageUUID + ".png)"));
    }
}

