/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.http.proxy;

import com.intellij.credentialStore.Credentials;
import com.intellij.jupyter.core.jupyter.connections.http.proxy.ProxyType;
import java.net.InetSocketAddress;
import java.net.Proxy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J?\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010!\u001a\u00020\u0007H\u00d6\u0081\u0004J\n\u0010\"\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/http/proxy/ProxySettings;", "", "type", "Lcom/intellij/jupyter/core/jupyter/connections/http/proxy/ProxyType;", "host", "", "port", "", "credentials", "Lcom/intellij/credentialStore/Credentials;", "ignoreHosts", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/http/proxy/ProxyType;Ljava/lang/String;ILcom/intellij/credentialStore/Credentials;Ljava/lang/String;)V", "getType", "()Lcom/intellij/jupyter/core/jupyter/connections/http/proxy/ProxyType;", "getHost", "()Ljava/lang/String;", "getPort", "()I", "getCredentials", "()Lcom/intellij/credentialStore/Credentials;", "getIgnoreHosts", "toJavaProxy", "Ljava/net/Proxy;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.jupyter.core"})
public final class ProxySettings {
    @NotNull
    private final ProxyType type;
    @NotNull
    private final String host;
    private final int port;
    @Nullable
    private final Credentials credentials;
    @Nullable
    private final String ignoreHosts;

    public ProxySettings(@NotNull ProxyType type, @NotNull String host, int port, @Nullable Credentials credentials, @Nullable String ignoreHosts) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.type = type;
        this.host = host;
        this.port = port;
        this.credentials = credentials;
        this.ignoreHosts = ignoreHosts;
    }

    public /* synthetic */ ProxySettings(ProxyType proxyType, String string, int n, Credentials credentials, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        this(proxyType, string, n, credentials, string2);
    }

    @NotNull
    public final ProxyType getType() {
        return this.type;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final Credentials getCredentials() {
        return this.credentials;
    }

    @Nullable
    public final String getIgnoreHosts() {
        return this.ignoreHosts;
    }

    @NotNull
    public final Proxy toJavaProxy() {
        return new Proxy(switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> Proxy.Type.HTTP;
            case 2 -> Proxy.Type.SOCKS;
            default -> throw new NoWhenBranchMatchedException();
        }, new InetSocketAddress(this.host, this.port));
    }

    @NotNull
    public final ProxyType component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.host;
    }

    public final int component3() {
        return this.port;
    }

    @Nullable
    public final Credentials component4() {
        return this.credentials;
    }

    @Nullable
    public final String component5() {
        return this.ignoreHosts;
    }

    @NotNull
    public final ProxySettings copy(@NotNull ProxyType type, @NotNull String host, int port, @Nullable Credentials credentials, @Nullable String ignoreHosts) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new ProxySettings(type, host, port, credentials, ignoreHosts);
    }

    public static /* synthetic */ ProxySettings copy$default(ProxySettings proxySettings, ProxyType proxyType, String string, int n, Credentials credentials, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            proxyType = proxySettings.type;
        }
        if ((n2 & 2) != 0) {
            string = proxySettings.host;
        }
        if ((n2 & 4) != 0) {
            n = proxySettings.port;
        }
        if ((n2 & 8) != 0) {
            credentials = proxySettings.credentials;
        }
        if ((n2 & 0x10) != 0) {
            string2 = proxySettings.ignoreHosts;
        }
        return proxySettings.copy(proxyType, string, n, credentials, string2);
    }

    @NotNull
    public String toString() {
        return "ProxySettings(type=" + this.type + ", host=" + this.host + ", port=" + this.port + ", credentials=" + this.credentials + ", ignoreHosts=" + this.ignoreHosts + ")";
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + this.host.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.port);
        result2 = result2 * 31 + (this.credentials == null ? 0 : this.credentials.hashCode());
        result2 = result2 * 31 + (this.ignoreHosts == null ? 0 : this.ignoreHosts.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProxySettings)) {
            return false;
        }
        ProxySettings proxySettings = (ProxySettings)other;
        if (this.type != proxySettings.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)proxySettings.host)) {
            return false;
        }
        if (this.port != proxySettings.port) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.credentials, (Object)proxySettings.credentials)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.ignoreHosts, (Object)proxySettings.ignoreHosts);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProxyType.values().length];
            try {
                nArray[ProxyType.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.SOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

