/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.managed;

import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterManagedServerProcessHandlerKt;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterProcessException;
import com.intellij.notebooks.jupyter.core.jupyter.preview.JupyterHttpUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.YieldKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 72\u00020\u0001:\u0003567B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010'\u001a\u00020\fH\u0002J\u0006\u0010(\u001a\u00020\u0018J\b\u0010)\u001a\u00020\fH\u0016J\u000e\u0010*\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\fH\u0014J\b\u0010-\u001a\u00020\fH\u0014J\b\u0010.\u001a\u00020\fH\u0002J\b\u0010/\u001a\u00020&H\u0014J\b\u00100\u001a\u000201H\u0014J\u0016\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u00104R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u0004\u0018\u00010\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00060!j\u0002`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler;", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "process", "Ljava/lang/Process;", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "targetCommandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "onServerTerminated", "Lkotlin/Function0;", "", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/Process;Lcom/intellij/execution/target/TargetEnvironment;Lcom/intellij/execution/target/TargetedCommandLine;Lkotlin/jvm/functions/Function0;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "getTargetEnvironment", "()Lcom/intellij/execution/target/TargetEnvironment;", "value", "Ljava/net/URI;", "location", "getLocation", "()Ljava/net/URI;", "", "token", "getToken", "()Ljava/lang/String;", "serverPath", "getServerPath", "STDERR_DATA_MAX_CAPACITY", "", "stderrData", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "serverInitLatch", "Ljava/util/concurrent/CountDownLatch;", "isDestroyedOnTerminate", "", "initJupyterServer", "collectErrorData", "startNotify", "startAndWaitForServer", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doDestroyProcess", "detachProcessImpl", "closeStreams", "destroyProcessGracefully", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "waitUntilServerReachable", "uri", "(Ljava/net/URI;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "JupyterProcessListener", "ConnectionPatternMatchResult", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterManagedServerProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterManagedServerProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,399:1\n23#2:400\n60#2,5:401\n23#2:406\n60#2,5:407\n23#2:412\n60#2,5:413\n23#2:418\n60#2,5:419\n23#2:424\n60#2,5:425\n23#2:430\n60#2,5:431\n23#2:436\n23#2:437\n23#2:438\n*S KotlinDebug\n*F\n+ 1 JupyterManagedServerProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler\n*L\n121#1:400\n121#1:401,5\n124#1:406\n124#1:407,5\n129#1:412\n129#1:413,5\n131#1:418\n131#1:419,5\n134#1:424\n134#1:425,5\n136#1:430\n136#1:431,5\n221#1:436\n233#1:437\n243#1:438\n*E\n"})
public final class JupyterManagedServerProcessHandler
extends KillableColoredProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final TargetEnvironment targetEnvironment;
    @NotNull
    private final Function0<Unit> onServerTerminated;
    @Nullable
    private volatile URI location;
    @Nullable
    private volatile String token;
    @Nullable
    private volatile String serverPath;
    private final int STDERR_DATA_MAX_CAPACITY;
    @NotNull
    private final StringBuilder stderrData;
    @NotNull
    private final CountDownLatch serverInitLatch;
    private boolean isDestroyedOnTerminate;
    @NotNull
    private static final Pattern NOTEBOOK_CONNECTION_PATTERN;
    @NotNull
    private static final Regex SERVER_PATH_PATTERN;

    public JupyterManagedServerProcessHandler(@NotNull CoroutineScope scope, @NotNull Process process2, @NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine targetCommandLine, @NotNull Function0<Unit> onServerTerminated) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)targetCommandLine, (String)"targetCommandLine");
        Intrinsics.checkNotNullParameter(onServerTerminated, (String)"onServerTerminated");
        super(process2, targetCommandLine.getCommandPresentation(targetEnvironment));
        this.scope = scope;
        this.targetEnvironment = targetEnvironment;
        this.onServerTerminated = onServerTerminated;
        this.STDERR_DATA_MAX_CAPACITY = 8192;
        this.stderrData = new StringBuilder();
        this.serverInitLatch = new CountDownLatch(1);
        this.isDestroyedOnTerminate = true;
        this.addProcessListener(new ProcessListener(){

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                Logger $this$debug_u24default$iv = JupyterManagedServerProcessHandlerKt.access$getLOG$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    String string = outputType.toString();
                    String string2 = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    char[] cArray = new char[]{'\r', '\n'};
                    logger.debug(string + ":" + StringsKt.trimStart((String)((Object)StringsKt.trimEnd((CharSequence)string2)).toString(), (char[])cArray), t$iv);
                }
            }
        });
    }

    public /* synthetic */ JupyterManagedServerProcessHandler(CoroutineScope coroutineScope, Process process2, TargetEnvironment targetEnvironment, TargetedCommandLine targetedCommandLine, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function0 = JupyterManagedServerProcessHandler::_init_$lambda$0;
        }
        this(coroutineScope, process2, targetEnvironment, targetedCommandLine, (Function0<Unit>)function0);
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final TargetEnvironment getTargetEnvironment() {
        return this.targetEnvironment;
    }

    @Nullable
    public final URI getLocation() {
        return this.location;
    }

    @Nullable
    public final String getToken() {
        return this.token;
    }

    @Nullable
    public final String getServerPath() {
        return this.serverPath;
    }

    private final void initJupyterServer() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        while (!this.serverInitLatch.await(500L, TimeUnit.MILLISECONDS)) {
            if (!this.isProcessTerminating() && !this.isProcessTerminated()) continue;
            throw new InterruptedException();
        }
        if (this.location == null || this.serverPath == null) {
            throw new JupyterProcessException(this.getExitCode(), this.collectErrorData());
        }
    }

    @NotNull
    public final String collectErrorData() {
        String string = this.stderrData.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void startNotify() {
        super.startNotify();
    }

    @Nullable
    public final Object startAndWaitForServer(@NotNull Continuation<? super Unit> $completion) {
        this.addProcessListener(new JupyterProcessListener());
        Deferred waitJob2 = BuildersKt.async$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterManagedServerProcessHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        JupyterManagedServerProcessHandler.access$initJupyterServer(this.this$0);
                        URI uRI = this.this$0.getLocation();
                        Intrinsics.checkNotNull((Object)uRI);
                        this.label = 1;
                        Object object2 = JupyterManagedServerProcessHandler.access$waitUntilServerReachable(this.this$0, uRI, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.startNotify();
        Object object = waitJob2.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected void doDestroyProcess() {
        boolean bl;
        boolean gracefulTerminationAttempted;
        Logger logger;
        JupyterManagedServerProcessHandler $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(JupyterManagedServerProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        Logger $this$debug_u24default$iv = logger2;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("Destroying Jupyter process", t$iv);
        }
        boolean bl3 = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canDestroyProcessGracefully() && this.destroyProcessGracefully();
        if (gracefulTerminationAttempted) {
            JupyterManagedServerProcessHandler $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger3 = Logger.getInstance(JupyterManagedServerProcessHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            Logger $this$debug_u24default$iv2 = logger3;
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl4 = false;
                logger.debug("Destroyed gracefully", t$iv2);
            }
            return;
        }
        boolean bl5 = bl = this.shouldDestroyProcessRecursively() && KillableColoredProcessHandler.processCanBeKilledByOS((Process)this.getProcess());
        if (bl) {
            JupyterManagedServerProcessHandler $this$thisLogger$iv3 = this;
            $i$f$thisLogger = false;
            Logger logger4 = Logger.getInstance(JupyterManagedServerProcessHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
            Logger $this$debug_u24default$iv3 = logger4;
            Throwable t$iv3 = null;
            boolean $i$f$debug3 = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                logger = $this$debug_u24default$iv3;
                boolean bl6 = false;
                logger.debug("Start kill process tree", t$iv3);
            }
            this.killProcessTree(this.getProcess());
            $this$thisLogger$iv3 = this;
            $i$f$thisLogger = false;
            Logger logger5 = Logger.getInstance(JupyterManagedServerProcessHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"getInstance(...)");
            $this$debug_u24default$iv3 = logger5;
            t$iv = null;
            $i$f$debug3 = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                logger = $this$debug_u24default$iv3;
                boolean bl7 = false;
                logger.debug("Finish kill process tree", t$iv);
            }
        } else if (!bl) {
            JupyterManagedServerProcessHandler $this$thisLogger$iv4 = this;
            $i$f$thisLogger = false;
            Logger logger6 = Logger.getInstance(JupyterManagedServerProcessHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger6, (String)"getInstance(...)");
            Logger $this$debug_u24default$iv4 = logger6;
            Throwable t$iv4 = null;
            boolean $i$f$debug4 = false;
            if ($this$debug_u24default$iv4.isDebugEnabled()) {
                logger = $this$debug_u24default$iv4;
                boolean bl8 = false;
                logger.debug("Start process destroy", t$iv4);
            }
            this.getProcess().destroy();
            $this$thisLogger$iv4 = this;
            $i$f$thisLogger = false;
            Logger logger7 = Logger.getInstance(JupyterManagedServerProcessHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger7, (String)"getInstance(...)");
            $this$debug_u24default$iv4 = logger7;
            t$iv = null;
            $i$f$debug4 = false;
            if ($this$debug_u24default$iv4.isDebugEnabled()) {
                logger = $this$debug_u24default$iv4;
                boolean bl9 = false;
                logger.debug("Finish process destroy", t$iv);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    protected void detachProcessImpl() {
        Object $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterManagedServerProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Detach process");
        if (SystemInfo.isUnix) {
            super.detachProcessImpl();
        } else {
            Runnable runnable = () -> JupyterManagedServerProcessHandler.detachProcessImpl$lambda$0(this);
            $this$thisLogger$iv = this.executeTask(runnable);
            Intrinsics.checkNotNull((Object)$this$thisLogger$iv);
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(JupyterManagedServerProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.debug("Process is detached");
    }

    private final void closeStreams() {
        block2: {
            try {
                this.myProcess.getOutputStream().close();
            }
            catch (IOException e) {
                if (!this.myProcess.isAlive()) break block2;
                JupyterManagedServerProcessHandler $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterManagedServerProcessHandler.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot close stdin of '" + this.getCommandLineForLog() + "'", (Throwable)e);
            }
        }
    }

    protected boolean destroyProcessGracefully() {
        return SystemInfo.isUnix ? false : super.destroyProcessGracefully();
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
        return options;
    }

    private final Object waitUntilServerReachable(URI uri, Continuation<? super Unit> $completion) {
        long timeout = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
        long finishPollingAt = TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), (long)timeout);
        String string = uri.getHost();
        if (string == null) {
            string = "127.0.0.1";
        }
        String host = string;
        int port = uri.getPort();
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(finishPollingAt, host, port, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ long $finishPollingAt;
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            {
                this.$finishPollingAt = $finishPollingAt;
                this.$host = $host;
                this.$port = $port;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 7 sources

                        while (TimeSource.Monotonic.ValueTimeMark.hasNotPassedNow-impl((long)this.$finishPollingAt) && CoroutineScopeKt.isActive((CoroutineScope)$this$loop)) {
                            socket = new Socket();
                            v0 = JupyterManagedServerProcessHandlerKt.access$timeRemainsMillis((TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)this.$finishPollingAt));
                            if (v0 == null) ** GOTO lbl14
                            v1 = v0;
                            ** GOTO lbl29
lbl14:
                            // 1 sources

                            var6_10 = Unit.INSTANCE;
                            var7_19 = $this$loop;
                            try {
                                $this$invokeSuspend_u24lambda_u240 = var7_19;
                                $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1 = false;
                                socket.close();
                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1) {
                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1));
                            }
                            return var6_10;
lbl29:
                            // 2 sources

                            remaining = v1;
                            if (remaining > 0) ** GOTO lbl46
                            var5_9 = Unit.INSTANCE;
                            var6_11 = $this$loop;
                            try {
                                $this$invokeSuspend_u24lambda_u240 = var6_11;
                                $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1 = false;
                                socket.close();
                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1) {
                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1));
                            }
                            return var5_9;
lbl46:
                            // 2 sources

                            socket.setSoLinger(true, 0);
                            socket.setSoTimeout(remaining);
                            socket.connect(new InetSocketAddress(this.$host, this.$port), remaining);
                            Intrinsics.checkNotNullExpressionValue((Object)socket.getOutputStream(), (String)"getOutputStream(...)");
                            $this$invokeSuspend_u24lambda_u240 = Charsets.UTF_8;
                            writer = new OutputStreamWriter(var6_12, (Charset)$this$invokeSuspend_u24lambda_u240);
                            writer.write("HEAD /api/status HTTP/1.1\r\nHost: " + this.$host + ":" + this.$port + "\r\nConnection: close\r\n\r\n");
                            writer.flush();
                            if (socket.getInputStream().read() == -1) ** GOTO lbl69
                            var6_12 = Unit.INSTANCE;
                            $this$invokeSuspend_u24lambda_u240 = $this$loop;
                            try {
                                $this$invokeSuspend_u24lambda_u240 = $this$invokeSuspend_u24lambda_u240;
                                $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1 = false;
                                socket.close();
                                var8_26 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable var9_31) {
                                var8_27 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var9_31));
                            }
                            return var6_12;
lbl69:
                            // 1 sources

                            remaining = $this$loop;
                            try {
                                $this$invokeSuspend_u24lambda_u240 = remaining;
                                $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1 = false;
                                socket.close();
                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1) {
                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1));
                            }
                            continue;
                            catch (Exception e) {
                                $this$thisLogger$iv = $this$loop;
                                $i$f$thisLogger = false;
                                v2 = Logger.getInstance(CoroutineScope.class);
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                                v2.debug("Jupyter reachability check failed (Host: " + this.$host + ":" + this.$port + "), retrying... " + e.getMessage());
                                this.L$0 = $this$loop;
                                this.L$1 = socket;
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                                this.label = 1;
                                v3 = YieldKt.yield((Continuation)((Continuation)this));
                                ** if (v3 != var10_3) goto lbl96
lbl95:
                                // 1 sources

                                return var10_3;
lbl96:
                                // 1 sources

                                ** GOTO lbl105
                            }
                        }
                        break;
                    }
                    case 1: {
                        e = (Exception)this.L$2;
                        socket = (Socket)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl105:
                        // 2 sources

                        this.L$0 = $this$loop;
                        this.L$1 = socket;
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                        this.label = 2;
                        v4 = DelayKt.delay((long)500L, (Continuation)((Continuation)this));
                        if (v4 != var10_3) ** GOTO lbl6
                        return var10_3;
                    }
                    case 2: {
                        e = (Exception)this.L$2;
                        socket = (Socket)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        ** GOTO lbl6
                        {
                            catch (Throwable var4_8) {
                                throw var4_8;
                            }
                        }
                        finally {
                            var4_5 = $this$loop;
                            try {
                                $this$invokeSuspend_u24lambda_u240 = var4_5;
                                $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1 = false;
                                socket.close();
                                var5_9 = Result.constructor-impl((Object)Unit.INSTANCE);
                                ** GOTO lbl6
                            }
                            catch (Throwable $i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1) {
                                var5_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JupyterManagedServerProcessHandler$waitUntilServerReachable$2$1));
                            }
                            ** GOTO lbl6
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void detachProcessImpl$lambda$0(JupyterManagedServerProcessHandler this$0) {
        this$0.closeStreams();
        this$0.myWaitFor.detach();
        this$0.notifyProcessDetached();
    }

    public static final /* synthetic */ void access$initJupyterServer(JupyterManagedServerProcessHandler $this) {
        $this.initJupyterServer();
    }

    public static final /* synthetic */ Object access$waitUntilServerReachable(JupyterManagedServerProcessHandler $this, URI uri, Continuation $completion) {
        return $this.waitUntilServerReachable(uri, (Continuation<? super Unit>)$completion);
    }

    static {
        Pattern pattern = Pattern.compile("(?<protocol>\\w+)://((?<host>[-.a-zA-Z0-9]+)|(\\([-.a-zA-Z0-9]+ or (?<localhost>[-.a-zA-Z0-9]+)\\))):(?<port>\\d*)(/(?<path>([a-zA-Z0-9.\\-_~!$&'()*+,;=:@%/])*)(\\?token=((?<token>\\w+)|\\.\\.\\.))?)?$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        NOTEBOOK_CONNECTION_PATTERN = pattern;
        SERVER_PATH_PATTERN = new Regex("Serving notebooks from local directory: (.*)$");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler$Companion;", "", "<init>", "()V", "NOTEBOOK_CONNECTION_PATTERN", "Ljava/util/regex/Pattern;", "SERVER_PATH_PATTERN", "Lkotlin/text/Regex;", "getSERVER_PATH_PATTERN", "()Lkotlin/text/Regex;", "findConnectionPattern", "Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler$ConnectionPatternMatchResult;", "input", "", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterManagedServerProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterManagedServerProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n1#2:400\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSERVER_PATH_PATTERN() {
            return SERVER_PATH_PATTERN;
        }

        @Nullable
        public final ConnectionPatternMatchResult findConnectionPattern(@NotNull CharSequence input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (!URLUtil.canContainUrl((String)((Object)input).toString())) {
                return null;
            }
            Matcher matcher = NOTEBOOK_CONNECTION_PATTERN.matcher(input);
            if (matcher.find()) {
                Object object;
                String string = matcher.group("protocol");
                if (string == null) {
                    return null;
                }
                String protocol = string;
                String string2 = matcher.group("host");
                if (string2 == null && (string2 = matcher.group("localhost")) == null) {
                    return null;
                }
                String host = string2;
                Object object2 = matcher.group("port");
                int port = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : -1;
                String token = matcher.group("token");
                Object object3 = this;
                try {
                    Companion $this$findConnectionPattern_u24lambda_u240 = object3;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)matcher.group("path"));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object3 = object;
                String string3 = (String)(Result.isFailure-impl((Object)object3) ? null : object3);
                String path = string3 != null ? StringsKt.removeSuffix((String)string3, (CharSequence)"/") : null;
                return new ConnectionPatternMatchResult(protocol, host, port, token, path);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JA\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u0006H\u00d6\u0081\u0004J\n\u0010\u001c\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler$ConnectionPatternMatchResult;", "", "protocol", "", "host", "port", "", "token", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getProtocol", "()Ljava/lang/String;", "getHost", "getPort", "()I", "getToken", "getPath", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.jupyter.core"})
    public static final class ConnectionPatternMatchResult {
        @NotNull
        private final String protocol;
        @Nullable
        private final String host;
        private final int port;
        @Nullable
        private final String token;
        @Nullable
        private final String path;

        public ConnectionPatternMatchResult(@NotNull String protocol, @Nullable String host, int port, @Nullable String token, @Nullable String path) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.token = token;
            this.path = path;
        }

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        @Nullable
        public final String getHost() {
            return this.host;
        }

        public final int getPort() {
            return this.port;
        }

        @Nullable
        public final String getToken() {
            return this.token;
        }

        @Nullable
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String component1() {
            return this.protocol;
        }

        @Nullable
        public final String component2() {
            return this.host;
        }

        public final int component3() {
            return this.port;
        }

        @Nullable
        public final String component4() {
            return this.token;
        }

        @Nullable
        public final String component5() {
            return this.path;
        }

        @NotNull
        public final ConnectionPatternMatchResult copy(@NotNull String protocol, @Nullable String host, int port, @Nullable String token, @Nullable String path) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            return new ConnectionPatternMatchResult(protocol, host, port, token, path);
        }

        public static /* synthetic */ ConnectionPatternMatchResult copy$default(ConnectionPatternMatchResult connectionPatternMatchResult, String string, String string2, int n, String string3, String string4, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = connectionPatternMatchResult.protocol;
            }
            if ((n2 & 2) != 0) {
                string2 = connectionPatternMatchResult.host;
            }
            if ((n2 & 4) != 0) {
                n = connectionPatternMatchResult.port;
            }
            if ((n2 & 8) != 0) {
                string3 = connectionPatternMatchResult.token;
            }
            if ((n2 & 0x10) != 0) {
                string4 = connectionPatternMatchResult.path;
            }
            return connectionPatternMatchResult.copy(string, string2, n, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ConnectionPatternMatchResult(protocol=" + this.protocol + ", host=" + this.host + ", port=" + this.port + ", token=" + this.token + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result2 = this.protocol.hashCode();
            result2 = result2 * 31 + (this.host == null ? 0 : this.host.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.port);
            result2 = result2 * 31 + (this.token == null ? 0 : this.token.hashCode());
            result2 = result2 * 31 + (this.path == null ? 0 : this.path.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionPatternMatchResult)) {
                return false;
            }
            ConnectionPatternMatchResult connectionPatternMatchResult = (ConnectionPatternMatchResult)other;
            if (!Intrinsics.areEqual((Object)this.protocol, (Object)connectionPatternMatchResult.protocol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.host, (Object)connectionPatternMatchResult.host)) {
                return false;
            }
            if (this.port != connectionPatternMatchResult.port) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.token, (Object)connectionPatternMatchResult.token)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)connectionPatternMatchResult.path);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler$JupyterProcessListener;", "Lcom/intellij/execution/process/ProcessListener;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "getPortForwardedUrl", "Ljava/net/URI;", "targetUri", "prepareUrl", "match", "Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler$ConnectionPatternMatchResult;", "processWillTerminate", "willBeDestroyed", "", "processTerminated", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterManagedServerProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterManagedServerProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler$JupyterProcessListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,399:1\n23#2:400\n23#2:401\n23#2:402\n*S KotlinDebug\n*F\n+ 1 JupyterManagedServerProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler$JupyterProcessListener\n*L\n179#1:400\n207#1:401\n212#1:402\n*E\n"})
    private final class JupyterProcessListener
    implements ProcessListener {
        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            if (!Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) {
                return;
            }
            StringBuilder stringBuilder = JupyterManagedServerProcessHandler.this.stderrData;
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            JupyterManagedServerProcessHandlerKt.access$append(stringBuilder, string, JupyterManagedServerProcessHandler.this.STDERR_DATA_MAX_CAPACITY);
            if (JupyterManagedServerProcessHandler.this.getServerPath() == null) {
                Regex regex = Companion.getSERVER_PATH_PATTERN();
                String string2 = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string2, (int)0, (int)2, null);
                if (matchResult != null) {
                    MatchResult matchResult2 = matchResult;
                    JupyterManagedServerProcessHandler jupyterManagedServerProcessHandler = JupyterManagedServerProcessHandler.this;
                    MatchResult it = matchResult2;
                    boolean bl = false;
                    jupyterManagedServerProcessHandler.serverPath = (String)it.getGroupValues().get(1);
                }
            }
            if (JupyterManagedServerProcessHandler.this.getLocation() != null) {
                return;
            }
            String string3 = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            ConnectionPatternMatchResult connectionPatternMatchResult = Companion.findConnectionPattern(string3);
            if (connectionPatternMatchResult == null) {
                return;
            }
            ConnectionPatternMatchResult match = connectionPatternMatchResult;
            URI targetUri = this.prepareUrl(match);
            URI uRI = this.getPortForwardedUrl(targetUri);
            if (uRI == null) {
                uRI = targetUri;
            }
            URI forwardedUrl = uRI;
            JupyterManagedServerProcessHandler.this.location = forwardedUrl;
            JupyterManagedServerProcessHandler.this.token = match.getToken();
            JupyterManagedServerProcessHandler.this.serverInitLatch.countDown();
        }

        private final URI getPortForwardedUrl(URI targetUri) {
            try {
                Map.Entry entry;
                block4: {
                    for (Map.Entry entry2 : (Iterable)JupyterManagedServerProcessHandler.this.getTargetEnvironment().getTargetPortBindings().entrySet()) {
                        boolean bl = false;
                        TargetEnvironment.TargetPortBinding portBinding = (TargetEnvironment.TargetPortBinding)entry2.getKey();
                        ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)entry2.getValue();
                        entry2 = portBinding.getTarget() == targetUri.getPort() ? resolvedPortBinding : null;
                        if (entry2 == null) continue;
                        entry = entry2;
                        break block4;
                    }
                    entry = null;
                }
                if (entry == null) {
                    return null;
                }
                Map.Entry portBinding = entry;
                HostPort localEndpoint = portBinding.getLocalEndpoint();
                return new URIBuilder(targetUri).setHost(localEndpoint.getHost()).setPort(localEndpoint.getPort()).build();
            }
            catch (Throwable t) {
                JupyterProcessListener $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterProcessListener.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to get local port bindings", t);
                return null;
            }
        }

        private final URI prepareUrl(ConnectionPatternMatchResult match) {
            boolean isLocal = Intrinsics.areEqual((Object)match.getHost(), (Object)"localhost") || Intrinsics.areEqual((Object)match.getHost(), (Object)"127.0.0.1") || Intrinsics.areEqual((Object)match.getHost(), (Object)"0.0.0.0");
            String resolvedHost = isLocal ? "127.0.0.1" : match.getHost();
            URI originalPath = new URIBuilder().setScheme(match.getProtocol()).setHost(resolvedHost).setPort(match.getPort()).setPath(match.getPath()).build();
            Object[] objectArray = new String[]{"lab", "tree"};
            Set set = SetsKt.setOf((Object[])objectArray);
            Intrinsics.checkNotNull((Object)originalPath);
            URI clearPath = set.contains(CollectionsKt.last((List)JupyterHttpUtilsKt.getPathSegments((URI)originalPath))) ? JupyterHttpUtilsKt.dropLastPathSegment((URI)originalPath) : originalPath;
            Intrinsics.checkNotNull((Object)clearPath);
            return clearPath;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            JupyterProcessListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterProcessListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Process will be " + (willBeDestroyed ? "destroyed" : "terminated"));
            JupyterManagedServerProcessHandler.this.isDestroyedOnTerminate = willBeDestroyed;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            JupyterProcessListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterProcessListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Process terminated with exit code " + event.getExitCode());
            JupyterManagedServerProcessHandler.this.onServerTerminated.invoke();
            JupyterManagedServerProcessHandler.this.location = null;
            JupyterManagedServerProcessHandler.this.token = null;
            JupyterManagedServerProcessHandler.this.serverPath = null;
        }
    }
}

