/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.convert;

import com.intellij.jupyter.core.jupyter.convert.LaTexToPdf;
import com.intellij.jupyter.core.jupyter.convert.LaTexToPdfKt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u000b2\u0006\u0010\u0010\u001a\u00020\nH\u0002JK\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2%\b\u0002\u0010\u0014\u001a\u001f\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0015H\u0086@\u00a2\u0006\u0002\u0010\u001bJU\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u000b2%\b\u0002\u0010 \u001a\u001f\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0015H\u0086@\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010%\u001a\u00020\nH\u0002J \u0010&\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0016H\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0016H\u0002J.\u0010+\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u000bH\u0002J\u0010\u0010,\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J&\u0010-\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u000200H\u0086@\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/jupyter/core/jupyter/convert/LaTexToPdf;", "", "<init>", "()V", "LATEX_TIMEOUT_MS", "", "LATEX_FONT_SIZE", "", "extractLatexExpressions", "Lkotlin/Pair;", "", "", "Lcom/intellij/jupyter/core/jupyter/convert/LaTexToPdf$LatexExpression;", "text", "unescapeHtmlEntities", "extractTags", "latex", "restoreAndRenderLatex", "html", "expressions", "onImageEncoded", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "base64Length", "", "(Ljava/lang/String;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertLatexToSvg", "inline", "", "tags", "onSvgRendered", "svgLength", "(Ljava/lang/String;ZLjava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isSimpleFormula", "extractSvgDimensions", "svgContent", "cleanSvgForInlineHtml", "width", "height", "calculateTagPositions", "numTags", "addTagsToSvg", "convertToJLatexMathCompatible", "renderLatexToSvg", "fontSize", "foreground", "Ljava/awt/Color;", "(Ljava/lang/String;FLjava/awt/Color;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripLatexAltText", "LatexExpression", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nLaTexToPdf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaTexToPdf.kt\ncom/intellij/jupyter/core/jupyter/convert/LaTexToPdf\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,481:1\n1342#2,2:482\n1915#3,2:484\n1924#3,2:486\n1926#3:489\n1#4:488\n*S KotlinDebug\n*F\n+ 1 LaTexToPdf.kt\ncom/intellij/jupyter/core/jupyter/convert/LaTexToPdf\n*L\n115#1:482,2\n128#1:484,2\n336#1:486,2\n336#1:489\n*E\n"})
public final class LaTexToPdf {
    @NotNull
    public static final LaTexToPdf INSTANCE = new LaTexToPdf();
    public static final long LATEX_TIMEOUT_MS = 10000L;
    public static final float LATEX_FONT_SIZE = 15.0f;

    private LaTexToPdf() {
    }

    @NotNull
    public final Pair<String, List<LatexExpression>> extractLatexExpressions(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List expressions = new ArrayList();
        String result2 = text;
        Ref.IntRef placeholderIndex = new Ref.IntRef();
        CharSequence charSequence = result2;
        Regex regex = new Regex("\\\\begin\\{([^}]+)}(.+?)\\\\end\\{\\1}", RegexOption.DOT_MATCHES_ALL);
        Function1 function1 = arg_0 -> LaTexToPdf.extractLatexExpressions$lambda$0(placeholderIndex, expressions, arg_0);
        result2 = regex.replace(charSequence, function1);
        charSequence = result2;
        regex = new Regex("\\$\\$(.+?)\\$\\$", RegexOption.DOT_MATCHES_ALL);
        function1 = arg_0 -> LaTexToPdf.extractLatexExpressions$lambda$1(placeholderIndex, expressions, arg_0);
        result2 = regex.replace(charSequence, function1);
        charSequence = result2;
        regex = new Regex("\\$([^$]+?)\\$");
        function1 = arg_0 -> LaTexToPdf.extractLatexExpressions$lambda$2(placeholderIndex, expressions, arg_0);
        result2 = regex.replace(charSequence, function1);
        return new Pair((Object)result2, (Object)expressions);
    }

    private final String unescapeHtmlEntities(String text) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"&amp;", (String)"&", (boolean)false, (int)4, null), (String)"&lt;", (String)"<", (boolean)false, (int)4, null), (String)"&gt;", (String)">", (boolean)false, (int)4, null), (String)"&quot;", (String)"\"", (boolean)false, (int)4, null), (String)"&#39;", (String)"'", (boolean)false, (int)4, null), (String)"&nbsp;", (String)" ", (boolean)false, (int)4, null);
    }

    private final List<String> extractTags(String latex) {
        List tags = new ArrayList();
        Regex tagRegex = new Regex("\\\\tag\\{([^}]*)}");
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)tagRegex, (CharSequence)latex, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult match = (MatchResult)element$iv;
            boolean bl = false;
            tags.add(match.getGroupValues().get(1));
        }
        return tags;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object restoreAndRenderLatex(@NotNull String html, @NotNull List<LatexExpression> expressions, @Nullable Function1<? super Integer, Unit> onImageEncoded, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof restoreAndRenderLatex.1)) ** GOTO lbl-1000
        var14_5 = $completion;
        if ((var14_5.label & -2147483648) != 0) {
            var14_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ LaTexToPdf this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.restoreAndRenderLatex(null, null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = new Ref.ObjectRef();
                result.element = html;
                $this$forEach$iv = expressions;
                $i$f$forEach = 0;
                var8_11 = $this$forEach$iv.iterator();
lbl17:
                // 2 sources

                while (var8_11.hasNext()) {
                    element$iv = var8_11.next();
                    expr = (LatexExpression)element$iv;
                    $i$a$-forEach-LaTexToPdf$restoreAndRenderLatex$2 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)html);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)expressions);
                    $continuation.L$2 = onImageEncoded;
                    $continuation.L$3 = result;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                    $continuation.L$5 = var8_11;
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$7 = expr;
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = $i$a$-forEach-LaTexToPdf$restoreAndRenderLatex$2;
                    $continuation.label = 1;
                    v0 = LaTexToPdf.INSTANCE.convertLatexToSvg(expr.getLatex(), expr.getInline(), expr.getTags(), (Function1<? super Integer, Unit>)onImageEncoded, (Continuation<? super String>)$continuation);
                    if (v0 == var15_7) {
                        return var15_7;
                    }
                    ** GOTO lbl50
                }
                break;
            }
            case 1: {
                $i$a$-forEach-LaTexToPdf$restoreAndRenderLatex$2 = $continuation.I$1;
                $i$f$forEach = $continuation.I$0;
                expr = (LatexExpression)$continuation.L$7;
                element$iv = $continuation.L$6;
                var8_11 = (Iterator)$continuation.L$5;
                $this$forEach$iv = (Iterable)$continuation.L$4;
                result = (Ref.ObjectRef)$continuation.L$3;
                onImageEncoded = (Function1)$continuation.L$2;
                expressions = (List)$continuation.L$1;
                html = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl50:
                // 2 sources

                rendered = (String)v0;
                result.element = StringsKt.replace$default((String)((String)result.element), (String)expr.getPlaceholder(), (String)rendered, (boolean)false, (int)4, null);
                ** GOTO lbl17
            }
        }
        return result.element;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object restoreAndRenderLatex$default(LaTexToPdf laTexToPdf, String string, List list, Function1 function1, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return laTexToPdf.restoreAndRenderLatex(string, list, (Function1<? super Integer, Unit>)function1, (Continuation<? super String>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object convertLatexToSvg(@NotNull String latex, boolean inline, @NotNull List<String> tags, @Nullable Function1<? super Integer, Unit> onSvgRendered, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof convertLatexToSvg.1)) ** GOTO lbl-1000
        var24_6 = $completion;
        if ((var24_6.label & -2147483648) != 0) {
            var24_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ LaTexToPdf this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.convertLatexToSvg(null, false, null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var25_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                compatibleLatex = this.convertToJLatexMathCompatible(latex);
                foreground = Color.BLACK;
                Intrinsics.checkNotNull((Object)foreground);
                $continuation.L$0 = latex;
                $continuation.L$1 = tags;
                $continuation.L$2 = onSvgRendered;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)compatibleLatex);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)foreground);
                $continuation.Z$0 = inline;
                $continuation.label = 1;
                v0 = this.renderLatexToSvg(compatibleLatex, 15.0f, foreground, (Continuation<? super String>)$continuation);
                if (v0 == var25_8) {
                    return var25_8;
                }
                ** GOTO lbl35
            }
            case 1: {
                inline = $continuation.Z$0;
                foreground = (Color)$continuation.L$4;
                compatibleLatex = (String)$continuation.L$3;
                onSvgRendered = (Function1)$continuation.L$2;
                tags = (List)$continuation.L$1;
                latex = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                svgContent = (String)v0;
                v1 = onSvgRendered;
                if (v1 != null) {
                    v1.invoke((Object)Boxing.boxInt((int)svgContent.length()));
                }
                var9_14 = this.extractSvgDimensions(svgContent);
                baseWidth = ((Number)var9_14.component1()).intValue();
                baseHeight = ((Number)var9_14.component2()).intValue();
                if (((Collection)tags).isEmpty() == false) {
                    svgWithTags = this.addTagsToSvg(svgContent, baseWidth, baseHeight, tags);
                    expandedWidth = baseWidth + 60;
                    v2 = new Pair((Object)svgWithTags, (Object)Boxing.boxInt((int)expandedWidth));
                } else {
                    v2 = new Pair((Object)svgContent, (Object)Boxing.boxInt((int)baseWidth));
                }
                var12_19 = v2;
                finalSvg = (String)var12_19.component1();
                finalWidth = ((Number)var12_19.component2()).intValue();
                verticalAlign = inline ? (this.isSimpleFormula(latex) ? "-0.35em" : "-0.20em") : "unset";
                display = inline != false ? "inline-block" : "block";
                margin = inline != false ? "0" : "10px auto";
                cleanSvg = this.cleanSvgForInlineHtml(finalSvg, finalWidth, baseHeight);
                if (((Collection)tags).isEmpty() == false) {
                    var20_24 = cleanSvg;
                    var21_25 = new Regex("width=\"" + baseWidth + "\"");
                    var22_26 = "width=\"" + finalWidth + "\"";
                    v3 = var21_25.replace(var20_24, var22_26);
                } else {
                    v3 = cleanSvg;
                }
                finalCleanSvg = v3;
                return "<div style=\"width: " + finalWidth + "px; height: " + baseHeight + "px; vertical-align: " + verticalAlign + "; display: " + display + "; margin: " + margin + ";\">" + finalCleanSvg + "</div>";
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object convertLatexToSvg$default(LaTexToPdf laTexToPdf, String string, boolean bl, List list, Function1 function1, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        return laTexToPdf.convertLatexToSvg(string, bl, list, (Function1<? super Integer, Unit>)function1, (Continuation<? super String>)continuation);
    }

    private final boolean isSimpleFormula(String latex) {
        boolean hasSimpleMathFont = StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\mathbb{", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\mathcal{", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\mathfrak{", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\mathscr{", (boolean)false, (int)2, null);
        return hasSimpleMathFont && !StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\begin{", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\\\", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\sum", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\int", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)latex, (CharSequence)"\\frac", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)latex, (CharSequence)"_", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)latex, (CharSequence)"^", (boolean)false, (int)2, null);
    }

    private final Pair<Integer, Integer> extractSvgDimensions(String svgContent) {
        MatchResult widthMatch = Regex.find$default((Regex)new Regex("width=\"(\\d+(?:\\.\\d+)?)\"[^>]*"), (CharSequence)svgContent, (int)0, (int)2, null);
        MatchResult heightMatch = Regex.find$default((Regex)new Regex("height=\"(\\d+(?:\\.\\d+)?)\"[^>]*"), (CharSequence)svgContent, (int)0, (int)2, null);
        Object object = widthMatch;
        int width = object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? (int)((Double)object).doubleValue() : 100;
        Object object2 = heightMatch;
        int height = object2 != null && (object2 = object2.getGroupValues()) != null && (object2 = (String)object2.get(1)) != null && (object2 = StringsKt.toDoubleOrNull((String)object2)) != null ? (int)((Double)object2).doubleValue() : 50;
        return TuplesKt.to((Object)width, (Object)height);
    }

    private final String cleanSvgForInlineHtml(String svgContent, int width, int height) {
        String cleaned = svgContent;
        CharSequence charSequence = cleaned;
        Regex regex = new Regex("<\\?xml[^>]*\\?>\\s*");
        String string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("<!DOCTYPE\\s+[^>]+>\\s*", RegexOption.DOT_MATCHES_ALL);
        string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("<defs>\\s*</defs>");
        string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("<defs/?>");
        string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("\\s*xmlns:xlink=\"[^\"]*\"");
        string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("\\s*fill-opacity:1;?");
        string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("\\s*stroke-opacity:1;?");
        string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("\\s*stroke:none;?");
        string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("\\s+style=\"\\s*\"");
        string = "";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("\\s+style=\";\\s*\"");
        string = "";
        cleaned = regex.replace(charSequence, string);
        cleaned = StringsKt.replace$default((String)cleaned, (String)"rgb(0,0,0)", (String)"#000", (boolean)false, (int)4, null);
        cleaned = StringsKt.replace$default((String)cleaned, (String)"rgb(255,255,255)", (String)"#fff", (boolean)false, (int)4, null);
        charSequence = cleaned;
        regex = new Regex("\\s+");
        string = " ";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex(">\\s+<");
        string = "><";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("\\s+/>");
        string = "/>";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("<\\s+");
        string = "<";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex("\\s+>");
        string = ">";
        cleaned = regex.replace(charSequence, string);
        if (!StringsKt.contains$default((CharSequence)(cleaned = ((Object)StringsKt.trim((CharSequence)cleaned)).toString()), (CharSequence)"xmlns=", (boolean)false, (int)2, null)) {
            cleaned = StringsKt.replace$default((String)cleaned, (String)"<svg", (String)"<svg xmlns=\"http://www.w3.org/2000/svg\"", (boolean)false, (int)4, null);
        }
        if (!StringsKt.contains$default((CharSequence)cleaned, (CharSequence)"width=", (boolean)false, (int)2, null)) {
            cleaned = StringsKt.replace$default((String)cleaned, (String)"<svg", (String)("<svg width=\"" + width + "\""), (boolean)false, (int)4, null);
        }
        if (!StringsKt.contains$default((CharSequence)cleaned, (CharSequence)"height=", (boolean)false, (int)2, null)) {
            cleaned = StringsKt.replace$default((String)cleaned, (String)"<svg", (String)("<svg height=\"" + height + "\""), (boolean)false, (int)4, null);
        }
        return cleaned;
    }

    private final List<Integer> calculateTagPositions(int height, int numTags) {
        if (numTags == 0) {
            return CollectionsKt.emptyList();
        }
        if (numTags == 1) {
            return CollectionsKt.listOf((Object)(height / 2));
        }
        List positions = new ArrayList();
        double spacing = (double)height / (double)(numTags + 1);
        int i = 1;
        if (i <= numTags) {
            while (true) {
                positions.add((int)(spacing * (double)i));
                if (i == numTags) break;
                ++i;
            }
        }
        return positions;
    }

    /*
     * WARNING - void declaration
     */
    private final String addTagsToSvg(String svgContent, int width, int height, List<String> tags) {
        if (tags.isEmpty()) {
            return svgContent;
        }
        List<Integer> positions = this.calculateTagPositions(height, tags.size());
        StringBuilder tagElements = new StringBuilder();
        Iterable $this$forEachIndexed$iv = tags;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void tag;
            Integer n;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n2;
            boolean bl = false;
            List<Integer> list = positions;
            boolean bl2 = 0 <= index ? index < list.size() : false;
            if (bl2) {
                n = list.get(index);
            } else {
                int it = index;
                boolean bl3 = false;
                n = height / 2;
            }
            int yPos = ((Number)n).intValue();
            tagElements.append("<text x=\"" + (width + 10) + "\" y=\"" + yPos + "\" font-size=\"14\" font-family=\"Times New Roman, serif\" font-weight=\"400\" stroke=\"none\" fill=\"black\" text-anchor=\"start\" dominant-baseline=\"middle\">(" + (String)tag + ")</text>");
        }
        Regex closingSvgRegex = new Regex("</svg\\s*>");
        MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)closingSvgRegex, (CharSequence)svgContent, (int)0, (int)2, null));
        if (matchResult == null) {
            return svgContent;
        }
        MatchResult match = matchResult;
        int closingSvgIndex = match.getRange().getFirst();
        String closingTag = match.getValue();
        String string = svgContent.substring(0, closingSvgIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string + tagElements + closingTag;
    }

    private final String convertToJLatexMathCompatible(String latex) {
        String result2 = latex;
        CharSequence charSequence = result2;
        Regex regex = new Regex("\\\\begin\\{align\\*?}(.+?)\\\\end\\{align\\*?}", RegexOption.DOT_MATCHES_ALL);
        Function1 function1 = LaTexToPdf::convertToJLatexMathCompatible$lambda$0;
        result2 = regex.replace(charSequence, function1);
        charSequence = result2;
        regex = new Regex("\\\\begin\\{equation\\*?}(.+?)\\\\end\\{equation\\*?}", RegexOption.DOT_MATCHES_ALL);
        function1 = LaTexToPdf::convertToJLatexMathCompatible$lambda$1;
        result2 = regex.replace(charSequence, function1);
        charSequence = result2;
        regex = new Regex("\\\\begin\\{cases}(.+?)\\\\end\\{cases}", RegexOption.DOT_MATCHES_ALL);
        function1 = LaTexToPdf::convertToJLatexMathCompatible$lambda$2;
        result2 = regex.replace(charSequence, function1);
        return result2;
    }

    @Nullable
    public final Object renderLatexToSvg(@NotNull String latex, float fontSize, @NotNull Color foreground, @NotNull Continuation<? super String> $completion) {
        long timeoutMs = RangesKt.coerceAtLeast((long)10000L, (long)1L);
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(timeoutMs, latex, fontSize, foreground, null){
            int label;
            final /* synthetic */ long $timeoutMs;
            final /* synthetic */ String $latex;
            final /* synthetic */ float $fontSize;
            final /* synthetic */ Color $foreground;
            {
                this.$timeoutMs = $timeoutMs;
                this.$latex = $latex;
                this.$fontSize = $fontSize;
                this.$foreground = $foreground;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeout((long)this.$timeoutMs, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this.$latex, this.$fontSize, this.$foreground, null){
                            int label;
                            final /* synthetic */ String $latex;
                            final /* synthetic */ float $fontSize;
                            final /* synthetic */ Color $foreground;
                            {
                                this.$latex = $latex;
                                this.$fontSize = $fontSize;
                                this.$foreground = $foreground;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (StringsKt.isBlank((CharSequence)this.$latex)) {
                                            LaTexToPdfKt.access$getLog$p().warn("Empty LaTeX expression provided");
                                        }
                                        TeXFormula formula = new TeXFormula(this.$latex);
                                        TeXIcon teXIcon = formula.createTeXIcon(0, this.$fontSize);
                                        Color color = this.$foreground;
                                        TeXIcon $this$invokeSuspend_u24lambda_u240 = teXIcon;
                                        boolean bl = false;
                                        $this$invokeSuspend_u24lambda_u240.setForeground(color);
                                        TeXIcon icon = teXIcon;
                                        int w = RangesKt.coerceAtLeast((int)icon.getIconWidth(), (int)1);
                                        int h = RangesKt.coerceAtLeast((int)icon.getIconHeight(), (int)1);
                                        if (icon.getIconWidth() == 0 || icon.getIconHeight() == 0) {
                                            LaTexToPdfKt.access$getLog$p().warn("LaTeX formula rendered with zero dimensions: width=" + icon.getIconWidth() + ", height=" + icon.getIconHeight() + ", fontSize=" + this.$fontSize + ", latex='" + this.$latex + "'");
                                        }
                                        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                                        String svgNS = "http://www.w3.org/2000/svg";
                                        Document document = domImpl.createDocument(svgNS, "svg", null);
                                        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
                                        boolean fontAsShapes = true;
                                        SVGGraphics2D g2 = new SVGGraphics2D(ctx, fontAsShapes);
                                        g2.setSVGCanvasSize(new Dimension(w, h));
                                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                                        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                                        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                                        g2.setColor(this.$foreground);
                                        g2.setPaint((Paint)this.$foreground);
                                        g2.setBackground(Color.WHITE);
                                        icon.paintIcon(null, (Graphics)g2, 0, 0);
                                        StringWriter writer = new StringWriter();
                                        boolean useCSS = false;
                                        g2.stream((Writer)writer, useCSS);
                                        String string = writer.toString();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                        String svgOutput = string;
                                        return LaTexToPdf.access$cleanSvgForInlineHtml(LaTexToPdf.INSTANCE, svgOutput, w, h);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final String stripLatexAltText(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Object[] objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        Regex re = new Regex("(<img[^>]*alt=\")LaTeX:[^\"]*(\"[^>]*>)", SetsKt.setOf((Object[])objectArray));
        return re.replace((CharSequence)html, LaTexToPdf::stripLatexAltText$lambda$0);
    }

    private static final CharSequence extractLatexExpressions$lambda$0(Ref.IntRef $placeholderIndex, List $expressions, MatchResult match) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String envName = (String)match.getGroupValues().get(1);
        if (StringsKt.endsWith((String)envName, (String)"matrix", (boolean)true) || StringsKt.equals((String)envName, (String)"cases", (boolean)true)) {
            charSequence = match.getValue();
        } else {
            String content = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(2)))).toString();
            String latex = INSTANCE.unescapeHtmlEntities("\\begin{" + envName + "}" + content + "\\end{" + envName + "}");
            List<String> tags = INSTANCE.extractTags(latex);
            String placeholder = "<span class=\"latex-placeholder\" data-id=\"" + $placeholderIndex.element + "\"></span>";
            $expressions.add(new LatexExpression(placeholder, latex, false, tags));
            int n = $placeholderIndex.element;
            $placeholderIndex.element = n + 1;
            charSequence = placeholder;
        }
        return charSequence;
    }

    private static final CharSequence extractLatexExpressions$lambda$1(Ref.IntRef $placeholderIndex, List $expressions, MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String latex = INSTANCE.unescapeHtmlEntities(((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString());
        List<String> tags = INSTANCE.extractTags(latex);
        String placeholder = "<span class=\"latex-placeholder\" data-id=\"" + $placeholderIndex.element + "\"></span>";
        $expressions.add(new LatexExpression(placeholder, latex, false, tags));
        int n = $placeholderIndex.element;
        $placeholderIndex.element = n + 1;
        return placeholder;
    }

    private static final CharSequence extractLatexExpressions$lambda$2(Ref.IntRef $placeholderIndex, List $expressions, MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String latex = INSTANCE.unescapeHtmlEntities(((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString());
        String placeholder = "<span class=\"latex-placeholder\" data-id=\"" + $placeholderIndex.element + "\"></span>";
        $expressions.add(new LatexExpression(placeholder, latex, true, null, 8, null));
        int n = $placeholderIndex.element;
        $placeholderIndex.element = n + 1;
        return placeholder;
    }

    private static final CharSequence convertToJLatexMathCompatible$lambda$0(MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String content = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString();
        CharSequence charSequence = content;
        Regex regex = new Regex("\\\\tag\\{[^}]*}");
        String string = "";
        String contentWithoutTags = regex.replace(charSequence, string);
        return "\\begin{array}{r@{\\quad}l}" + contentWithoutTags + "\\end{array}";
    }

    private static final CharSequence convertToJLatexMathCompatible$lambda$1(MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String content = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString();
        CharSequence charSequence = content;
        Regex regex = new Regex("\\\\tag\\{[^}]*}");
        String string = "";
        String contentWithoutTags = regex.replace(charSequence, string);
        return contentWithoutTags;
    }

    private static final CharSequence convertToJLatexMathCompatible$lambda$2(MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String content = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString();
        return "\\left\\{\\begin{array}{l@{\\quad}l}" + content + "\\end{array}\\right.";
    }

    private static final CharSequence stripLatexAltText$lambda$0(MatchResult m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return "" + m.getGroupValues().get(1) + m.getGroupValues().get(2);
    }

    public static final /* synthetic */ String access$cleanSvgForInlineHtml(LaTexToPdf $this, String svgContent, int width, int height) {
        return $this.cleanSvgForInlineHtml(svgContent, width, height);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/jupyter/convert/LaTexToPdf$LatexExpression;", "", "placeholder", "", "latex", "inline", "", "tags", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLjava/util/List;)V", "getPlaceholder", "()Ljava/lang/String;", "getLatex", "getInline", "()Z", "getTags", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.jupyter.core"})
    public static final class LatexExpression {
        @NotNull
        private final String placeholder;
        @NotNull
        private final String latex;
        private final boolean inline;
        @NotNull
        private final List<String> tags;

        public LatexExpression(@NotNull String placeholder, @NotNull String latex, boolean inline, @NotNull List<String> tags) {
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            Intrinsics.checkNotNullParameter((Object)latex, (String)"latex");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            this.placeholder = placeholder;
            this.latex = latex;
            this.inline = inline;
            this.tags = tags;
        }

        public /* synthetic */ LatexExpression(String string, String string2, boolean bl, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, string2, bl, list);
        }

        @NotNull
        public final String getPlaceholder() {
            return this.placeholder;
        }

        @NotNull
        public final String getLatex() {
            return this.latex;
        }

        public final boolean getInline() {
            return this.inline;
        }

        @NotNull
        public final List<String> getTags() {
            return this.tags;
        }

        @NotNull
        public final String component1() {
            return this.placeholder;
        }

        @NotNull
        public final String component2() {
            return this.latex;
        }

        public final boolean component3() {
            return this.inline;
        }

        @NotNull
        public final List<String> component4() {
            return this.tags;
        }

        @NotNull
        public final LatexExpression copy(@NotNull String placeholder, @NotNull String latex, boolean inline, @NotNull List<String> tags) {
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            Intrinsics.checkNotNullParameter((Object)latex, (String)"latex");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            return new LatexExpression(placeholder, latex, inline, tags);
        }

        public static /* synthetic */ LatexExpression copy$default(LatexExpression latexExpression, String string, String string2, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = latexExpression.placeholder;
            }
            if ((n & 2) != 0) {
                string2 = latexExpression.latex;
            }
            if ((n & 4) != 0) {
                bl = latexExpression.inline;
            }
            if ((n & 8) != 0) {
                list = latexExpression.tags;
            }
            return latexExpression.copy(string, string2, bl, list);
        }

        @NotNull
        public String toString() {
            return "LatexExpression(placeholder=" + this.placeholder + ", latex=" + this.latex + ", inline=" + this.inline + ", tags=" + this.tags + ")";
        }

        public int hashCode() {
            int result2 = this.placeholder.hashCode();
            result2 = result2 * 31 + this.latex.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.inline);
            result2 = result2 * 31 + ((Object)this.tags).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LatexExpression)) {
                return false;
            }
            LatexExpression latexExpression = (LatexExpression)other;
            if (!Intrinsics.areEqual((Object)this.placeholder, (Object)latexExpression.placeholder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.latex, (Object)latexExpression.latex)) {
                return false;
            }
            if (this.inline != latexExpression.inline) {
                return false;
            }
            return Intrinsics.areEqual(this.tags, latexExpression.tags);
        }
    }
}

