/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.convert;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"log", "Lcom/intellij/openapi/diagnostic/Logger;", "isVegaVisualization", "", "html", "", "extractVegaLiteSpec", "convertVegaHtmlToSvg", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nVegaSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VegaSupport.kt\ncom/intellij/jupyter/core/jupyter/convert/VegaSupportKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,85:1\n57#2:86\n35#2,2:87\n*S KotlinDebug\n*F\n+ 1 VegaSupport.kt\ncom/intellij/jupyter/core/jupyter/convert/VegaSupportKt\n*L\n5#1:86\n5#1:87,2\n*E\n"})
public final class VegaSupportKt {
    @NotNull
    private static final Logger log;

    public static final boolean isVegaVisualization(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        return StringsKt.contains$default((CharSequence)html, (CharSequence)"vegaEmbed", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"vega-lite", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"altair-viz-", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final String extractVegaLiteSpec(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        try {
            Regex vegaEmbedPattern = new Regex("vegaEmbed\\s*\\([^,]+,\\s*(\\{[\\s\\S]*?})\\s*,\\s*\\{[^}]*}\\s*\\)", RegexOption.MULTILINE);
            MatchResult match = Regex.find$default((Regex)vegaEmbedPattern, (CharSequence)html, (int)0, (int)2, null);
            if (match != null) {
                String spec = (String)match.getGroupValues().get(1);
                log.debug("Extracted Vega-Lite spec (" + spec.length() + " chars)");
                return spec;
            }
            Regex functionPattern = new Regex("\\(function\\s*\\([^)]+\\)\\s*\\{[\\s\\S]*?}\\)\\s*\\((\\{[\\s\\S]*?})\\s*,\\s*\\{[^}]*}\\s*\\)", RegexOption.MULTILINE);
            MatchResult functionMatch = Regex.find$default((Regex)functionPattern, (CharSequence)html, (int)0, (int)2, null);
            if (functionMatch != null) {
                String spec = (String)functionMatch.getGroupValues().get(1);
                log.debug("Extracted Vega-Lite spec from function call (" + spec.length() + " chars)");
                return spec;
            }
            log.warn("Could not extract Vega-Lite spec from HTML");
            return null;
        }
        catch (Exception e) {
            log.warn("Failed to extract Vega-Lite spec: " + e.getMessage());
            return null;
        }
    }

    @Nullable
    public static final String convertVegaHtmlToSvg(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        if (!VegaSupportKt.isVegaVisualization(html)) {
            return null;
        }
        String string = VegaSupportKt.extractVegaLiteSpec(html);
        if (string == null) {
            return null;
        }
        String spec = string;
        return null;
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

