/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterBrowserOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.core.jupyter.nbformat.outputs.JupyterDisplayDataOutput;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.notebooks.visualization.ui.EditorCellOutput;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/JupyterSvgOutputUtils;", "", "<init>", "()V", "resolveSelectedDisplayOutput", "Lcom/intellij/jupyter/core/jupyter/nbformat/outputs/JupyterDisplayDataOutput;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getSelectedSvgAsText", "", "intellij.jupyter.core"})
public final class JupyterSvgOutputUtils {
    @NotNull
    public static final JupyterSvgOutputUtils INSTANCE = new JupyterSvgOutputUtils();

    private JupyterSvgOutputUtils() {
    }

    @Nullable
    public final JupyterDisplayDataOutput resolveSelectedDisplayOutput(@NotNull AnActionEvent event, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EditorCellOutput editorCellOutput = (EditorCellOutput)event.getData(NotebookDataContext.INSTANCE.getNOTEBOOK_CELL_OUTPUT_DATA_KEY());
        NotebookOutputDataKey notebookOutputDataKey = editorCellOutput != null ? editorCellOutput.getDataKey() : null;
        JupyterBrowserOutputDataKey jupyterBrowserOutputDataKey = notebookOutputDataKey instanceof JupyterBrowserOutputDataKey ? (JupyterBrowserOutputDataKey)notebookOutputDataKey : null;
        if (jupyterBrowserOutputDataKey == null) {
            return null;
        }
        JupyterBrowserOutputDataKey outputKey = jupyterBrowserOutputDataKey;
        Object object = outputKey.getInfo();
        JupyterWebOutputInfo.Output output = object instanceof JupyterWebOutputInfo.Output ? (JupyterWebOutputInfo.Output)object : null;
        if (output == null) {
            return null;
        }
        JupyterWebOutputInfo.Output info = output;
        Object object2 = file.getNotebook().getCell(info.getCellIndex()).getOutputs();
        if (object2 == null || (object2 = object2.getOutputs()) == null) {
            return null;
        }
        Object outputs = object2;
        object = CollectionsKt.getOrNull((List)outputs, (int)info.getOutputIndex());
        return object instanceof JupyterDisplayDataOutput ? (JupyterDisplayDataOutput)object : null;
    }

    @Nullable
    public final String getSelectedSvgAsText(@NotNull AnActionEvent event, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JupyterDisplayDataOutput jupyterDisplayDataOutput = this.resolveSelectedDisplayOutput(event, file);
        if (jupyterDisplayDataOutput == null) {
            return null;
        }
        JupyterDisplayDataOutput output = jupyterDisplayDataOutput;
        return output.getData().getAsString(MimeType.IMAGE_SVG.getMimeType());
    }
}

