/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.controllers.below.tags;

import com.intellij.jupyter.core.editor.utils.JupyterEditorCellExtensionsKt;
import com.intellij.jupyter.core.jupyter.editor.controllers.below.tags.NotebookCellTagLabel;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.metadata.JupyterTag;
import com.intellij.jupyter.core.jupyter.nbformat.tags.JupyterTagsEventListener;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBBox;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/controllers/below/tags/NotebookCellTagsPanelController;", "Lcom/intellij/openapi/Disposable$Default;", "editorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "getEditorCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "component", "Lcom/intellij/ui/components/JBBox;", "getComponent", "()Lcom/intellij/ui/components/JBBox;", "tagsSpacing", "", "cellTags", "", "Lcom/intellij/jupyter/core/jupyter/nbformat/metadata/JupyterTag;", "getCellTags", "()Ljava/util/List;", "updateTags", "", "createAddTagButton", "Ljavax/swing/JComponent;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCellTagsPanelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellTagsPanelController.kt\ncom/intellij/jupyter/core/jupyter/editor/controllers/below/tags/NotebookCellTagsPanelController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1915#2,2:72\n*S KotlinDebug\n*F\n+ 1 NotebookCellTagsPanelController.kt\ncom/intellij/jupyter/core/jupyter/editor/controllers/below/tags/NotebookCellTagsPanelController\n*L\n53#1:72,2\n*E\n"})
public final class NotebookCellTagsPanelController
implements Disposable.Default {
    @NotNull
    private final EditorCell editorCell;
    @NotNull
    private final JBBox component;
    private final int tagsSpacing;

    public NotebookCellTagsPanelController(@NotNull EditorCell editorCell) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editorCell, (String)"editorCell");
            this.editorCell = editorCell;
            this.component = new JBBox(0);
            this.tagsSpacing = JBUI.scale((int)6);
            this.updateTags();
            EventDispatcher<JupyterTagsEventListener> eventDispatcher = JupyterEditorCellExtensionsKt.getJupyterNotebook(this.editorCell);
            if (eventDispatcher == null || (eventDispatcher = eventDispatcher.getListeners()) == null || (eventDispatcher = eventDispatcher.getTagsListeners()) == null) break block0;
            eventDispatcher.addListener((EventListener)new JupyterTagsEventListener(){

                @Override
                public void tagsUpdated(NotebookIntervalPointer intervalPointer) {
                    Intrinsics.checkNotNullParameter((Object)intervalPointer, (String)"intervalPointer");
                    NotebookCellLines.Interval interval = this.getEditorCell().getIntervalPointer().get();
                    NotebookCellLines.Interval interval2 = intervalPointer.get();
                    if (Intrinsics.areEqual((Object)(interval != null ? Integer.valueOf(interval.getOrdinal()) : null), (Object)(interval2 != null ? Integer.valueOf(interval2.getOrdinal()) : null))) {
                        this.updateTags();
                    }
                }
            }, (Disposable)this);
        }
    }

    @NotNull
    public final EditorCell getEditorCell() {
        return this.editorCell;
    }

    @NotNull
    public final JBBox getComponent() {
        return this.component;
    }

    private final List<JupyterTag> getCellTags() {
        Object object = JupyterEditorCellExtensionsKt.getJupyterCell(this.editorCell);
        return object != null && (object = object.getMetadata()) != null ? ((JupyterMetadata)object).getTags$intellij_jupyter_core() : null;
    }

    public final void updateTags() {
        this.component.removeAll();
        if (!Registry.Companion.is("jupyter.cell.metadata.tags", true)) {
            return;
        }
        NotebookCellLines.Interval interval = this.editorCell.getIntervalOrNull();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        List<JupyterTag> cellTags = this.getCellTags();
        Collection collection = cellTags;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.component.add((Component)this.createAddTagButton());
        Iterable $this$forEach$iv = cellTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterTag tag = (JupyterTag)element$iv;
            boolean bl = false;
            this.component.add((Component)new NotebookCellTagLabel(tag.getName(), interval2.getOrdinal()));
            this.component.add(Box.createHorizontalStrut(this.tagsSpacing));
        }
    }

    private final JComponent createAddTagButton() {
        ActionToolbar actionToolbar;
        ActionGroup actionGroup = ActionUtil.getActionGroup((String)"JupyterCellAddTagInlayActionGroup");
        Intrinsics.checkNotNull((Object)actionGroup);
        ActionGroup actionGroup2 = actionGroup;
        ActionToolbar $this$createAddTagButton_u24lambda_u240 = actionToolbar = ActionManager.getInstance().createActionToolbar("NotebookTagsPanel", actionGroup2, true);
        boolean bl = false;
        $this$createAddTagButton_u24lambda_u240.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        $this$createAddTagButton_u24lambda_u240.getComponent().setBorder(BorderFactory.createEmptyBorder());
        $this$createAddTagButton_u24lambda_u240.setMinimumButtonSize((Dimension)JBUI.size((int)18, (int)18));
        $this$createAddTagButton_u24lambda_u240.setTargetComponent($this$createAddTagButton_u24lambda_u240.getComponent());
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar toolbar = actionToolbar2;
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component2 = jComponent;
        Container container = component2.getParent();
        component2.setBackground(container != null ? container.getBackground() : null);
        return component2;
    }
}

