/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef;

import com.intellij.jupyter.core.jupyter.nbformat.JupyterAttachment;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J*\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/JupyterAttachmentCefResourceHandler;", "Lorg/cef/handler/CefResourceHandler;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;)V", "attachment", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterAttachment;", "attachmentInputStream", "Ljava/io/ByteArrayInputStream;", "attachmentLength", "", "processRequest", "", "request", "Lorg/cef/network/CefRequest;", "callback", "Lorg/cef/callback/CefCallback;", "getResponseHeaders", "", "response", "Lorg/cef/network/CefResponse;", "responseLength", "Lorg/cef/misc/IntRef;", "redirectUrl", "Lorg/cef/misc/StringRef;", "readResponse", "dataOut", "", "bytesToRead", "bytesRead", "cancel", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterAttachmentCefResourceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterAttachmentCefResourceHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/JupyterAttachmentCefResourceHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n23#2:80\n23#2:81\n*S KotlinDebug\n*F\n+ 1 JupyterAttachmentCefResourceHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/JupyterAttachmentCefResourceHandler\n*L\n66#1:80\n73#1:81\n*E\n"})
public final class JupyterAttachmentCefResourceHandler
implements CefResourceHandler {
    @NotNull
    private final JupyterNotebook notebook;
    private JupyterAttachment attachment;
    private ByteArrayInputStream attachmentInputStream;
    private int attachmentLength;

    public JupyterAttachmentCefResourceHandler(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.notebook = notebook;
    }

    public boolean processRequest(@NotNull CefRequest request, @NotNull CefCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        String string = request.getURL();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"attachment:", (boolean)false, (int)2, null)) {
            return false;
        }
        String string2 = request.getURL();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getURL(...)");
        String string3 = string2;
        int n = 11;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String attachmentId = string4;
        boolean found = false;
        for (JupyterCell cell : this.notebook.computeCells()) {
            JupyterAttachment att = cell.getAttachments().getAttachment(attachmentId);
            if (att == null) continue;
            this.attachment = att;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        JupyterAttachment jupyterAttachment = this.attachment;
        if (jupyterAttachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            jupyterAttachment = null;
        }
        byte[] decodedBytes = decoder.decode(jupyterAttachment.getData());
        this.attachmentLength = decodedBytes.length;
        this.attachmentInputStream = new ByteArrayInputStream(decodedBytes);
        callback2.Continue();
        return true;
    }

    public void getResponseHeaders(@NotNull CefResponse response, @NotNull IntRef responseLength, @Nullable StringRef redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)responseLength, (String)"responseLength");
        JupyterAttachment jupyterAttachment = this.attachment;
        if (jupyterAttachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            jupyterAttachment = null;
        }
        response.setMimeType(jupyterAttachment.getType());
        responseLength.set(this.attachmentLength);
        response.setStatus(200);
    }

    public boolean readResponse(@NotNull byte[] dataOut, int bytesToRead, @NotNull IntRef bytesRead, @Nullable CefCallback callback2) {
        boolean $i$f$thisLogger;
        JupyterAttachmentCefResourceHandler $this$thisLogger$iv;
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        Intrinsics.checkNotNullParameter((Object)bytesRead, (String)"bytesRead");
        try {
            int availableSize;
            ByteArrayInputStream byteArrayInputStream = this.attachmentInputStream;
            if (byteArrayInputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentInputStream");
                byteArrayInputStream = null;
            }
            if ((availableSize = byteArrayInputStream.available()) > 0) {
                int bytesToRead2 = Math.min(bytesToRead, availableSize);
                ByteArrayInputStream byteArrayInputStream2 = this.attachmentInputStream;
                if (byteArrayInputStream2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentInputStream");
                    byteArrayInputStream2 = null;
                }
                bytesToRead2 = byteArrayInputStream2.read(dataOut, 0, bytesToRead2);
                bytesRead.set(bytesToRead2);
                return true;
            }
        }
        catch (IOException e) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterAttachmentCefResourceHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
        bytesRead.set(0);
        try {
            ByteArrayInputStream byteArrayInputStream = this.attachmentInputStream;
            if (byteArrayInputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentInputStream");
                byteArrayInputStream = null;
            }
            byteArrayInputStream.close();
        }
        catch (IOException e) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterAttachmentCefResourceHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
        return false;
    }

    public void cancel() {
    }
}

