/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaExecutionUtil {
    private static final Logger LOG = Logger.getInstance(JavaExecutionUtil.class);

    private JavaExecutionUtil() {
    }

    public static Module findModule(Module contextModule, Set<String> patterns, Project project, Condition<? super PsiClass> isTestMethod) {
        Module nextModule;
        HashSet<Module> modules = new HashSet<Module>();
        for (String className : patterns) {
            PsiClass psiClass = JavaExecutionUtil.findMainClass(project, className.contains(",") ? className.substring(0, className.indexOf(44)) : className, GlobalSearchScope.allScope((Project)project));
            if (psiClass == null || !isTestMethod.value((Object)psiClass)) continue;
            modules.add(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass));
        }
        if (modules.size() == 1 && (nextModule = (Module)modules.iterator().next()) != null) {
            return nextModule;
        }
        if (contextModule != null && modules.size() > 1) {
            HashSet moduleDependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)contextModule, moduleDependencies);
            if (moduleDependencies.containsAll(modules)) {
                return contextModule;
            }
            return null;
        }
        return contextModule;
    }

    @Nullable
    public static String getRuntimeQualifiedName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaExecutionUtil.$$$reportNull$$$0(0);
        }
        return ClassUtil.getJVMClassName((PsiClass)aClass);
    }

    @Nullable
    @NlsSafe
    public static String getPresentableClassName(@Nullable String rtClassName) {
        if (StringUtil.isEmpty((String)rtClassName)) {
            return null;
        }
        int lastDot = rtClassName.lastIndexOf(46);
        return lastDot == -1 || lastDot == rtClassName.length() - 1 ? rtClassName : rtClassName.substring(lastDot + 1);
    }

    public static Module findModule(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaExecutionUtil.$$$reportNull$$$0(1);
        }
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass.getContainingFile());
    }

    @Nullable
    public static PsiClass findMainClass(Module module, String mainClassName) {
        return JavaExecutionUtil.findMainClass(module.getProject(), mainClassName, module.getModuleRuntimeScope(true));
    }

    @Nullable
    public static PsiClass findMainClass(Project project, String mainClassName, GlobalSearchScope scope) {
        if (project.isDefault() || DumbService.isDumb((Project)project) && FileBasedIndex.getInstance().getCurrentDumbModeAccessType(project) == null && !DumbService.getInstance((Project)project).isAlternativeResolveEnabled()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        String shortName = StringUtil.getShortName((String)mainClassName);
        String packageName = StringUtil.getPackageName((String)mainClassName);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject());
        try {
            PsiClass psiClass = psiFacade.findClass(StringUtil.getQualifiedName((String)packageName, (String)shortName.replace('$', '.')), scope);
            return psiClass == null ? psiFacade.findClass(mainClassName, scope) : psiClass;
        }
        catch (IndexNotReadyException ex) {
            return null;
        }
    }

    public static boolean isNewName(String name) {
        return name == null || name.startsWith(ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]));
    }

    public static Location stepIntoSingleClass(@NotNull Location location) {
        PsiClassOwner psiFile;
        PsiClass[] classes;
        if (location == null) {
            JavaExecutionUtil.$$$reportNull$$$0(2);
        }
        PsiElement element = location.getPsiElement();
        TextRange elementTextRange = element.getTextRange();
        if (!(element instanceof PsiClassOwner)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != null) {
                return location;
            }
            if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClassOwner.class)) == null) {
                return location;
            }
        }
        if ((classes = (psiFile = (PsiClassOwner)element).getClasses()).length != 1) {
            return location;
        }
        TextRange textRange = classes[0].getTextRange();
        if (textRange == null) {
            return location;
        }
        if (elementTextRange != null && textRange.contains(elementTextRange)) {
            return location;
        }
        return PsiLocation.fromPsiElement((PsiElement)classes[0]);
    }

    public static String getShortClassName(@Nullable String fqName) {
        return fqName == null ? "" : StringUtil.getShortName((String)fqName);
    }

    @Deprecated(forRemoval=true)
    public static void showExecutionErrorMessage(ExecutionException e, @NlsContexts.DialogTitle String title, Project project) {
        ExecutionErrorDialog.show((ExecutionException)e, (String)title, (Project)project);
    }

    @Nullable
    public static String handleSpacesInAgentPath(@NotNull String agentPath, @NotNull String copyDirName, @Nullable String agentPathPropertyKey) {
        if (agentPath == null) {
            JavaExecutionUtil.$$$reportNull$$$0(3);
        }
        if (copyDirName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(4);
        }
        return JavaExecutionUtil.handleSpacesInAgentPath(agentPath, copyDirName, agentPathPropertyKey, null);
    }

    @Nullable
    public static String handleSpacesInAgentPath(@NotNull String agentPath, @NotNull String copyDirName, @Nullable String agentPathPropertyKey, @Nullable FileFilter fileFilter) {
        String agentName;
        String containingDir;
        if (agentPath == null) {
            JavaExecutionUtil.$$$reportNull$$$0(5);
        }
        if (copyDirName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(6);
        }
        return (containingDir = JavaExecutionUtil.handleSpacesInContainingDir(agentPath, agentName = new File(agentPath).getName(), copyDirName, agentPathPropertyKey, fileFilter)) == null ? null : FileUtil.join((String[])new String[]{containingDir, agentName});
    }

    @Nullable
    private static String handleSpacesInContainingDir(@NotNull String agentPath, @NotNull String agentName, @NotNull String copyDirName, @Nullable String agentPathPropertyKey, @Nullable FileFilter fileFilter) {
        String userDefined;
        String agentContainingDir;
        if (agentPath == null) {
            JavaExecutionUtil.$$$reportNull$$$0(7);
        }
        if (agentName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(8);
        }
        if (copyDirName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(9);
        }
        if ((agentContainingDir = (userDefined = agentPathPropertyKey == null ? null : System.getProperty(agentPathPropertyKey)) != null && new File(userDefined).exists() ? userDefined : new File(agentPath).getParent()).contains(" ")) {
            String res = JavaExecutionUtil.tryCopy(agentContainingDir, agentName, new File(PathManager.getSystemPath(), copyDirName), fileFilter);
            if (res == null) {
                try {
                    res = JavaExecutionUtil.tryCopy(agentContainingDir, agentName, FileUtil.createTempDirectory((String)copyDirName, (String)"jars"), fileFilter);
                    if (res == null) {
                        String message = "agent not used since the agent path contains spaces: " + agentContainingDir;
                        if (agentPathPropertyKey != null) {
                            message = message + "\nOne can move the agent libraries to a directory with no spaces in path and specify its path in idea.properties as " + agentPathPropertyKey + "=<path>";
                        }
                        LOG.info(message);
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            return res;
        }
        return agentContainingDir;
    }

    @Nullable
    private static String tryCopy(@NotNull String agentDir, @NotNull String agentName, @NotNull File targetDir, @Nullable FileFilter fileFilter) {
        if (agentDir == null) {
            JavaExecutionUtil.$$$reportNull$$$0(10);
        }
        if (agentName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(11);
        }
        if (targetDir == null) {
            JavaExecutionUtil.$$$reportNull$$$0(12);
        }
        if (targetDir.getAbsolutePath().contains(" ")) {
            return null;
        }
        try {
            if (fileFilter == null) {
                FileUtil.copy((File)new File(agentDir, agentName), (File)new File(targetDir, agentName));
            } else {
                FileUtil.copyDir((File)new File(agentDir), (File)targetDir, (FileFilter)fileFilter);
            }
            LOG.info("Agent jars were copied to " + targetDir.getPath());
            return targetDir.getPath();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentPath";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyDirName";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/JavaExecutionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRuntimeQualifiedName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stepIntoSingleClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSpacesInAgentPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSpacesInContainingDir";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCopy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

