/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.text.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RemoteConnection {
    private boolean myUseSockets;
    private boolean myServerMode;
    private String myApplicationHostName;
    private String myApplicationAddress;
    private String myDebuggerHostName;
    private String myDebuggerAddress;
    public static final String ONTHROW = ",onthrow=<FQ exception class name>";
    public static final String ONUNCAUGHT = ",onuncaught=<y/n>";

    public RemoteConnection(boolean useSockets, String hostName, String address, boolean serverMode) {
        this.myUseSockets = useSockets;
        this.myServerMode = serverMode;
        this.myApplicationHostName = hostName;
        this.myDebuggerHostName = hostName;
        this.myApplicationAddress = address;
        this.myDebuggerAddress = address;
    }

    public boolean isUseSockets() {
        return this.myUseSockets;
    }

    public boolean isServerMode() {
        return this.myServerMode;
    }

    public void setUseSockets(boolean useSockets) {
        this.myUseSockets = useSockets;
    }

    public void setServerMode(boolean serverMode) {
        this.myServerMode = serverMode;
    }

    @Deprecated(forRemoval=true)
    public String getHostName() {
        return this.myApplicationHostName;
    }

    @Deprecated(forRemoval=true)
    public String getAddress() {
        return this.myApplicationAddress;
    }

    public String getApplicationHostName() {
        return this.myApplicationHostName;
    }

    public void setApplicationHostName(String hostName) {
        this.myApplicationHostName = hostName;
    }

    public String getDebuggerHostName() {
        return this.myDebuggerHostName;
    }

    public void setDebuggerHostName(String debuggerHostName) {
        this.myDebuggerHostName = debuggerHostName;
    }

    public String getApplicationAddress() {
        return this.myApplicationAddress;
    }

    public void setApplicationAddress(String applicationAddress) {
        this.myApplicationAddress = applicationAddress;
    }

    public String getDebuggerAddress() {
        return this.myDebuggerAddress;
    }

    public void setDebuggerAddress(String debuggerAddress) {
        this.myDebuggerAddress = debuggerAddress;
    }

    public String getLaunchCommandLine() {
        String result;
        String address = this.getApplicationAddress();
        boolean shmem = !this.isUseSockets();
        boolean serverMode = this.isServerMode();
        if (shmem) {
            result = serverMode ? "-Xdebug -Xrunjdwp:transport=dt_shmem,server=n,address=" + (!address.isEmpty() ? address : "...") + ",suspend=y,onthrow=<FQ exception class name>,onuncaught=<y/n>" : "-Xdebug -Xrunjdwp:transport=dt_shmem,server=y,suspend=n,address=" + (!address.isEmpty() ? address : "...");
        } else {
            int port = StringUtil.parseInt((String)address, (int)-1);
            if (serverMode) {
                Object localHostName = "<host name>:";
                try {
                    InetAddress localAddress = InetAddress.getLocalHost();
                    String name = localAddress.getCanonicalHostName();
                    if (name != null) {
                        localHostName = name + ":";
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                result = "-Xdebug -Xrunjdwp:transport=dt_socket,server=n,address=" + (String)localHostName + (port == -1 ? "<port>" : Integer.toString(port)) + ",suspend=y,onthrow=<FQ exception class name>,onuncaught=<y/n>";
            } else {
                result = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + (port == -1 ? "..." : Integer.toString(port));
            }
        }
        return result;
    }

    public String toString() {
        return "RemoteConnection{myUseSockets=" + this.myUseSockets + ", myServerMode=" + this.myServerMode + ", myApplicationHostName='" + this.myApplicationHostName + "', myApplicationAddress='" + this.myApplicationAddress + "', myDebuggerHostName='" + this.myDebuggerHostName + "', myDebuggerAddress='" + this.myDebuggerAddress + "'}";
    }
}

