/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.JvmExceptionOccurrenceFilter;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AdvancedExceptionFilter
extends ExceptionFilter {
    AdvancedExceptionFilter(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            AdvancedExceptionFilter.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            AdvancedExceptionFilter.$$$reportNull$$$0(1);
        }
        super(project, scope);
    }

    @Override
    @NotNull
    List<Filter.ResultItem> getExceptionClassNameItems(ExceptionInfo prevLineException) {
        ExceptionInfoCache.ClassResolveInfo info = this.myCache.resolveClass(prevLineException.getExceptionClassName());
        if (info.getClasses().isEmpty()) {
            List<Filter.ResultItem> list = Collections.emptyList();
            if (list == null) {
                AdvancedExceptionFilter.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = this.myCache.getProject();
        List classMap = DumbService.isDumb((Project)project) ? ContainerUtil.filterIsInstance(info.getClasses().values(), PsiClass.class) : info.getExceptionClasses();
        if (classMap.isEmpty()) {
            List<Filter.ResultItem> list = Collections.emptyList();
            if (list == null) {
                AdvancedExceptionFilter.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<Filter.ResultItem> exceptionResults = new ArrayList<Filter.ResultItem>();
        JvmExceptionOccurrenceFilter.EP_NAME.forEachExtensionSafe(filter -> {
            Filter.ResultItem res = filter.applyFilter(prevLineException.getExceptionClassName(), classMap, prevLineException.getClassNameOffset());
            ContainerUtil.addIfNotNull((Collection)exceptionResults, (Object)res);
        });
        ArrayList<Filter.ResultItem> arrayList = exceptionResults;
        if (arrayList == null) {
            AdvancedExceptionFilter.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/AdvancedExceptionFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/AdvancedExceptionFilter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionClassNameItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

