/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.core;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.jupyter.core.core.impl.file.JupyterTemplateNotebookFileCreator;
import com.intellij.jupyter.py.actions.NewJupyterNotebookAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/py/core/PythonJupyterTemplateNotebookFileCreator;", "Lcom/intellij/jupyter/core/core/impl/file/JupyterTemplateNotebookFileCreator;", "<init>", "()V", "setTemplateContent", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTemplateContent", "", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nPythonJupyterTemplateNotebookFileCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonJupyterTemplateNotebookFileCreator.kt\ncom/intellij/jupyter/py/core/PythonJupyterTemplateNotebookFileCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class PythonJupyterTemplateNotebookFileCreator
implements JupyterTemplateNotebookFileCreator {
    public void setTemplateContent(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getLength() == 0L) {
            FileTemplate fileTemplate = FileTemplateManager.getDefaultInstance().getInternalTemplate("Jupyter Notebook");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInternalTemplate(...)");
            FileTemplate template = fileTemplate;
            String content = this.getTemplateContent(file, template);
            ActionsKt.invokeAndWaitIfNeeded$default(null, () -> PythonJupyterTemplateNotebookFileCreator.setTemplateContent$lambda$0(file, content), (int)1, null);
        }
    }

    private final String getTemplateContent(VirtualFile file, FileTemplate template) {
        Object object;
        PsiDirectory psiDirectory;
        block4: {
            block3: {
                Project project = ProjectUtil.guessProjectForFile((VirtualFile)file);
                psiDirectory = (PsiDirectory)ActionsKt.runReadAction(() -> PythonJupyterTemplateNotebookFileCreator.getTemplateContent$lambda$0(project, file));
                object = project;
                if (object == null) break block3;
                Project it = object;
                boolean bl = false;
                Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
                object = properties;
                if (properties != null) break block4;
            }
            Properties properties = FileTemplateManager.getDefaultInstance().getDefaultProperties();
            object = properties;
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        }
        Object properties = object;
        Map<String, String> templateValues = NewJupyterNotebookAction.Companion.createTemplateValues(psiDirectory);
        for (Map.Entry<String, String> entry : templateValues.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            ((Map)properties).put(key, value);
        }
        String string = template.getText((Properties)properties);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final void setTemplateContent$lambda$0$0(VirtualFile $file, String $content) {
        byte[] byArray = $content.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $file.setBinaryContent(byArray);
    }

    private static final Unit setTemplateContent$lambda$0(VirtualFile $file, String $content) {
        WriteAction.run(() -> PythonJupyterTemplateNotebookFileCreator.setTemplateContent$lambda$0$0($file, $content));
        return Unit.INSTANCE;
    }

    private static final PsiDirectory getTemplateContent$lambda$0(Project $project, VirtualFile $file) {
        PsiDirectory psiDirectory;
        Project project = $project;
        if (project != null) {
            Project it = project;
            boolean bl = false;
            PsiFileSystemItem psiFileSystemItem = PsiUtilCore.findFileSystemItem((Project)it, (VirtualFile)$file.getParent());
            psiDirectory = psiFileSystemItem instanceof PsiDirectory ? (PsiDirectory)psiFileSystemItem : null;
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }
}

