/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jupyter.py.editor.inspections.quickfix.StatementEffectSplitCellQuickFix;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.jetbrains.python.inspections.PyStatementEffectQuickFixProvider;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/py/editor/inspections/quickfix/JupyterNoEffectStatementSplitQuickFixProvider;", "Lcom/jetbrains/python/inspections/PyStatementEffectQuickFixProvider;", "<init>", "()V", "getQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "expressionStatement", "Lcom/jetbrains/python/psi/PyExpressionStatement;", "intellij.jupyter.py"})
public final class JupyterNoEffectStatementSplitQuickFixProvider
implements PyStatementEffectQuickFixProvider {
    @Nullable
    public LocalQuickFix getQuickFix(@NotNull PyExpressionStatement expressionStatement) {
        Intrinsics.checkNotNullParameter((Object)expressionStatement, (String)"expressionStatement");
        PyExpression pyExpression = expressionStatement.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getExpression(...)");
        PyExpression expression = pyExpression;
        VirtualFile virtualFile = expression.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Document document = VirtualFileUtil.findDocument((VirtualFile)virtualFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (!NotebookCellLines.Companion.hasSupport(document2)) {
            return null;
        }
        if (!(expression.getParent().getParent() instanceof PyFile)) {
            return null;
        }
        return new StatementEffectSplitCellQuickFix();
    }
}

