/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureStorage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

public class OverheadDetector {
    private boolean throttleWhenOverhead = false;
    private final AtomicBoolean myFirstOverheadDetected = new AtomicBoolean(false);
    private static final long PERIOD_NS = 0x20000000L;
    private final long MAX_OVERHEAD_NS;
    private final double myTargetOverheadPercent;
    private final boolean myThrottlingEnabled;
    private Timer ourTimer = new CoarseTimer(TimeUnit.MICROSECONDS.toNanos(100L));
    private static final OverheadTracker NO_OP_TRACKER = new OverheadTracker(){

        @Override
        public boolean runIfNoOverhead(Runnable runnable) {
            runnable.run();
            return true;
        }
    };

    public OverheadDetector(double targetOverheadPercent, boolean throttlingEnabled) {
        this.MAX_OVERHEAD_NS = Math.round(targetOverheadPercent * 5.36870912E8 / 100.0);
        this.myTargetOverheadPercent = targetOverheadPercent;
        this.myThrottlingEnabled = throttlingEnabled;
    }

    void onOverheadDetected() {
        if (!this.myFirstOverheadDetected.compareAndSet(false, true)) {
            return;
        }
        if (CaptureStorage.DEBUG) {
            System.out.println("Overhead detected");
        }
        this.overheadDetected(this);
    }

    private void overheadDetected(OverheadDetector overheadDetector) {
    }

    void setTimer(Timer timer) {
        this.ourTimer = timer;
    }

    OverheadTracker createOverheadTracker() {
        if (this.myTargetOverheadPercent >= 100.0) {
            return NO_OP_TRACKER;
        }
        if (this.ourTimer instanceof CoarseTimer) {
            ((CoarseTimer)this.ourTimer).initialize();
        }
        return new PerThread();
    }

    private class PerThread
    implements OverheadTracker {
        private long myLastExecutionTime;
        private long myOverhead;
        private boolean myInProgress;
        private boolean myLocalFirstOverheadDetected;

        private PerThread() {
            this.myLastExecutionTime = OverheadDetector.this.ourTimer.nanoTime();
            this.myOverhead = 0L;
            this.myInProgress = false;
            this.myLocalFirstOverheadDetected = OverheadDetector.this.myFirstOverheadDetected.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean runIfNoOverhead(Runnable runnable) {
            if (this.myInProgress) {
                runnable.run();
                return true;
            }
            long startTime = OverheadDetector.this.ourTimer.nanoTime();
            this.restore(startTime);
            if (this.overheadDetected()) {
                this.notifyOverheadDetected();
                if (OverheadDetector.this.myThrottlingEnabled) {
                    return false;
                }
            }
            this.myInProgress = true;
            try {
                runnable.run();
            }
            finally {
                long endTime = OverheadDetector.this.ourTimer.nanoTime();
                long elapsedTime = endTime - startTime;
                this.myOverhead = Math.min(2L * OverheadDetector.this.MAX_OVERHEAD_NS, this.myOverhead + elapsedTime);
                this.myInProgress = false;
            }
            return true;
        }

        private boolean overheadDetected() {
            return this.myOverhead >= OverheadDetector.this.MAX_OVERHEAD_NS;
        }

        private void notifyOverheadDetected() {
            if (this.myLocalFirstOverheadDetected) {
                return;
            }
            this.myLocalFirstOverheadDetected = true;
            OverheadDetector.this.onOverheadDetected();
        }

        private void restore(long currentTime) {
            long lastTime = this.myLastExecutionTime;
            this.myLastExecutionTime = currentTime;
            long passedTime = currentTime - lastTime;
            if (passedTime >= 0x20000000L) {
                this.myOverhead = 0L;
            } else {
                long restored = passedTime * OverheadDetector.this.MAX_OVERHEAD_NS / 0x20000000L;
                long overhead = this.myOverhead - restored;
                if (overhead < 0L) {
                    overhead = 0L;
                }
                this.myOverhead = overhead;
            }
        }
    }

    static interface OverheadTracker {
        public boolean runIfNoOverhead(Runnable var1);
    }

    private static class CoarseTimer
    implements Timer {
        private final AtomicBoolean myInitialized = new AtomicBoolean(false);
        private final long myPrecisionNs;
        private volatile long myTimeNs;

        CoarseTimer(long precisionNs) {
            this.myPrecisionNs = precisionNs;
        }

        public void initialize() {
            if (!this.myInitialized.compareAndSet(false, true)) {
                return;
            }
            this.myTimeNs = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        LockSupport.parkNanos(CoarseTimer.this.myPrecisionNs);
                        CoarseTimer.this.myTimeNs = System.nanoTime();
                    }
                }
            }, "CoarseTimer");
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public long nanoTime() {
            return this.myTimeNs;
        }
    }

    static interface Timer {
        public long nanoTime();
    }
}

