/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.definitions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.compiler.plugin.definitions.ScriptCompilationConfigurationProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/ScriptCompilationConfigurationProviderOverDefinitionProvider;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/ScriptCompilationConfigurationProvider;", "provider", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionProvider;", "<init>", "(Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionProvider;)V", "isScript", "", "source", "Lkotlin/script/experimental/api/SourceCode;", "findBaseCompilationConfiguration", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getDefaultCompilationConfiguration", "kotlin-scripting-compiler"})
public final class ScriptCompilationConfigurationProviderOverDefinitionProvider
implements ScriptCompilationConfigurationProvider {
    @NotNull
    private final ScriptDefinitionProvider provider;

    public ScriptCompilationConfigurationProviderOverDefinitionProvider(@NotNull ScriptDefinitionProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
    }

    @Override
    public boolean isScript(@NotNull SourceCode source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.provider.isScript(source);
    }

    @Override
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfiguration> findBaseCompilationConfiguration(@NotNull SourceCode source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ScriptDefinition scriptDefinition = this.provider.findDefinition(source);
        return (ResultWithDiagnostics)(scriptDefinition != null && (scriptDefinition = scriptDefinition.getCompilationConfiguration()) != null ? ErrorHandlingKt.asSuccess$default((Object)scriptDefinition, null, (int)1, null) : null);
    }

    @Override
    @NotNull
    public ResultWithDiagnostics<ScriptCompilationConfiguration> getDefaultCompilationConfiguration() {
        return (ResultWithDiagnostics)ErrorHandlingKt.asSuccess$default((Object)this.provider.getDefaultDefinition().getCompilationConfiguration(), null, (int)1, null);
    }
}

