/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport;

import com.intellij.DynamicBundle;
import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportHostTarget;
import com.intellij.javaee.transport.TransportHostTargetEditor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.ServerPasswordSafeDeployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.transport.WebDeploymentTransportHost;
import com.jetbrains.plugins.webDeployment.transport.WebDeploymentTransportHostTarget;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;

public final class WebDeploymentTransportHostTargetEditor
implements TransportHostTargetEditor {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton.NoPathCompletion myTargetPath;
    private WebDeploymentTransportHost myHost;

    public WebDeploymentTransportHostTargetEditor() {
        this.$$$setupUI$$$();
        this.setupTargetPathField(this.myTargetPath, WDBundle.message((String)"WebDeploymentTransportHostTargetEditor.dialog.title", (Object[])new Object[0]));
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void setHost(TransportHost host) {
        this.myHost = (WebDeploymentTransportHost)host;
    }

    public void resetStateFrom(TransportHostTarget state) {
        this.myTargetPath.setText(((WebDeploymentTransportHostTarget)state).getTargetPath());
    }

    public void applyStateTo(TransportHostTarget state) {
        ((WebDeploymentTransportHostTarget)state).setTargetPath(this.myTargetPath.getText());
    }

    private void setupTargetPathField(final TextFieldWithBrowseButton.NoPathCompletion targetPathField, final @Nls String title) {
        targetPathField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServerConfig.RemotePath path;
                WebServerConfig server = WebDeploymentTransportHostTargetEditor.this.myHost.getServer();
                if (server == null) {
                    return;
                }
                WebServerConfig.RemotePath initialPath = server.getRootPath();
                ServerBrowserDialog dialog = new ServerBrowserDialog((Component)targetPathField, (Deployable)new ServerPasswordSafeDeployable(server, WebDeploymentTransportHostTargetEditor.this.myHost.getSshUiData()), title, true, FileTransferConfig.Origin.Default, initialPath);
                if (dialog.showAndGet() && (path = dialog.getPath()) != null) {
                    targetPathField.setText(server.getFileTransferConfig().getAccessType() == AccessType.MOUNT ? FileUtilRt.toSystemDependentName((String)FileUtilRt.getRelativePath((String)FileUtilRt.toSystemIndependentName((String)server.getFileTransferConfig().getMountedFolder()), (String)FileUtilRt.toSystemIndependentName((String)path.path), (char)'/')) : path.path);
                }
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WDBundle", WebDeploymentTransportHostTargetEditor.class).getString("Form.WebDeploymentTransportHostTargetEditor.path.from.root"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTargetPath = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel.add((Component)noPathCompletion, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

