/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action.task;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.impl.statistics.RunConfigurationOptionUsagesCollector;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class RunExternalSystemTaskAction
extends ExternalSystemNodeAction<TaskData> {
    private static final Logger LOG = Logger.getInstance(RunExternalSystemTaskAction.class);

    public RunExternalSystemTaskAction() {
        super(TaskData.class);
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull TaskData taskData, @NotNull AnActionEvent e) {
        if (project == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(0);
        }
        if (projectSystemId == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(1);
        }
        if (taskData == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(3);
        }
        ExternalTaskExecutionInfo taskExecutionInfo = ExternalSystemActionUtil.buildTaskInfo(taskData);
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)e.getDataContext(), (String)e.getPlace());
        RunnerAndConfigurationSettings configuration = RunExternalSystemTaskAction.findOrGet(context);
        if (configuration == null || !RunExternalSystemTaskAction.runTaskAsExistingConfiguration(taskExecutionInfo, configuration)) {
            RunExternalSystemTaskAction.runTaskAsNewRunConfiguration(project, projectSystemId, taskExecutionInfo);
            configuration = RunExternalSystemTaskAction.findOrGet(context);
        }
        context.getRunManager().setSelectedConfiguration(configuration);
    }

    @Nullable
    private static RunnerAndConfigurationSettings findOrGet(@NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings result;
        if (context == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(4);
        }
        if ((result = context.findExisting()) == null && (result = context.getConfiguration()) != null) {
            context.getRunManager().setTemporaryConfiguration(result);
            RunConfigurationOptionUsagesCollector.logAddNew((Project)context.getProject(), (String)result.getType().getId(), (String)context.getPlace());
        }
        return result;
    }

    private static boolean runTaskAsExistingConfiguration(@NotNull ExternalTaskExecutionInfo taskExecutionInfo, @NotNull RunnerAndConfigurationSettings configuration) {
        if (taskExecutionInfo == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(6);
        }
        String executorId = taskExecutionInfo.getExecutorId();
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            return false;
        }
        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
        return true;
    }

    private static void runTaskAsNewRunConfiguration(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull ExternalTaskExecutionInfo taskExecutionInfo) {
        if (project == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(7);
        }
        if (projectSystemId == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(8);
        }
        if (taskExecutionInfo == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(9);
        }
        ExternalSystemUtil.runTask(taskExecutionInfo.getSettings(), taskExecutionInfo.getExecutorId(), project, projectSystemId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutionInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/task/RunExternalSystemTaskAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrGet";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runTaskAsExistingConfiguration";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "runTaskAsNewRunConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

