/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker$ProjectDataState$;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker$State$;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTrackerKt;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTrackerSettings;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemModificationType;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ProjectBatchFileChangeListener;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker$State$;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.update.PriorityEatUpdate;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemActivityKey;
import com.intellij.openapi.observable.operation.core.AtomicOperationTrace;
import com.intellij.openapi.observable.operation.core.MutableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTraceUtil;
import com.intellij.openapi.observable.operation.core.OperationUtilKt;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ListenerUtilKt;
import com.intellij.openapi.observable.properties.MutableBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.observable.util.RevertPropertyOnDisposeUtilKt;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingQueueUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="ExternalSystemProjectTracker", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\b*\u0002\u001f\"\b\u0007\u0018\u0000 W2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0005STUVWB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\"\u0010*\u001a\u00020(2\u0018\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-0,H\u0002J&\u00104\u001a\u00020(2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\f\u00108\u001a\b\u0012\u0004\u0012\u00020(09H\u0002J\u0010\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020<H\u0002J\"\u0010=\u001a\u00020(2\u0018\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-0,H\u0002J\u0018\u0010>\u001a\u00020<2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010?\u001a\u00020/H\u0002J\u0018\u0010@\u001a\u00020<2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010?\u001a\u00020/H\u0002J\u0010\u0010A\u001a\u00020(2\u0006\u0010B\u001a\u00020.H\u0016J\u0010\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020\u0011H\u0016J\u0010\u0010E\u001a\u00020(2\u0006\u0010D\u001a\u00020\u0011H\u0016J\u0010\u0010F\u001a\u00020(2\u0006\u0010D\u001a\u00020\u0011H\u0016J\b\u0010G\u001a\u00020(H\u0016J?\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010D\u001a\u00020\u00112+\u00108\u001a'\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140I\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140H\u00a2\u0006\u0002\bJH\u0002J\b\u0010K\u001a\u00020\u0004H\u0016J\u0010\u0010L\u001a\u00020(2\u0006\u0010M\u001a\u00020\u0004H\u0016J\u0018\u0010L\u001a\u00020(2\u0006\u0010N\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0014H\u0002J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00110PH\u0007J\u0010\u0010Q\u001a\u00020(2\u0006\u0010R\u001a\u000206H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectTracker;", "Lcom/intellij/openapi/Disposable$Default;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "serviceDisposable", "Lcom/intellij/openapi/Disposable;", "settings", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTrackerSettings;", "notificationAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectNotificationAware;", "projectDataStates", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectDataState;", "projectDataMap", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectData;", "projectChangeOperation", "Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace;", "isProjectLookupActivateProperty", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "dispatcher", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "createProjectChangesListener", "com/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$createProjectChangesListener$1", "()Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$createProjectChangesListener$1;", "createProjectReloadListener", "com/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$createProjectReloadListener$1", "projectData", "(Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectData;)Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$createProjectReloadListener$1;", "createProjectCompletionListener", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "scheduleProjectRefresh", "", "scheduleChangeProcessing", "scheduleDelayedProjectReload", "projectsToReload", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "currentActivityLock", "Ljava/util/concurrent/locks/ReentrantLock;", "currentActivity", "Lcom/intellij/internal/performanceTests/ProjectInitializationDiagnosticService$ActivityTracker;", "schedule", "priority", "", "dispatchIterations", "action", "Lkotlin/Function0;", "processChanges", "isExplicitReload", "", "reloadProject", "isDisabledReload", "context", "isDisabledAutoReload", "register", "projectAware", "activate", "id", "remove", "markDirty", "markDirtyAllProjects", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "getState", "loadState", "state", "projectId", "getActivatedProjects", "", "setDispatcherMergingSpan", "delay", "ProjectData", "State", "ProjectDataState", "ProjectReloadContext", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAutoImportProjectTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoImportProjectTracker.kt\ncom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,552:1\n221#2,2:553\n*S KotlinDebug\n*F\n+ 1 AutoImportProjectTracker.kt\ncom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker\n*L\n386#1:553,2\n*E\n"})
public final class AutoImportProjectTracker
implements ExternalSystemProjectTracker,
Disposable.Default,
PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable serviceDisposable;
    @NotNull
    private final AutoImportProjectTrackerSettings settings;
    @NotNull
    private final ExternalSystemProjectNotificationAware notificationAware;
    @NotNull
    private final ConcurrentHashMap<ExternalSystemProjectId, ProjectDataState> projectDataStates;
    @NotNull
    private final ConcurrentHashMap<ExternalSystemProjectId, ProjectData> projectDataMap;
    @NotNull
    private final AtomicOperationTrace projectChangeOperation;
    @NotNull
    private final AtomicBooleanProperty isProjectLookupActivateProperty;
    @NotNull
    private final ExecutorService backgroundExecutor;
    @NotNull
    private final MergingUpdateQueue dispatcher;
    @NotNull
    private final ReentrantLock currentActivityLock;
    @Nullable
    private ProjectInitializationDiagnosticService.ActivityTracker currentActivity;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final AtomicBooleanProperty onceIgnoreDisableReloadRegistryProperty;
    @NotNull
    private static final AtomicBooleanProperty enableReloadProperty;
    @NotNull
    private static final AtomicBooleanProperty enableAutoReloadProperty;
    @NotNull
    private static final AtomicBooleanProperty asyncChangesProcessingProperty;

    public AutoImportProjectTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.serviceDisposable = (Disposable)this;
        this.settings = AutoImportProjectTrackerSettings.Companion.getInstance(this.project);
        this.notificationAware = ExternalSystemProjectNotificationAware.Companion.getInstance(this.project);
        this.projectDataStates = new ConcurrentHashMap();
        this.projectDataMap = new ConcurrentHashMap();
        this.projectChangeOperation = new AtomicOperationTrace("Project change operation");
        this.isProjectLookupActivateProperty = new AtomicBooleanProperty(false);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AutoImportProjectTracker.backgroundExecutor", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.backgroundExecutor = executorService;
        this.dispatcher = new MergingUpdateQueue("AutoImportProjectTracker.dispatcher", (int)AutoImportProjectTrackerKt.access$getMERGING_TIME_SPAN_MS$p(), true, null, this.serviceDisposable, null, false, 32, null);
        this.currentActivityLock = new ReentrantLock();
        LOG.debug("Project tracker initialization");
        ObservableOperationTraceUtil.whenOperationStarted((ObservableOperationTrace)((ObservableOperationTrace)this.projectChangeOperation), (Disposable)this.serviceDisposable, () -> AutoImportProjectTracker._init_$lambda$0(this));
        ObservableOperationTraceUtil.whenOperationFinished((ObservableOperationTrace)((ObservableOperationTrace)this.projectChangeOperation), (Disposable)this.serviceDisposable, () -> AutoImportProjectTracker._init_$lambda$1(this));
        ListenerUtilKt.whenPropertySet((ObservableBooleanProperty)((ObservableBooleanProperty)this.isProjectLookupActivateProperty), (Disposable)this.serviceDisposable, () -> AutoImportProjectTracker._init_$lambda$2(this));
        ListenerUtilKt.whenPropertyReset((ObservableBooleanProperty)((ObservableBooleanProperty)this.isProjectLookupActivateProperty), (Disposable)this.serviceDisposable, () -> AutoImportProjectTracker._init_$lambda$3(this));
        ListenerUtilKt.whenPropertyChanged((ObservableProperty)((ObservableProperty)this.settings.getAutoReloadTypeProperty$intellij_platform_externalSystem_impl()), (Disposable)this.serviceDisposable, arg_0 -> AutoImportProjectTracker._init_$lambda$4(this, arg_0));
        this.dispatcher.setPassThrough(asyncChangesProcessingProperty.get() == false);
        ListenerUtilKt.whenPropertyChanged((ObservableProperty)((ObservableProperty)asyncChangesProcessingProperty), (Disposable)this.serviceDisposable, arg_0 -> AutoImportProjectTracker._init_$lambda$5(this, arg_0));
        this.dispatcher.setRestartTimerOnAdd(true);
        MessageBusConnection messageBusConnection = ApplicationKt.getApplication().getMessageBus().connect(this.serviceDisposable);
        Topic topic = BatchFileChangeListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this.createProjectChangesListener());
        MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect(this.serviceDisposable);
        Topic topic2 = LookupManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)this.createProjectCompletionListener());
    }

    private final createProjectChangesListener.1 createProjectChangesListener() {
        Project project = this.project;
        return new ProjectBatchFileChangeListener(this, project){
            final /* synthetic */ AutoImportProjectTracker this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void batchChangeStarted(String activityName) {
                MutableOperationTrace.traceStart$default((MutableOperationTrace)((MutableOperationTrace)AutoImportProjectTracker.access$getProjectChangeOperation$p(this.this$0)), null, (int)1, null);
            }

            public void batchChangeCompleted() {
                MutableOperationTrace.traceFinish$default((MutableOperationTrace)((MutableOperationTrace)AutoImportProjectTracker.access$getProjectChangeOperation$p(this.this$0)), null, null, (int)3, null);
            }
        };
    }

    private final createProjectReloadListener.1 createProjectReloadListener(ProjectData projectData) {
        return new ExternalSystemProjectListener(projectData){
            final /* synthetic */ ProjectData $projectData;
            {
                this.$projectData = $projectData;
            }

            public void onProjectReloadStart() {
                MutableOperationTrace.traceStart$default((MutableOperationTrace)this.$projectData.reloadOperation, null, (int)1, null);
                this.$projectData.status.markSynchronized(ProjectStatus.Stamp.Companion.nextStamp());
                this.$projectData.setActivated(true);
            }

            public void onProjectReloadFinish(ExternalSystemRefreshStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                if (status != ExternalSystemRefreshStatus.SUCCESS) {
                    this.$projectData.status.markBroken(ProjectStatus.Stamp.Companion.nextStamp());
                }
                MutableOperationTrace.traceFinish$default((MutableOperationTrace)this.$projectData.reloadOperation, null, null, (int)3, null);
            }
        };
    }

    private final LookupManagerListener createProjectCompletionListener() {
        return (arg_0, arg_1) -> AutoImportProjectTracker.createProjectCompletionListener$lambda$0(this, arg_0, arg_1);
    }

    public void scheduleProjectRefresh() {
        LOG.debug("Schedule change processing (isExplicitReload=true)", new Throwable());
        this.schedule(0, 1, (Function0<Unit>)((Function0)() -> AutoImportProjectTracker.scheduleProjectRefresh$lambda$0(this)));
    }

    public void scheduleChangeProcessing() {
        LOG.debug("Schedule change processing (isExplicitReload=false)");
        this.schedule(1, 1, (Function0<Unit>)((Function0)() -> AutoImportProjectTracker.scheduleChangeProcessing$lambda$0(this)));
    }

    private final void scheduleDelayedProjectReload(List<? extends Pair<? extends ExternalSystemProjectAware, ? extends ExternalSystemProjectReloadContext>> projectsToReload) {
        Comparable comparable;
        LOG.debug("Schedule delayed project reload");
        Collection<ProjectData> collection = this.projectDataMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterator iterator = ((Iterable)collection).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            ProjectData it = (ProjectData)iterator.next();
            boolean bl = false;
            Duration duration = it.projectAware.getSmartProjectReloadDelay-FghU774();
            Comparable comparable2 = (Comparable)Duration.box-impl((long)(duration != null ? duration.unbox-impl() : AutoImportProjectTrackerKt.access$getDEFAULT_SMART_PROJECT_RELOAD_DELAY$p()));
            while (iterator.hasNext()) {
                ProjectData it2 = (ProjectData)iterator.next();
                $i$a$-maxOfOrNull-AutoImportProjectTracker$scheduleDelayedProjectReload$smartProjectReloadDelay$1 = false;
                Duration duration2 = it2.projectAware.getSmartProjectReloadDelay-FghU774();
                Comparable comparable3 = (Comparable)Duration.box-impl((long)(duration2 != null ? duration2.unbox-impl() : AutoImportProjectTrackerKt.access$getDEFAULT_SMART_PROJECT_RELOAD_DELAY$p()));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Duration duration = (Duration)comparable;
        long smartProjectReloadDelay = duration != null ? duration.unbox-impl() : AutoImportProjectTrackerKt.access$getDEFAULT_SMART_PROJECT_RELOAD_DELAY$p();
        int smartProjectReloadDispatcherIterations = (int)Duration.div-LRDsOJo((long)Duration.minus-LRDsOJo((long)smartProjectReloadDelay, (long)AutoImportProjectTrackerKt.access$getMERGING_TIME_SPAN$p()), (long)AutoImportProjectTrackerKt.access$getMERGING_TIME_SPAN$p());
        int dispatchIterations = Math.max(smartProjectReloadDispatcherIterations, 1);
        this.schedule(2, dispatchIterations, (Function0<Unit>)((Function0)() -> AutoImportProjectTracker.scheduleDelayedProjectReload$lambda$1(this, projectsToReload)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void schedule(int priority, int dispatchIterations, Function0<Unit> action2) {
        Lock lock = this.currentActivityLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.currentActivity == null) {
                this.currentActivity = ProjectInitializationDiagnosticService.registerTracker((Project)this.project, (String)"AutoImportProjectTracker.schedule");
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        MergingQueueUtil.queueTracked((MergingUpdateQueue)this.dispatcher, (Update)PriorityEatUpdate.Companion.invoke(priority, (Function0<Unit>)((Function0)() -> AutoImportProjectTracker.schedule$lambda$1(this, dispatchIterations, priority, action2))));
    }

    private final void processChanges(boolean isExplicitReload) {
        LOG.debug("Process changes (isExplicitReload=" + isExplicitReload + ")");
        ArrayList<Pair> projectsToReload = new ArrayList<Pair>();
        Iterator<ProjectData> iterator = this.projectDataMap.values().iterator();
        while (iterator.hasNext()) {
            ProjectData projectData;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            ProjectReloadContext context = new ProjectReloadContext(isExplicitReload, !projectData.status.isUpToDate(), projectData.settingsTracker.getSettingsContext());
            ExternalSystemProjectId projectId = projectData.projectAware.getProjectId();
            if (projectData.isUpToDate()) {
                LOG.debug(projectId + ": Skip project reload (UpToDate)");
                this.notificationAware.notificationExpire(projectId);
                continue;
            }
            if (this.isDisabledReload(projectData, context)) {
                LOG.debug(projectId + ": Skip project reload (disabled)");
                this.notificationAware.notificationExpire(projectId);
                continue;
            }
            if (!isExplicitReload && this.isDisabledAutoReload(projectData, context)) {
                LOG.debug(projectId + ": Skip project auto-reload (disabled)");
                this.notificationAware.notificationNotify(projectData.projectAware);
                continue;
            }
            LOG.debug(projectId + ": Schedule project reload");
            this.notificationAware.notificationExpire(projectId);
            projectsToReload.add(TuplesKt.to((Object)projectData.projectAware, (Object)context));
        }
        if (projectsToReload.isEmpty()) {
            LOG.debug("Skip all project reloads");
        } else if (isExplicitReload) {
            this.reloadProject((List<? extends Pair<? extends ExternalSystemProjectAware, ? extends ExternalSystemProjectReloadContext>>)projectsToReload);
        } else {
            this.scheduleDelayedProjectReload((List<? extends Pair<? extends ExternalSystemProjectAware, ? extends ExternalSystemProjectReloadContext>>)projectsToReload);
        }
    }

    private final void reloadProject(List<? extends Pair<? extends ExternalSystemProjectAware, ? extends ExternalSystemProjectReloadContext>> projectsToReload) {
        LOG.debug("Reload projects");
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> AutoImportProjectTracker.reloadProject$lambda$0(projectsToReload), (int)1, null);
    }

    private final boolean isDisabledReload(ProjectData projectData, ExternalSystemProjectReloadContext context) {
        ExternalSystemProjectId projectId = projectData.projectAware.getProjectId();
        if (!AutoImportProjectTracker.Companion.isEnabledReload()) {
            LOG.debug(projectId + ": Disabled reload (global property)");
            return true;
        }
        if (!projectData.isActivated()) {
            LOG.debug(projectId + ": Disabled reload (activation)");
            return true;
        }
        if (OperationUtilKt.isOperationInProgress((ObservableOperationTrace)((ObservableOperationTrace)this.projectChangeOperation))) {
            LOG.debug(projectId + ": Disabled reload (project change)");
            return true;
        }
        if (OperationUtilKt.isOperationInProgress((ObservableOperationTrace)((ObservableOperationTrace)projectData.reloadOperation))) {
            LOG.debug(projectId + ": Disabled reload (project reload)");
            return true;
        }
        if (projectData.projectAware.isDisabledReload(context)) {
            LOG.debug(projectId + ": Disabled reload (custom)");
            return true;
        }
        return false;
    }

    private final boolean isDisabledAutoReload(ProjectData projectData, ExternalSystemProjectReloadContext context) {
        ExternalSystemProjectId projectId = projectData.projectAware.getProjectId();
        if (!AutoImportProjectTracker.Companion.isEnabledAutoReload()) {
            LOG.debug(projectId + ": Disabled auto-reload (global property)");
            return true;
        }
        if (this.isProjectLookupActivateProperty.get().booleanValue()) {
            LOG.debug(projectId + ": Disabled auto-reload (project lookup)");
            return true;
        }
        ExternalSystemProjectTrackerSettings.AutoReloadType autoReloadType = this.settings.getAutoReloadType();
        ExternalSystemModificationType modificationType = projectData.getModificationType();
        boolean isDisabledAutoReload = switch (WhenMappings.$EnumSwitchMapping$1[autoReloadType.ordinal()]) {
            case 1 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[modificationType.ordinal()]) {
                    case 1: {
                        yield false;
                    }
                    case 2: {
                        yield false;
                    }
                    case 3: {
                        yield true;
                    }
                    case 4: {
                        yield true;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[modificationType.ordinal()]) {
                    case 1: {
                        yield false;
                    }
                    case 2: {
                        yield true;
                    }
                    case 3: {
                        yield true;
                    }
                    case 4: {
                        yield true;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (isDisabledAutoReload) {
            LOG.debug(projectId + ": Disabled auto-reload (" + autoReloadType + ", " + modificationType + ")");
            return true;
        }
        if (projectData.projectAware.isDisabledAutoReload(context)) {
            LOG.debug(projectId + ": Disabled auto-reload (custom)");
            return true;
        }
        return false;
    }

    public void register(@NotNull ExternalSystemProjectAware projectAware) {
        Intrinsics.checkNotNullParameter((Object)projectAware, (String)"projectAware");
        ExternalSystemProjectId projectId = projectAware.getProjectId();
        AtomicBooleanProperty activationProperty = new AtomicBooleanProperty(false);
        AtomicOperationTrace reloadOperation = new AtomicOperationTrace("Reload " + projectId);
        ProjectStatus projectStatus = new ProjectStatus(projectId.toString());
        Disposable disposable = Disposer.newDisposable((Disposable)this.serviceDisposable, (String)projectId.toString());
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable parentDisposable = disposable;
        ProjectSettingsTracker settingsTracker = new ProjectSettingsTracker(this.project, this, this.backgroundExecutor, projectAware, parentDisposable);
        ProjectData projectData = new ProjectData(projectStatus, (MutableBooleanProperty)activationProperty, (MutableOperationTrace)reloadOperation, projectAware, settingsTracker, parentDisposable);
        ((Map)this.projectDataMap).put(projectId, projectData);
        settingsTracker.beforeApplyChanges(parentDisposable, (Function0<Unit>)((Function0)() -> AutoImportProjectTracker.register$lambda$0(reloadOperation)));
        settingsTracker.afterApplyChanges(parentDisposable, (Function0<Unit>)((Function0)() -> AutoImportProjectTracker.register$lambda$1(reloadOperation)));
        ListenerUtilKt.whenPropertySet((ObservableBooleanProperty)((ObservableBooleanProperty)activationProperty), (Disposable)parentDisposable, () -> AutoImportProjectTracker.register$lambda$2(projectId, this));
        ObservableOperationTraceUtil.whenOperationStarted((ObservableOperationTrace)((ObservableOperationTrace)reloadOperation), (Disposable)this.serviceDisposable, () -> AutoImportProjectTracker.register$lambda$3(projectId, this));
        ObservableOperationTraceUtil.whenOperationFinished((ObservableOperationTrace)((ObservableOperationTrace)reloadOperation), (Disposable)this.serviceDisposable, () -> AutoImportProjectTracker.register$lambda$4(projectId, this));
        projectAware.subscribe((ExternalSystemProjectListener)this.createProjectReloadListener(projectData), parentDisposable);
        DisposerUtilKt.whenDisposed((Disposable)parentDisposable, () -> AutoImportProjectTracker.register$lambda$5(this, projectId));
        this.loadState(projectId, projectData);
    }

    public void activate(@NotNull ExternalSystemProjectId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ProjectData projectData = this.projectDataMap(id, (Function2<? super Map<ExternalSystemProjectId, ProjectData>, ? super ExternalSystemProjectId, ProjectData>)((Function2)AutoImportProjectTracker::activate$lambda$0));
        if (projectData == null) {
            return;
        }
        ProjectData projectData2 = projectData;
        projectData2.setActivated(true);
    }

    public void remove(@NotNull ExternalSystemProjectId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ProjectData projectData = this.projectDataMap.remove(id);
        if (projectData == null) {
            return;
        }
        ProjectData projectData2 = projectData;
        Disposer.dispose((Disposable)projectData2.parentDisposable);
    }

    public void markDirty(@NotNull ExternalSystemProjectId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ProjectData projectData = this.projectDataMap(id, (Function2<? super Map<ExternalSystemProjectId, ProjectData>, ? super ExternalSystemProjectId, ProjectData>)((Function2)AutoImportProjectTracker::markDirty$lambda$0));
        if (projectData == null) {
            return;
        }
        ProjectData projectData2 = projectData;
        ProjectStatus.markDirty$default(projectData2.status, ProjectStatus.Stamp.Companion.nextStamp(), null, 2, null);
    }

    public void markDirtyAllProjects() {
        ProjectStatus.Stamp modificationTimeStamp = ProjectStatus.Stamp.Companion.nextStamp();
        Iterator<ProjectData> iterator = this.projectDataMap.values().iterator();
        while (iterator.hasNext()) {
            ProjectData projectData;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            ProjectStatus.markDirty$default(projectData.status, modificationTimeStamp, null, 2, null);
        }
    }

    private final ProjectData projectDataMap(ExternalSystemProjectId id, Function2<? super Map<ExternalSystemProjectId, ProjectData>, ? super ExternalSystemProjectId, ProjectData> action2) {
        ProjectData projectData = (ProjectData)action2.invoke(this.projectDataMap, (Object)id);
        if (projectData == null) {
            String string = "Project isn't registered by id=%s";
            Object[] objectArray = new Object[]{id};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            LOG.warn(string2, new Throwable());
        }
        return projectData;
    }

    @NotNull
    public State getState() {
        TreeMap<Object, TreeMap> systemStates = new TreeMap<Object, TreeMap>();
        for (Map.Entry entry : ((Map)this.projectDataMap).entrySet()) {
            TreeMap projectStates;
            ExternalSystemProjectId projectId = (ExternalSystemProjectId)entry.getKey();
            ProjectData projectData = (ProjectData)entry.getValue();
            ProjectSystemId systemId = projectId.component1();
            String externalProjectPath = projectId.component2();
            Intrinsics.checkNotNullExpressionValue((Object)systemStates.computeIfAbsent(systemId.getId(), arg_0 -> AutoImportProjectTracker.getState$lambda$1(AutoImportProjectTracker::getState$lambda$0, arg_0)), (String)"computeIfAbsent(...)");
            ((Map)projectStates).put(externalProjectPath, new ProjectDataState(projectData.status.isDirty(), projectData.settingsTracker.getState()));
        }
        return new State((Map<String, ? extends Map<String, ProjectDataState>>)systemStates);
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        for (Map.Entry<String, Map<String, ProjectDataState>> entry : state.projectData.entrySet()) {
            String systemId = entry.getKey();
            Map<String, ProjectDataState> systemData = entry.getValue();
            for (Map.Entry entry2 : systemData.entrySet()) {
                String externalProjectPath = (String)entry2.getKey();
                ProjectDataState projectData = (ProjectDataState)entry2.getValue();
                ExternalSystemProjectId projectId = new ExternalSystemProjectId(new ProjectSystemId(systemId), externalProjectPath);
                ((Map)this.projectDataStates).put(projectId, projectData);
            }
        }
        Map $this$forEach$iv = this.projectDataMap;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            Map.Entry entry = element$iv;
            boolean bl = false;
            ExternalSystemProjectId id = (ExternalSystemProjectId)entry.getKey();
            ProjectData data = (ProjectData)entry.getValue();
            this.loadState(id, data);
        }
    }

    private final void loadState(ExternalSystemProjectId projectId, ProjectData projectData) {
        ProjectSettingsTracker.State settingsTrackerState;
        ProjectDataState projectState;
        ProjectDataState projectDataState = projectState = this.projectDataStates.remove(projectId);
        ProjectSettingsTracker.State state = settingsTrackerState = projectDataState != null ? projectDataState.settingsTracker : null;
        if (settingsTrackerState == null || projectState.isDirty) {
            projectData.status.markDirty(ProjectStatus.Stamp.Companion.nextStamp(), ExternalSystemModificationType.EXTERNAL);
            this.scheduleChangeProcessing();
            return;
        }
        projectData.settingsTracker.loadState(settingsTrackerState);
        projectData.settingsTracker.refreshChanges();
    }

    @TestOnly
    @NotNull
    public final Set<ExternalSystemProjectId> getActivatedProjects() {
        Collection<ProjectData> collection = this.projectDataMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), AutoImportProjectTracker::getActivatedProjects$lambda$0), AutoImportProjectTracker::getActivatedProjects$lambda$1));
    }

    @TestOnly
    public final void setDispatcherMergingSpan(int delay) {
        this.dispatcher.setMergingTimeSpan(delay);
    }

    private static final void createProjectCompletionListener$lambda$0(AutoImportProjectTracker this$0, Lookup lookup, Lookup newLookup) {
        this$0.isProjectLookupActivateProperty.set(newLookup != null);
    }

    private static final Unit scheduleProjectRefresh$lambda$0(AutoImportProjectTracker this$0) {
        this$0.processChanges(true);
        return Unit.INSTANCE;
    }

    private static final Unit scheduleChangeProcessing$lambda$0(AutoImportProjectTracker this$0) {
        this$0.processChanges(false);
        return Unit.INSTANCE;
    }

    private static final Unit scheduleDelayedProjectReload$lambda$1(AutoImportProjectTracker this$0, List $projectsToReload) {
        this$0.reloadProject($projectsToReload);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit schedule$lambda$1$0(int $dispatchIterations, AutoImportProjectTracker this$0, int $priority, Function0 $action) {
        if ($dispatchIterations - 1 > 0) {
            this$0.schedule($priority, $dispatchIterations - 1, (Function0<Unit>)$action);
        } else {
            $action.invoke();
            if (this$0.dispatcher.isEmpty()) {
                Lock lock = this$0.currentActivityLock;
                lock.lock();
                try {
                    boolean bl = false;
                    ProjectInitializationDiagnosticService.ActivityTracker activityTracker = this$0.currentActivity;
                    if (activityTracker != null) {
                        activityTracker.activityFinished();
                    }
                    this$0.currentActivity = null;
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit schedule$lambda$1(AutoImportProjectTracker this$0, int $dispatchIterations, int $priority, Function0 $action) {
        TrackingUtil.trackActivityBlocking((Project)this$0.project, (ActivityKey)((ActivityKey)ExternalSystemActivityKey.INSTANCE), () -> AutoImportProjectTracker.schedule$lambda$1$0($dispatchIterations, this$0, $priority, $action));
        return Unit.INSTANCE;
    }

    private static final Unit reloadProject$lambda$0(List $projectsToReload) {
        for (Pair pair : $projectsToReload) {
            ExternalSystemProjectAware projectAware = (ExternalSystemProjectAware)pair.component1();
            ExternalSystemProjectReloadContext context = (ExternalSystemProjectReloadContext)pair.component2();
            LOG.debug(projectAware.getProjectId() + ": reload project");
            projectAware.reloadProject(context);
        }
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$0(AtomicOperationTrace $reloadOperation) {
        MutableOperationTrace.traceStart$default((MutableOperationTrace)((MutableOperationTrace)$reloadOperation), null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$1(AtomicOperationTrace $reloadOperation) {
        MutableOperationTrace.traceFinish$default((MutableOperationTrace)((MutableOperationTrace)$reloadOperation), null, null, (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$2(ExternalSystemProjectId $projectId, AutoImportProjectTracker this$0) {
        LOG.debug($projectId + " is activated");
        this$0.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$3(ExternalSystemProjectId $projectId, AutoImportProjectTracker this$0) {
        LOG.debug($projectId + ": Detected project reload start event");
        this$0.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$4(ExternalSystemProjectId $projectId, AutoImportProjectTracker this$0) {
        LOG.debug($projectId + ": Detected project reload finish event");
        this$0.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$5(AutoImportProjectTracker this$0, ExternalSystemProjectId $projectId) {
        this$0.notificationAware.notificationExpire($projectId);
        return Unit.INSTANCE;
    }

    private static final ProjectData activate$lambda$0(Map $this$projectDataMap, ExternalSystemProjectId it) {
        Intrinsics.checkNotNullParameter((Object)$this$projectDataMap, (String)"$this$projectDataMap");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ProjectData)$this$projectDataMap.get(it);
    }

    private static final ProjectData markDirty$lambda$0(Map $this$projectDataMap, ExternalSystemProjectId it) {
        Intrinsics.checkNotNullParameter((Object)$this$projectDataMap, (String)"$this$projectDataMap");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ProjectData)$this$projectDataMap.get(it);
    }

    private static final TreeMap getState$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new TreeMap();
    }

    private static final TreeMap getState$lambda$1(Function1 $tmp0, Object p0) {
        return (TreeMap)$tmp0.invoke(p0);
    }

    private static final boolean getActivatedProjects$lambda$0(ProjectData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isActivated();
    }

    private static final ExternalSystemProjectId getActivatedProjects$lambda$1(ProjectData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.projectAware.getProjectId();
    }

    private static final Unit _init_$lambda$0(AutoImportProjectTracker this$0) {
        LOG.debug("Detected project change start event");
        this$0.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(AutoImportProjectTracker this$0) {
        LOG.debug("Detected project change finish event");
        this$0.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(AutoImportProjectTracker this$0) {
        LOG.debug("Detected project lookup start event");
        this$0.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(AutoImportProjectTracker this$0) {
        LOG.debug("Detected project lookup finish event");
        this$0.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(AutoImportProjectTracker this$0, ExternalSystemProjectTrackerSettings.AutoReloadType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LOG.debug("Detected project reload type change event");
        this$0.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(AutoImportProjectTracker this$0, boolean it) {
        this$0.dispatcher.setPassThrough(!it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AtomicOperationTrace access$getProjectChangeOperation$p(AutoImportProjectTracker $this) {
        return $this.projectChangeOperation;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        onceIgnoreDisableReloadRegistryProperty = new AtomicBooleanProperty(false);
        enableReloadProperty = new AtomicBooleanProperty(!ApplicationKt.getApplication().isUnitTestMode());
        enableAutoReloadProperty = new AtomicBooleanProperty(!ApplicationKt.getApplication().isUnitTestMode());
        asyncChangesProcessingProperty = new AtomicBooleanProperty(!ApplicationKt.getApplication().isHeadlessEnvironment() || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode() || Boolean.getBoolean("external.system.auto.import.headless.async"));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\u001d\u001a\u00020\u0018H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0012*\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;", "project", "Lcom/intellij/openapi/project/Project;", "onceIgnoreDisableReloadRegistryProperty", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "enableReloadProperty", "enableAutoReloadProperty", "asyncChangesProcessingProperty", "isEnabledReload", "", "()Z", "isEnabledAutoReload", "isAsyncChangesProcessing", "isAsyncChangesProcessing$delegate", "(Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$Companion;)Ljava/lang/Object;", "enableReloadInTests", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "enableAutoReloadInTests", "enableAsyncAutoReloadInTests", "onceIgnoreDisableAutoReloadRegistry", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final AutoImportProjectTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExternalSystemProjectTracker externalSystemProjectTracker = ExternalSystemProjectTracker.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)externalSystemProjectTracker, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker");
            return (AutoImportProjectTracker)externalSystemProjectTracker;
        }

        private final boolean isEnabledReload() {
            return enableReloadProperty.get() != false && (onceIgnoreDisableReloadRegistryProperty.getAndSet(false) || !Registry.Companion.is("external.system.auto.import.disabled"));
        }

        private final boolean isEnabledAutoReload() {
            return this.isEnabledReload() && enableAutoReloadProperty.get() != false;
        }

        public final boolean isAsyncChangesProcessing() {
            return (Boolean)asyncChangesProcessingProperty.getValue((Object)this, $$delegatedProperties[0]);
        }

        private static Object isAsyncChangesProcessing$delegate(Companion companion) {
            return asyncChangesProcessingProperty;
        }

        @TestOnly
        public final void enableReloadInTests(@NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            RevertPropertyOnDisposeUtilKt.setObservableProperty((ObservableMutableProperty)((ObservableMutableProperty)enableReloadProperty), (Object)true, (Disposable)parentDisposable);
        }

        @TestOnly
        public final void enableAutoReloadInTests(@NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            RevertPropertyOnDisposeUtilKt.setObservableProperty((ObservableMutableProperty)((ObservableMutableProperty)enableReloadProperty), (Object)true, (Disposable)parentDisposable);
            RevertPropertyOnDisposeUtilKt.setObservableProperty((ObservableMutableProperty)((ObservableMutableProperty)enableAutoReloadProperty), (Object)true, (Disposable)parentDisposable);
        }

        @TestOnly
        public final void enableAsyncAutoReloadInTests(@NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            RevertPropertyOnDisposeUtilKt.setObservableProperty((ObservableMutableProperty)((ObservableMutableProperty)asyncChangesProcessingProperty), (Object)true, (Disposable)parentDisposable);
        }

        @ApiStatus.Internal
        public final void onceIgnoreDisableAutoReloadRegistry() {
            onceIgnoreDisableReloadRegistryProperty.set(true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "isAsyncChangesProcessing", "isAsyncChangesProcessing()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c6\u0003JE\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0014\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004J\n\u0010&\u001a\u00020'H\u00d6\u0081\u0004R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0012\u0010\u0015\"\u0004\b\u0016\u0010\u0017*\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectData;", "", "status", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;", "activationProperty", "Lcom/intellij/openapi/observable/properties/MutableBooleanProperty;", "reloadOperation", "Lcom/intellij/openapi/observable/operation/core/MutableOperationTrace;", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "settingsTracker", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;Lcom/intellij/openapi/observable/properties/MutableBooleanProperty;Lcom/intellij/openapi/observable/operation/core/MutableOperationTrace;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;Lcom/intellij/openapi/Disposable;)V", "<set-?>", "", "isActivated", "isActivated$delegate", "(Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectData;)Ljava/lang/Object;", "()Z", "setActivated", "(Z)V", "isUpToDate", "getModificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
    private static final class ProjectData {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @JvmField
        @NotNull
        public final ProjectStatus status;
        @JvmField
        @NotNull
        public final MutableBooleanProperty activationProperty;
        @JvmField
        @NotNull
        public final MutableOperationTrace reloadOperation;
        @JvmField
        @NotNull
        public final ExternalSystemProjectAware projectAware;
        @JvmField
        @NotNull
        public final ProjectSettingsTracker settingsTracker;
        @JvmField
        @NotNull
        public final Disposable parentDisposable;

        public ProjectData(@NotNull ProjectStatus status, @NotNull MutableBooleanProperty activationProperty, @NotNull MutableOperationTrace reloadOperation, @NotNull ExternalSystemProjectAware projectAware, @NotNull ProjectSettingsTracker settingsTracker, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)activationProperty, (String)"activationProperty");
            Intrinsics.checkNotNullParameter((Object)reloadOperation, (String)"reloadOperation");
            Intrinsics.checkNotNullParameter((Object)projectAware, (String)"projectAware");
            Intrinsics.checkNotNullParameter((Object)settingsTracker, (String)"settingsTracker");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.status = status;
            this.activationProperty = activationProperty;
            this.reloadOperation = reloadOperation;
            this.projectAware = projectAware;
            this.settingsTracker = settingsTracker;
            this.parentDisposable = parentDisposable;
        }

        public final boolean isActivated() {
            return (Boolean)this.activationProperty.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setActivated(boolean bl) {
            this.activationProperty.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        private static Object isActivated$delegate(ProjectData projectData) {
            return projectData.activationProperty;
        }

        public final boolean isUpToDate() {
            return this.status.isUpToDate() && this.settingsTracker.isUpToDate();
        }

        @NotNull
        public final ExternalSystemModificationType getModificationType() {
            return ProjectStatus.Companion.merge(this.status.getModificationType(), this.settingsTracker.getModificationType());
        }

        @NotNull
        public final ProjectStatus component1() {
            return this.status;
        }

        @NotNull
        public final MutableBooleanProperty component2() {
            return this.activationProperty;
        }

        @NotNull
        public final MutableOperationTrace component3() {
            return this.reloadOperation;
        }

        @NotNull
        public final ExternalSystemProjectAware component4() {
            return this.projectAware;
        }

        @NotNull
        public final ProjectSettingsTracker component5() {
            return this.settingsTracker;
        }

        @NotNull
        public final Disposable component6() {
            return this.parentDisposable;
        }

        @NotNull
        public final ProjectData copy(@NotNull ProjectStatus status, @NotNull MutableBooleanProperty activationProperty, @NotNull MutableOperationTrace reloadOperation, @NotNull ExternalSystemProjectAware projectAware, @NotNull ProjectSettingsTracker settingsTracker, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)activationProperty, (String)"activationProperty");
            Intrinsics.checkNotNullParameter((Object)reloadOperation, (String)"reloadOperation");
            Intrinsics.checkNotNullParameter((Object)projectAware, (String)"projectAware");
            Intrinsics.checkNotNullParameter((Object)settingsTracker, (String)"settingsTracker");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            return new ProjectData(status, activationProperty, reloadOperation, projectAware, settingsTracker, parentDisposable);
        }

        public static /* synthetic */ ProjectData copy$default(ProjectData projectData, ProjectStatus projectStatus, MutableBooleanProperty mutableBooleanProperty, MutableOperationTrace mutableOperationTrace, ExternalSystemProjectAware externalSystemProjectAware, ProjectSettingsTracker projectSettingsTracker, Disposable disposable, int n, Object object) {
            if ((n & 1) != 0) {
                projectStatus = projectData.status;
            }
            if ((n & 2) != 0) {
                mutableBooleanProperty = projectData.activationProperty;
            }
            if ((n & 4) != 0) {
                mutableOperationTrace = projectData.reloadOperation;
            }
            if ((n & 8) != 0) {
                externalSystemProjectAware = projectData.projectAware;
            }
            if ((n & 0x10) != 0) {
                projectSettingsTracker = projectData.settingsTracker;
            }
            if ((n & 0x20) != 0) {
                disposable = projectData.parentDisposable;
            }
            return projectData.copy(projectStatus, mutableBooleanProperty, mutableOperationTrace, externalSystemProjectAware, projectSettingsTracker, disposable);
        }

        @NotNull
        public String toString() {
            return "ProjectData(status=" + this.status + ", activationProperty=" + this.activationProperty + ", reloadOperation=" + this.reloadOperation + ", projectAware=" + this.projectAware + ", settingsTracker=" + this.settingsTracker + ", parentDisposable=" + this.parentDisposable + ")";
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + this.activationProperty.hashCode();
            result = result * 31 + this.reloadOperation.hashCode();
            result = result * 31 + this.projectAware.hashCode();
            result = result * 31 + this.settingsTracker.hashCode();
            result = result * 31 + this.parentDisposable.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectData)) {
                return false;
            }
            ProjectData projectData = (ProjectData)other;
            if (!Intrinsics.areEqual((Object)this.status, (Object)projectData.status)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.activationProperty, (Object)projectData.activationProperty)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.reloadOperation, (Object)projectData.reloadOperation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectAware, (Object)projectData.projectAware)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.settingsTracker, (Object)projectData.settingsTracker)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parentDisposable, (Object)projectData.parentDisposable);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ProjectData.class, "isActivated", "isActivated()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Serializable
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B-\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectDataState;", "", "isDirty", "", "settingsTracker", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "<init>", "(ZLcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IZLcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_externalSystem_impl", "$serializer", "Companion", "intellij.platform.externalSystem.impl"})
    public static final class ProjectDataState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        public final boolean isDirty;
        @JvmField
        @Nullable
        public final ProjectSettingsTracker.State settingsTracker;

        public ProjectDataState(boolean isDirty, @Nullable ProjectSettingsTracker.State settingsTracker) {
            this.isDirty = isDirty;
            this.settingsTracker = settingsTracker;
        }

        public /* synthetic */ ProjectDataState(boolean bl, ProjectSettingsTracker.State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                state = null;
            }
            this(bl, state);
        }

        public final boolean component1() {
            return this.isDirty;
        }

        @Nullable
        public final ProjectSettingsTracker.State component2() {
            return this.settingsTracker;
        }

        @NotNull
        public final ProjectDataState copy(boolean isDirty, @Nullable ProjectSettingsTracker.State settingsTracker) {
            return new ProjectDataState(isDirty, settingsTracker);
        }

        public static /* synthetic */ ProjectDataState copy$default(ProjectDataState projectDataState, boolean bl, ProjectSettingsTracker.State state, int n, Object object) {
            if ((n & 1) != 0) {
                bl = projectDataState.isDirty;
            }
            if ((n & 2) != 0) {
                state = projectDataState.settingsTracker;
            }
            return projectDataState.copy(bl, state);
        }

        @NotNull
        public String toString() {
            return "ProjectDataState(isDirty=" + this.isDirty + ", settingsTracker=" + this.settingsTracker + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isDirty);
            result = result * 31 + (this.settingsTracker == null ? 0 : this.settingsTracker.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectDataState)) {
                return false;
            }
            ProjectDataState projectDataState = (ProjectDataState)other;
            if (this.isDirty != projectDataState.isDirty) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.settingsTracker, (Object)projectDataState.settingsTracker);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_externalSystem_impl(ProjectDataState self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.isDirty) {
                output.encodeBooleanElement(serialDesc, 0, self.isDirty);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.settingsTracker != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)ProjectSettingsTracker$State$.serializer.INSTANCE, (Object)self.settingsTracker);
            }
        }

        public /* synthetic */ ProjectDataState(int seen0, boolean isDirty, ProjectSettingsTracker.State settingsTracker, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)ProjectDataState$$serializer.INSTANCE.getDescriptor());
            }
            this.isDirty = (seen0 & 1) == 0 ? false : isDirty;
            this.settingsTracker = (seen0 & 2) == 0 ? null : settingsTracker;
        }

        public ProjectDataState() {
            this(false, null, 3, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectDataState$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectDataState;", "intellij.platform.externalSystem.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ProjectDataState> serializer() {
                return (KSerializer)ProjectDataState$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectReloadContext;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "isExplicitReload", "", "hasUndefinedModifications", "settingsFilesContext", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;", "<init>", "(ZZLcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;)V", "()Z", "getHasUndefinedModifications", "getSettingsFilesContext", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
    private static final class ProjectReloadContext
    implements ExternalSystemProjectReloadContext {
        private final boolean isExplicitReload;
        private final boolean hasUndefinedModifications;
        @NotNull
        private final ExternalSystemSettingsFilesReloadContext settingsFilesContext;

        public ProjectReloadContext(boolean isExplicitReload, boolean hasUndefinedModifications, @NotNull ExternalSystemSettingsFilesReloadContext settingsFilesContext) {
            Intrinsics.checkNotNullParameter((Object)settingsFilesContext, (String)"settingsFilesContext");
            this.isExplicitReload = isExplicitReload;
            this.hasUndefinedModifications = hasUndefinedModifications;
            this.settingsFilesContext = settingsFilesContext;
        }

        public boolean isExplicitReload() {
            return this.isExplicitReload;
        }

        public boolean getHasUndefinedModifications() {
            return this.hasUndefinedModifications;
        }

        @NotNull
        public ExternalSystemSettingsFilesReloadContext getSettingsFilesContext() {
            return this.settingsFilesContext;
        }

        public final boolean component1() {
            return this.isExplicitReload;
        }

        public final boolean component2() {
            return this.hasUndefinedModifications;
        }

        @NotNull
        public final ExternalSystemSettingsFilesReloadContext component3() {
            return this.settingsFilesContext;
        }

        @NotNull
        public final ProjectReloadContext copy(boolean isExplicitReload, boolean hasUndefinedModifications, @NotNull ExternalSystemSettingsFilesReloadContext settingsFilesContext) {
            Intrinsics.checkNotNullParameter((Object)settingsFilesContext, (String)"settingsFilesContext");
            return new ProjectReloadContext(isExplicitReload, hasUndefinedModifications, settingsFilesContext);
        }

        public static /* synthetic */ ProjectReloadContext copy$default(ProjectReloadContext projectReloadContext, boolean bl, boolean bl2, ExternalSystemSettingsFilesReloadContext externalSystemSettingsFilesReloadContext, int n, Object object) {
            if ((n & 1) != 0) {
                bl = projectReloadContext.isExplicitReload;
            }
            if ((n & 2) != 0) {
                bl2 = projectReloadContext.hasUndefinedModifications;
            }
            if ((n & 4) != 0) {
                externalSystemSettingsFilesReloadContext = projectReloadContext.settingsFilesContext;
            }
            return projectReloadContext.copy(bl, bl2, externalSystemSettingsFilesReloadContext);
        }

        @NotNull
        public String toString() {
            return "ProjectReloadContext(isExplicitReload=" + this.isExplicitReload + ", hasUndefinedModifications=" + this.hasUndefinedModifications + ", settingsFilesContext=" + this.settingsFilesContext + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isExplicitReload);
            result = result * 31 + Boolean.hashCode(this.hasUndefinedModifications);
            result = result * 31 + this.settingsFilesContext.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectReloadContext)) {
                return false;
            }
            ProjectReloadContext projectReloadContext = (ProjectReloadContext)other;
            if (this.isExplicitReload != projectReloadContext.isExplicitReload) {
                return false;
            }
            if (this.hasUndefinedModifications != projectReloadContext.hasUndefinedModifications) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.settingsFilesContext, (Object)projectReloadContext.settingsFilesContext);
        }
    }

    @Serializable
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB)\u0012 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B=\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012 \u0010\u0002\u001a\u001c\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ!\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0003H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0004H\u00d6\u0081\u0004J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bR(\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State;", "", "projectData", "", "", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectDataState;", "<init>", "(Ljava/util/Map;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_externalSystem_impl", "$serializer", "Companion", "intellij.platform.externalSystem.impl"})
    public static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final Map<String, Map<String, ProjectDataState>> projectData;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public State(@NotNull Map<String, ? extends Map<String, ProjectDataState>> projectData) {
            Intrinsics.checkNotNullParameter(projectData, (String)"projectData");
            this.projectData = projectData;
        }

        public /* synthetic */ State(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @NotNull
        public final Map<String, Map<String, ProjectDataState>> component1() {
            return this.projectData;
        }

        @NotNull
        public final State copy(@NotNull Map<String, ? extends Map<String, ProjectDataState>> projectData) {
            Intrinsics.checkNotNullParameter(projectData, (String)"projectData");
            return new State(projectData);
        }

        public static /* synthetic */ State copy$default(State state, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = state.projectData;
            }
            return state.copy(map);
        }

        @NotNull
        public String toString() {
            return "State(projectData=" + this.projectData + ")";
        }

        public int hashCode() {
            return ((Object)this.projectData).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return Intrinsics.areEqual(this.projectData, state.projectData);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_externalSystem_impl(State self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual(self.projectData, (Object)MapsKt.emptyMap())) {
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.projectData);
            }
        }

        public /* synthetic */ State(int seen0, Map projectData, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)State$$serializer.INSTANCE.getDescriptor());
            }
            this.projectData = (seen0 & 1) == 0 ? MapsKt.emptyMap() : projectData;
        }

        public State() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)ProjectDataState$$serializer.INSTANCE)))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State;", "intellij.platform.externalSystem.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<State> serializer() {
                return (KSerializer)State$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExternalSystemModificationType.values().length];
            try {
                nArray[ExternalSystemModificationType.EXTERNAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalSystemModificationType.INTERNAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalSystemModificationType.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalSystemModificationType.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ExternalSystemProjectTrackerSettings.AutoReloadType.values().length];
            try {
                nArray[ExternalSystemProjectTrackerSettings.AutoReloadType.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalSystemProjectTrackerSettings.AutoReloadType.SELECTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalSystemProjectTrackerSettings.AutoReloadType.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

