/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H$J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/NewFilesListener;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesListener;", "<init>", "()V", "fireNewFilesCreated", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "modifiedFiles", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "init", "apply", "isRelevant", "", "file", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "updateFile", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public abstract class NewFilesListener
implements VirtualFileChangesListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentLinkedQueue<VirtualFile> modifiedFiles = new ConcurrentLinkedQueue();

    protected abstract void fireNewFilesCreated(@NotNull Collection<? extends VirtualFile> var1);

    @Override
    public void init() {
        this.modifiedFiles.clear();
    }

    @Override
    public void apply() {
        ArrayList set = new ArrayList(this.modifiedFiles);
        if (!((Collection)set).isEmpty()) {
            this.fireNewFilesCreated(set);
        }
    }

    @Override
    public boolean isRelevant(@NotNull VirtualFile file, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return event instanceof VFileCopyEvent || event instanceof VFileCreateEvent || event instanceof VFileMoveEvent || event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename();
    }

    @Override
    public void updateFile(@NotNull VirtualFile file, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.modifiedFiles.add(file);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\u00020\u00052'\u0010\u0006\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/NewFilesListener$Companion;", "", "<init>", "()V", "whenNewFilesCreated", "", "action", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/ParameterName;", "name", "modifiedFiles", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void whenNewFilesCreated(@NotNull Function1<? super Collection<? extends VirtualFile>, Unit> action2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            NewFilesListener listener2 = new NewFilesListener(action2){
                final /* synthetic */ Function1<Collection<? extends VirtualFile>, Unit> $action;
                {
                    this.$action = $action;
                }

                protected void fireNewFilesCreated(Collection<? extends VirtualFile> files) {
                    Intrinsics.checkNotNullParameter(files, (String)"files");
                    this.$action.invoke(files);
                }
            };
            VirtualFileChangesListener.Companion.installAsyncVirtualFileListener(listener2, parentDisposable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

