/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DataWriterFilter;
import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStorage;
import com.intellij.openapi.externalSystem.configurationStore.PersistentMapManagerKt;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J$\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/FileSystemExternalSystemStorage;", "Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStorage;", "dirName", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "dir", "Ljava/nio/file/Path;", "getDir", "()Ljava/nio/file/Path;", "value", "", "hasSomeData", "getHasSomeData", "()Z", "nameToPath", "name", "remove", "", "read", "Lorg/jdom/Element;", "write", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "filter", "Lcom/intellij/configurationStore/DataWriterFilter;", "rename", "oldName", "newName", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nPersistentMapManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentMapManager.kt\ncom/intellij/openapi/externalSystem/configurationStore/FileSystemExternalSystemStorage\n+ 2 path.kt\ncom/intellij/util/io/PathKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n168#2,2:109\n171#2,3:114\n777#3:111\n873#3,2:112\n1915#3,2:117\n1#4:119\n*S KotlinDebug\n*F\n+ 1 PersistentMapManager.kt\ncom/intellij/openapi/externalSystem/configurationStore/FileSystemExternalSystemStorage\n*L\n54#1:109,2\n54#1:114,3\n55#1:111\n55#1:112,2\n57#1:117,2\n*E\n"})
public abstract class FileSystemExternalSystemStorage
implements ExternalSystemStorage {
    @NotNull
    private final Path dir;
    private boolean hasSomeData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public FileSystemExternalSystemStorage(@NotNull String dirName, @NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = ExternalProjectsDataStorage.getProjectConfigurationDir(project).resolve(dirName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.dir = path;
        BasicFileAttributes fileAttributes = PathKt.basicAttributesIfExists((Path)this.dir);
        FileSystemExternalSystemStorage fileSystemExternalSystemStorage = this;
        if (fileAttributes == null) {
            bl = false;
        } else if (fileAttributes.isRegularFile()) {
            Closeable children;
            Object object;
            Iterable $this$directoryStreamIfExists$iv;
            String prefix = ((Object)this.dir.getFileName()).toString();
            Path path2 = this.dir.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            Path path3 = path2;
            FileSystemExternalSystemStorage fileSystemExternalSystemStorage2 = fileSystemExternalSystemStorage;
            boolean $i$f$directoryStreamIfExists = false;
            try {
                Iterable stream;
                object = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv);
                Throwable throwable = null;
                try {
                    void $this$filterTo$iv$iv;
                    stream = (DirectoryStream)object;
                    boolean bl2 = false;
                    Iterable $this$filter$iv = stream;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Path it = (Path)element$iv$iv;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)prefix, (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    stream = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = stream;
            }
            catch (NoSuchFileException noSuchFileException) {
                object = null;
            }
            fileSystemExternalSystemStorage = fileSystemExternalSystemStorage2;
            Closeable closeable = children = object;
            if (closeable != null) {
                void $this$forEach$iv;
                $this$directoryStreamIfExists$iv = (Iterable)((Object)closeable);
                FileSystemExternalSystemStorage fileSystemExternalSystemStorage3 = fileSystemExternalSystemStorage;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it);
                    PathsKt.deleteRecursively((Path)it);
                }
                fileSystemExternalSystemStorage = fileSystemExternalSystemStorage3;
            }
            bl = false;
        } else {
            PersistentMapManagerKt.access$getLOG$p().assertTrue(fileAttributes.isDirectory());
            bl = true;
        }
        fileSystemExternalSystemStorage.hasSomeData = bl;
    }

    @NotNull
    protected final Path getDir() {
        return this.dir;
    }

    public final boolean getHasSomeData() {
        return this.hasSomeData;
    }

    @NotNull
    protected Path nameToPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path path = this.dir.resolve(name);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    public void remove(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.hasSomeData) {
            return;
        }
        PathsKt.deleteRecursively((Path)this.nameToPath(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element read(@NotNull String name) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.hasSomeData) {
            return null;
        }
        InputStream inputStream = PathKt.inputStreamIfExists((Path)this.nameToPath(name));
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Element element2 = JDOMUtil.load((InputStream)it);
                element = element2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            element = null;
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String name, @Nullable DataWriter dataWriter, @Nullable DataWriterFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (dataWriter == null || filter2 != null && !dataWriter.hasData(filter2)) {
            this.remove(name);
            return;
        }
        this.hasSomeData = true;
        Closeable closeable = PathKt.outputStream((Path)this.nameToPath(name));
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            dataWriter.writeTo(it, LineSeparator.LF, filter2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void rename(@NotNull String oldName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (!this.hasSomeData) {
            return;
        }
        Path oldFile = this.nameToPath(oldName);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(oldFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.move((Path)oldFile, (Path)this.nameToPath(newName));
        }
    }
}

