/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.dependency.analyzer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SplitAction;
import com.intellij.ide.plugins.UIComponentFileEditor;
import com.intellij.ide.plugins.UIComponentVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerView;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerViewImpl;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerVirtualFile;", "Lcom/intellij/ide/plugins/UIComponentVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;)V", "views", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerView;", "getViews", "", "createContent", "Lcom/intellij/ide/plugins/UIComponentVirtualFile$Content;", "editor", "Lcom/intellij/ide/plugins/UIComponentFileEditor;", "intellij.platform.externalSystem.impl"})
public final class DependencyAnalyzerVirtualFile
extends UIComponentVirtualFile {
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectSystemId systemId;
    @NotNull
    private final DisposableWrapperList<DependencyAnalyzerView> views;

    public DependencyAnalyzerVirtualFile(@NotNull Project project, @NotNull ProjectSystemId systemId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        super(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.editor.tab.name", (Object[])new Object[0]), AllIcons.Actions.DependencyAnalyzer);
        this.project = project;
        this.systemId = systemId;
        this.views = new DisposableWrapperList();
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
    }

    @NotNull
    public final List<DependencyAnalyzerView> getViews() {
        return CollectionsKt.toList((Iterable)((Iterable)this.views));
    }

    @NotNull
    public UIComponentVirtualFile.Content createContent(@NotNull UIComponentFileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        DependencyAnalyzerViewImpl view = new DependencyAnalyzerViewImpl(this.project, this.systemId, (Disposable)editor);
        this.views.add((Object)view, (Disposable)editor);
        return () -> DependencyAnalyzerVirtualFile.createContent$lambda$0(view);
    }

    private static final JComponent createContent$lambda$0(DependencyAnalyzerViewImpl $view) {
        return $view.createComponent();
    }
}

