/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildView;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.testframework.HistoryTestRunnableState;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskRunner;", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "getRunnerId", "", "Lorg/jetbrains/annotations/NotNull;", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "doExecute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemTaskRunner
implements ProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "ExternalSystemTaskRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof ExternalSystemRunConfiguration && Intrinsics.areEqual((Object)"Run", (Object)executorId);
    }

    public void execute(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = environment.getState();
        if (runProfileState == null) {
            return;
        }
        RunProfileState state = runProfileState;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ExecutionManager.Companion.getInstance(project).startRunProfile(environment, () -> ExternalSystemTaskRunner.execute$lambda$0(this, state, environment));
    }

    private final RunContentDescriptor doExecute(RunProfileState state, ExecutionEnvironment environment) {
        if (!(state instanceof ExternalSystemRunnableState) && !(state instanceof HistoryTestRunnableState)) {
            return null;
        }
        ExecutionResult executionResult = state.execute(environment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            return null;
        }
        ExecutionResult executionResult2 = executionResult;
        RunContentDescriptor runContentDescriptor = new RunContentBuilder(executionResult2, environment).showRunContent(environment.getContentToReuse());
        if (runContentDescriptor == null) {
            return null;
        }
        RunContentDescriptor runContentDescriptor2 = runContentDescriptor;
        if (state instanceof HistoryTestRunnableState) {
            return runContentDescriptor2;
        }
        ((ExternalSystemRunnableState)state).setContentDescriptor(runContentDescriptor2);
        if (executionResult2.getExecutionConsole() instanceof BuildView) {
            return runContentDescriptor2;
        }
        ExecutionConsole executionConsole = runContentDescriptor2.getExecutionConsole();
        ProcessHandler processHandler = runContentDescriptor2.getProcessHandler();
        JComponent jComponent = runContentDescriptor2.getComponent();
        String string = runContentDescriptor2.getDisplayName();
        Icon icon = runContentDescriptor2.getIcon();
        AnAction[] anActionArray = runContentDescriptor2.getRestartActions();
        RunContentDescriptor descriptor2 = new RunContentDescriptor(executionConsole, processHandler, jComponent, string, icon, anActionArray){

            public boolean isHiddenContent() {
                return true;
            }
        };
        descriptor2.setRunnerLayoutUi(runContentDescriptor2.getRunnerLayoutUi());
        return descriptor2;
    }

    private static final Promise execute$lambda$0(ExternalSystemTaskRunner this$0, RunProfileState $state, ExecutionEnvironment $environment) {
        return Promises.resolvedPromise((Object)this$0.doExecute($state, $environment));
    }
}

