/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleSdkData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/ModuleSdkDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleSdkData;", "Lcom/intellij/openapi/project/Project;", "<init>", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "importModuleSdk", "module", "Lcom/intellij/openapi/module/Module;", "sdkData", "useDefaultsIfCan", "", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nSdkDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkDataService.kt\ncom/intellij/openapi/externalSystem/service/project/manage/ModuleSdkDataService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class ModuleSdkDataService
extends AbstractProjectDataService<ModuleSdkData, Project> {
    @NotNull
    public Key<ModuleSdkData> getTargetDataKey() {
        return ModuleSdkData.KEY;
    }

    public void importData(@NotNull Collection<? extends DataNode<ModuleSdkData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (toImport.isEmpty() || projectData == null) {
            return;
        }
        boolean useDefaultsIfCan = ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)projectData, (Module[])modelsProvider.getModules());
        for (DataNode<ModuleSdkData> dataNode : toImport) {
            Module module;
            DataNode moduleNode;
            if (dataNode.getParent(ModuleData.class) == null || (Module)moduleNode.getUserData(AbstractModuleDataService.MODULE_KEY) == null) continue;
            Object object = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
            this.importModuleSdk(module, (ModuleSdkData)object, modelsProvider, useDefaultsIfCan);
        }
    }

    private final void importModuleSdk(Module module, ModuleSdkData sdkData, IdeModifiableModelsProvider modelsProvider, boolean useDefaultsIfCan) {
        Sdk sdk;
        String moduleSdkName = sdkData.getSdkName();
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectJdkTable, (String)"getInstance(...)");
        ProjectJdkTable projectJdkTable2 = projectJdkTable;
        String string = moduleSdkName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            sdk = projectJdkTable2.findJdk(moduleSdkName);
        } else {
            sdk = null;
        }
        Sdk sdk2 = sdk;
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableRootModel(...)");
        ModifiableRootModel modifiableRootModel2 = modifiableRootModel;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)module.getProject());
        Sdk projectSdk = projectRootManager.getProjectSdk();
        if (moduleSdkName == null) {
            modifiableRootModel2.inheritSdk();
        } else if (useDefaultsIfCan && Intrinsics.areEqual((Object)sdk2, (Object)projectSdk)) {
            modifiableRootModel2.inheritSdk();
        } else if (sdk2 == null) {
            modifiableRootModel2.setInvalidSdk(moduleSdkName, ExternalSystemBundle.message((String)"unknown.sdk.type", (Object[])new Object[0]));
        } else {
            modifiableRootModel2.setSdk(sdk2);
        }
    }
}

