/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui.completion;

import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.externalSystem.service.ui.completion.TextCompletionField;
import com.intellij.openapi.externalSystem.service.ui.completion.TextCompletionRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0005\u0015\u0016\u0017\u0018\u0019B;\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0014J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup;", "T", "Lcom/intellij/ui/popup/list/ListPopupImpl;", "project", "Lcom/intellij/openapi/project/Project;", "textComponent", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField;", "contributor", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Contributor;", "renderer", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionRenderer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField;Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Contributor;Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionRenderer;)V", "getListElementRenderer", "Ljavax/swing/ListCellRenderer;", "update", "", "showUnderneathOfTextComponent", "process", "aEvent", "Ljava/awt/event/KeyEvent;", "PopupStep", "Renderer", "Item", "Contributor", "Companion", "intellij.platform.externalSystem.impl"})
public final class TextCompletionPopup<T>
extends ListPopupImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextCompletionField<T> textComponent;
    @NotNull
    private final Contributor<T> contributor;
    @NotNull
    private final TextCompletionRenderer<T> renderer;
    private static final int MAX_COMPLETION_LIST_SIZE = 1000;

    public TextCompletionPopup(@Nullable Project project, @NotNull TextCompletionField<T> textComponent, @NotNull Contributor<T> contributor2, @NotNull TextCompletionRenderer<T> renderer) {
        Intrinsics.checkNotNullParameter(textComponent, (String)"textComponent");
        Intrinsics.checkNotNullParameter(contributor2, (String)"contributor");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        super(project, null, (ListPopupStep)new PopupStep<T>(contributor2), null);
        this.textComponent = textComponent;
        this.contributor = contributor2;
        this.renderer = renderer;
        this.setMaxRowCount(10);
        this.setRequestFocus(false);
        this.getList().setPrototypeCellValue(Item.None.INSTANCE);
        this.getList().setBackground(LookupCellRenderer.BACKGROUND_COLOR);
        this.getList().setSelectionBackground(LookupCellRenderer.SELECTED_BACKGROUND_COLOR);
        this.getList().setSelectionMode(0);
        this.getList().setBorder(null);
        this.getList().setFocusable(false);
        this.getList().setFont(this.textComponent.getFont());
        JList jList = this.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList, (String)"getList(...)");
        String[] stringArray = new String[]{"$Copy"};
        UiUtils.removeKeyboardAction((JComponent)jList, (List)UiUtils.getKeyStrokes((String[])stringArray));
        JList jList2 = this.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList2, (String)"getList(...)");
        stringArray = new String[]{"$Cut"};
        UiUtils.removeKeyboardAction((JComponent)jList2, (List)UiUtils.getKeyStrokes((String[])stringArray));
        JList jList3 = this.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList3, (String)"getList(...)");
        stringArray = new String[]{"$Delete"};
        UiUtils.removeKeyboardAction((JComponent)jList3, (List)UiUtils.getKeyStrokes((String[])stringArray));
        JList jList4 = this.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList4, (String)"getList(...)");
        stringArray = new String[]{"$Paste"};
        UiUtils.removeKeyboardAction((JComponent)jList4, (List)UiUtils.getKeyStrokes((String[])stringArray));
        JList jList5 = this.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList5, (String)"getList(...)");
        stringArray = new String[]{"$SelectAll"};
        UiUtils.removeKeyboardAction((JComponent)jList5, (List)UiUtils.getKeyStrokes((String[])stringArray));
        JList jList6 = this.getList();
        Intrinsics.checkNotNullExpressionValue((Object)jList6, (String)"getList(...)");
        stringArray = new String[]{"EditorChooseLookupItemReplace"};
        UiUtils.addKeyboardAction((JComponent)jList6, (List)UiUtils.getKeyStrokes((String[])stringArray), arg_0 -> TextCompletionPopup._init_$lambda$0(this, arg_0));
    }

    @NotNull
    protected ListCellRenderer<?> getListElementRenderer() {
        return (ListCellRenderer)((Object)new Renderer());
    }

    public final void update() {
        this.getListModel().updateOriginalList();
        this.setSize(new Dimension(this.textComponent.getWidth(), this.getList().getFixedCellHeight() * Math.max(1, Math.min(this.getList().getModel().getSize(), this.getList().getVisibleRowCount()))));
        this.getList().revalidate();
    }

    public final void showUnderneathOfTextComponent() {
        this.show(new RelativePoint((Component)((Object)this.textComponent), new Point(this.getContent().getInsets().left, this.textComponent.getHeight())));
    }

    protected void process(@NotNull KeyEvent aEvent) {
        Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
        if (aEvent.getKeyCode() != 37 && aEvent.getKeyCode() != 39) {
            super.process(aEvent);
        }
    }

    private static final Unit _init_$lambda$0(TextCompletionPopup this$0, ActionEvent it) {
        Item selectedValue;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object e = this$0.getList().getSelectedValue();
        Item item = selectedValue = e instanceof Item ? (Item)e : null;
        if (selectedValue instanceof Item.Just) {
            this$0.contributor.fireItemChosen(((Item.Just)selectedValue).getItem());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Companion;", "", "<init>", "()V", "MAX_COMPLETION_LIST_SIZE", "", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H&J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Contributor;", "T", "", "getItems", "", "fireItemChosen", "", "item", "(Ljava/lang/Object;)V", "intellij.platform.externalSystem.impl"})
    public static interface Contributor<T> {
        @NotNull
        public List<T> getItems();

        public void fireItemChosen(T var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002:\u0003\u0003\u0004\u0005\u0082\u0001\u0003\u0006\u0007\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item;", "T", "", "None", "More", "Just", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item$Just;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item$More;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item$None;", "intellij.platform.externalSystem.impl"})
    private static sealed interface Item<T> {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item$Just;", "T", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item;", "item", "<init>", "(Ljava/lang/Object;)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "intellij.platform.externalSystem.impl"})
        public static final class Just<T>
        implements Item<T> {
            private final T item;

            public Just(T item) {
                this.item = item;
            }

            public final T getItem() {
                return this.item;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item$More;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item;", "", "<init>", "()V", "intellij.platform.externalSystem.impl"})
        public static final class More
        implements Item {
            @NotNull
            public static final More INSTANCE = new More();

            private More() {
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item$None;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item;", "", "<init>", "()V", "intellij.platform.externalSystem.impl"})
        public static final class None
        implements Item {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0004B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\rH\u0016J$\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016J\u0016\u0010\u001b\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$PopupStep;", "T", "Lcom/intellij/openapi/ui/popup/util/BaseStep;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item;", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "contributor", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Contributor;", "<init>", "(Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Contributor;)V", "isSelectable", "", "value", "getValues", "", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValue", "finalChoice", "getTextFor", "", "getIconFor", "Ljavax/swing/Icon;", "getSeparatorAbove", "Lcom/intellij/openapi/ui/popup/ListSeparator;", "getDefaultOptionIndex", "", "getTitle", "hasSubstep", "canceled", "", "intellij.platform.externalSystem.impl"})
    @SourceDebugExtension(value={"SMAP\nTextCompletionPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextCompletionPopup.kt\ncom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$PopupStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1586#2:158\n1661#2,3:159\n1586#2:162\n1661#2,3:163\n*S KotlinDebug\n*F\n+ 1 TextCompletionPopup.kt\ncom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$PopupStep\n*L\n91#1:158\n91#1:159,3\n93#1:162\n93#1:163,3\n*E\n"})
    private static final class PopupStep<T>
    extends BaseStep<Item<? extends T>>
    implements ListPopupStep<Item<? extends T>> {
        @NotNull
        private final Contributor<T> contributor;

        public PopupStep(@NotNull Contributor<T> contributor2) {
            Intrinsics.checkNotNullParameter(contributor2, (String)"contributor");
            this.contributor = contributor2;
        }

        public boolean isSelectable(@NotNull Item<? extends T> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return value instanceof Item.Just;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<Item<T>> getValues() {
            List<T> items = this.contributor.getItems();
            if (items.isEmpty()) {
                return CollectionsKt.listOf((Object)Item.None.INSTANCE);
            }
            if (items.size() > 1000) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = CollectionsKt.take((Iterable)items, (int)1000);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Item.Just<void>(it));
                }
                return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)Item.More.INSTANCE);
            }
            Iterable $this$map$iv = items;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv;
                Object it = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Item.Just(it));
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public com.intellij.openapi.ui.popup.PopupStep<?> onChosen(@NotNull Item<? extends T> selectedValue, boolean finalChoice) {
            Intrinsics.checkNotNullParameter(selectedValue, (String)"selectedValue");
            if (selectedValue instanceof Item.Just) {
                this.contributor.fireItemChosen(((Item.Just)selectedValue).getItem());
            }
            return BaseStep.FINAL_CHOICE;
        }

        @NotNull
        public String getTextFor(@NotNull Item<? extends T> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return "";
        }

        @Nullable
        public Icon getIconFor(@NotNull Item<? extends T> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return null;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(@NotNull Item<? extends T> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return null;
        }

        public int getDefaultOptionIndex() {
            return 0;
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        public boolean hasSubstep(@NotNull Item<? extends T> selectedValue) {
            Intrinsics.checkNotNullParameter(selectedValue, (String)"selectedValue");
            return false;
        }

        public void canceled() {
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JD\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Renderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup$Item;", "<init>", "(Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.platform.externalSystem.impl"})
    private final class Renderer
    extends ColoredListCellRenderer<Item<? extends T>> {
        protected void customizeCellRenderer(@NotNull JList<? extends Item<? extends T>> list, @NotNull Item<? extends T> value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.mySelected = false;
            this.setMyBorder(null);
            this.setEnabled(value instanceof Item.Just);
            Item item = value;
            if (item instanceof Item.None) {
                SimpleColoredComponent simpleColoredComponent = this.append(LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]));
                Intrinsics.checkNotNull((Object)simpleColoredComponent);
            } else if (item instanceof Item.More) {
                Object[] objectArray = new Object[]{1000};
                SimpleColoredComponent simpleColoredComponent = this.append(LangBundle.message((String)"completion.more.suggestions", (Object[])objectArray));
                Intrinsics.checkNotNull((Object)simpleColoredComponent);
            } else if (item instanceof Item.Just) {
                TextCompletionRenderer.Cell cell = new TextCompletionRenderer.Cell((SimpleColoredComponent)this, ((Item.Just)value).getItem(), list, index, selected, hasFocus);
                TextCompletionPopup.this.renderer.customizeCellRenderer(TextCompletionPopup.this.textComponent, cell);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

