/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J4\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSourceAttachCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "HANDLER_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "SUCCESS_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "SOURCES_ATTACHED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "onSourcesAttached", "", "project", "Lcom/intellij/openapi/project/Project;", "handlerClass", "Ljava/lang/Class;", "language", "Lcom/intellij/lang/Language;", "success", "", "durationMs", "", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemSourceAttachCollector
extends CounterUsagesCollector {
    @NotNull
    public static final ExternalSystemSourceAttachCollector INSTANCE = new ExternalSystemSourceAttachCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("build.tools.sources", 1, null, 4, null);
    @NotNull
    private static final ClassEventField HANDLER_FIELD = EventFields.Class((String)"handler");
    @NotNull
    private static final BooleanEventField SUCCESS_FIELD = EventFields.Boolean((String)"success");
    @NotNull
    private static final VarargEventId SOURCES_ATTACHED_EVENT;

    private ExternalSystemSourceAttachCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void onSourcesAttached(@NotNull Project project, @NotNull Class<?> handlerClass, @NotNull Language language, boolean success, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(handlerClass, (String)"handlerClass");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object[] objectArray = new EventPair[]{HANDLER_FIELD.with(handlerClass), EventFields.Language.with((Object)language), SUCCESS_FIELD.with((Object)success), EventFields.DurationMs.with((Object)durationMs)};
        List events = CollectionsKt.listOf((Object[])objectArray);
        SOURCES_ATTACHED_EVENT.log(project, events);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{HANDLER_FIELD, EventFields.Language, SUCCESS_FIELD, EventFields.DurationMs};
        SOURCES_ATTACHED_EVENT = GROUP.registerVarargEvent("attached", eventFieldArray);
    }
}

