/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.externalSystem.util.ExternalSystemCrcCalculator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J'\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0015J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/util/AbstractCrcCalculator;", "Lcom/intellij/openapi/externalSystem/util/ExternalSystemCrcCalculator;", "<init>", "()V", "isIgnoredToken", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "tokenText", "", "parserDefinition", "Lcom/intellij/lang/ParserDefinition;", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "calculateCrc", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileText", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/CharSequence;)Ljava/lang/Long;", "charSequence", "update", "", "Ljava/util/zip/CRC32;", "getParserDefinition", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.platform.externalSystem.impl"})
public abstract class AbstractCrcCalculator
implements ExternalSystemCrcCalculator {
    public abstract boolean isIgnoredToken(@NotNull IElementType var1, @NotNull CharSequence var2, @NotNull ParserDefinition var3);

    @NotNull
    public Lexer createLexer(@NotNull Project project, @NotNull ParserDefinition parserDefinition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parserDefinition, (String)"parserDefinition");
        Lexer lexer = parserDefinition.createLexer(project);
        Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"createLexer(...)");
        return lexer;
    }

    @Nullable
    public Long calculateCrc(@NotNull Project project, @NotNull VirtualFile file, @NotNull CharSequence fileText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        ParserDefinition parserDefinition = this.getParserDefinition(fileType);
        if (parserDefinition == null) {
            return null;
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        return this.calculateCrc(project, fileText, parserDefinition2);
    }

    private final long calculateCrc(Project project, CharSequence charSequence, ParserDefinition parserDefinition) {
        Lexer lexer = this.createLexer(project, parserDefinition);
        CRC32 crc32 = new CRC32();
        lexer.start(charSequence);
        ProgressManager.checkCanceled();
        while (lexer.getTokenType() != null) {
            IElementType tokenType;
            CharSequence tokenText = charSequence.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
            this.update(crc32, tokenType, tokenText, parserDefinition);
            lexer.advance();
            ProgressManager.checkCanceled();
        }
        return crc32.getValue();
    }

    private final void update(CRC32 $this$update, IElementType tokenType, CharSequence tokenText, ParserDefinition parserDefinition) {
        if (this.isIgnoredToken(tokenType, tokenText, parserDefinition)) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)tokenText)) {
            return;
        }
        this.update($this$update, tokenText);
    }

    private final void update(CRC32 $this$update, CharSequence charSequence) {
        $this$update.update(charSequence.length());
        for (int j = 0; j < charSequence.length(); ++j) {
            char ch = charSequence.charAt(j);
            $this$update.update(ch);
        }
    }

    private final ParserDefinition getParserDefinition(FileType fileType) {
        return fileType instanceof LanguageFileType ? (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage()) : null;
    }
}

