/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierAliasBase;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportExportSpecifierStub;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPolyVariantReferenceBase;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 1*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\u00020\u00042\u00020\u0005:\u00011B\u0013\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001d\b\u0016\u0012\b\u0010\n\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\b\u0010\rJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J+\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0016\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u00050(j\b\u0012\u0004\u0012\u00020\u0005`)H\u0016\u00a2\u0006\u0002\u0010*J\n\u0010+\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\"\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00062"}, d2={"Lcom/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase;", "T", "Lcom/intellij/lang/ecmascript6/psi/stubs/ES6ImportExportSpecifierStub;", "Lcom/intellij/lang/javascript/psi/impl/JSPolyVariantReferenceBase;", "Lcom/intellij/refactoring/rename/BindablePsiReference;", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportSpecifier;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "stub", "type", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/lang/ecmascript6/psi/stubs/ES6ImportExportSpecifierStub;Lcom/intellij/psi/tree/IElementType;)V", "referenceElement", "getReferenceElement", "()Lcom/intellij/lang/ASTNode;", "getDeclaredName", "", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getCanonicalText", "getReferenceName", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "bindToElement", "element", "renameReference", "newName", "isSoft", "", "getDeclaration", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclaration;", "isDefault", "()Z", "resolveOverAliases", "", "Lcom/intellij/psi/ResolveResult;", "visited", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "(Ljava/util/HashSet;)[Lcom/intellij/psi/ResolveResult;", "getReferenceNameElement", "isReferenceTo", "unresolvedReferenceSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getUnresolvedReferenceSeverity", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "Companion", "intellij.javascript.psi.impl"})
public abstract class ES6ImportExportSpecifierBase<T extends ES6ImportExportSpecifierStub<?>>
extends JSPolyVariantReferenceBase<T>
implements BindablePsiReference,
ES6ImportExportSpecifier {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ES6ImportExportSpecifierBase(@Nullable ASTNode node) {
        super(node);
    }

    public ES6ImportExportSpecifierBase(@Nullable T stub, @Nullable IElementType type) {
        super((JSStubElement)stub, type);
    }

    @Nullable
    protected final ASTNode getReferenceElement() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        return ES6ImportExportSpecifierBase.Companion.getReferenceElement(aSTNode);
    }

    @Override
    @Nullable
    public String getDeclaredName() {
        ES6ImportExportSpecifierAlias alias = this.getAlias();
        if (alias != null) {
            return alias.getName();
        }
        return this.getReferenceName();
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameIdentifier = this.getReferenceElement();
        int startOffset = 0;
        int length = 0;
        if (nameIdentifier != null) {
            startOffset = nameIdentifier.getTextRange().getStartOffset() - this.getNode().getStartOffset();
            length = nameIdentifier.getTextLength();
            if (nameIdentifier.getElementType() == JSTokenTypes.STRING_LITERAL && length >= 2) {
                char lastChar;
                ++startOffset;
                char firstChar = nameIdentifier.getText().charAt(0);
                length -= (lastChar = nameIdentifier.getText().charAt(length - 1)) == firstChar ? 2 : 1;
            }
        } else {
            startOffset = 0;
            length = this.getTextLength();
        }
        return new TextRange(startOffset, startOffset + length);
    }

    @NotNull
    public String getCanonicalText() {
        TextRange range = this.getRangeInElement();
        String string = range.substring(this.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Override
    @NotNull
    public String getReferenceName() {
        ES6ImportExportSpecifierStub stub = (ES6ImportExportSpecifierStub)this.getGreenStub();
        if (stub != null) {
            return stub.getReferencedName();
        }
        String string = JSStringUtil.unescapeStringLiteralValue(this.getCanonicalText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeStringLiteralValue(...)");
        return string;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        return this.renameReference(newElementName);
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PsiNamedElement)) {
            return (PsiElement)this;
        }
        String newName = ((PsiNamedElement)element).getName();
        if (StringUtil.isEmpty((String)newName)) {
            return (PsiElement)this;
        }
        return this.renameReference(newName);
    }

    private final PsiElement renameReference(String newName) {
        ASTNode referenceElement = this.getReferenceElement();
        if (newName != null && referenceElement != null && !Intrinsics.areEqual((Object)newName, (Object)referenceElement.getText())) {
            ASTNode nameElement = JSChangeUtil.createImportOrExportNameIdentifier(newName, referenceElement, this.isNameCanBeString());
            if (nameElement == null) {
                return (PsiElement)this;
            }
            this.getNode().replaceChild(referenceElement, nameElement);
        }
        return (PsiElement)this;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @Nullable
    public ES6ImportExportDeclaration getDeclaration() {
        ES6ImportExportSpecifierStub stub = (ES6ImportExportSpecifierStub)this.getGreenStub();
        if (stub != null) {
            return (ES6ImportExportDeclaration)stub.getParentStubOfType(ES6ImportExportDeclaration.class);
        }
        return (ES6ImportExportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)this), ES6ImportExportDeclaration.class);
    }

    @Override
    public boolean isDefault() {
        ES6ImportExportSpecifierStub stub = (ES6ImportExportSpecifierStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDefault();
        }
        ASTNode element = this.getReferenceElement();
        return element != null && element.getElementType() == JSTokenTypes.DEFAULT_KEYWORD;
    }

    @Override
    @NotNull
    public ResolveResult[] resolveOverAliases(@NotNull HashSet<ES6ImportExportSpecifier> visited) {
        Intrinsics.checkNotNullParameter(visited, (String)"visited");
        if (!visited.add(this)) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = this.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
        ResolveResult[] results = resolveResultArray;
        ArrayList<ResolveResult> newResults = new ArrayList<ResolveResult>();
        for (ResolveResult result : results) {
            Serializable serializable;
            PsiElement element = result.getElement();
            if (element instanceof ES6ImportExportSpecifierAlias) {
                ResolveResult[] resolvedOverAliases;
                ES6ImportExportSpecifier aliasedElement;
                ES6ImportExportSpecifier eS6ImportExportSpecifier = aliasedElement = ((ES6ImportExportSpecifierAlias)element).findSpecifierElement();
                Object object = resolvedOverAliases = eS6ImportExportSpecifier != null ? eS6ImportExportSpecifier.resolveOverAliases(visited) : null;
                if (aliasedElement != null) {
                    boolean bl = resolvedOverAliases != null ? !(resolvedOverAliases.length == 0) : false;
                    if (bl) {
                        ResolveResult[] resolveResultArray2 = resolvedOverAliases;
                        Collection collection = ContainerUtil.addAll((Collection)newResults, (Object[])Arrays.copyOf(resolveResultArray2, resolveResultArray2.length));
                        Intrinsics.checkNotNull((Object)collection);
                        serializable = (Serializable)((Object)collection);
                        continue;
                    }
                }
                serializable = Boolean.valueOf(newResults.add(new JSResolveResult((PsiElement)aliasedElement)));
                continue;
            }
            serializable = Boolean.valueOf(newResults.add(result));
        }
        ResolveResult[] resolveResultArray3 = newResults.toArray(ResolveResult.EMPTY_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray3, (String)"toArray(...)");
        return resolveResultArray3;
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode element;
        ASTNode aSTNode = element = this.getReferenceElement();
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, this.getReferenceName(), element);
    }

    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        ES6FromClause fromClause;
        ES6ImportExportDeclaration parent = this.getDeclaration();
        if (parent != null && (fromClause = parent.getFromClause()) != null) {
            Collection<PsiElement> collection = fromClause.resolveReferencedElements();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveReferencedElements(...)");
            Collection<PsiElement> fromElements = collection;
            if (!fromElements.isEmpty()) {
                HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"WEAK_WARNING");
                return highlightSeverity;
            }
        }
        HighlightSeverity highlightSeverity = HighlightSeverity.INFORMATION;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"INFORMATION");
        return highlightSeverity;
    }

    @JvmStatic
    @Nullable
    public static final ASTNode getDeclarationNameElement(@NotNull ASTNode importExportSpecifierNode) {
        return Companion.getDeclarationNameElement(importExportSpecifierNode);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase$Companion;", "", "<init>", "()V", "getReferenceElement", "Lcom/intellij/lang/ASTNode;", "importExportSpecifierNode", "getDeclarationNameElement", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final ASTNode getReferenceElement(ASTNode importExportSpecifierNode) {
            ASTNode childNode;
            for (childNode = importExportSpecifierNode.getLastChildNode(); childNode != null && childNode.getElementType() != JSTokenTypes.STRING_LITERAL && !JSKeywordSets.IDENTIFIER_NAMES.contains(childNode.getElementType()); childNode = childNode.getTreePrev()) {
            }
            return childNode;
        }

        @JvmStatic
        @Nullable
        public final ASTNode getDeclarationNameElement(@NotNull ASTNode importExportSpecifierNode) {
            Intrinsics.checkNotNullParameter((Object)importExportSpecifierNode, (String)"importExportSpecifierNode");
            ASTNode alias = importExportSpecifierNode.findChildByType(JSElementTypes.IMPORT_SPECIFIER_ALIAS);
            if (alias == null) {
                alias = importExportSpecifierNode.findChildByType(JSElementTypes.EXPORT_SPECIFIER_ALIAS);
            }
            if (alias != null) {
                return ES6ImportExportSpecifierAliasBase.findNameIdentifier(alias);
            }
            return this.getReferenceElement(importExportSpecifierNode);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

