/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.evaluation.JSApproximateBuiltInTypeEngineContext;
import com.intellij.lang.javascript.evaluation.JSTypeEngineContextKt;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorTaskComplexityPolicy;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSEvaluatorComplexityTracker {
    private static final ThreadLocal<JSEvaluatorComplexityTracker> ourComplexityTracker = ThreadLocal.withInitial(() -> new JSEvaluatorComplexityTracker());
    private static final AtomicInteger ourLogMessageCounter = new AtomicInteger();
    private static final RecursionGuard<Object> ourRecursionGuard = RecursionManager.createGuard((String)"js.evaluator.depth.tracker");
    private int myCurrentDepth = 0;
    private int myMaxBranchDepth = 0;
    private Object myKeyForCachingPrevention = null;
    private static boolean ourAssertOnPrevention = false;

    private static int getAllowedDepth() {
        return Registry.intValue((String)"js.max.evaluation.depth");
    }

    @Nullable
    public <T> JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T> runTask(@NotNull JSEvaluatorTaskComplexityPolicy ownComplexity, @NotNull Supplier<? extends @Nullable T> task) {
        int ownDepth;
        if (ownComplexity == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(0);
        }
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(1);
        }
        switch (ownComplexity) {
            default: {
                throw new MatchException(null, null);
            }
            case NEVER: {
                int n = 0;
                break;
            }
            case WHEN_FORCED: {
                int n;
                if (JSEvaluatorComplexityTracker.isDepthLimitForced()) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case ALWAYS: {
                int n = ownDepth = 2;
            }
        }
        if (this.myCurrentDepth + ownDepth > JSEvaluatorComplexityTracker.getAllowedDepth()) {
            if (this.myKeyForCachingPrevention != null) {
                ourRecursionGuard.prohibitResultCaching(this.myKeyForCachingPrevention);
            }
            JSEvaluationLogger.getInstance().cachingProhibited();
            PsiElement location = JSTypeEvaluationLocationProvider.getTypeEvaluationLocation();
            if (location != null && DialectDetector.isTypeScript(location) && !JSApproximateBuiltInTypeEngineContext.INSTANCE.equals(JSTypeEngineContextKt.getCurrentJSTypeEngineContext())) {
                JSEvaluatorComplexityTracker.logTooDeepEvaluation();
            }
            return null;
        }
        Object key = new Object();
        boolean keyForCachingPreventionWasSet = false;
        if (this.myKeyForCachingPrevention == null && this.myCurrentDepth + ownDepth > 0) {
            this.myKeyForCachingPrevention = key;
            keyForCachingPreventionWasSet = true;
        }
        int depthBefore = this.myCurrentDepth;
        int maxBranchDepthBefore = this.myMaxBranchDepth;
        Object value = null;
        Throwable throwable = null;
        try {
            JSEvaluationLogger.getInstance().startComplexityTrackerTask(task, depthBefore, maxBranchDepthBefore);
            this.myCurrentDepth += ownDepth;
            this.myMaxBranchDepth = this.myCurrentDepth;
            value = keyForCachingPreventionWasSet ? ourRecursionGuard.doPreventingRecursion(key, true, task::get) : task.get();
            JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<Object> jSComplexityAwareCachedValue = new JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<Object>(this.myMaxBranchDepth - depthBefore, value);
            return jSComplexityAwareCachedValue;
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            JSEvaluationLogger.getInstance().finishComplexityTrackerTask(task, value, this.myMaxBranchDepth, throwable);
            this.myCurrentDepth = depthBefore;
            this.myMaxBranchDepth = Math.max(this.myMaxBranchDepth, maxBranchDepthBefore);
            if (keyForCachingPreventionWasSet) {
                this.myKeyForCachingPrevention = null;
            }
        }
    }

    public boolean tryUseDepth(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("depth: " + depth);
        }
        if (this.myCurrentDepth + depth > JSEvaluatorComplexityTracker.getAllowedDepth()) {
            return false;
        }
        this.myMaxBranchDepth = Math.max(this.myMaxBranchDepth, this.myCurrentDepth + depth);
        return true;
    }

    @TestOnly
    public static void assertOnRecursionPrevention(@NotNull Disposable disposable) {
        if (disposable == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(2);
        }
        ourAssertOnPrevention = true;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertOnPrevention = false;
            }
        });
    }

    @TestOnly
    public static boolean isAssertOnPrevention() {
        return ourAssertOnPrevention;
    }

    @NotNull
    public static JSEvaluatorComplexityTracker getDefaultInstance() {
        JSEvaluatorComplexityTracker jSEvaluatorComplexityTracker = ourComplexityTracker.get();
        if (jSEvaluatorComplexityTracker == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(3);
        }
        return jSEvaluatorComplexityTracker;
    }

    private static boolean isDepthLimitForced() {
        return Registry.is((String)"js.max.evaluation.depth.forced") || JSApproximateBuiltInTypeEngineContext.INSTANCE.equals(JSTypeEngineContextKt.getCurrentJSTypeEngineContext());
    }

    private static void logTooDeepEvaluation() {
        int number;
        int beforeZeroes = number = ourLogMessageCounter.incrementAndGet();
        while (beforeZeroes % 10 == 0) {
            beforeZeroes /= 10;
        }
        if (number <= 5 || beforeZeroes == 1 || beforeZeroes == 2 || beforeZeroes == 5) {
            Object message = "Evaluation is too deep and was stopped";
            if (number > 5) {
                message = (String)message + ", occurrence " + number;
            }
            Logger.getInstance(JSEvaluatorComplexityTracker.class).warn((String)message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownComplexity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecursionPrevention";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

