/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.evaluation.JSTypeEngineContext;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorTaskComplexityPolicy;
import com.intellij.lang.javascript.psi.resolve.JSResolveCacheEntry;
import com.intellij.lang.javascript.psi.resolve.complexity.JSNamedEvaluationTask;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003B%\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/JSResolveEvaluationTask;", "T", "Lcom/intellij/psi/PsiPolyVariantReference;", "Lcom/intellij/lang/javascript/psi/resolve/complexity/JSNamedEvaluationTask;", "", "Lcom/intellij/psi/ResolveResult;", "resolver", "Lcom/intellij/psi/impl/source/resolve/ResolveCache$PolyVariantResolver;", "reference", "incompleteCode", "", "<init>", "(Lcom/intellij/psi/impl/source/resolve/ResolveCache$PolyVariantResolver;Lcom/intellij/psi/PsiPolyVariantReference;Z)V", "Lcom/intellij/psi/PsiPolyVariantReference;", "get", "()[Lcom/intellij/psi/ResolveResult;", "toString", "", "execute", "Lcom/intellij/lang/javascript/psi/resolve/JSResolveCacheEntry;", "complexityTracker", "Lcom/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker;", "currentResolveCacheKey", "Lcom/intellij/lang/javascript/evaluation/JSTypeEngineContext;", "Lcom/intellij/lang/javascript/psi/resolve/JSResolveCacheKey;", "intellij.javascript.psi.impl"})
final class JSResolveEvaluationTask<T extends PsiPolyVariantReference>
extends JSNamedEvaluationTask<ResolveResult[]> {
    @NotNull
    private final ResolveCache.PolyVariantResolver<T> resolver;
    @NotNull
    private final T reference;
    private final boolean incompleteCode;

    public JSResolveEvaluationTask(@NotNull ResolveCache.PolyVariantResolver<T> resolver, @NotNull T reference, boolean incompleteCode) {
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        this.resolver = resolver;
        this.reference = reference;
        this.incompleteCode = incompleteCode;
    }

    @Override
    @NotNull
    public ResolveResult[] get() {
        ResolveResult[] resolveResultArray = this.resolver.resolve(this.reference, this.incompleteCode);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"resolve(...)");
        return resolveResultArray;
    }

    @NotNull
    public String toString() {
        return "JSResolveUtil.resolve of " + JSEvaluationLogger.toPresentable(((PsiReference)this.reference).getElement());
    }

    @NotNull
    public final JSResolveCacheEntry execute(@NotNull JSEvaluatorComplexityTracker complexityTracker, @NotNull JSTypeEngineContext currentResolveCacheKey) {
        Intrinsics.checkNotNullParameter((Object)complexityTracker, (String)"complexityTracker");
        Intrinsics.checkNotNullParameter((Object)currentResolveCacheKey, (String)"currentResolveCacheKey");
        JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<ResolveResult[]> value = complexityTracker.runTask(JSEvaluatorTaskComplexityPolicy.NEVER, this);
        return new JSResolveCacheEntry(currentResolveCacheKey, value);
    }
}

