/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.NullableEnumStructureElement;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFileCachedData {
    private static final EnumStructureElement<JSModuleStatusOwner.ModuleStatus> MODULE_STATUS_FLAG = new EnumStructureElement<JSModuleStatusOwner.ModuleStatus>(JSModuleStatusOwner.ModuleStatus.class);
    private static final NullableEnumStructureElement<JSTestFileType> TEST_FILE_FLAG = new NullableEnumStructureElement<JSTestFileType>(JSTestFileType.class);
    private static final BooleanStructureElement HAS_ES6_SYNTAX_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_JSX_SYNTAX_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement MAY_HAVE_TESTS_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(MODULE_STATUS_FLAG, TEST_FILE_FLAG, HAS_ES6_SYNTAX_FLAG, HAS_JSX_SYNTAX_FLAG, MAY_HAVE_TESTS_FLAG);
    private byte myFlags;
    private Map<String, String> myPragmaFlags = null;

    public void applyModuleStatus(@NotNull JSModuleStatusOwner.ModuleStatus moduleStatus) {
        JSModuleStatusOwner.ModuleStatus prevModuleStatus;
        JSModuleStatusOwner.ModuleStatus newModuleStatus;
        if (moduleStatus == null) {
            JSFileCachedData.$$$reportNull$$$0(0);
        }
        if ((newModuleStatus = JSFileCachedData.combineModuleStatuses(prevModuleStatus = this.getModuleStatus(), moduleStatus)) != prevModuleStatus) {
            this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, MODULE_STATUS_FLAG, newModuleStatus, this.myFlags);
        }
    }

    @NotNull
    private static JSModuleStatusOwner.ModuleStatus combineModuleStatuses(@NotNull JSModuleStatusOwner.ModuleStatus s1, @NotNull JSModuleStatusOwner.ModuleStatus s2) {
        if (s1 == null) {
            JSFileCachedData.$$$reportNull$$$0(1);
        }
        if (s2 == null) {
            JSFileCachedData.$$$reportNull$$$0(2);
        }
        if (s1 == JSModuleStatusOwner.ModuleStatus.ES6 || s2 == JSModuleStatusOwner.ModuleStatus.ES6) {
            JSModuleStatusOwner.ModuleStatus moduleStatus = JSModuleStatusOwner.ModuleStatus.ES6;
            if (moduleStatus == null) {
                JSFileCachedData.$$$reportNull$$$0(3);
            }
            return moduleStatus;
        }
        if (s1 == JSModuleStatusOwner.ModuleStatus.COMMONJS || s2 == JSModuleStatusOwner.ModuleStatus.COMMONJS) {
            JSModuleStatusOwner.ModuleStatus moduleStatus = JSModuleStatusOwner.ModuleStatus.COMMONJS;
            if (moduleStatus == null) {
                JSFileCachedData.$$$reportNull$$$0(4);
            }
            return moduleStatus;
        }
        if (s1 == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS || s2 == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS) {
            JSModuleStatusOwner.ModuleStatus moduleStatus = JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS;
            if (moduleStatus == null) {
                JSFileCachedData.$$$reportNull$$$0(5);
            }
            return moduleStatus;
        }
        JSModuleStatusOwner.ModuleStatus moduleStatus = JSModuleStatusOwner.ModuleStatus.NONE;
        if (moduleStatus == null) {
            JSFileCachedData.$$$reportNull$$$0(6);
        }
        return moduleStatus;
    }

    @Deprecated(forRemoval=true)
    public void setTestFileType(@Nullable JSTestFileType testFileType) {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, TEST_FILE_FLAG, testFileType, this.myFlags);
    }

    public void setHasES6Syntax() {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_ES6_SYNTAX_FLAG, true, this.myFlags);
    }

    public void setHasJSXSyntax() {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_JSX_SYNTAX_FLAG, true, this.myFlags);
    }

    public void setMayHaveTests() {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, MAY_HAVE_TESTS_FLAG, true, this.myFlags);
    }

    @NotNull
    public JSModuleStatusOwner.ModuleStatus getModuleStatus() {
        JSModuleStatusOwner.ModuleStatus moduleStatus = ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, MODULE_STATUS_FLAG, this.myFlags);
        if (moduleStatus == null) {
            JSFileCachedData.$$$reportNull$$$0(7);
        }
        return moduleStatus;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public JSTestFileType getTestFileType() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, TEST_FILE_FLAG, this.myFlags);
    }

    public boolean hasES6Syntax() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_ES6_SYNTAX_FLAG, this.myFlags);
    }

    public boolean hasJSXSyntax() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_JSX_SYNTAX_FLAG, this.myFlags);
    }

    public boolean mayHaveTests() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, MAY_HAVE_TESTS_FLAG, this.myFlags);
    }

    public void addPragmaFlag(@NotNull String name, @NotNull String text) {
        Map<String, String> flags;
        if (name == null) {
            JSFileCachedData.$$$reportNull$$$0(8);
        }
        if (text == null) {
            JSFileCachedData.$$$reportNull$$$0(9);
        }
        if ((flags = this.myPragmaFlags) == null) {
            this.myPragmaFlags = flags = new HashMap<String, String>();
        }
        flags.put(name, text);
    }

    public void setPragmaFlags(@NotNull Map<String, String> map) {
        if (map == null) {
            JSFileCachedData.$$$reportNull$$$0(10);
        }
        this.myPragmaFlags = map;
    }

    public Map<String, String> getPragmaFlags() {
        return this.myPragmaFlags == null ? Collections.emptyMap() : this.myPragmaFlags;
    }

    public void serialize(@NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            JSFileCachedData.$$$reportNull$$$0(11);
        }
        dataStream.writeByte((int)this.myFlags);
        JSFileCachedData.serializeStringMap(this.myPragmaFlags, dataStream);
    }

    public static JSFileCachedData deserialize(StubInputStream dataStream) throws IOException {
        JSFileCachedData cachedData = new JSFileCachedData();
        cachedData.myFlags = dataStream.readByte();
        cachedData.myPragmaFlags = JSFileCachedData.deserializeStringMap(dataStream);
        return cachedData;
    }

    public static void serializeStringSet(@NotNull Set<String> set, @NotNull StubOutputStream dataStream) throws IOException {
        if (set == null) {
            JSFileCachedData.$$$reportNull$$$0(12);
        }
        if (dataStream == null) {
            JSFileCachedData.$$$reportNull$$$0(13);
        }
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)set.size());
        for (String referencedFile : set) {
            dataStream.writeUTFFast(referencedFile);
        }
    }

    @NotNull
    public static Set<String> deserializeStringSet(StubInputStream dataStream) throws IOException {
        int referencedFilesCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        if (referencedFilesCount == 0) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JSFileCachedData.$$$reportNull$$$0(14);
            }
            return set;
        }
        HashSet<String> set = new HashSet<String>(referencedFilesCount);
        for (int i = 0; i < referencedFilesCount; ++i) {
            String referencedFile = dataStream.readUTFFast();
            set.add(referencedFile);
        }
        HashSet<String> hashSet = set;
        if (hashSet == null) {
            JSFileCachedData.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    public static void serializeStringMap(@Nullable Map<String, String> map, @NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            JSFileCachedData.$$$reportNull$$$0(16);
        }
        if (map == null) {
            map = Collections.emptyMap();
        }
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dataStream.writeName(entry.getKey());
            dataStream.writeUTFFast(entry.getValue());
        }
    }

    @NotNull
    public static Map<String, String> deserializeStringMap(@NotNull StubInputStream dataStream) throws IOException {
        int size;
        if (dataStream == null) {
            JSFileCachedData.$$$reportNull$$$0(17);
        }
        if ((size = DataInputOutputUtil.readINT((DataInput)dataStream)) == 0) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                JSFileCachedData.$$$reportNull$$$0(18);
            }
            return map;
        }
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = dataStream.readNameString();
            String value = dataStream.readUTFFast();
            map.put(key, value);
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            JSFileCachedData.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 14, 15, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStatus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "combineModuleStatuses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleStatus";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeStringSet";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeStringMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyModuleStatus";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "combineModuleStatuses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPragmaFlag";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setPragmaFlags";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "serializeStringSet";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "serializeStringMap";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deserializeStringMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 14, 15, 18, 19 -> new IllegalStateException(string);
        };
    }
}

