/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.javascript.types.TSAnyType;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnyType
extends JSTypeBaseImpl
implements JSNamespace,
JSUtilType {
    @NotNull
    private final JSTypeSource.SourceLanguage myLanguage;

    protected JSAnyType(@NotNull JSTypeSource.SourceLanguage language) {
        if (language == null) {
            JSAnyType.$$$reportNull$$$0(0);
        }
        super(new JSTypeSource(null, language, true));
        this.myLanguage = language;
    }

    @NotNull
    public static JSAnyTypeImpl deserialize(@NotNull CharacterIterator inputStream) {
        if (inputStream == null) {
            JSAnyType.$$$reportNull$$$0(1);
        }
        char languageChar = inputStream.current();
        inputStream.next();
        JSTypeSource.SourceLanguage language = switch (languageChar) {
            case 'J' -> JSTypeSource.SourceLanguage.JS;
            case 'T' -> JSTypeSource.SourceLanguage.TS;
            case 'A' -> JSTypeSource.SourceLanguage.AS;
            default -> throw new JSTypeSerializer.JSTypeDeserializationException();
        };
        return JSAnyType.getWithLanguage(language);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSAnyType.$$$reportNull$$$0(2);
        }
        outputStream.append(switch (this.myLanguage) {
            default -> throw new MatchException(null, null);
            case JSTypeSource.SourceLanguage.JS -> 'J';
            case JSTypeSource.SourceLanguage.TS -> 'T';
            case JSTypeSource.SourceLanguage.AS -> 'A';
        });
    }

    @NotNull
    public static JSAnyType getSimple() {
        return JSAnyType.get((PsiElement)null);
    }

    @NotNull
    public static JSAnyType get(@NotNull JSTypeSource source) {
        if (source == null) {
            JSAnyType.$$$reportNull$$$0(3);
        }
        return JSAnyType.getWithLanguage(source.getLanguage());
    }

    @Deprecated
    @NotNull
    public static JSAnyType get(@Nullable PsiElement context, boolean isStrict) {
        return JSAnyType.get(context);
    }

    @NotNull
    public static JSAnyType get(@Nullable PsiElement context) {
        JSTypeSource.SourceLanguage language = JSTypeSourceFactory.getSourceLanguage(context);
        return JSAnyType.getWithLanguage(language);
    }

    @NotNull
    public static JSAnyTypeImpl getWithLanguage(JSTypeSource.SourceLanguage language) {
        if (language == JSTypeSource.SourceLanguage.TS) {
            JSAnyTypeImpl jSAnyTypeImpl = JSAnyTypeImpl.ourTS;
            if (jSAnyTypeImpl == null) {
                JSAnyType.$$$reportNull$$$0(4);
            }
            return jSAnyTypeImpl;
        }
        if (language == JSTypeSource.SourceLanguage.AS) {
            JSAnyTypeImpl jSAnyTypeImpl = JSAnyTypeImpl.ourAS;
            if (jSAnyTypeImpl == null) {
                JSAnyType.$$$reportNull$$$0(5);
            }
            return jSAnyTypeImpl;
        }
        JSAnyTypeImpl jSAnyTypeImpl = JSAnyTypeImpl.ourJS;
        if (jSAnyTypeImpl == null) {
            JSAnyType.$$$reportNull$$$0(6);
        }
        return jSAnyTypeImpl;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSAnyType.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            JSAnyType.$$$reportNull$$$0(8);
        }
        builder.append(switch (this.myLanguage) {
            default -> throw new MatchException(null, null);
            case JSTypeSource.SourceLanguage.JS -> {
                if (format == JSType.TypeTextFormat.PRESENTABLE) {
                    yield "any";
                }
                yield "*";
            }
            case JSTypeSource.SourceLanguage.TS -> "any";
            case JSTypeSource.SourceLanguage.AS -> "*";
        });
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSAnyType.$$$reportNull$$$0(9);
        }
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSAnyType.$$$reportNull$$$0(10);
        }
        if (processingContext == null) {
            JSAnyType.$$$reportNull$$$0(11);
        }
        return true;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSAnyType.$$$reportNull$$$0(12);
        }
        return true;
    }

    @Override
    @NotNull
    protected JSAnyType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSAnyType.$$$reportNull$$$0(13);
        }
        return JSAnyType.getWithLanguage(source.getLanguage());
    }

    @Override
    @Nullable
    public JSQualifiedName getQualifiedName() {
        return null;
    }

    @Override
    public boolean hasQualifiedName() {
        return false;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType jSRecordType = this.emptyRecordType();
        if (jSRecordType == null) {
            JSAnyType.$$$reportNull$$$0(14);
        }
        return jSRecordType;
    }

    @Override
    @NotNull
    public JSTypeContext getTypeContext() {
        JSTypeContext jSTypeContext = JSTypeContext.UNKNOWN;
        if (jSTypeContext == null) {
            JSAnyType.$$$reportNull$$$0(15);
        }
        return jSTypeContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSAnyType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSAnyType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 14, 15 -> new IllegalStateException(string);
        };
    }

    public static final class JSAnyTypeImpl
    extends JSAnyType
    implements TSAnyType {
        private static final JSAnyTypeImpl ourTS = new JSAnyTypeImpl(JSTypeSource.SourceLanguage.TS);
        private static final JSAnyTypeImpl ourJS = new JSAnyTypeImpl(JSTypeSource.SourceLanguage.JS);
        private static final JSAnyTypeImpl ourAS = new JSAnyTypeImpl(JSTypeSource.SourceLanguage.AS);

        private JSAnyTypeImpl(@NotNull JSTypeSource.SourceLanguage language) {
            if (language == null) {
                JSAnyTypeImpl.$$$reportNull$$$0(0);
            }
            super(language);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/psi/types/JSAnyType$JSAnyTypeImpl", "<init>"));
        }
    }
}

