/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.TypeMarker;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/configurationStore/BinaryXmlReader;", "", "input", "Ljava/io/DataInputStream;", "<init>", "(Ljava/io/DataInputStream;)V", "strings", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "read", "Lorg/jdom/Element;", "readString", "readElement", "readContent", "", "element", "readAttributes", "readUInt29", "", "intellij.platform.projectModel.impl"})
final class BinaryXmlReader {
    @NotNull
    private final DataInputStream input;
    @NotNull
    private final ArrayList<String> strings;

    public BinaryXmlReader(@NotNull DataInputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.strings = new ArrayList();
    }

    @NotNull
    public final Element read() {
        return this.readElement();
    }

    private final String readString() {
        int lengthOrIndex = this.readUInt29();
        if (lengthOrIndex == 1) {
            return "";
        }
        if ((lengthOrIndex & 1) == 1) {
            String string = IOUtil.readUTF((DataInput)this.input);
            this.strings.add(string);
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        String string = this.strings.get(lengthOrIndex >> 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    private final Element readElement() {
        Element element = new Element(this.readString());
        this.readAttributes(element);
        this.readContent(element);
        return element;
    }

    private final void readContent(Element element) {
        while (true) {
            int n;
            if ((n = this.input.read()) == TypeMarker.ELEMENT.ordinal()) {
                element.addContent(this.readElement());
                continue;
            }
            if (n == TypeMarker.TEXT.ordinal()) {
                element.addContent((Content)new Text(this.readString()));
                continue;
            }
            if (n == TypeMarker.CDATA.ordinal()) {
                element.addContent((Content)new CDATA(this.readString()));
                continue;
            }
            if (n == TypeMarker.ELEMENT_END.ordinal()) break;
        }
    }

    private final void readAttributes(Element element) {
        int size = this.input.readUnsignedByte();
        for (int i = 0; i < size; ++i) {
            element.setAttribute(new Attribute(this.readString(), this.readString()));
        }
    }

    private final int readUInt29() {
        int b = this.input.read();
        if ((b & 0xFF) < 128) {
            return b;
        }
        int value = (b & 0x7F) << 7;
        b = this.input.read();
        if ((b & 0xFF) < 128) {
            return value | b;
        }
        value = (value | b & 0x7F) << 7;
        b = this.input.read();
        if ((b & 0xFF) < 128) {
            return value | b;
        }
        return (value | b & 0x7F) << 8 | this.input.read() & 0xFF;
    }
}

