/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StateStorageManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0003H&J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H&J:\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u0019H&J>\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0!\"\b\b\u0000\u0010+*\u00020\u00012\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H+0#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0019\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006,\u00c0\u0006\u0001"}, d2={"Lcom/intellij/configurationStore/ProjectStoreDescriptor;", "", "isExternalStorageSupported", "", "()Z", "projectIdentityFile", "Ljava/nio/file/Path;", "getProjectIdentityFile", "()Ljava/nio/file/Path;", "historicalProjectBasePath", "getHistoricalProjectBasePath", "dotIdea", "getDotIdea", "removeProjectConfigurationAndCaches", "", "presentableUrl", "getPresentableUrl", "testStoreDirectoryExistsForProjectRoot", "projectName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getProjectName", "()Ljava/lang/String;", "saveProjectName", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "customMacros", "", "getJpsBridgeAwareStorageSpec", "Lcom/intellij/openapi/components/Storage;", "filePath", "getModuleStorageSpecs", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "getStorageSpecs", "T", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@ApiStatus.Experimental
public interface ProjectStoreDescriptor {
    default public boolean isExternalStorageSupported() {
        return false;
    }

    @NotNull
    public Path getProjectIdentityFile();

    @NotNull
    public Path getHistoricalProjectBasePath();

    @Nullable
    public Path getDotIdea();

    default public void removeProjectConfigurationAndCaches() {
        Path path = this.getDotIdea();
        Intrinsics.checkNotNull((Object)path);
        for (Path file : NioFiles.list((Path)path)) {
            NioFiles.deleteRecursively((Path)file);
        }
    }

    @NotNull
    default public Path getPresentableUrl() {
        return this.getProjectIdentityFile();
    }

    public boolean testStoreDirectoryExistsForProjectRoot();

    @NotNull
    default public String getProjectName() {
        String string = NioFiles.getFileName((Path)this.getHistoricalProjectBasePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        return string;
    }

    @Nullable
    default public Object saveProjectName(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        return ProjectStoreDescriptor.saveProjectName$suspendImpl(this, project, $completion);
    }

    public static /* synthetic */ Object saveProjectName$suspendImpl(ProjectStoreDescriptor $this, Project project, Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @NotNull
    default public Map<String, Path> customMacros() {
        return MapsKt.emptyMap();
    }

    @NotNull
    public Storage getJpsBridgeAwareStorageSpec(@NotNull String var1, @NotNull Project var2);

    @NotNull
    public List<Storage> getModuleStorageSpecs(@NotNull PersistentStateComponent<?> var1, @NotNull State var2, @NotNull StateStorageOperation var3, @NotNull StateStorageManager var4, @NotNull Project var5);

    @NotNull
    public <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> var1, @NotNull State var2, @NotNull StateStorageOperation var3, @NotNull StateStorageManager var4);
}

