/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ProjectWidePathMacroContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.serviceContainer.NonInjectable;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ProjectPathMacroManager
extends PathMacroManager {
    private final @NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer;
    private final @NotNull Supplier<@Nullable @SystemIndependent String> basePathPointer;
    private final @Nullable Supplier<@NotNull @SystemIndependent String> namePointer;

    public ProjectPathMacroManager(@NotNull Project project) {
        if (project == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(0);
        }
        super(PathMacros.getInstance());
        this.projectFilePathPointer = () -> ((Project)project).getProjectFilePath();
        this.basePathPointer = () -> {
            if (project instanceof ProjectStoreOwner) {
                ProjectStoreOwner projectStoreOwner = (ProjectStoreOwner)project;
                return FileUtilRt.toSystemIndependentName((String)projectStoreOwner.getComponentStore().getStoreDescriptor().getHistoricalProjectBasePath().toString());
            }
            return project.getBasePath();
        };
        this.namePointer = project.isDefault() ? null : () -> ((Project)project).getName();
    }

    @NonInjectable
    private ProjectPathMacroManager(@NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer, @NotNull Supplier<@Nullable @SystemIndependent String> basePathPointer, @Nullable Supplier<@NotNull @SystemIndependent String> namePointer) {
        if (projectFilePathPointer == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(1);
        }
        if (basePathPointer == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(2);
        }
        super(PathMacros.getInstance());
        this.projectFilePathPointer = projectFilePathPointer;
        this.basePathPointer = basePathPointer;
        this.namePointer = namePointer;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        String projectFile;
        ExpandMacroToPathMap result = super.getExpandMacroMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result, "PROJECT_DIR", this.basePathPointer.get());
        if (this.namePointer != null) {
            result.addMacroExpand("PROJECT_NAME", this.namePointer.get());
        }
        if ((projectFile = this.projectFilePathPointer.get()) != null) {
            for (Map.Entry<String, String> entry : ProjectWidePathMacroContributor.getAllMacros(projectFile).entrySet()) {
                result.addMacroExpand(entry.getKey(), entry.getValue());
            }
        }
        ExpandMacroToPathMap expandMacroToPathMap = result;
        if (expandMacroToPathMap == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(3);
        }
        return expandMacroToPathMap;
    }

    @Override
    @NotNull
    protected ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result = super.computeReplacePathMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result, "PROJECT_DIR", this.basePathPointer.get(), null);
        String projectFile = this.projectFilePathPointer.get();
        if (projectFile != null) {
            for (Map.Entry<String, String> entry : ProjectWidePathMacroContributor.getAllMacros(projectFile).entrySet()) {
                result.addMacroReplacement(entry.getValue(), entry.getKey());
            }
        }
        ReplacePathToMacroMap replacePathToMacroMap = result;
        if (replacePathToMacroMap == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(4);
        }
        return replacePathToMacroMap;
    }

    public static ProjectPathMacroManager createInstance(@NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer, @NotNull Supplier<@SystemIndependent @Nullable String> basePathPointer, @Nullable Supplier<@SystemIndependent @NotNull String> namePointer) {
        if (projectFilePathPointer == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(5);
        }
        if (basePathPointer == null) {
            ProjectPathMacroManager.$$$reportNull$$$0(6);
        }
        return new ProjectPathMacroManager(projectFilePathPointer, basePathPointer, namePointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilePathPointer";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePathPointer";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/ProjectPathMacroManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/ProjectPathMacroManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandMacroMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeReplacePathMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

