/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OrderEntryUtil {
    private OrderEntryUtil() {
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @Nullable Library library) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(0);
        }
        if (library == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals((Object)((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @NotNull String libraryName) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            OrderEntryUtil.$$$reportNull$$$0(2);
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            String libName;
            if (!(orderEntry instanceof LibraryOrderEntry) || !libraryName.equals(libName = ((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static ModuleOrderEntry findModuleOrderEntry(@NotNull ModuleRootModel model, @Nullable Module module) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(3);
        }
        if (module == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof ModuleOrderEntry) || !module.equals((Object)((ModuleOrderEntry)orderEntry).getModule())) continue;
            return (ModuleOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static JdkOrderEntry findJdkOrderEntry(@NotNull ModuleRootModel model, @Nullable Sdk sdk) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry) || !sdk.equals((Object)((JdkOrderEntry)orderEntry).getJdk())) continue;
            return (JdkOrderEntry)orderEntry;
        }
        return null;
    }

    public static boolean equals(OrderEntry orderEntry1, OrderEntry orderEntry2) {
        JdkOrderEntry jdkOrderEntry1;
        if (orderEntry1 instanceof JdkOrderEntry) {
            jdkOrderEntry1 = (JdkOrderEntry)orderEntry1;
            if (orderEntry2 instanceof JdkOrderEntry) {
                JdkOrderEntry jdkOrderEntry2 = (JdkOrderEntry)orderEntry2;
                return Comparing.equal((Object)jdkOrderEntry1.getJdk(), (Object)jdkOrderEntry2.getJdk()) && Comparing.strEqual((String)jdkOrderEntry1.getJdkName(), (String)jdkOrderEntry2.getJdkName());
            }
        }
        if (orderEntry1 instanceof LibraryOrderEntry) {
            jdkOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            if (orderEntry2 instanceof LibraryOrderEntry) {
                LibraryOrderEntry jdkOrderEntry2 = (LibraryOrderEntry)orderEntry2;
                return Comparing.equal((Object)jdkOrderEntry1.getLibrary(), (Object)jdkOrderEntry2.getLibrary());
            }
        }
        if (orderEntry1 instanceof ModuleSourceOrderEntry) {
            jdkOrderEntry1 = (ModuleSourceOrderEntry)orderEntry1;
            if (orderEntry2 instanceof ModuleSourceOrderEntry) {
                ModuleSourceOrderEntry jdkOrderEntry2 = (ModuleSourceOrderEntry)orderEntry2;
                return Comparing.equal((Object)jdkOrderEntry1.getOwnerModule(), (Object)jdkOrderEntry2.getOwnerModule());
            }
        }
        if (orderEntry1 instanceof ModuleOrderEntry) {
            jdkOrderEntry1 = (ModuleOrderEntry)orderEntry1;
            if (orderEntry2 instanceof ModuleOrderEntry) {
                ModuleOrderEntry jdkOrderEntry2 = (ModuleOrderEntry)orderEntry2;
                return Comparing.equal((Object)jdkOrderEntry1.getModule(), (Object)jdkOrderEntry2.getModule());
            }
        }
        return false;
    }

    public static boolean equals(Library library1, Library library2) {
        if (library1 == library2) {
            return true;
        }
        if (library1 == null || library2 == null) {
            return false;
        }
        LibraryTable table = library1.getTable();
        if (table != null) {
            if (library2.getTable() != table) {
                return false;
            }
            String name = library1.getName();
            return name != null && name.equals(library2.getName());
        }
        if (library2.getTable() != null) {
            return false;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            if (Arrays.equals(library1.getUrls(type), library2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    public static void addLibraryToRoots(@NotNull LibraryOrderEntry libraryOrderEntry, @NotNull Module module) {
        Library library;
        if (libraryOrderEntry == null) {
            OrderEntryUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            OrderEntryUtil.$$$reportNull$$$0(6);
        }
        if ((library = libraryOrderEntry.getLibrary()) == null) {
            return;
        }
        OrderEntryUtil.addLibraryToRoots(module, library);
    }

    public static void addLibraryToRoots(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            OrderEntryUtil.$$$reportNull$$$0(7);
        }
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(8);
        }
        OrderEntryUtil.addLibraryToRoots(module, library, DependencyScope.COMPILE, false);
    }

    public static void addLibraryToRoots(@NotNull Module module, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        LibraryOrderEntry entry;
        if (module == null) {
            OrderEntryUtil.$$$reportNull$$$0(9);
        }
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            OrderEntryUtil.$$$reportNull$$$0(11);
        }
        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        if (library.getTable() == null) {
            Library jarLibrary = rootModel.getModuleLibraryTable().createLibrary();
            Library.ModifiableModel libraryModel = jarLibrary.getModifiableModel();
            for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                VirtualFile[] files;
                for (VirtualFile jarFile : files = library.getFiles(orderRootType)) {
                    libraryModel.addRoot(jarFile, orderRootType);
                }
            }
            libraryModel.commit();
            entry = rootModel.findLibraryOrderEntry(jarLibrary);
        } else {
            entry = rootModel.addLibraryEntry(library);
        }
        if (entry != null) {
            entry.setScope(scope);
            entry.setExported(exported);
        }
        rootModel.commit();
    }

    private static int findLibraryOrderEntry(OrderEntry @NotNull [] entries, @NotNull Library library) {
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(12);
        }
        if (entries == null) {
            OrderEntryUtil.$$$reportNull$$$0(13);
        }
        for (int i = 0; i < entries.length; ++i) {
            OrderEntry entry = entries[i];
            if (!(entry instanceof LibraryOrderEntry) || !library.equals((Object)((LibraryOrderEntry)entry).getLibrary())) continue;
            return i;
        }
        return -1;
    }

    public static void replaceLibrary(@NotNull ModifiableRootModel model, @NotNull Library oldLibrary, @NotNull Library newLibrary) {
        int i;
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(14);
        }
        if (oldLibrary == null) {
            OrderEntryUtil.$$$reportNull$$$0(15);
        }
        if (newLibrary == null) {
            OrderEntryUtil.$$$reportNull$$$0(16);
        }
        if ((i = OrderEntryUtil.findLibraryOrderEntry(model.getOrderEntries(), oldLibrary)) == -1) {
            return;
        }
        model.addLibraryEntry(newLibrary);
        OrderEntryUtil.replaceLibraryByAdded(model, i);
    }

    public static void replaceLibraryEntryByAdded(@NotNull ModifiableRootModel model, @NotNull LibraryOrderEntry entry) {
        int i;
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(17);
        }
        if (entry == null) {
            OrderEntryUtil.$$$reportNull$$$0(18);
        }
        if ((i = ArrayUtil.indexOf((Object[])model.getOrderEntries(), (Object)entry)) == -1) {
            return;
        }
        OrderEntryUtil.replaceLibraryByAdded(model, i);
    }

    private static void replaceLibraryByAdded(@NotNull ModifiableRootModel model, int toReplace) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(19);
        }
        OrderEntry[] entries = model.getOrderEntries();
        LibraryOrderEntry newEntry2 = (LibraryOrderEntry)entries[entries.length - 1];
        LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entries[toReplace];
        boolean exported = libraryEntry.isExported();
        DependencyScope scope = libraryEntry.getScope();
        model.removeOrderEntry((OrderEntry)libraryEntry);
        newEntry2.setExported(exported);
        newEntry2.setScope(scope);
        OrderEntry[] newEntries = new OrderEntry[entries.length - 1];
        System.arraycopy(entries, 0, newEntries, 0, toReplace);
        newEntries[toReplace] = newEntry2;
        System.arraycopy(entries, toReplace + 1, newEntries, toReplace + 1, entries.length - toReplace - 2);
        model.rearrangeOrderEntries(newEntries);
    }

    public static void moveLastOrderEntries(@NotNull ModifiableRootModel model, int toIndex, int length) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(20);
        }
        OrderEntry[] entries = model.getOrderEntries();
        if (toIndex < 0 || length <= 0 || toIndex + length > entries.length) {
            return;
        }
        OrderEntry[] newEntries = new OrderEntry[entries.length];
        System.arraycopy(entries, 0, newEntries, 0, toIndex);
        System.arraycopy(entries, entries.length - length, newEntries, toIndex, length);
        System.arraycopy(entries, toIndex, newEntries, toIndex + length, entries.length - toIndex - length);
        model.rearrangeOrderEntries(newEntries);
    }

    public static <T extends OrderEntry> void processOrderEntries(@NotNull Module module, @NotNull Class<? extends T> orderEntryClass, @NotNull Processor<? super T> processor) {
        OrderEntry[] orderEntries;
        if (module == null) {
            OrderEntryUtil.$$$reportNull$$$0(21);
        }
        if (orderEntryClass == null) {
            OrderEntryUtil.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            OrderEntryUtil.$$$reportNull$$$0(23);
        }
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (orderEntryClass.isInstance(orderEntry) && !processor.process(orderEntryClass.cast(orderEntry))) break;
        }
    }

    @NotNull
    public static DependencyScope intersectScopes(@NotNull DependencyScope scope1, @NotNull DependencyScope scope2) {
        if (scope1 == null) {
            OrderEntryUtil.$$$reportNull$$$0(24);
        }
        if (scope2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(25);
        }
        if (scope1 == scope2) {
            DependencyScope dependencyScope = scope1;
            if (dependencyScope == null) {
                OrderEntryUtil.$$$reportNull$$$0(26);
            }
            return dependencyScope;
        }
        if (scope1 == DependencyScope.COMPILE) {
            DependencyScope dependencyScope = scope2;
            if (dependencyScope == null) {
                OrderEntryUtil.$$$reportNull$$$0(27);
            }
            return dependencyScope;
        }
        if (scope2 == DependencyScope.COMPILE) {
            DependencyScope dependencyScope = scope1;
            if (dependencyScope == null) {
                OrderEntryUtil.$$$reportNull$$$0(28);
            }
            return dependencyScope;
        }
        if (scope1 == DependencyScope.TEST || scope2 == DependencyScope.TEST) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                OrderEntryUtil.$$$reportNull$$$0(29);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = scope1;
        if (dependencyScope == null) {
            OrderEntryUtil.$$$reportNull$$$0(30);
        }
        return dependencyScope;
    }

    @NotNull
    public static List<Library> getModuleLibraries(@NotNull ModuleRootModel model) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(31);
        }
        OrderEntry[] orderEntries = model.getOrderEntries();
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (OrderEntry orderEntry : orderEntries) {
            LibraryOrderEntry entry;
            if (!(orderEntry instanceof LibraryOrderEntry) || !(entry = (LibraryOrderEntry)orderEntry).isModuleLevel()) continue;
            libraries.add(entry.getLibrary());
        }
        ArrayList<Library> arrayList = libraries;
        if (arrayList == null) {
            OrderEntryUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    public static boolean isModuleLibraryOrderEntry(@Nullable OrderEntry orderEntry) {
        return orderEntry instanceof LibraryOrderEntry && ((LibraryOrderEntry)orderEntry).isModuleLevel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 26, 27, 28, 29, 30, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryOrderEntry";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldLibrary";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLibrary";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEntryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEntryUtil";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectScopes";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryOrderEntry";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findModuleOrderEntry";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findJdkOrderEntry";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryToRoots";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibrary";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibraryEntryByAdded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibraryByAdded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moveLastOrderEntries";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processOrderEntries";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "intersectScopes";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getModuleLibraries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 26, 27, 28, 29, 30, 32 -> new IllegalStateException(string);
        };
    }
}

